/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.RMCP;
import IPMIView20.UDPSocket;
import com.supermicro.ipmi.IPMIMessagingCommand;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class DeviceStatus {
    public static final int DEVICE_UNKNOWN = 0;
    public static final int DEVICE_OSA = 1;
    public static final int DEVICE_PEPPERCON_KVM = 2;
    public static final int DEVICE_PEPPERCON_NONE_KVM = 3;
    public static final int DEVICE_PEPPERCON_CMM = 4;
    public static final int DEVICE_PEPPERCON_OFFICE_BLADE_CMM = 5;
    public static final int DEVICE_PEPPERCON_TWIN_BLADE_CMM = 6;
    public static final int DEVICE_BLADE_MODULE = 7;
    public static final int DEVICE_AMI = 8;
    public static final int DEVICE_AMI_SIMBL = 9;
    public static final int DEVICE_ATEN = 10;
    public static final int DEVICE_AMI_X9 = 11;
    public static final int DEVICE_ATEN_ASPEED = 12;
    public static final int DEVICE_AMI_ASPEED = 13;
    GlobalDefine gd = new GlobalDefine();
    SortedMap device;
    boolean isRun = true;
    Timer timer = null;
    Thread th;
    CSession xSession = new CSession();

    public DeviceStatus() {
        this.device = new TreeMap();
    }

    public void addDevice(Vector deviceIPs) {
        for (String ip : deviceIPs) {
            if (this.device.containsKey(ip)) continue;
            DeviceInfo deviceInfo = new DeviceInfo();
            deviceInfo.deviceIP = ip;
            this.device.put(ip, deviceInfo);
        }
    }

    public DeviceInfo addDevice(String deviceIP) {
        if (!this.device.containsKey(deviceIP)) {
            DeviceInfo deviceInfo = new DeviceInfo();
            deviceInfo.deviceIP = deviceIP;
            this.device.put(deviceIP, deviceInfo);
        }
        return (DeviceInfo)this.device.get(deviceIP);
    }

    public boolean getStatus(String deviceIP) {
        if (deviceIP == null || !this.device.containsKey(deviceIP)) {
            return false;
        }
        DeviceInfo b = (DeviceInfo)this.device.get(deviceIP);
        return b.isOn;
    }

    public int getDeviceType(String deviceIP) {
        if (!this.device.containsKey(deviceIP)) {
            return 0;
        }
        DeviceInfo b = (DeviceInfo)this.device.get(deviceIP);
        return b.deviceType;
    }

    public String getVersionInfo(String deviceIP) {
        if (deviceIP == null || !this.device.containsKey(deviceIP)) {
            return "";
        }
        DeviceInfo b = (DeviceInfo)this.device.get(deviceIP);
        return b.version;
    }

    public void startMonitor_old() {
        this.isRun = true;
        this.th = new Thread(){

            @Override
            public void run() {
                while (DeviceStatus.this.isRun) {
                    try {
                        DeviceStatus.this.monitorAllAtSameTime();
                        try {
                            Thread.sleep(20000L);
                        }
                        catch (InterruptedException ex) {
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.th.start();
    }

    public void startMonitor() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                DeviceStatus.this.monitorAllAtSameTime();
            }
        };
        this.timer = new Timer();
        this.timer.schedule(timerTask, 0L, 20000L);
    }

    public void stopMonitor_old() {
        this.isRun = false;
        this.th.interrupt();
    }

    public void stopMonitor() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void monitorAllAtSameTime() {
        Object[] an_deviceInfos = this.device.values().toArray();
        for (int i = 0; i < an_deviceInfos.length; ++i) {
            MonitorStatus monitorStatus = new MonitorStatus((DeviceInfo)an_deviceInfos[i]);
            monitorStatus.start();
        }
    }

    public void monitor(String deviceIP) {
        DeviceInfo deviceInfo = this.addDevice(deviceIP);
        MonitorStatus monitorStatus = new MonitorStatus(deviceInfo);
        monitorStatus.start();
    }

    private void checkIsAlive(DeviceInfo deviceInfo) {
        if (deviceInfo == null) {
            return;
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(deviceInfo.deviceIP, IPMIView20.getInstance().socketTimeout, IPMIView20.getInstance().retryTime);
        if (guid != null) {
            if (IPMIMessagingCommand.isOSAGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 (SUPERO IPMI)";
                deviceInfo.deviceType = 1;
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isPepperconGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 (SIM IPMI+KVM)";
                deviceInfo.deviceType = 2;
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 (SIM IPMI)";
                deviceInfo.deviceType = 3;
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isCMMGUID(guid)) {
                if (IPMIMessagingCommand.isNormalBladeCMMGUID(guid)) {
                    IPMIView20.getInstance();
                    if (IPMIView20.inspur) {
                        deviceInfo.version = "IPMI 2.0 (Inspur Blade CMM)";
                    } else {
                        IPMIView20.getInstance();
                        if (IPMIView20.clearCube) {
                            deviceInfo.version = "IPMI 2.0 (ClearCube Blade CMM)";
                        } else {
                            IPMIView20.getInstance();
                            if (IPMIView20.acer) {
                                deviceInfo.version = "IPMI 2.0 (ACER Smart Blade CMM)";
                            } else {
                                IPMIView20.getInstance();
                                if (IPMIView20.gateway) {
                                    deviceInfo.version = "IPMI 2.0 (Gateway Smart Blade CMM)";
                                } else {
                                    IPMIView20.getInstance();
                                    if (IPMIView20.cray) {
                                        deviceInfo.version = "IPMI 2.0 (Cray CX1 CMM)";
                                    } else {
                                        IPMIView20.getInstance();
                                        deviceInfo.version = IPMIView20.zte ? "IPMI 2.0 (ZXF20 E8000 CMM)" : "IPMI 2.0 (SuperBlade CMM)";
                                    }
                                }
                            }
                        }
                    }
                    deviceInfo.deviceType = 4;
                } else if (IPMIMessagingCommand.isOfficeBladeCMMGUID(guid)) {
                    IPMIView20.getInstance();
                    if (IPMIView20.inspur) {
                        deviceInfo.version = "IPMI 2.0 (Inspur Office Blade CMM)";
                    } else {
                        IPMIView20.getInstance();
                        deviceInfo.version = IPMIView20.clearCube ? "IPMI 2.0 (ClearCube Office Blade CMM)" : "IPMI 2.0 (OfficeBlade CMM)";
                    }
                    deviceInfo.deviceType = 5;
                } else if (IPMIMessagingCommand.isTwinBladeCMMGUID(guid)) {
                    IPMIView20.getInstance();
                    if (IPMIView20.acer) {
                        deviceInfo.version = "IPMI 2.0 (Blade System CMM)";
                    } else {
                        IPMIView20.getInstance();
                        if (IPMIView20.gateway) {
                            deviceInfo.version = "IPMI 2.0 (Blade System CMM)";
                        } else {
                            IPMIView20.getInstance();
                            deviceInfo.version = IPMIView20.zte ? "IPMI 2.0 (ZXF20 E8000 CMM)" : "IPMI 2.0 (TwinBlade CMM)";
                        }
                    }
                    deviceInfo.deviceType = 6;
                }
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isAMIGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 SIM(W) IPMI+KVM";
                deviceInfo.deviceType = 8;
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isAMISIMBLGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 (SIMBL(W) Blade)";
                deviceInfo.deviceType = 9;
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isATENGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 SIM(WA) IPMI+KVM";
                deviceInfo.deviceType = 10;
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isSIMBL(guid)) {
                deviceInfo.version = "IPMI 2.0 (SIMBL Blade)";
                deviceInfo.deviceType = 7;
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
                deviceInfo.version = "IPMI 2.0 SIM(X9) IPMI+KVM";
                deviceInfo.deviceType = 11;
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isATENAspeedGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 ASPD_T IPMI+KVM";
                deviceInfo.deviceType = 12;
                deviceInfo.isOn = true;
            } else if (IPMIMessagingCommand.isAMIAspeedGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 ASPD_M IPMI+KVM";
                deviceInfo.deviceType = 13;
                deviceInfo.isOn = true;
            } else {
                int result = this.checkIPMIVersion(deviceInfo.deviceIP);
                if (result == 121) {
                    result = this.checkIPMIVersionOld(deviceInfo.deviceIP);
                }
                if (result == 0) {
                    deviceInfo.version = "IPMI 1.5";
                    deviceInfo.isOn = true;
                } else if (result == 1) {
                    deviceInfo.version = "IPMI 2.0";
                    deviceInfo.isOn = true;
                } else if (result == 2) {
                    deviceInfo.version = "IPMI 2.0+";
                    deviceInfo.isOn = true;
                } else {
                    deviceInfo.version = L.t("discover.Unknown");
                    deviceInfo.isOn = false;
                }
            }
        } else {
            deviceInfo.version = L.t("discover.Unknown");
            deviceInfo.isOn = false;
        }
    }

    public int checkIPMIVersion(String SIP) {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = new RMCP();
        UDPSocket udpSocket = new UDPSocket(2, 0);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.setIgnoreIOException(true);
        param[0] = -127;
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        Para.addElement(param);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)56, (byte)65, Para, this.xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, this.xSession.InboundSessionSeq, rawdata, length[0], false)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                byte[] byte3 = (byte[])rmcpPacket.retValue.get(1);
                byte[] byte4 = (byte[])rmcpPacket.retValue.get(2);
                byte[] byte5 = (byte[])rmcpPacket.retValue.get(3);
                byte[] byte6_8 = (byte[])rmcpPacket.retValue.get(4);
                byte[] byte9 = (byte[])rmcpPacket.retValue.get(5);
                byte ipmiVesion = byte5[0];
                if ((ipmiVesion & 2) == 2) {
                    if ((byte3[0] & 0x80) > 0) {
                        udpSocket.closeSocket();
                        return 2;
                    }
                    udpSocket.closeSocket();
                    return 1;
                }
                if (ipmiVesion == 0) {
                    udpSocket.closeSocket();
                }
                return 0;
            }
        }
        udpSocket.closeSocket();
        return 121;
    }

    public int checkIPMIVersionOld(String SIP) {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = new RMCP();
        UDPSocket udpSocket = new UDPSocket(2, 0);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.setIgnoreIOException(true);
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        Para.addElement(param);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)56, (byte)65, Para, this.xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, this.xSession.InboundSessionSeq, rawdata, length[0], false)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                byte[] temp = (byte[])rmcpPacket.retValue.get(3);
                byte ipmiVesion = temp[0];
                if ((ipmiVesion & 2) == 2) {
                    udpSocket.closeSocket();
                    return 1;
                }
                if (ipmiVesion == 0) {
                    udpSocket.closeSocket();
                    return 0;
                }
            }
        }
        udpSocket.closeSocket();
        return 121;
    }

    public byte[] getSystemGUID(String SIP) {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = new RMCP();
        UDPSocket udpSocket = new UDPSocket(IPMIView20.getInstance().socketTimeout, IPMIView20.getInstance().retryTime);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.setIgnoreIOException(true);
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)55, (byte)65, Para, this.xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, this.xSession.InboundSessionSeq, rawdata, length[0], true)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                byte[] bytes = (byte[])rmcpPacket.retValue.get(0);
                udpSocket.closeSocket();
                return bytes;
            }
        }
        udpSocket.closeSocket();
        return null;
    }

    public boolean isCMMType(int type) {
        return type == 4 || type == 5 || type == 6;
    }

    public boolean isCMMType(String deviceIP) {
        int type = this.getDeviceType(deviceIP);
        return this.isCMMType(type);
    }

    public static void main(String[] args) {
        IPMIView20 i;
        IPMIView20.instance = i = new IPMIView20();
        DeviceStatus ds = new DeviceStatus();
        ds.addDevice("192.168.1.111");
        ds.addDevice("192.168.1.115");
        ds.addDevice("192.168.1.118");
        ds.addDevice("192.168.10.240");
        ds.startMonitor();
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ds.stopMonitor();
        System.out.println("stop monitor");
    }

    class DeviceInfo {
        String deviceIP;
        String version = "";
        boolean isOn = false;
        int deviceType = 0;
        boolean isPassLogin = false;
        String id;
        String pw;

        DeviceInfo() {
        }

        public String toString() {
            return "IP:" + this.deviceIP + ", " + (this.isOn ? "On" : "Off") + "," + this.version;
        }
    }

    class MonitorStatus
    extends Thread {
        DeviceInfo deviceInfo;

        public MonitorStatus(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
        }

        @Override
        public void run() {
            DeviceStatus.this.checkIsAlive(this.deviceInfo);
            if (IPMIView20.getInstance() != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IPMIView20.getInstance().deviceList.repaint();
                        IPMIView20.getInstance().domainTree.repaint();
                    }
                });
            }
        }
    }
}

