/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.FanModePanel_jUpdateButton_actionAdapter;
import IPMIView20.IPMIView20;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class FanModePanel
extends JPanel {
    private String ip;
    private String id;
    private String password;
    private byte privilege;
    boolean isLoaded;
    TitledBorder titledBorder1 = new TitledBorder("");
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JRadioButton jOptimalRadioButton = new JRadioButton();
    JRadioButton jFullRadioButton = new JRadioButton();
    JRadioButton jStandardRadioButton = new JRadioButton();
    JRadioButton jPUEOptimalRadioButton = new JRadioButton();
    JRadioButton jHeavyIORadioButton = new JRadioButton();
    JButton jUpdateButton = new JButton();
    TitledBorder titledBorder2 = new TitledBorder("");
    byte orgLANMode;

    public FanModePanel(String ip, String id, String password, byte privilege) {
        try {
            this.ip = ip;
            this.id = id;
            this.password = password;
            this.privilege = privilege;
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        this.buttonGroup1.add(this.jOptimalRadioButton);
        this.buttonGroup1.add(this.jStandardRadioButton);
        this.buttonGroup1.add(this.jFullRadioButton);
        this.buttonGroup1.add(this.jPUEOptimalRadioButton);
        this.buttonGroup1.add(this.jHeavyIORadioButton);
    }

    private void jbInit() throws Exception {
        this.titledBorder2 = new TitledBorder("Fan Speed Mode");
        this.titledBorder1 = new TitledBorder("Fan Speed Mode");
        this.setLayout(null);
        this.jOptimalRadioButton.setToolTipText("Optimal");
        this.jOptimalRadioButton.setText("Optimal");
        this.jOptimalRadioButton.setBounds(new Rectangle(74, 21, 63, 23));
        this.jFullRadioButton.setToolTipText("Full");
        this.jFullRadioButton.setText("Full");
        this.jFullRadioButton.setBounds(new Rectangle(8, 40, 43, 23));
        this.jStandardRadioButton.setToolTipText("Standard");
        this.jStandardRadioButton.setText("Standard");
        this.jStandardRadioButton.setBounds(new Rectangle(8, 21, 67, 23));
        this.jPUEOptimalRadioButton.setToolTipText("PUE Optimal");
        this.jPUEOptimalRadioButton.setText("PUE Opt");
        this.jPUEOptimalRadioButton.setBounds(new Rectangle(74, 40, 67, 23));
        this.jHeavyIORadioButton.setToolTipText("Heavy IO");
        this.jHeavyIORadioButton.setText("Heavy IO");
        this.jHeavyIORadioButton.setBounds(new Rectangle(8, 59, 80, 23));
        this.jUpdateButton.setBounds(new Rectangle(145, 28, 65, 23));
        this.jUpdateButton.setPreferredSize(new Dimension(65, 23));
        this.jUpdateButton.setToolTipText("Update");
        this.jUpdateButton.setHorizontalTextPosition(0);
        this.jUpdateButton.setText("Update");
        this.jUpdateButton.addActionListener(new FanModePanel_jUpdateButton_actionAdapter(this));
        this.setBorder(this.titledBorder2);
        this.add(this.jStandardRadioButton);
        this.add(this.jOptimalRadioButton);
        this.add(this.jFullRadioButton);
        this.add(this.jPUEOptimalRadioButton);
        this.add(this.jHeavyIORadioButton);
        this.add(this.jUpdateButton);
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivilege(byte privilege) {
        this.privilege = privilege;
    }

    public String getIp() {
        return this.ip;
    }

    public String getId() {
        return this.id;
    }

    public String getPassword() {
        return this.password;
    }

    public byte getPrivilege() {
        return this.privilege;
    }

    public boolean getIsLoaded() {
        return this.isLoaded;
    }

    public void load() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.password);
        config.setPrivilege(this.privilege);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        this.isLoaded = false;
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new IPMIException("Cannot connect to host");
        }
        ipmiOEMCommand.setIPMIInterface(rmcp);
        byte fanMode = ipmiOEMCommand.getFANSpeedMode();
        this.setFanModeRadioButton(fanMode);
        int fanModeCapability = -1;
        try {
            fanModeCapability = ipmiOEMCommand.getFANSpeedModeCapability();
        }
        catch (Exception e) {
            // empty catch block
        }
        if ((byte)(fanModeCapability & 1) == 1) {
            this.jStandardRadioButton.setEnabled(true);
        } else {
            this.jStandardRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 2) == 2) {
            this.jFullRadioButton.setEnabled(true);
        } else {
            this.jFullRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 4) == 4) {
            this.jOptimalRadioButton.setEnabled(true);
        } else {
            this.jOptimalRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 8) == 8) {
            this.jPUEOptimalRadioButton.setEnabled(true);
        } else {
            this.jPUEOptimalRadioButton.setEnabled(false);
        }
        if ((byte)(fanModeCapability & 0x10) == 16) {
            this.jHeavyIORadioButton.setEnabled(true);
        } else {
            this.jHeavyIORadioButton.setEnabled(false);
        }
        this.isLoaded = true;
        sessionController.closeSession();
    }

    private void setFanModeRadioButton(byte fanMode) {
        switch (fanMode) {
            case 0: {
                this.jStandardRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.jFullRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.jOptimalRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.jPUEOptimalRadioButton.setSelected(true);
                break;
            }
            case 4: {
                this.jHeavyIORadioButton.setSelected(true);
                break;
            }
        }
    }

    public void update() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.password);
        config.setPrivilege(this.privilege);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new IPMIException("Cannot connect to host");
        }
        ipmiOEMCommand.setIPMIInterface(rmcp);
        int fanMode = 0;
        this.orgLANMode = ipmiOEMCommand.getFANSpeedMode();
        if (this.jHeavyIORadioButton.isSelected()) {
            fanMode = 4;
        } else if (this.jPUEOptimalRadioButton.isSelected()) {
            fanMode = 3;
        } else if (this.jOptimalRadioButton.isSelected()) {
            fanMode = 2;
        } else if (this.jStandardRadioButton.isSelected()) {
            fanMode = 0;
        } else if (this.jFullRadioButton.isSelected()) {
            fanMode = 1;
        }
        if (fanMode != this.orgLANMode) {
            ipmiOEMCommand.setFANSpeedMode((byte)fanMode);
        }
        sessionController.closeSession();
    }

    public void jUpdateButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                FanModePanel.this.setCursor(new Cursor(3));
                try {
                    FanModePanel.this.update();
                }
                catch (IPMIException ex) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Not a supported fan mode");
                    FanModePanel.this.setFanModeRadioButton(FanModePanel.this.orgLANMode);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), ex.toString());
                    FanModePanel.this.setFanModeRadioButton(FanModePanel.this.orgLANMode);
                }
                FanModePanel.this.setCursor(new Cursor(0));
            }
        };
        thread.start();
    }
}

