/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.L;

public class GlobalDefine {
    public static final byte ASFMessage = 6;
    public static final byte IPMIMessage = 7;
    public static final byte CHASSIS_REQUEST = 0;
    public static final byte CHASSIS_RESPONSE = 4;
    public static final byte BRIDGE_REQUEST = 8;
    public static final byte BRIDGE_RESPONSE = 12;
    public static final byte SENSOR_EVENT_REQUEST = 16;
    public static final byte SENSOR_EVENT_RESPONSE = 20;
    public static final byte APP_REQUEST = 24;
    public static final byte APP_RESPONSE = 28;
    public static final byte FW_REQUEST = 32;
    public static final byte FW_RESPONSE = 36;
    public static final byte STORAGE_REQUEST = 40;
    public static final byte STORAGE_RESPONSE = 44;
    public static final byte TRANSPORT_REQUEST = 48;
    public static final byte TRANSPORT_RESPONSE = 52;
    public static final byte OEM_REQUEST = -64;
    public static final byte OEM_RESPONSE = -60;
    public static final byte DCM_SDK_GA_REQUEST = -64;
    public static final byte GET_DEVICE_ID = 1;
    public static final byte COLD_RESET = 2;
    public static final byte WARM_RESET = 3;
    public static final byte GET_SELF_TEST_RESULTS = 4;
    public static final byte SET_ACPI_POWER_STATE = 6;
    public static final byte GET_ACPI_POWER_STATE = 7;
    public static final byte GET_DEVICE_GUID = 8;
    public static final byte GET_MESSAGE = 51;
    public static final byte SEND_MESSAGE = 52;
    public static final byte GET_SYSTEM_GUID = 55;
    public static final byte GET_CHANNEL_AUTH_CAP = 56;
    public static final byte GET_SESSION_CHALLENGE = 57;
    public static final byte ACTIVATE_SESSION = 58;
    public static final byte SET_SESSION_PRIVILEGE = 59;
    public static final byte CLOSE_SESSION = 60;
    public static final byte GET_SESSION_INFO = 61;
    public static final byte SET_USER_ACCESS = 67;
    public static final byte GET_USER_ACCESS = 68;
    public static final byte SET_USER_NAME = 69;
    public static final byte GET_USER_NAME = 70;
    public static final byte SET_USER_PASSWORD = 71;
    public static final byte ACTIVATE_PAYLOAD = 72;
    public static final byte DEACTIVATE_PAYLOAD = 73;
    public static final byte GET_CHANNEL_CIPHER_SUITES = 84;
    public static final byte MASTER_WRITE_I2C = 80;
    public static final byte MASTER_READ_I2C = 81;
    public static final byte MASTER_WRITE_READ_I2C = 82;
    public static final byte DUMP_TASK = 93;
    public static final byte SET_USER_PAYLOAD_ACCESS = 76;
    public static final byte GET_USER_PAYLOAD_ACCESS = 77;
    public static final byte PLATFORM_EVENT_MESSAGE = 2;
    public static final byte GET_DEVICE_SDR_INFO = 32;
    public static final byte GET_DEVICE_SDR = 33;
    public static final byte GET_SENSOR_HISTERISIS = 37;
    public static final byte GET_SENSOR_THRESHOLD = 39;
    public static final byte SET_SENSOR_EVENT_ENABLE = 40;
    public static final byte GET_SENSOR_EVENT_STATUS = 43;
    public static final byte GET_SENSOR_READING = 45;
    public static final byte GET_SENSOR_TYPE = 47;
    public static final byte GET_FRU_INVENTORY_AREA_INFO = 16;
    public static final byte READ_FRU_INVENTORY_DATA = 17;
    public static final byte WRITE_FRU_INVENTORY_DATA = 18;
    public static final byte READ_BMC_MEMORY = 27;
    public static final byte GET_SDR_REPOSITORY_INFO = 32;
    public static final byte RESERVE_SDR_REPOSITORY = 34;
    public static final byte GET_SDR = 35;
    public static final byte PARTIAL_ADD_SDR = 37;
    public static final byte CLEAR_SDR_REPOSITORY = 39;
    public static final byte GET_SDR_REPOSITORY_TIME = 40;
    public static final byte GET_SEL_INFO = 64;
    public static final byte RESERVE_SEL_REPOSITORY = 66;
    public static final byte GET_SEL = 67;
    public static final byte ADD_SEL_ENTRY = 68;
    public static final byte PARTIAL_ADD_SEL = 69;
    public static final byte DELETE_SEL = 70;
    public static final byte CLEAR_SEL = 71;
    public static final byte GET_SEL_TIME = 72;
    public static final byte SET_SEL_TIME = 73;
    public static final byte SET_LAN_CONFIGURATION = 1;
    public static final byte GET_LAN_CONFIGURATION = 2;
    public static final byte SET_LAN_STATISTICS = 3;
    public static final byte GET_LAN_STATISTICS = 4;
    public static final byte SET_SOL_CONFIGURATION_PARAMETERS = 33;
    public static final byte GET_SOL_CONFIGURATION_PARAMETERS = 34;
    public static final byte ENTER_FW_TRANSFER = 0;
    public static final byte FW_PROGRAM_MEMORY = 1;
    public static final byte FW_READ_MEMORY = 2;
    public static final byte GET_FW_CHECKSUM = 3;
    public static final byte EXIT_FW_TRANSFER = 4;
    public static final byte SET_SEGMENT = 5;
    public static final byte CHASSIS_CONTROL = 2;
    public static final byte GET_BMC_MANUFACTORY = 11;
    public static final byte GET_BIOS_TYPE = 12;
    public static final byte GET_PRODUCT_ID = 33;
    public static final byte ENABLE_UID_LED = 13;
    public static final byte DISABLE_UID_LED = 14;
    public static final byte IS_UID_LED_PRESENT = 16;
    public static final byte IS_SUPPORT_STANDARD_GRACEFUL_SHUTDOWN_FOR_OSA = -120;
    public static final byte IS_POWER_SUPPLY_FAILURE_REVERSE = -121;
    public static final byte GET_LAN_DRIVER = 20;
    public static final byte CHECK_NO_VM_AND_WEB = 39;
    public static final byte IS_OEM_COMMAND_SUPPORTED = 41;
    public static final byte APPEND_RECORD = 0;
    public static final byte REPLACE_RECORD = 1;
    public static final byte PARTIAL_ADD_IN_PROGRESS = 0;
    public static final byte LAST_RECORD_DATA = 1;
    public static final byte COMPCODE_NORMAL = 0;
    public static final byte COMPCODE_NODEBUSY = -64;
    public static final byte COMPCODE_INVALIDCMD = -63;
    public static final byte COMPCODE_INVALIDLUN = -62;
    public static final byte COMPCODE_TIMEOUT = -61;
    public static final byte COMPCODE_OUTOFSPACE = -60;
    public static final byte COMPCODE_RESVTNCNCLD = -59;
    public static final byte COMPCODE_REQDATATRUNC = -58;
    public static final byte COMPCODE_REQDATABADLEN = -57;
    public static final byte COMPCODE_REQDATATOOLONG = -56;
    public static final byte COMPCODE_OFFSETOUTOFRANGE = -55;
    public static final byte COMPCODE_RESPDATATRUNC = -54;
    public static final byte COMPCODE_NOTFOUND = -53;
    public static final byte COMPCODE_INVALIDFIELD = -52;
    public static final byte COMPCODE_COMMANDILLEGAL = -51;
    public static final byte COMPCODE_NORESPONSE = -50;
    public static final byte COMPCODE_DUPLCATEDREQ = -49;
    public static final byte COMPCODE_SDRINUPDATE = -48;
    public static final byte COMPCODE_FIRMWAREUPDATE = -47;
    public static final byte COMPCODE_BMCINITING = -46;
    public static final byte COMPCODE_DESTUNAVAIL = -45;
    public static final byte COMPCODE_INSUFFPRIVLEVEL = -44;
    public static final byte COMPCODE_UNSPECIFIED = -1;
    public static final byte I2C_WRITE_STATUS_NORMAL = 0;
    public static final byte I2C_WRITE_STATUS_LOST_ARB = 1;
    public static final byte I2C_WRITE_STATUS_BUS_ERROR = 2;
    public static final byte I2C_WRITE_STATUS_NAK_WRITE = 3;
    public static final byte I2C_WRITE_STATUS_TRUNC_READ = 4;
    public static final byte I2C_WRITE_STATUS_NAK_ADDRESS = 5;
    public static final byte I2C_WRITE_STATUS_BAD_LENGTH = 6;
    public static final byte I2C_READ_STATUS_NORMAL = 0;
    public static final byte REQ_OFFSET_NETFN = 0;
    public static final byte REQ_OFFSET_CMD = 1;
    public static final byte REQ_OFFSET_DATA = 2;
    public static final byte RSP_OFFSET_ADDR = 0;
    public static final byte RSP_OFFSET_NETFN = 1;
    public static final byte RSP_OFFSET_CMD = 2;
    public static final byte RSP_OFFSET_COMPCODE = 3;
    public static final byte RSP_OFFSET_DATA = 4;
    public static final byte IMB_RSP_OFFSET_RQADDR = 0;
    public static final byte IMB_RSP_OFFSET_NETFN = 1;
    public static final byte IMB_RSP_OFFSET_CKSUM = 2;
    public static final byte IMB_RSP_OFFSET_RSADDR = 3;
    public static final byte IMB_RSP_OFFSET_RQSEQRSLUN = 4;
    public static final byte IMB_RSP_OFFSET_CMD = 5;
    public static final byte IMB_RSP_OFFSET_COMPCODE = 6;
    public static final byte IMB_RSP_OFFSET_DATA = 7;
    public static final byte IPMIV20Plus = 2;
    public static final byte IPMIV20 = 1;
    public static final byte IPMIV15 = 0;
    public static final byte IPMIVERSION_UNKNOWN = 121;
    public static final byte PRIVILEGE_HIGHEST = 0;
    public static final byte PRIVILEGE_CALLBACK = 1;
    public static final byte PRIVILEGE_USER = 2;
    public static final byte PRIVILEGE_OPERATOR = 3;
    public static final byte PRIVILEGE_ADMINISTRATOR = 4;
    public static final byte PRIVILEGE_OEM = 5;
    public static final byte BIOS_UNKNOWN = 127;
    public static final byte BIOS_AWARD = 0;
    public static final byte BIOS_PHOENIX = 1;
    public static final byte BIOS_AMI = 2;
    public static final byte BMC_UNKNOWN = 127;
    public static final byte BMC_SUPERMICRO = 1;
    public static final byte NIC_UNKNOWN = 127;
    public static final byte NIC_B5721 = 0;
    public static final byte NIC_B5704 = 1;
    public static final byte NIC_I82546 = 2;
    public static final byte NIC_I82541 = 3;
    public static final byte NIC_I82573 = 4;
    String[][] SensorTypeCodes = new String[][]{{"1", "-", L.t("define.Temperature"), L.t("define.Temperature")}, {"2", "-", L.t("define.Voltage"), L.t("define.Voltage")}, {"3", "-", L.t("define.Current"), L.t("define.Current")}, {"4", "-", L.t("define.Fan"), L.t("define.Fan")}, {"5", "0", L.t("define.Physical_Security_Chassis_Intrusion"), L.t("define.General_Chassis_Intrusion")}, {"5", "1", L.t("define.Physical_Security_Chassis_Intrusion"), "Drive Bay intrusion"}, {"5", "2", L.t("define.Physical_Security_Chassis_Intrusion"), "I/O Card area intrusion"}, {"5", "3", L.t("define.Physical_Security_Chassis_Intrusion"), "Processor area intrusion"}, {"5", "4", L.t("define.Physical_Security_Chassis_Intrusion"), "LAN Leash Lost (system has been unplugged from LAN)"}, {"5", "5", L.t("define.Physical_Security_Chassis_Intrusion"), "Unauthorized dock/undock"}, {"5", "6", L.t("define.Physical_Security_Chassis_Intrusion"), "FAN area intrusion (supports detection of hot plug fan tampering)"}, {"6", "0", L.t("define.Platform_Security_Violation_Attempt"), "Secure Mode (Front Panel Lockout) Violation attempt"}, {"6", "1", L.t("define.Platform_Security_Violation_Attempt"), "Pre-boot Password Violation - user password"}, {"6", "2", L.t("define.Platform_Security_Violation_Attempt"), "Pre-boot Password Violation attempt - setup password"}, {"6", "3", L.t("define.Platform_Security_Violation_Attempt"), "Pre-boot Password Violation - network boot password"}, {"6", "4", L.t("define.Platform_Security_Violation_Attempt"), "Other pre-boot Password Violation"}, {"6", "5", L.t("define.Platform_Security_Violation_Attempt"), "Out-of-band Access Password Violation"}, {"7", "0", L.t("define.Processor"), "IERR"}, {"7", "1", L.t("define.Processor"), "Thermal Trip"}, {"7", "2", L.t("define.Processor"), "FRB1/BIST failure"}, {"7", "3", L.t("define.Processor"), "FRB2/Hang in POST failure."}, {"7", "4", L.t("define.Processor"), "FRB3/Processor Startup/Initialization failure (CPU didn't start)"}, {"7", "5", L.t("define.Processor"), "Configuration Error (for DMI)"}, {"7", "6", L.t("define.Processor"), "SM BIOS 'Uncorrectable CPU-complex Error'"}, {"7", "7", L.t("define.Processor"), "Processor Presence detected"}, {"7", "8", L.t("define.Processor"), "Processor disabled"}, {"7", "9", L.t("define.Processor"), "Terminator Presence Detected"}, {"8", "0", L.t("define.Power_Supply"), "Presence detected"}, {"8", "1", L.t("define.Power_Supply"), L.t("define.Power_Supply_Failure_detected")}, {"8", "2", L.t("define.Power_Supply"), "Predictive Failure asserted"}, {"8", "3", L.t("define.Power_Supply"), "Power Supply AC lost"}, {"8", "4", L.t("define.Power_Supply"), "AC lost or out-of-range"}, {"8", "5", L.t("define.Power_Supply"), "AC out-of-range, but present"}, {"9", "0", L.t("define.Power_Unit"), "Power Off / Power Down"}, {"9", "1", L.t("define.Power_Unit"), "Power Cycle"}, {"9", "2", L.t("define.Power_Unit"), "240VA Power Down"}, {"9", "3", L.t("define.Power_Unit"), "Interlock Power Down"}, {"9", "4", L.t("define.Power_Unit"), "AC lost"}, {"9", "5", L.t("define.Power_Unit"), "Soft Power Control Failure (unit did not respond to request to turn on)"}, {"9", "6", L.t("define.Power_Unit"), "Power Unit Failure detected"}, {"A", "-", "Cooling Device", "-"}, {"B", "-", "Other Units-based Sensor (per units given in SDR)", "-"}, {"C", "0", "Memory", "Correctable ECC"}, {"C", "1", "Memory", "Uncorrectable ECC"}, {"C", "2", "Memory", "Parity"}, {"C", "3", "Memory", "Memory Scrub Failed (stuck bit)"}, {"C", "4", "Memory", "Memory Device Disabled"}, {"C", "5", "Memory", "Correctable ECC / other correctable memory error logging limit reached"}, {"D", "-", "Drive Slot (Bay)", "-"}, {"E", "-", "POST Memory Resize", "-"}, {"F", "0", "System Firmware Progress (formerly POST Error)", "System Firmware Error (POST Error)"}, {"F", "1", "System Firmware Progress (formerly POST Error)", "System Firmware Hang (uses same Event Data 2 definition as following System Firmware Progress offset)"}, {"F", "2", "System Firmware Progress (formerly POST Error)", "System Firmware Progress"}, {"10", "0", "Event Logging Disabled", "Correctable Memory Error Logging Disabled"}, {"10", "1", "Event Logging Disabled", "Event 'Type' Logging Disabled."}, {"10", "2", "Event Logging Disabled", "Log Area Reset/Cleared"}, {"10", "3", "Event Logging Disabled", "All Event Logging Disabled"}, {"11", "0", "Watchdog 1", "BIOS Watchdog Reset"}, {"11", "1", "Watchdog 1", "OS Watchdog Reset"}, {"11", "2", "Watchdog 1", "OS Watchdog Shut Down"}, {"11", "3", "Watchdog 1", "OS Watchdog Power Down"}, {"11", "4", "Watchdog 1", "OS Watchdog Power Cycle"}, {"11", "5", "Watchdog 1", "OS Watchdog NMI / Diagnostic Interrupt"}, {"11", "6", "Watchdog 1", "OS Watchdog Expired, status only"}, {"11", "7", "Watchdog 1", "OS Watchdog pre-timeout Interrupt, non-NMI"}, {"12", "0", "System Event", "System Reconfigured"}, {"12", "1", "System Event", "OEM System Boot Event"}, {"12", "2", "System Event", "Undetermined system hardware failure"}, {"13", "0", "Critical Interrupt", "Front Panel NMI / Diagnostic Interrupt"}, {"13", "1", "Critical Interrupt", "Bus Timeout"}, {"13", "2", "Critical Interrupt", "I/O channel check NMI"}, {"13", "3", "Critical Interrupt", "Software NMI"}, {"13", "4", "Critical Interrupt", "PCI PERR"}, {"13", "5", "Critical Interrupt", "PCI SERR"}, {"13", "6", "Critical Interrupt", "EISA Fail Safe Timeout"}, {"13", "7", "Critical Interrupt", "Bus Correctable Error"}, {"13", "8", "Critical Interrupt", "Bus Uncorrectable Error"}, {"13", "9", "Critical Interrupt", "Fatal NMI (port 61h, bit 7)"}, {"14", "0", "Button", "Power Button pressed"}, {"14", "1", "Button", "Sleep Button pressed"}, {"14", "2", "Button", "Reset Button pressed"}, {"15", "-", "Module / Board", "-"}, {"16", "-", "Microcontroller / Coprocessor", "-"}, {"17", "-", "Add-in Card", "-"}, {"18", "-", "Chassis", "-"}, {"19", "-", "Chip Set", "-"}, {"1A", "-", "Other FRU", "-"}, {"1B", "-", "Cable / Interconnect", "-"}, {"1C", "-", "Terminator", "-"}, {"1D", "0", "System Boot Initiated", "Initiated by power up"}, {"1D", "1", "System Boot Initiated", "Initiated by hard reset"}, {"1D", "2", "System Boot Initiated", "Initiated by warm reset"}, {"1D", "3", "System Boot Initiated", "User requested PXE boot"}, {"1D", "4", "System Boot Initiated", "Automatic boot to diagnostic"}, {"1E", "0", "Boot Error", "No bootable media"}, {"1E", "1", "Boot Error", "Non-bootable diskette left in drive"}, {"1E", "2", "Boot Error", "PXE Server not found"}, {"1E", "3", "Boot Error", "Invalid boot sector"}, {"1E", "4", "Boot Error", "Timeout waiting for user selection of boot source"}, {"1F", "0", "OS Boot", "A: boot completed"}, {"1F", "1", "OS Boot", "C: boot completed"}, {"1F", "2", "OS Boot", "PXE boot completed"}, {"1F", "3", "OS Boot", "Diagnostic boot completed"}, {"1F", "4", "OS Boot", "CD-ROM boot completed"}, {"1F", "5", "OS Boot", "ROM boot completed"}, {"1F", "6", "OS Boot", "boot completed - boot device not specified"}, {"20", "0", "OS Critical Stop", "Stop during OS load / initialization"}, {"20", "1", "OS Critical Stop", "Run-time Stop"}, {"21", "0", "Slot / Connector", "Fault Status asserted"}, {"21", "1", "Slot / Connector", "Identify Status asserted"}, {"21", "2", "Slot / Connector", "Slot / Connector Device installed/attached"}, {"21", "3", "Slot / Connector", "Slot / Connector Ready for Device Installation."}, {"21", "4", "Slot / Connector", "Slot/Connector Ready for Device Removal"}, {"21", "5", "Slot / Connector", "Slot Power is Off"}, {"21", "6", "Slot / Connector", "Slot / Connector Device Removal Request."}, {"21", "7", "Slot / Connector", "Interlock asserted."}, {"21", "8", "Slot / Connector", "Slot is Disabled"}, {"22", "0", "System ACPI Power State", "S0 / G0 'working'"}, {"22", "1", "System ACPI Power State", "S1 'sleeping with system h/w & processor context maintained'"}, {"22", "2", "System ACPI Power State", "S2 'sleeping, processor context lost'"}, {"22", "3", "System ACPI Power State", "S3 'sleeping, processor & h/w context lost, memory retained.'"}, {"22", "4", "System ACPI Power State", "S4 'non-volatile sleep / suspend-to disk'"}, {"22", "5", "System ACPI Power State", "S5 / G2 'soft-off'"}, {"22", "6", "System ACPI Power State", "S4 / S5 soft-off, particular S4 / S5 state cannot be determined"}, {"22", "7", "System ACPI Power State", "G3 / Mechanical Off"}, {"22", "8", "System ACPI Power State", "Sleeping in an S1, S2, or S3 states"}, {"22", "9", "System ACPI Power State", "G1 sleeping (S1-S4 state cannot be determined)"}, {"22", "A", "System ACPI Power State", "S5 entered by override"}, {"22", "B", "System ACPI Power State", "Legacy ON state"}, {"22", "C", "System ACPI Power State", "Legacy OFF state"}, {"22", "E", "System ACPI Power State", "Unknown"}, {"23", "0", "Watchdog 2", "Timer expired, status only (no action, no interrupt)"}, {"23", "1", "Watchdog 2", "Hard Reset"}, {"23", "2", "Watchdog 2", "Power Down"}, {"23", "3", "Watchdog 2", "Power Cycle"}, {"23", "4", "Watchdog 2", "reserved"}, {"23", "5", "Watchdog 2", "reserved"}, {"23", "6", "Watchdog 2", "reserved"}, {"23", "7", "Watchdog 2", "reserved"}, {"23", "8", "Watchdog 2", "Timer interrupt"}, {"24", "0", "Platform Alert", "platform generated page"}, {"24", "1", "Platform Alert", "platform generated LAN alert"}, {"24", "2", "Platform Alert", "Platform Event Trap generated, formatted per IPMI PET specification"}, {"24", "3", "Platform Alert", "platform generated SNMP trap, OEM format"}, {"25", "0", "Entity Presence", "Entity Present."}, {"25", "1", "Entity Presence", "Entity Absent."}, {"26", "-", "Monitor ASIC / IC", "-"}, {"27", "0", "LAN", "LAN Heartbeat Lost"}, {"27", "1", "LAN", "LAN Heartbeat"}, {"28", "0", "Management Subsystem Healt", "sensor access degraded or unavailable"}, {"28", "1", "Management Subsystem Healt", "controller access degraded or unavailable"}, {"28", "2", "Management Subsystem Healt", "management controller off-line"}, {"28", "3", "Management Subsystem Healt", "management controller unavailable"}, {"C1", "1", "Blade", "OverHeat"}, {"C2", "1", "PowerSupply", "OverHeat"}, {"C3", "1", "GigabitSwitch", "OverHeat"}, {"C4", "1", "Inifiniband", "OverHeat"}, {"C5", "1", "CMM", "CMM"}, {"-", "-", ""}};
    String[][] EventTypeCodes = new String[][]{{"1", "0", L.t("define.Lower_Non-critical_-_going_low")}, {"1", "1", L.t("define.Lower_Non-critical_-_going_high")}, {"1", "2", L.t("define.Lower_Critical_-_going_low")}, {"1", "3", L.t("define.Lower_Critical_-_going_high")}, {"1", "4", L.t("define.Lower_Non-recoverable_-_going_low")}, {"1", "5", L.t("define.Lower_Non-recoverable_-_going_high")}, {"1", "6", L.t("define.Upper_Non-critical_-_going_low")}, {"1", "7", L.t("define.Upper_Non-critical_-_going_high")}, {"1", "8", L.t("define.Upper_Critical_-_going_low")}, {"1", "9", L.t("define.Upper_Critical_-_going_high")}, {"1", "A", L.t("define.Upper_Non-recoverable_-_going_low")}, {"1", "B", L.t("define.Upper_Non-recoverable_-_going_high")}, {"2", "0", "Transition to Idle"}, {"2", "1", "Transition to Active"}, {"2", "2", "Transition to Busy"}, {"3", "0", "State Deasserted"}, {"3", "1", "State Asserted"}, {"4", "0", "Predictive Failure deasserted"}, {"4", "1", "Predictive Failure asserted"}, {"5", "0", "Limit Not Exceeded"}, {"5", "1", "Limit Exceeded"}, {"6", "0", "Performance Met"}, {"6", "1", "Performance Lags"}, {"7", "0", "transition to OK"}, {"7", "1", "transition to Non-Critical from OK"}, {"7", "2", "transition to Critical from less severe"}, {"7", "3", "transition to Non-recoverable from less severe"}, {"7", "4", "transition to Non-Critical from more severe"}, {"7", "5", "transition to Critical from Non-recoverable"}, {"7", "6", "transition to Non-recoverable"}, {"7", "7", "Monitor"}, {"7", "8", "Informational"}, {"8", "0", "Device Removed / Device Absent"}, {"8", "1", "Device Inserted / Device Present"}, {"9", "0", "Device Disabled"}, {"9", "1", "Device Enabled"}, {"A", "0", "transition to Running"}, {"A", "1", "transition to In Test"}, {"A", "2", "transition to Power Off"}, {"A", "3", "transition to On Line"}, {"A", "4", "transition to Off Line"}, {"A", "5", "transition to Off Duty"}, {"A", "6", "transition to Degraded"}, {"A", "7", "transition to Power Save"}, {"A", "8", "Install Error"}, {"B", "0", "Redundancy Regained"}, {"B", "1", "Redundancy Lost"}, {"B", "2", "Redundancy Degraded"}, {"-", "-", "Redundancy Degraded"}};
    public static final String confirm = "Confirmation";
    public static String IPMI_DOMAIN = "IPMI Domain";

    public String getSensorType(int TypeCode) {
        if (TypeCode >= 192) {
            return "OEM";
        }
        for (int i = 0; i < this.SensorTypeCodes.length; ++i) {
            if (Integer.toHexString(TypeCode).compareToIgnoreCase(this.SensorTypeCodes[i][0]) != 0) continue;
            return this.SensorTypeCodes[i][2];
        }
        return "undefined";
    }

    public String getSensorType(int TypeCode, byte eventData1) {
        return com.supermicro.ipmi.GlobalDefine.getSensorType(TypeCode, eventData1);
    }

    public String LookupSensorType(int SensorType, int Offset) {
        if (SensorType >= 192) {
            return "OEM";
        }
        int i = 0;
        while (this.SensorTypeCodes[i][0] != "-") {
            if (Integer.toHexString(SensorType).compareToIgnoreCase(this.SensorTypeCodes[i][0]) == 0) {
                while (Integer.toHexString(SensorType).compareToIgnoreCase(this.SensorTypeCodes[i][0]) == 0) {
                    if (this.SensorTypeCodes[i][1] == "-") {
                        return this.SensorTypeCodes[i][2];
                    }
                    if (Integer.toHexString(Offset).compareToIgnoreCase(this.SensorTypeCodes[i][1]) == 0) {
                        return this.SensorTypeCodes[i][2] + ", Event = " + this.SensorTypeCodes[i][3];
                    }
                    ++i;
                }
                return "undefined";
            }
            ++i;
        }
        return "undefined";
    }

    public String LookupEventType(int TypeCode, int Offset) {
        int i = 0;
        while (this.EventTypeCodes[i][0] != "-") {
            if (Integer.toHexString(TypeCode).compareToIgnoreCase(this.EventTypeCodes[i][0]) == 0 && Integer.toHexString(Offset).compareToIgnoreCase(this.EventTypeCodes[i][1]) == 0) {
                return this.EventTypeCodes[i][2];
            }
            ++i;
        }
        return "undefined";
    }

    public String getEventType(int TypeCode, byte SType, byte EData1, byte EData2, byte EData3) {
        byte[] productID = new byte[2];
        return this.getEventType(TypeCode, SType, EData1, EData2, EData3, productID);
    }

    public String getEventType(int TypeCode, byte SType, byte EData1, byte EData2, byte EData3, byte[] productID) {
        boolean Assertion = (TypeCode & 0x80) == 0;
        int EventType2 = TypeCode & 0x7F;
        String xString = null;
        xString = Assertion ? L.t("define.Assertion") + ": " : L.t("define.De-assertion") + ": ";
        if (EventType2 == 0) {
            return L.t("define.unspecified");
        }
        if (EventType2 >= 1 && EventType2 <= 11) {
            xString = xString + this.LookupEventType(EventType2, EData1 & 0xF);
        } else if (EventType2 == 111 || EventType2 == 112) {
            xString = xString + com.supermicro.ipmi.GlobalDefine.LookupSensorType(SType, EData1, EData2, EData3, productID);
        } else {
            if (EventType2 >= 112 && EventType2 <= 127) {
                return L.t("define.OEM");
            }
            return L.t("define.reserved");
        }
        return xString;
    }
}

