/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.Readable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HistoryMonitor
extends JPanel {
    static JCheckBox dateStampCB = new JCheckBox("Output Date Stamp");
    public Surface surf;
    JPanel controls;
    boolean doControls;
    JTextField tf;
    Readable readable;
    boolean refresh = false;

    public HistoryMonitor(Readable readable) {
        this.readable = readable;
        this.setLayout(new BorderLayout());
        this.surf = new Surface();
        this.add(this.surf);
        this.controls = new JPanel();
        Font font = new Font("serif", 0, 10);
        JLabel label = new JLabel("Sample Rate");
        label.setFont(font);
        label.setForeground(Color.black);
        this.controls.add(label);
        this.tf = new JTextField("1000");
        this.tf.setPreferredSize(new Dimension(45, 20));
        this.controls.add(this.tf);
        label = new JLabel("ms");
        this.controls.add(label);
        label.setFont(font);
        label.setForeground(Color.black);
        this.controls.add(dateStampCB);
        dateStampCB.setFont(font);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    public void setSleepTime(int second) {
        this.surf.sleepAmount = second * 1000;
    }

    public void updateHistory() {
        this.surf.updateHistory();
    }

    public static void main(String[] s) {
        final HistoryMonitor demo = new HistoryMonitor(null);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                demo.surf.start();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                demo.surf.stop();
            }
        };
        JFrame f = new JFrame("Java2D Demo - MemoryMonitor");
        f.addWindowListener(l);
        f.getContentPane().add("Center", demo);
        f.pack();
        f.setSize(new Dimension(160, 160));
        f.setVisible(true);
        demo.surf.start();
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 1000L;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private Runtime r = Runtime.getRuntime();
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private int ascent;
        private int descent;
        private float freeMemory;
        private float totalMemory;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
        }

        @Override
        public void setPreferredSize(Dimension d) {
            super.setPreferredSize(d);
        }

        @Override
        public void setSize(Dimension d) {
            super.setSize(d);
        }

        @Override
        public void paint(Graphics g) {
            if (this.bimg != null) {
                g.drawImage(this.bimg, 0, 0, this);
            }
        }

        private void paintHistoryChart() {
            if (this.big == null) {
                return;
            }
            float offset = HistoryMonitor.this.readable.getOffset();
            float highLimit = HistoryMonitor.this.readable.highLimit();
            float lowLimit = HistoryMonitor.this.readable.lowLimit();
            String title = HistoryMonitor.this.readable.getTitle();
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float freeMemory = HistoryMonitor.this.readable.getValue();
            float totalMemory = HistoryMonitor.this.readable.maxValue();
            this.big.setColor(Color.yellow);
            this.usedStr = String.valueOf((int)(totalMemory - freeMemory) / 1024);
            this.big.drawString(new Float(freeMemory).toString(), 4, this.h - this.descent);
            freeMemory += offset;
            float ssH = this.ascent + this.descent;
            float remainingHeight = (float)this.h - ssH * 2.0f - 0.5f;
            float blockHeight = remainingHeight / 10.0f;
            float blockWidth = 20.0f;
            float remainingWidth = (float)this.w - blockWidth - 10.0f;
            this.big.setColor(this.mfColor);
            int MemUsage = (int)(freeMemory / totalMemory * 10.0f);
            boolean i = false;
            this.big.setColor(Color.green);
            this.big.setColor(this.graphColor);
            int graphX = 5;
            int graphY = (int)ssH;
            int graphW = this.w - graphX - 5;
            int graphH = (int)remainingHeight;
            this.graphOutlineRect.setRect(graphX, graphY, graphW, graphH);
            this.big.draw(this.graphOutlineRect);
            int graphRow = graphH / 10;
            for (int j = graphY; j <= graphH + graphY; j += graphRow) {
                this.graphLine.setLine(graphX, j, graphX + graphW, j);
                this.big.draw(this.graphLine);
            }
            this.big.setColor(this.graphColor);
            int graphColumn = graphW / 15;
            if (this.columnInc == 0) {
                this.columnInc = graphColumn;
            }
            for (int j = graphX + this.columnInc; j < graphW + graphX; j += graphColumn) {
                this.graphLine.setLine(j, graphY, j, graphY + graphH);
                this.big.draw(this.graphLine);
            }
            this.big.setColor(Color.blue);
            int offsetValue = (int)((float)(graphY + graphH) - (float)graphH * (offset / totalMemory));
            this.graphLine.setLine(graphX, offsetValue, graphX + graphW, offsetValue);
            this.big.draw(this.graphLine);
            this.big.setColor(Color.red);
            int chartHighLimit = 0;
            int chartLowLimit = 0;
            if (highLimit != -1.0f) {
                chartHighLimit = (int)((float)(graphY + graphH) - (float)graphH * ((highLimit + offset) / totalMemory));
                this.graphLine.setLine(graphX, chartHighLimit, graphX + graphW, chartHighLimit);
                this.big.draw(this.graphLine);
            }
            if (lowLimit != -1.0f) {
                chartLowLimit = (int)((float)(graphY + graphH) - (float)graphH * ((lowLimit + offset) / totalMemory));
                this.graphLine.setLine(graphX, chartLowLimit, graphX + graphW, chartLowLimit);
                this.big.draw(this.graphLine);
            }
            if (this.pts == null) {
                this.pts = new int[graphW];
                this.ptNum = 0;
            } else if (this.pts.length != graphW) {
                int[] tmp = null;
                if (this.ptNum < graphW) {
                    tmp = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, tmp, 0, tmp.length);
                } else {
                    tmp = new int[graphW];
                    System.arraycopy(this.pts, this.pts.length - tmp.length, tmp, 0, tmp.length);
                    this.ptNum = tmp.length - 2;
                }
                this.pts = new int[graphW];
                System.arraycopy(tmp, 0, this.pts, 0, tmp.length);
            } else {
                this.pts[this.ptNum] = (int)((float)(graphY + graphH) - (float)graphH * (freeMemory / totalMemory));
                int j = graphX + graphW - this.ptNum;
                int k = 0;
                while (k < this.ptNum) {
                    if (this.pts[k] > chartLowLimit && lowLimit != -1.0f || this.pts[k] < chartHighLimit && highLimit != -1.0f) {
                        this.big.setColor(Color.red);
                    } else {
                        this.big.setColor(Color.yellow);
                    }
                    if (k != 0) {
                        if (this.pts[k] != this.pts[k - 1]) {
                            if (this.pts[k] != offsetValue) {
                                this.big.drawLine(j - 1, this.pts[k - 1], j, this.pts[k]);
                            }
                        } else if (this.pts[k] != offsetValue) {
                            this.big.fillRect(j, this.pts[k], 1, 1);
                        }
                    }
                    ++k;
                    ++j;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    for (j = 1; j < this.ptNum; ++j) {
                        this.pts[j - 1] = this.pts[j];
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (true) {
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException e) {
                    break;
                }
                Dimension d = this.getPreferredSize();
                this.w = d.width;
                this.h = d.height;
                if (this.w <= 0 || this.h <= 0) continue;
                if (this.bimg == null) {
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                }
                this.big = this.bimg.createGraphics();
                this.big.setFont(this.font);
                FontMetrics fm = this.big.getFontMetrics(this.font);
                this.ascent = fm.getAscent();
                this.descent = fm.getDescent();
                this.paintHistoryChart();
                this.repaint();
                if (!dateStampCB.isSelected()) continue;
            }
            this.thread = null;
        }

        public void updateHistory() {
            Dimension d = this.getPreferredSize();
            this.w = d.width;
            this.h = d.height;
            if (this.w <= 0 || this.h <= 0) {
                return;
            }
            if (this.bimg == null) {
                this.bimg = (BufferedImage)this.createImage(this.w, this.h);
            }
            this.big = this.bimg.createGraphics();
            this.big.setFont(this.font);
            FontMetrics fm = this.big.getFontMetrics(this.font);
            this.ascent = fm.getAscent();
            this.descent = fm.getDescent();
            this.paintHistoryChart();
            this.repaint();
        }
    }
}

