/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class JTextTempPanel
extends JPanel {
    public static final byte TEMPERATURE_LOW = 0;
    public static final byte TEMPERATURE_MEDIUM = 1;
    public static final byte TEMPERATURE_HIGH = 2;
    public static final byte TEMPERATURE_OVERHEAT = 4;
    public static final byte TEMPERATURE_NOT_INSTALLED = 7;
    public static final byte TEMPERATURE_NA = -1;
    Icon lowIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon mediumIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon highIcon = new ImageIcon(this.getClass().getResource("/images/warning_yellow.gif"));
    Icon overheatIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    public String sensorName;
    public int sensorNumber;
    public byte reading;
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jNameLabel = new JLabel();
    JLabel jCpuTempLabel = new JLabel();
    JPanel jPanel1 = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");

    public JTextTempPanel(String sensorName, int sensorNumber) {
        try {
            this.sensorName = sensorName;
            this.sensorNumber = sensorNumber;
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateStatus(byte reading) {
        this.reading = reading;
        switch (reading) {
            case 0: {
                this.showTemperatureLow();
                break;
            }
            case 1: {
                this.showTemperatureMedium();
                break;
            }
            case 2: {
                this.showTemperatureHigh();
                break;
            }
            case 4: {
                this.showTemperatureOverheat();
                break;
            }
            case -1: 
            case 7: {
                this.showTemperatureUnknown();
                break;
            }
            default: {
                this.showTemperatureUnknown();
            }
        }
    }

    public void showTemperatureLow() {
        this.jCpuTempLabel.setText("Low");
        this.jCpuTempLabel.setIcon(this.lowIcon);
        this.jCpuTempLabel.setForeground(Color.blue);
        this.jNameLabel.setForeground(Color.blue);
    }

    public void showTemperatureMedium() {
        this.jCpuTempLabel.setText("Medium");
        this.jCpuTempLabel.setIcon(this.mediumIcon);
        this.jCpuTempLabel.setForeground(Color.blue);
        this.jNameLabel.setForeground(Color.blue);
    }

    public void showTemperatureHigh() {
        this.jCpuTempLabel.setText("High");
        this.jCpuTempLabel.setIcon(this.highIcon);
        this.jCpuTempLabel.setForeground(Color.red);
        this.jNameLabel.setForeground(Color.red);
    }

    public void showTemperatureOverheat() {
        this.jCpuTempLabel.setText("Overheat");
        this.jCpuTempLabel.setIcon(this.overheatIcon);
        this.jCpuTempLabel.setForeground(Color.red);
        this.jNameLabel.setForeground(Color.red);
    }

    public void showTemperatureUnknown() {
        this.jCpuTempLabel.setText("N/A");
        this.jCpuTempLabel.setIcon(null);
        this.jCpuTempLabel.setForeground(Color.blue);
        this.jNameLabel.setForeground(Color.blue);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setBorder(null);
        this.setPreferredSize(new Dimension(150, 50));
        this.jNameLabel.setForeground(Color.blue);
        this.jNameLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jNameLabel.setHorizontalAlignment(0);
        this.jNameLabel.setText("CPU Temp");
        this.jCpuTempLabel.setFont(new Font("Arial", 1, 20));
        this.jCpuTempLabel.setForeground(Color.blue);
        this.jCpuTempLabel.setHorizontalAlignment(0);
        this.jCpuTempLabel.setIcon(this.lowIcon);
        this.jCpuTempLabel.setText("Low");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.jNameLabel, "South");
        this.jPanel1.add(this.jCpuTempLabel);
        this.add((Component)this.jPanel1, "Center");
    }

    private void myInit() {
        this.jNameLabel.setText(this.sensorName);
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public int getSensorNumber() {
        return this.sensorNumber;
    }
}

