/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SDRDevice
extends JPanel {
    boolean bLoaded = false;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    JLabel Message;
    CSession Session;
    int TabId;
    UDPSocket udpSocket;
    int TotalEntries = 0;
    private JTextField EFrom;
    private JTextField ETo;
    private JLabel FreeSpace;
    private JLabel REAdd;
    private JLabel REErase;
    private JTextField SDRTime;
    private JLabel SELVersion;
    private JLabel TotalEntry;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;

    public SDRDevice() {
        this.initComponents();
        this.buttonGroup1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
    }

    public void preset(UDPSocket xSocket, CSession iSession, JLabel xMessage) {
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        this.GetSDRRepoInfo();
        this.GetSDRRepoTime();
        this.TabId = iSession.Loading;
    }

    private boolean GetSDRRepoInfo() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.Message.setText("Getting SDR Repository Info");
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)32, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                this.Message.setText("Get SDR Repository Info succeeded");
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                this.SELVersion.setText((bytex[0] & 0xF) + "." + ((bytex[0] & 0xF0) >> 4));
                bytex = (byte[])this.rmcpPacket.retValue.get(1);
                this.TotalEntries = this.ByteToInt(bytex, 0, 2);
                this.EFrom.setText("1");
                this.ETo.setText(this.TotalEntries + "");
                this.TotalEntry.setText(this.TotalEntries + "");
                bytex = (byte[])this.rmcpPacket.retValue.get(2);
                this.FreeSpace.setText(this.ByteToInt(bytex, 0, 2) + " bytes");
                bytex = (byte[])this.rmcpPacket.retValue.get(3);
                SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                long k = (long)this.ByteToInt(bytex, 0, 4) * 1000L;
                Date d = new Date(k);
                this.REAdd.setText(f.format(d));
                bytex = (byte[])this.rmcpPacket.retValue.get(4);
                k = (long)this.ByteToInt(bytex, 0, 4) * 1000L;
                d = new Date(k);
                this.REErase.setText(f.format(d));
                bResult = true;
            } else {
                this.Message.setText("Get SDR Repository Info failed");
            }
        } else {
            this.Message.setText("Get SDR Repository Info failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean GetSDRRepoTime() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.Message.setText("Getting SDR Repository Time");
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)40, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                this.Message.setText("Get SDR Repository Time succeeded");
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                long k = (long)this.ByteToInt(bytex, 0, 4) * 1000L;
                Date d = new Date(k);
                this.SDRTime.setText(f.format(d));
                bResult = true;
            } else {
                this.Message.setText("Get SDR Repository failed");
            }
        } else {
            this.Message.setText("Get SDR Repository failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean GetSensor(int SensorNum, byte[] byteResult) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        byte[] SNum = new byte[1];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.removeAllElements();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        SNum[0] = (byte)SensorNum;
        Para.addElement(SNum);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)16, (byte)45, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, byteResult, 0, bytex.length);
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean GetSDRRecord(byte[] ReserveID, byte[] RecordID, byte[] NextRecordID, byte[] Offset, byte[] byteResult, int[] retlength) {
        byte[] AuthType = new byte[]{0};
        byte[] ByteToRead = new byte[]{-1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.removeAllElements();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(ReserveID);
        Para.addElement(RecordID);
        Para.addElement(Offset);
        Para.addElement(ByteToRead);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)35, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, NextRecordID, 0, 2);
                bytex = (byte[])this.rmcpPacket.retValue.get(1);
                System.arraycopy(bytex, 0, byteResult, 0, bytex.length);
                retlength[0] = bytex.length;
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean ReserveSDR(byte[] ReserveID) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.removeAllElements();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)34, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, ReserveID, 0, 2);
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean GetSDRRecords() {
        byte[] RecordID = new byte[]{0, 0};
        byte[] NextRecordID = new byte[]{0, 0};
        byte[] ReserveID = new byte[]{0, 0};
        byte[] Offset = new byte[]{0};
        byte[] bytex = new byte[128];
        byte[] bytey = new byte[128];
        byte[] bytez = new byte[128];
        int[] lengthx = new int[1];
        int[] lengthz = new int[1];
        int StartE = 0;
        int EndE = 0;
        int ArrayNum = 9;
        Vector Para = new Vector(1);
        boolean bResult = false;
        Vector<String[]> vRecords = new Vector<String[]>(10);
        Object[] ColumnHead = new String[]{"ID", "Version", "Type", "Length", "Sensor Number", "Sensor Type", "Reading", "ID String", "Value"};
        String[] toolTipStr = new String[]{"ID used for record organization and access", "Version of the Sensor Model specification that this record is compatiable with", "Record Type", "Number of remaining record bytes following", "Sensor Number", "Sensor Type", "Sensor Reading", "ID String", "Actual Value"};
        if (this.jRadioButton1.isSelected()) {
            StartE = 0;
            EndE = this.TotalEntries - 1;
        } else {
            try {
                StartE = Integer.parseInt(this.EFrom.getText());
                EndE = Integer.parseInt(this.ETo.getText());
                if (StartE < 1) {
                    StartE = 1;
                }
                if (EndE > this.TotalEntries) {
                    EndE = this.TotalEntries;
                }
            }
            catch (Exception e) {
                JOptionPane MBox = new JOptionPane();
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Invalid numeric!");
                StartE = 1;
                EndE = this.TotalEntries;
            }
        }
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        RecordID[0] = (byte)StartE;
        RecordID[1] = (byte)(StartE >> 8);
        if (this.ReserveSDR(ReserveID)) {
            for (int i = StartE; i <= EndE; ++i) {
                bResult = false;
                this.Message.setText("Getting SDR Record: " + i);
                Offset[0] = 0;
                if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytex, lengthx)) {
                    int totallen;
                    this.Message.setText("Get SDR Record: " + i + " succeeded");
                    String[] xString = new String[ArrayNum];
                    xString[0] = new String(this.ByteToInt(bytex, 0, 2) + "");
                    xString[1] = new String((bytex[2] & 0xF) + "." + (bytex[2] & 0xF0));
                    xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h");
                    if (bytex[3] == 1) {
                        int BExp;
                        int RExp;
                        int B;
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (Full Sensor)");
                        xString[4] = new String(this.ByteToInt(bytex, 7, 1) + "");
                        xString[5] = this.gd.getSensorType(this.ByteToInt(bytex, 12, 1));
                        this.GetSensor(bytex[7] & 0xFF, bytey);
                        int X = this.ByteToInt(bytey, 0, 1);
                        xString[6] = new String(X + "");
                        for (totallen = bytex[4] - lengthx[0] + 5; totallen > 0; totallen -= lengthz[0]) {
                            Offset[0] = (byte)lengthx[0];
                            if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytez, lengthz)) {
                                System.arraycopy(bytez, 0, bytex, lengthx[0], lengthz[0]);
                                lengthx[0] = lengthx[0] + lengthz[0];
                                continue;
                            }
                            this.Message.setText("Get SDR Record: " + i + " failed");
                            break;
                        }
                        ByteArrayOutputStream strout = new ByteArrayOutputStream();
                        strout.write(bytex, 48, bytex[47] & 0x1F);
                        xString[7] = strout.toString();
                        int M = (bytex[25] & 0xC0) * 4 + (bytex[24] & 0xFF);
                        if (M >= 512) {
                            M = -(512 - (M & 0x1FF));
                        }
                        if ((B = (bytex[27] & 0xC0) * 4 + (bytex[26] & 0xFF)) >= 512) {
                            B = -(512 - (B & 0x1FF));
                        }
                        if ((RExp = (bytex[29] & 0xF0) >> 4) >= 8) {
                            RExp = -(8 - (RExp & 7));
                        }
                        if ((BExp = bytex[29] & 0xF) >= 8) {
                            BExp = -(8 - (BExp & 7));
                        }
                        int Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                        xString[8] = new String((double)Value / 100.0 + "");
                    } else if (bytex[3] == 2) {
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (Compact Sensor)");
                        xString[4] = new String(this.ByteToInt(bytex, 7, 1) + "");
                        xString[5] = new String(this.ByteToInt(bytex, 12, 1) + "");
                        this.GetSensor(bytex[7] & 0xFF, bytey);
                        xString[6] = new String(this.ByteToInt(bytey, 0, 1) + "");
                        for (totallen = bytex[4] - lengthx[0] + 5; totallen > 0; totallen -= lengthz[0]) {
                            Offset[0] = (byte)lengthx[0];
                            if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytez, lengthz)) {
                                System.arraycopy(bytez, 0, bytex, lengthx[0], lengthz[0]);
                                lengthx[0] = lengthx[0] + lengthz[0];
                                continue;
                            }
                            this.Message.setText("Get SDR Record: " + i + " failed");
                            break;
                        }
                        ByteArrayOutputStream strout = new ByteArrayOutputStream();
                        strout.write(bytex, 32, bytex[31] & 0x1F);
                        xString[7] = strout.toString();
                    } else if (bytex[3] == 8) {
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (Entity Association)");
                    } else if (bytex[3] == 9) {
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (Device-relative Entity Association)");
                    } else if (bytex[3] == 16) {
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (generic Device Locator)");
                    } else if (bytex[3] == 17) {
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (FRU Device Locator)");
                    } else if (bytex[3] == 18) {
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (IPMB Management Controller Device Locator)");
                    } else if (bytex[3] == 19) {
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (IPMB Management Controller Device Confirmation)");
                    } else if (bytex[3] == 20) {
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (BMC Message Channel Info)");
                    } else if (bytex[3] == -64) {
                        xString[2] = new String(Integer.toHexString(this.ByteToInt(bytex, 3, 1)) + "h (OEM)");
                    }
                    xString[3] = new String(this.ByteToInt(bytex, 4, 1) + "");
                    vRecords.addElement(xString);
                    System.arraycopy(NextRecordID, 0, RecordID, 0, 2);
                    bResult = true;
                    continue;
                }
                this.Message.setText("Get SDR Record: " + i + " failed");
            }
        }
        Object[][] Records = new String[vRecords.size()][ArrayNum];
        for (int j = 0; j < vRecords.size(); ++j) {
            for (int k = 0; k < ArrayNum; ++k) {
                Records[j][k] = ((String[])vRecords.get(j))[k];
            }
        }
        JTable jTable1 = new JTable(Records, ColumnHead);
        jTable1.setAutoResizeMode(0);
        ToolTipHeader header = new ToolTipHeader(jTable1.getColumnModel());
        header.setToolTipStrings(toolTipStr);
        header.setToolTipText("Default ToolTip TEXT");
        jTable1.setTableHeader(header);
        TableColumn tc = jTable1.getColumn("ID");
        tc.setPreferredWidth(30);
        tc = jTable1.getColumn("Type");
        tc.setPreferredWidth(140);
        this.jScrollPane1.setViewportView(jTable1);
        this.Message.setText("Get SDR Record is successful");
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.EFrom = new JTextField();
        this.jLabel2 = new JLabel();
        this.ETo = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel4 = new JLabel();
        this.SELVersion = new JLabel();
        this.jLabel6 = new JLabel();
        this.TotalEntry = new JLabel();
        this.jLabel8 = new JLabel();
        this.FreeSpace = new JLabel();
        this.jLabel10 = new JLabel();
        this.REAdd = new JLabel();
        this.jLabel12 = new JLabel();
        this.REErase = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jLabel14 = new JLabel();
        this.SDRTime = new JTextField();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jLabel3 = new JLabel();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel1.setText("Sensor Data Record Repository");
        this.jLabel1.setForeground(Color.blue);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setFont(new Font("Microsoft Sans Serif", 0, 18));
        this.jLabel1.setOpaque(true);
        this.add((Component)this.jLabel1, new AbsoluteConstraints(160, 0, 300, 30));
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel1.setBorder(new TitledBorder("Get Records"));
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("All");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDRDevice.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jRadioButton1, new AbsoluteConstraints(30, 20, -1, -1));
        this.jRadioButton2.setText("From");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDRDevice.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jRadioButton2, new AbsoluteConstraints(30, 50, 50, 20));
        this.EFrom.setEditable(false);
        this.jPanel1.add((Component)this.EFrom, new AbsoluteConstraints(80, 50, 40, 20));
        this.jLabel2.setText("To");
        this.jLabel2.setHorizontalAlignment(0);
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(130, 50, -1, 20));
        this.ETo.setEditable(false);
        this.jPanel1.add((Component)this.ETo, new AbsoluteConstraints(150, 50, 40, 20));
        this.jButton1.setText("Get");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SDRDevice.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton1, new AbsoluteConstraints(70, 80, 110, 30));
        this.add((Component)this.jPanel1, new AbsoluteConstraints(40, 40, 230, 120));
        this.jLabel4.setText("SDR Version:");
        this.jLabel4.setHorizontalAlignment(4);
        this.add((Component)this.jLabel4, new AbsoluteConstraints(280, 50, 130, -1));
        this.SELVersion.setForeground(Color.blue);
        this.SELVersion.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.SELVersion, new AbsoluteConstraints(420, 50, 90, -1));
        this.jLabel6.setText("Total Records:");
        this.jLabel6.setHorizontalAlignment(4);
        this.add((Component)this.jLabel6, new AbsoluteConstraints(280, 70, 130, -1));
        this.TotalEntry.setForeground(Color.blue);
        this.TotalEntry.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.TotalEntry, new AbsoluteConstraints(420, 70, 90, -1));
        this.jLabel8.setText("Free Space:");
        this.jLabel8.setHorizontalAlignment(4);
        this.add((Component)this.jLabel8, new AbsoluteConstraints(280, 90, 130, -1));
        this.FreeSpace.setForeground(Color.blue);
        this.FreeSpace.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.FreeSpace, new AbsoluteConstraints(420, 90, 90, -1));
        this.jLabel10.setText("Recent Record Added:");
        this.jLabel10.setHorizontalAlignment(4);
        this.add((Component)this.jLabel10, new AbsoluteConstraints(280, 110, 130, -1));
        this.REAdd.setForeground(Color.blue);
        this.REAdd.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.REAdd, new AbsoluteConstraints(420, 110, 150, -1));
        this.jLabel12.setText("Recent Record Erased:");
        this.jLabel12.setHorizontalAlignment(4);
        this.add((Component)this.jLabel12, new AbsoluteConstraints(280, 130, 130, -1));
        this.REErase.setForeground(Color.blue);
        this.REErase.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.REErase, new AbsoluteConstraints(420, 130, 150, -1));
        this.add((Component)this.jScrollPane1, new AbsoluteConstraints(40, 170, 520, 180));
        this.jLabel14.setText("Current SDR Timestamp:");
        this.add((Component)this.jLabel14, new AbsoluteConstraints(40, 420, 190, -1));
        this.add((Component)this.SDRTime, new AbsoluteConstraints(230, 420, 170, 20));
        this.jButton3.setText("Set Timestamp");
        this.add((Component)this.jButton3, new AbsoluteConstraints(410, 410, 120, 30));
        this.jButton4.setText("Clear All Entries");
        this.add((Component)this.jButton4, new AbsoluteConstraints(300, 360, 160, 30));
        this.jButton5.setText("Delete Selected Entry");
        this.add((Component)this.jButton5, new AbsoluteConstraints(140, 360, 160, 30));
        this.jLabel3.setText("Developing purpose only.  This function is replaced by Sensors. ");
        this.add((Component)this.jLabel3, new AbsoluteConstraints(120, 470, 410, -1));
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.EFrom.setEditable(true);
        this.ETo.setEditable(true);
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.EFrom.setEditable(false);
        this.ETo.setEditable(false);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            @Override
            public void run() {
                SDRDevice.this.GetSDRRecords();
            }
        };
        th.start();
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    class ToolTipHeader
    extends JTableHeader {
        String[] toolTips;

        public ToolTipHeader(TableColumnModel model) {
            super(model);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            String retStr;
            int col = this.columnAtPoint(e.getPoint());
            int modelCol = this.getTable().convertColumnIndexToModel(col);
            try {
                retStr = this.toolTips[modelCol];
            }
            catch (NullPointerException ex) {
                retStr = "";
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                retStr = "";
            }
            if (retStr.length() < 1) {
                retStr = super.getToolTipText(e);
            }
            return retStr;
        }

        public void setToolTipStrings(String[] toolTips) {
            this.toolTips = toolTips;
        }
    }
}

