/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.UOLImageFile;
import IPMIView20.UOLMessage;
import IPMIView20.UOLSession;
import IPMIView20.UOLUDPHandler;
import IPMIView20.UOLUDPSocket;
import java.net.SocketException;

public class UOLMessageFactory {
    public static UOLMessage establishConnectionMessage() {
        UOLMessage uolMessage = new UOLMessage();
        uolMessage.setVersion((byte)9);
        uolMessage.setChannelID((byte)0);
        uolMessage.setState((byte)0);
        uolMessage.setStatus((byte)32);
        uolMessage.setPacketSequenceNumber((byte)1);
        uolMessage.setACKSequenceNumber((byte)0);
        byte[] b = new byte[]{0, 0};
        uolMessage.setDataSize(b);
        uolMessage.setHeadChecksum((byte)0);
        return uolMessage;
    }

    public static UOLMessage keepSessionMessage(UOLSession session) {
        byte seq = 0;
        seq = session.getKeepSessionPacketSequence() == -1 ? (byte)(session.getPacketSequence() + 1) : (byte)(session.getKeepSessionPacketSequence() + 1);
        UOLMessage uolMessage = new UOLMessage();
        uolMessage.setVersion((byte)9);
        uolMessage.setChannelID((byte)0);
        uolMessage.setState((byte)18);
        uolMessage.setStatus((byte)0);
        uolMessage.setPacketSequenceNumber(seq);
        uolMessage.setACKSequenceNumber((byte)0);
        byte[] b = new byte[]{2, 0};
        uolMessage.setDataSize(b);
        byte[] data = new byte[]{5, -1};
        uolMessage.setData(data);
        uolMessage.setHeadChecksum((byte)0);
        return uolMessage;
    }

    public static UOLMessage closeConnectionMessage() {
        UOLMessage uolMessage = new UOLMessage();
        uolMessage.setVersion((byte)9);
        uolMessage.setChannelID((byte)0);
        uolMessage.setState((byte)2);
        uolMessage.setStatus((byte)16);
        uolMessage.setPacketSequenceNumber((byte)0);
        uolMessage.setACKSequenceNumber((byte)0);
        byte[] b = new byte[]{0, 0};
        uolMessage.setDataSize(b);
        uolMessage.setHeadChecksum((byte)0);
        return uolMessage;
    }

    public static void main_messageTest(String[] args) {
        UOLMessage uolMessage = UOLMessageFactory.establishConnectionMessage();
        System.out.println(uolMessage.toByteString());
        UOLSession session = new UOLSession();
        session.setPacketSequence((byte)1);
        uolMessage = UOLMessageFactory.keepSessionMessage(session);
        System.out.println(uolMessage.toByteString());
        System.out.println(uolMessage.replyACKOnlyMessage().toByteString());
    }

    public static void main(String[] args) throws SocketException {
        UOLSession session = new UOLSession();
        UOLMessage uolMessage = UOLMessageFactory.establishConnectionMessage();
        UOLUDPSocket udp = new UOLUDPSocket("192.168.10.245");
        UOLImageFile file = new UOLImageFile();
        file.load("D:\\test.IMG");
        UOLUDPHandler handler = new UOLUDPHandler("192.168.10.245", 664, udp, session, file, null);
        handler.start();
        udp.sendPacket(uolMessage.toByteArray());
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }
}

