/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.Logger;
import IPMIView20.UOLDebug;
import IPMIView20.UOLImageFile;
import IPMIView20.UOLKeepSessionWatchDog;
import IPMIView20.UOLMessage;
import IPMIView20.UOLMessageFactory;
import IPMIView20.UOLMessageHandler;
import IPMIView20.UOLOutputInterface;
import IPMIView20.UOLSession;
import IPMIView20.UOLUDPSocket;
import IPMIView20.uol.UOLPacketSender;
import IPMIView20.uol.UOLStorage;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UOLUDPHandler
extends Thread {
    DatagramSocket socket;
    DatagramPacket packet;
    UOLUDPSocket uolUDPSocket;
    InetAddress address;
    InetAddress localAddress;
    UOLSession session;
    UOLMessageHandler messageHandler;
    UOLImageFile file;
    UOLKeepSessionWatchDog watchDog;
    UOLOutputInterface output = null;
    int port;
    boolean flag = true;
    byte[] recvBuf = new byte[256];
    UOLPacketSender uolPacketSender;
    UOLStorage uolStorage;

    public UOLUDPHandler(String ip, int port, UOLUDPSocket uolUDPSocket, UOLSession session, UOLImageFile file, UOLOutputInterface output) throws SocketException {
        this.socket = new DatagramSocket(port);
        this.port = port;
        this.uolUDPSocket = uolUDPSocket;
        this.file = file;
        this.session = session;
        this.uolStorage = new UOLStorage();
        this.uolPacketSender = new UOLPacketSender(this.uolStorage, uolUDPSocket);
        this.uolPacketSender.start();
        this.messageHandler = new UOLMessageHandler(session, uolUDPSocket, file, output, this.uolStorage, this.uolPacketSender);
        this.watchDog = new UOLKeepSessionWatchDog(20, uolUDPSocket, session, output);
        this.output = output;
        try {
            this.address = InetAddress.getByName(ip);
            this.localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ue) {
            System.out.println("UnknowHostException error ");
        }
    }

    public void stopHandler() {
        this.flag = false;
        this.socket.disconnect();
        this.socket.close();
        this.uolPacketSender.stopSend();
    }

    public void stopUOL() {
        this.flag = false;
        this.uolUDPSocket.sendPacket(UOLMessageFactory.closeConnectionMessage().toByteArray());
        this.socket.close();
        this.uolPacketSender.stopSend();
        if (this.output != null) {
            this.output.outputLog("Close Connection");
        }
    }

    @Override
    public void run() {
        this.flag = true;
        int rlength = 256;
        while (this.flag) {
            this.packet = new DatagramPacket(this.recvBuf, rlength, this.localAddress, this.port);
            try {
                this.socket.receive(this.packet);
                int size = this.packet.getLength();
                UOLMessage message = UOLMessage.makeMessage(this.recvBuf);
                if (message.getACKSequenceNumber() != 0 && message.getPacketSequenceNumber() == 0) {
                    if (UOLDebug.debugLevel >= 1) {
                        Logger.writeLog("<<-- :" + message.toByteString() + "(BMC Normal ACK)");
                    }
                    this.messageHandler.processReply(message);
                    this.watchDog.stop();
                    this.watchDog.start();
                    continue;
                }
                if ((message.getState() & 0xF0) == 32) {
                    if (UOLDebug.debugLevel >= 1) {
                        Logger.writeLog("<<-- :" + message.toByteString() + "(BMC BULK ACK)");
                    }
                    this.messageHandler.processReply(message);
                    this.watchDog.stop();
                    this.watchDog.start();
                    continue;
                }
                if (UOLDebug.debugLevel >= 1) {
                    Logger.writeLog("<<-- :" + message.toByteString() + "(" + message.stateToString() + ")");
                }
                this.messageHandler.process(message);
            }
            catch (Exception ex) {
                Logger.writeLog("receive error:" + ex.toString());
            }
        }
    }

    private String byteToString(byte b) {
        int i = b & 0xFF;
        String strByte = Integer.toHexString(i);
        if (strByte.length() == 1) {
            strByte = "0" + strByte;
        }
        if (strByte.length() > 2) {
            strByte = strByte.substring(strByte.length() - 1, strByte.length());
        }
        strByte = strByte.toUpperCase();
        return strByte;
    }

    public String toByteString(byte[] byteArray, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append(this.byteToString(byteArray[i]) + " ");
        }
        return sb.toString();
    }

    public void setUOLOutputInterface(UOLOutputInterface output) {
        this.output = output;
        this.messageHandler.output = output;
        this.messageHandler.ufiMessageHandler.output = output;
        this.watchDog.output = output;
    }
}

