/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.trap.Trap;
import IPMIView20.trap.TrapReceiverListener;
import IPMIView20.trap.TrapReceiverStartStopListener;
import IPMIView20.trap.TrapView;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.swing.GrayFilter;
import javax.swing.UIManager;
import org.tanukisoftware.wrapper.WrapperManager;

public class TrapReceiverTray {
    private static TrapReceiverTray trapReceiverTray;
    private CheckboxMenuItem autoStartServiceCheckboxMenuItem;
    private TrayIcon trayIcon;
    private Image startImage;
    private Image stopImage;
    public TrapView trapView;
    private Properties properties;
    private String script;
    private boolean trapReceiverState;
    private final String osName = System.getProperty("os.name");

    private TrapReceiverTray() {
    }

    public static TrapReceiverTray getInstance() {
        TrapReceiverTray temp;
        if (trapReceiverTray == null && (temp = new TrapReceiverTray()).init()) {
            trapReceiverTray = temp;
        }
        return trapReceiverTray;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setTrapReceiverState(boolean trapReceiverState) {
        this.trapReceiverState = trapReceiverState;
    }

    private boolean init() {
        if (SystemTray.isSupported()) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            this.trapView = new TrapView();
            this.trapView.frame.setIPMIViewStart(true);
            this.trapView.frame.addTrapReceiverStartStopListener(new TrapReceiverStartStopListener(){

                @Override
                public void action(boolean start) {
                    if (TrapReceiverTray.this.osName.contains("Windows")) {
                        if (TrapReceiverTray.this.trapView.frame.isReceiverStart()) {
                            TrapReceiverTray.this.trayIcon.setImage(TrapReceiverTray.this.startImage);
                        } else {
                            TrapReceiverTray.this.trayIcon.setImage(TrapReceiverTray.this.stopImage);
                        }
                    } else if (TrapReceiverTray.this.osName.contains("Linux")) {
                        TrapReceiverTray.this.trapView.frame.trapViewController.receiver.stopReceiver();
                        if (!TrapReceiverTray.this.trapReceiverState) {
                            TrapReceiverTray.this.trayIcon.setImage(TrapReceiverTray.this.stopImage);
                            TrapReceiverTray.this.trapView.frame.jStartButton.setEnabled(true);
                            TrapReceiverTray.this.trapView.frame.jStopButton.setEnabled(false);
                            return;
                        }
                        if (start) {
                            TrapReceiverTray.this.trayIcon.setImage(TrapReceiverTray.this.startImage);
                            TrapReceiverTray.this.trapView.frame.jStartButton.setEnabled(false);
                            TrapReceiverTray.this.trapView.frame.jStopButton.setEnabled(true);
                        } else {
                            TrapReceiverTray.this.trayIcon.setImage(TrapReceiverTray.this.stopImage);
                            TrapReceiverTray.this.trapView.frame.jStartButton.setEnabled(true);
                            TrapReceiverTray.this.trapView.frame.jStopButton.setEnabled(false);
                        }
                    }
                }
            });
            this.trapView.frame.trapViewController.receiver.addTrapReceiverListener(new TrapReceiverListener(){

                @Override
                public void action(Trap trap) {
                    trapReceiverTray.showMessage(trap.getDescription());
                }
            });
            MenuItem showMenuItem = new MenuItem("Show");
            showMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrapReceiverTray.this.trapView.frame.setVisible(true);
                    TrapReceiverTray.this.trapView.frame.setState(0);
                }
            });
            MenuItem hideMenuItem = new MenuItem("Hide");
            hideMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrapReceiverTray.this.trapView.frame.setVisible(false);
                }
            });
            this.autoStartServiceCheckboxMenuItem = new CheckboxMenuItem("Auto Start Service");
            this.autoStartServiceCheckboxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String command = new String();
                    if (TrapReceiverTray.this.osName.contains("Windows")) {
                        command = "sc config " + TrapReceiverTray.this.properties.getProperty("wrapper.ntservice.name", "") + " start= ";
                        command = e.getStateChange() == 1 ? command + "auto" : command + "demand";
                    } else if (TrapReceiverTray.this.osName.contains("Linux")) {
                        command = e.getStateChange() == 1 ? "ln -s " + TrapReceiverTray.this.script + " " + "/etc/init.d/" : "rm /etc/init.d/" + TrapReceiverTray.this.properties.getProperty("wrapper.name", "");
                    }
                    try {
                        System.out.println("command :" + command);
                        Runtime.getRuntime().exec(command);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            });
            MenuItem exitMenuItem = new MenuItem("Exit");
            exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TrapReceiverTray.this.osName.contains("Windows")) {
                        WrapperManager.stop((int)0);
                    } else if (TrapReceiverTray.this.osName.contains("Linux")) {
                        TrapReceiverTray.this.stop();
                        System.exit(0);
                    }
                }
            });
            PopupMenu popup = new PopupMenu();
            popup.add(showMenuItem);
            popup.add(hideMenuItem);
            popup.add(new MenuItem("-"));
            popup.add(this.autoStartServiceCheckboxMenuItem);
            popup.add(new MenuItem("-"));
            popup.add(exitMenuItem);
            this.startImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("Middle.gif"));
            this.stopImage = GrayFilter.createDisabledImage(this.startImage);
            this.trayIcon = new TrayIcon(this.startImage, "Trap Receiver", popup);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrapReceiverTray.this.trapView.frame.setVisible(true);
                    TrapReceiverTray.this.trapView.frame.setState(0);
                }
            });
            try {
                SystemTray.getSystemTray().add(this.trayIcon);
            }
            catch (AWTException ex) {
                ex.printStackTrace(System.err);
            }
            this.trapView.frame.jStartButton_actionPerformed(null);
            return true;
        }
        System.out.println("Not support system tray.");
        return false;
    }

    public void stop() {
        if (this.trapView.frame.isReceiverStart()) {
            this.trapView.frame.stopReceiver();
        }
        this.trapView.frame.setVisible(false);
        SystemTray.getSystemTray().remove(this.trayIcon);
    }

    public void startReceiver() {
        this.trapView.frame.startReceiver();
        if (!this.trapView.frame.isReceiverStart()) {
            this.trayIcon.setImage(this.stopImage);
        }
    }

    public void showMessage(String msg) {
        this.trayIcon.displayMessage("Trap Receiver", msg, TrayIcon.MessageType.INFO);
    }

    public void refreshServiceState() {
        if (this.osName.contains("Windows")) {
            Process child = null;
            try {
                child = Runtime.getRuntime().exec("sc qc " + this.properties.getProperty("wrapper.ntservice.name", "") + " 512");
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(child.getInputStream()));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.contains("START_TYPE")) continue;
                    if (line.contains("AUTO_START")) {
                        this.autoStartServiceCheckboxMenuItem.setState(true);
                    }
                    break;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        } else if (this.osName.contains("Linux") && new File("/etc/init.d/" + this.properties.getProperty("wrapper.name", "")).exists()) {
            this.autoStartServiceCheckboxMenuItem.setState(true);
        }
    }
}

