/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class ASFMessage {
    byte[] IANAnum = new byte[4];
    byte messageType;
    byte messageTag;
    byte reserved;
    byte dataLength;
    byte[] IANAnum2 = new byte[4];
    byte[] OEMDefined = new byte[4];
    byte supportedEntities;
    byte supportedInteractions;
    byte[] reserved6bytes = new byte[6];

    public ASFMessage() {
        this.IANAnum[0] = 0;
        this.IANAnum[1] = 0;
        this.IANAnum[2] = 17;
        this.IANAnum[3] = -66;
        this.messageType = (byte)-128;
        this.messageTag = 0;
        this.reserved = 0;
        this.dataLength = 0;
    }

    public byte[] raw() {
        byte[] bytes = new byte[8];
        System.arraycopy(this.IANAnum, 0, bytes, 0, 4);
        bytes[4] = this.messageType;
        bytes[5] = this.messageTag;
        bytes[6] = this.reserved;
        bytes[7] = this.dataLength;
        return bytes;
    }

    public static ASFMessage fromRaw(byte[] bytes) {
        ASFMessage msg = new ASFMessage();
        int index = 0;
        System.arraycopy(bytes, 0, msg.IANAnum, 0, index);
        index += 4;
        msg.messageTag = bytes[index++];
        msg.messageType = bytes[index++];
        msg.reserved = bytes[index++];
        msg.dataLength = bytes[index++];
        System.arraycopy(bytes, index, msg.IANAnum2, 0, 4);
        System.arraycopy(bytes, index += 4, msg.OEMDefined, 0, 4);
        index += 4;
        msg.supportedEntities = bytes[index++];
        msg.supportedInteractions = bytes[index++];
        System.arraycopy(bytes, index, msg.reserved6bytes, 0, 6);
        return msg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("IANANum               = " + ByteUtility.bytesToHex(this.IANAnum) + "\n");
        sb.append("messageTag            = " + ByteUtility.byteToHex(this.messageTag) + "\n");
        sb.append("messageType           = " + ByteUtility.byteToHex(this.messageType) + "\n");
        sb.append("reserved              = " + ByteUtility.byteToHex(this.reserved) + "\n");
        sb.append("IANAnum2              = " + ByteUtility.bytesToHex(this.IANAnum2) + "\n");
        sb.append("OEMDefined            = " + ByteUtility.bytesToHex(this.OEMDefined) + "\n");
        sb.append("supportedEntities     = " + ByteUtility.byteToHex(this.supportedEntities) + "\n");
        sb.append("supportedInteractions = " + ByteUtility.byteToHex(this.supportedInteractions) + "\n");
        sb.append("reserved6bytes        = " + ByteUtility.bytesToHex(this.reserved6bytes) + "\n");
        return sb.toString();
    }
}

