/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;

public class IPMIAMIOEMCommand
extends IPMICommand {
    public static final byte AMI_MOUSE_MODE_RELATIVE = 1;
    public static final byte AMI_MOUSE_MODE_ABSOLUTE = 2;
    public static final byte AMI_MOUSE_MODE_OTHER = 3;
    public static final byte AMI_VIRTUAL_MEDIA_ATTACH = 0;
    public static final byte AMI_VIRTUAL_MEDIA_AUTO_ATTACH = 1;
    public static final byte AMI_VIRTUAL_MEDIA_DETACH = 2;

    public IPMIAMIOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getKVMSessionTokenCommand(byte[] username, byte[] ip) {
        username = new byte[]{65, 68, 77, 73, 78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ip = new byte[]{49, 57, 50, 46, 49, 54, 56, 46, 49, 48, 48, 46, 49, 50, 52, 0};
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[33];
        data[0] = 1;
        System.arraycopy(username, 0, data, 1, username.length);
        System.arraycopy(ip, 0, data, 17, ip.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getKVMSessionTokenSH7757Command() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{72};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIfRemoveClearChassisIntrusionCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{74};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMouseModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setMouseModeCommand(byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLANModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setLANModeCommand(byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12, 1, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getAMILANModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12, 0, 0, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAMILANModeCommand(byte isEnable, byte type) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12, 1, isEnable, type};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setVirtualMediaAttachModeCommand(byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        data[0] = 11;
        data[1] = mode;
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDNSServerCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-56, (byte)67, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDNSServerCommand(byte[] ip1, byte[] ip2) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{ip1[0], ip1[1], ip1[2], ip1[3], ip2[0], ip2[1], ip2[2], ip2[3]};
        ipmiMessage.setCommandAndData((byte)-56, (byte)68, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isB9Command() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)22, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage GetUIDStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{28};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableUIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{29};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage disableUIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{30};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void API____________() {
    }

    public String getKVMSessionToken() {
        IPMIMessage resMessage = this.getKVMSessionTokenCommand(null, null);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte[] token = new byte[16];
            System.arraycopy(resMessage.data, 76, token, 0, 16);
            return new String(token);
        }
        return null;
    }

    public String getKVMSessionTokenSH7757() {
        IPMIMessage resMessage = this.getKVMSessionTokenCommand(null, null);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte[] token = new byte[16];
            if (resMessage.data.length == 57) {
                System.arraycopy(resMessage.data, 40, token, 0, 16);
            } else if (resMessage.data.length == 61) {
                System.arraycopy(resMessage.data, 44, token, 0, 16);
            }
            return new String(token);
        }
        return null;
    }

    public boolean getIfRemoveClearChassisIntrusion() {
        IPMIMessage resMessage = this.getIfRemoveClearChassisIntrusionCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data.length > 0 && resMessage.data[0] == 1;
        }
        return false;
    }

    public byte getMouseMode() throws IPMIException {
        IPMIMessage resMessage = this.getMouseModeCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("Call getMouseMode failed");
    }

    public boolean setMouseMode(byte mode) throws IPMIException {
        IPMIMessage resMessage = this.setMouseModeCommand(mode);
        if (resMessage != null && resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("Call setMouseMode failed");
    }

    public byte getLANMode() throws IPMIException {
        IPMIMessage resMessage = this.getLANModeCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            if (resMessage.data.length == 1) {
                if (resMessage.data[0] == 0 || resMessage.data[0] == 1 || resMessage.data[0] == 2) {
                    return resMessage.data[0];
                }
                throw new IPMIException("GetLANModeCommand data value invalid");
            }
            throw new IPMIException("GetLANModeCommand data length invalid");
        }
        throw new IPMIException("Call getLANModeCommand failed");
    }

    public boolean setLANMode(byte mode) throws IPMIException {
        IPMIMessage resMessage = this.setLANModeCommand(mode);
        if (resMessage != null && resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("Call getLANModeCommand failed");
    }

    public byte[] getAMILANMode() throws IPMIException {
        byte[] retBytes = new byte[2];
        IPMIMessage resMessage = this.getAMILANModeCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            if (resMessage.data.length == 2) {
                if (resMessage.data[0] == 0 || resMessage.data[0] == 1 || resMessage.data[1] == 0 || resMessage.data[1] == 1) {
                    retBytes[0] = resMessage.data[0];
                    retBytes[1] = resMessage.data[1];
                } else {
                    retBytes[0] = -1;
                    retBytes[1] = -1;
                }
                return retBytes;
            }
            throw new IPMIException("GetAMILANModeCommand data length invalid");
        }
        throw new IPMIException("Call getAMILANModeCommand failed");
    }

    public boolean setAMILANMode(byte isEnable, byte type) throws IPMIException {
        IPMIMessage resMessage = this.setAMILANModeCommand(isEnable, type);
        if (resMessage != null && resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("Call setAMILANModeCommand failed");
    }

    public boolean setVirtualMediaAttachMode(byte mode) throws IPMIException {
        IPMIMessage resMessage = this.setVirtualMediaAttachModeCommand(mode);
        if (resMessage != null && resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("Call setVirtualMediaAttachMode failed");
    }

    public String[] getDNSServer() throws IPMIException {
        IPMIMessage resMessage = this.getDNSServerCommand();
        if (resMessage != null && resMessage.completionCode == 0 && resMessage.data.length == 8) {
            String ip1 = "" + (resMessage.data[0] & 0xFF) + "." + (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF);
            String ip2 = "" + (resMessage.data[4] & 0xFF) + "." + (resMessage.data[5] & 0xFF) + "." + (resMessage.data[6] & 0xFF) + "." + (resMessage.data[7] & 0xFF);
            String[] s = new String[]{ip1, ip2};
            return s;
        }
        throw new IPMIException("Call getDNSServerCommand failed");
    }

    public boolean setDNSServer(String ip1, String ip2) throws IPMIException {
        byte[] ip2Bytes;
        byte[] ip1Bytes = ByteUtility.ipToBytes(ip1);
        IPMIMessage resMessage = this.setDNSServerCommand(ip1Bytes, ip2Bytes = ByteUtility.ipToBytes(ip2));
        if (resMessage != null && resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("Call setDNSServerCommand failed");
    }

    public boolean isB9() throws IPMIException {
        boolean itIsB9 = false;
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiInterface);
        String boardName = ipmiOEMCommand.getBoardModel();
        if (boardName != null && boardName.indexOf("B9") != -1) {
            itIsB9 = true;
        }
        return itIsB9;
    }

    public byte getUIDStatus() throws IPMIException {
        IPMIMessage resMessage = this.GetUIDStatusCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("Call GetUIDStatusCommand failed");
    }

    public void enableUID() throws IPMIException {
        IPMIMessage resMessage = this.enableUIDCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            return;
        }
        throw new IPMIException("Call enableUIDCommand failed");
    }

    public void disableUID() throws IPMIException {
        IPMIMessage resMessage = this.disableUIDCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            return;
        }
        throw new IPMIException("Call disableUIDCommand failed");
    }

    private void INNER_CLASS____________() {
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("67.207.207.212");
        config.setUserName("supermicro");
        config.setPassword("z5zeDePr");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiAMIOEMCommand.setIPMIInterface(rmcp);
        System.out.println("Token(SH7757) = " + ipmiAMIOEMCommand.getKVMSessionTokenSH7757());
        sessionController.closeSession();
    }

    public class YafuHeader {
        public byte[] seqnum = new byte[4];
        public byte[] yafuCmd = new byte[2];
        public byte[] datalen = new byte[2];
        public byte[] crc32CheckSum = new byte[4];

        public byte[] toRaw() {
            byte[] raw = new byte[this.seqnum.length + this.yafuCmd.length + this.datalen.length + this.crc32CheckSum.length];
            int index = 0;
            System.arraycopy(this.seqnum, 0, raw, index, this.seqnum.length);
            System.arraycopy(this.yafuCmd, 0, raw, index += this.seqnum.length, this.yafuCmd.length);
            System.arraycopy(this.datalen, 0, raw, index += this.yafuCmd.length, this.datalen.length);
            System.arraycopy(this.crc32CheckSum, 0, raw, index += this.datalen.length, this.crc32CheckSum.length);
            return raw;
        }
    }
}

