/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IIPMIMessage;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RMCPSession {
    public static final byte AUTH_TYPE_NONE = 0;
    public static final byte AUTH_TYPE_MD2 = 1;
    public static final byte AUTH_TYPE_MD5 = 2;
    public static final byte SOL_PAYLOAD = -128;
    byte authType = (byte)2;
    byte[] sessionSeq = new byte[]{0, 0, 0, 0};
    byte[] sessionID = new byte[]{0, 0, 0, 0};
    byte[] authCode = new byte[16];
    byte[] inboundSessionSeq = new byte[]{0, 0, 0, 0};

    public byte[] raw() {
        byte[] bytes;
        if (this.authType != 0) {
            bytes = new byte[25];
            bytes[0] = this.authType;
            System.arraycopy(this.sessionSeq, 0, bytes, 1, 4);
            System.arraycopy(this.sessionID, 0, bytes, 5, 4);
            System.arraycopy(this.authCode, 0, bytes, 9, 16);
        } else {
            bytes = new byte[9];
            System.arraycopy(this.sessionSeq, 0, bytes, 1, 4);
            System.arraycopy(this.sessionID, 0, bytes, 5, 4);
        }
        return bytes;
    }

    public void calcAuthCode(IIPMIMessage ipmiMessage, String passwordString) {
        byte[] password = new byte[16];
        int passwordLength = passwordString.length() >= 16 ? 16 : passwordString.length();
        System.arraycopy(passwordString.getBytes(), 0, password, 0, passwordLength);
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(password);
            algorithm.update(this.sessionID);
            algorithm.update(ipmiMessage.raw());
            algorithm.update(this.sessionSeq);
            algorithm.update(password);
            byte[] digest = algorithm.digest();
            System.arraycopy(digest, 0, this.authCode, 0, 16);
        }
        catch (NoSuchAlgorithmException ex) {
            // empty catch block
        }
    }

    public synchronized void IncreaseSessionSeq() {
        int SeqNum = this.ByteToInt(this.sessionSeq, 0, 4) + 1;
        this.IntToByte(this.sessionSeq, 0, SeqNum);
        SeqNum = this.ByteToInt(this.inboundSessionSeq, 0, 4) + 1;
        this.IntToByte(this.inboundSessionSeq, 0, SeqNum);
    }

    public synchronized void DeincreaseSessionSeq() {
        int SeqNum = this.ByteToInt(this.sessionSeq, 0, 4) - 1;
        this.IntToByte(this.sessionSeq, 0, SeqNum);
        SeqNum = this.ByteToInt(this.inboundSessionSeq, 0, 4) - 1;
        this.IntToByte(this.inboundSessionSeq, 0, SeqNum);
    }

    public byte[] getSessionID() {
        return this.sessionID;
    }

    public byte[] getSessionSeq() {
        return this.sessionSeq;
    }

    public byte[] getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(byte[] authCode) {
        this.authCode = authCode;
    }

    public void setAuthType(byte authType) {
        this.authType = authType;
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }
}

