/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.MB_BHQIE_SensorEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

public class MB_BHQG6_SensorEntity
extends MB_BHQIE_SensorEntity {
    public static final String CPU1_DIMM_VOLTAGE = "CPU1 DIMM Voltage";
    public static final String CPU2_DIMM_VOLTAGE = "CPU2 DIMM Voltage";
    public static final String CPU3_DIMM_VOLTAGE = "CPU3 DIMM Voltage";
    public static final String CPU4_DIMM_VOLTAGE = "CPU4 DIMM Voltage";
    protected byte cpu1DIMMVoltage;
    protected byte cpu2DIMMVoltage;
    protected byte cpu3DIMMVoltage;
    protected byte cpu4DIMMVoltage;

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.remoteCPU1Temp = raw[2];
        this.remoteCPU2Temp = raw[3];
        this.remoteCPU3Temp = raw[4];
        this.remoteCPU4Temp = raw[5];
        this.systemTemp = raw[6];
        this.cpu1CoreVoltage = raw[7];
        this.cpu2CoreVoltage = raw[8];
        this.cpu3CoreVoltage = raw[9];
        this.cpu4CoreVoltage = raw[10];
        this.cpu1DIMMVoltage = raw[11];
        this.cpu2DIMMVoltage = raw[12];
        this.cpu3DIMMVoltage = raw[13];
        this.cpu4DIMMVoltage = raw[14];
        this.v1p1 = raw[15];
        this.v3p3 = raw[16];
        this.v3sb = raw[17];
        this.v5 = raw[18];
        this.v5sb = raw[19];
        this.v12 = raw[20];
        this.batteryVoltage = raw[21];
        this.raw = raw;
        return true;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Temp"));
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Temp"));
        }
        if (this.checkRemoteCPU3Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU3 Temp"));
        }
        if (this.checkRemoteCPU4Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU4 Temp"));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "System Temp"));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Vcore"));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Vcore"));
        }
        if (this.checkCpu3CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU3 Vcore"));
        }
        if (this.checkCpu4CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU4 Vcore"));
        }
        if (this.checkCPU1DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1_DIMM_VOLTAGE));
        }
        if (this.checkCPU2DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2_DIMM_VOLTAGE));
        }
        if (this.checkCPU3DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU3_DIMM_VOLTAGE));
        }
        if (this.checkCPU4DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU4_DIMM_VOLTAGE));
        }
        if (this.checkV1p1() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "1.1V"));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3V"));
        }
        if (this.checkV12() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "12V"));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5V"));
        }
        if (this.checkV5sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5VSB"));
        }
        if (this.checkV3sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3VSB"));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VBAT"));
        }
        return failures;
    }

    public double getCPU1DIMMVoltageFormula() {
        return (double)(this.cpu1DIMMVoltage & 0xFF) * 0.008;
    }

    public double getCPU2DIMMVoltageFormula() {
        return (double)(this.cpu2DIMMVoltage & 0xFF) * 0.008;
    }

    public double getCPU3DIMMVoltageFormula() {
        return (double)(this.cpu3DIMMVoltage & 0xFF) * 0.008;
    }

    public double getCPU4DIMMVoltageFormula() {
        return (double)(this.cpu4DIMMVoltage & 0xFF) * 0.008;
    }

    public double getCPU1DIMMVoltageLowLimit() {
        return 1.04;
    }

    public double getCPU2DIMMVoltageLowLimit() {
        return 1.04;
    }

    public double getCPU3DIMMVoltageLowLimit() {
        return 1.04;
    }

    public double getCPU4DIMMVoltageLowLimit() {
        return 1.04;
    }

    public double getCPU1DIMMVoltageHighLimit() {
        return 1.85;
    }

    public double getCPU2DIMMVoltageHighLimit() {
        return 1.85;
    }

    public double getCPU3DIMMVoltageHighLimit() {
        return 1.85;
    }

    public double getCPU4DIMMVoltageHighLimit() {
        return 1.85;
    }

    public int checkCPU1DIMMVoltage() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 2;
        }
        if (this.getCPU1DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCPU1DIMMVoltageFormula() <= this.getCPU1DIMMVoltageLowLimit() || this.getCPU1DIMMVoltageFormula() >= this.getCPU1DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCPU2DIMMVoltage() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 2;
        }
        if (this.getCPU2DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCPU2DIMMVoltageFormula() <= this.getCPU2DIMMVoltageLowLimit() || this.getCPU2DIMMVoltageFormula() >= this.getCPU2DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCPU3DIMMVoltage() {
        if (this.getRemoteCPU3Temp() == 7) {
            return 2;
        }
        if (this.getCPU3DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCPU3DIMMVoltageFormula() <= this.getCPU3DIMMVoltageLowLimit() || this.getCPU3DIMMVoltageFormula() >= this.getCPU3DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCPU4DIMMVoltage() {
        if (this.getRemoteCPU4Temp() == 7) {
            return 2;
        }
        if (this.getCPU4DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCPU4DIMMVoltageFormula() <= this.getCPU4DIMMVoltageLowLimit() || this.getCPU4DIMMVoltageFormula() >= this.getCPU4DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        this.addRaw(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCPUTempString(this.getRemoteCPU1Temp()), "N/A", "N/A");
        this.addRaw(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCPUTempString(this.getRemoteCPU2Temp()), "N/A", "N/A");
        this.addRaw(this.checkRemoteCPU3Temp(), "CPU3 Temp", this.showCPUTempString(this.getRemoteCPU3Temp()), "N/A", "N/A");
        this.addRaw(this.checkRemoteCPU4Temp(), "CPU4 Temp", this.showCPUTempString(this.getRemoteCPU4Temp()), "N/A", "N/A");
        this.addRaw(this.checkSystemTemp(), "System Temp", "" + this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit()));
        if (this.getRemoteCPU1Temp() == 7) {
            this.setCpu1CoreVoltage((byte)0);
        }
        if (this.getRemoteCPU2Temp() == 7) {
            this.setCpu2CoreVoltage((byte)0);
        }
        if (this.getRemoteCPU3Temp() == 7) {
            this.setCpu3CoreVoltage((byte)0);
        }
        if (this.getRemoteCPU4Temp() == 7) {
            this.setCpu4CoreVoltage((byte)0);
        }
        this.addRaw(this.checkCpu1CoreVoltage(), "CPU1 Vcore", this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getCpu1CoreVoltageLowLimit()), this.d2StrV(this.getCpu1CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), "CPU2 Vcore", this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getCpu2CoreVoltageLowLimit()), this.d2StrV(this.getCpu2CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu3CoreVoltage(), "CPU3 Vcore", this.d2StrV(this.getCpu3CoreVoltageFormula()), this.d2StrV(this.getCpu3CoreVoltageLowLimit()), this.d2StrV(this.getCpu3CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu4CoreVoltage(), "CPU4 Vcore", this.d2StrV(this.getCpu4CoreVoltageFormula()), this.d2StrV(this.getCpu4CoreVoltageLowLimit()), this.d2StrV(this.getCpu4CoreVoltageHighLimit()));
        this.addRaw(this.checkCPU1DIMMVoltage(), CPU1_DIMM_VOLTAGE, this.d2StrV(this.getCPU1DIMMVoltageFormula()), this.d2StrV(this.getCPU1DIMMVoltageLowLimit()), this.d2StrV(this.getCPU1DIMMVoltageHighLimit()));
        this.addRaw(this.checkCPU2DIMMVoltage(), CPU2_DIMM_VOLTAGE, this.d2StrV(this.getCPU2DIMMVoltageFormula()), this.d2StrV(this.getCPU2DIMMVoltageLowLimit()), this.d2StrV(this.getCPU2DIMMVoltageHighLimit()));
        this.addRaw(this.checkCPU3DIMMVoltage(), CPU3_DIMM_VOLTAGE, this.d2StrV(this.getCPU3DIMMVoltageFormula()), this.d2StrV(this.getCPU3DIMMVoltageLowLimit()), this.d2StrV(this.getCPU3DIMMVoltageHighLimit()));
        this.addRaw(this.checkCPU4DIMMVoltage(), CPU4_DIMM_VOLTAGE, this.d2StrV(this.getCPU4DIMMVoltageFormula()), this.d2StrV(this.getCPU4DIMMVoltageLowLimit()), this.d2StrV(this.getCPU4DIMMVoltageHighLimit()));
        this.addRaw(this.checkV1p1(), "1.1V", this.d2StrV(this.getV1p1Formula()), this.d2StrV(this.getV1p1LowLimit()), this.d2StrV(this.getV1p1HighLimit()));
        this.addRaw(this.checkV3p3(), "3.3V", this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getV3p3LowLimit()), this.d2StrV(this.getV3p3HighLimit()));
        this.addRaw(this.checkV3sb(), "3.3VSB", this.d2StrV(this.getV3sbFormula()), this.d2StrV(this.getV3sbLowLimit()), this.d2StrV(this.getV3sbHighLimit()));
        this.addRaw(this.checkV5(), "5V", this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV5sb(), "5VSB", this.d2StrV(this.getV5sbFormula()), this.d2StrV(this.getV5sbLowLimit()), this.d2StrV(this.getV5sbHighLimit()));
        this.addRaw(this.checkV12(), "12V", this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkBatteryVoltage(), "VBAT", this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        return this.formatedString.toString();
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCPUTempString(this.getRemoteCPU1Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCPUTempString(this.getRemoteCPU2Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkRemoteCPU3Temp(), "CPU3 Temp", this.showCPUTempString(this.getRemoteCPU3Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkRemoteCPU4Temp(), "CPU4 Temp", this.showCPUTempString(this.getRemoteCPU4Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkSystemTemp(), "System Temp", this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit())));
        return list;
    }

    @Override
    public int checkRemoteCPU1Temp() {
        if (this.getRemoteCPU1Temp() == 0 || this.getRemoteCPU1Temp() == 1 || this.getRemoteCPU1Temp() == 2) {
            return 0;
        }
        if (this.getRemoteCPU1Temp() == 4) {
            return 1;
        }
        return 2;
    }

    @Override
    public int checkRemoteCPU2Temp() {
        if (this.getRemoteCPU2Temp() == 0 || this.getRemoteCPU2Temp() == 1 || this.getRemoteCPU2Temp() == 2) {
            return 0;
        }
        if (this.getRemoteCPU2Temp() == 4) {
            return 1;
        }
        return 2;
    }

    @Override
    public int checkRemoteCPU3Temp() {
        if (this.getRemoteCPU3Temp() == 0 || this.getRemoteCPU3Temp() == 1 || this.getRemoteCPU3Temp() == 2) {
            return 0;
        }
        if (this.getRemoteCPU3Temp() == 4) {
            return 1;
        }
        return 2;
    }

    @Override
    public int checkRemoteCPU4Temp() {
        if (this.getRemoteCPU4Temp() == 0 || this.getRemoteCPU4Temp() == 1 || this.getRemoteCPU4Temp() == 2) {
            return 0;
        }
        if (this.getRemoteCPU4Temp() == 4) {
            return 1;
        }
        return 2;
    }

    public byte getCpu1DIMMVoltage() {
        return this.cpu1DIMMVoltage;
    }

    public byte getCpu2DIMMVoltage() {
        return this.cpu2DIMMVoltage;
    }

    public byte getCpu3DIMMVoltage() {
        return this.cpu3DIMMVoltage;
    }

    public byte getCpu4DIMMVoltage() {
        return this.cpu4DIMMVoltage;
    }

    public void setCpu1DIMMVoltage(byte cpu1DIMMVoltage) {
        this.cpu1DIMMVoltage = cpu1DIMMVoltage;
    }

    public void setCpu2DIMMVoltage(byte cpu2DIMMVoltage) {
        this.cpu2DIMMVoltage = cpu2DIMMVoltage;
    }

    public void setCpu3DIMMVoltage(byte cpu3DIMMVoltage) {
        this.cpu3DIMMVoltage = cpu3DIMMVoltage;
    }

    public void setCpu4DIMMVoltage(byte cpu4DIMMVoltage) {
        this.cpu4DIMMVoltage = cpu4DIMMVoltage;
    }

    @Override
    public double getV5sbFormula() {
        return (double)(this.v5sb & 0xFF) * 0.04;
    }

    @Override
    public double getV5Formula() {
        return (double)(this.v5 & 0xFF) * 0.04;
    }

    @Override
    public double getV12Formula() {
        return (double)(this.v12 & 0xFF) * 0.096;
    }
}

