/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task;

import com.supermicro.ipmi.task.BTask;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BTaskManager {
    ExecutorService executor;
    SortedMap<String, BTask> tasks = new TreeMap<String, BTask>(new IntegerComparator());
    private static BTaskManager instance = new BTaskManager();
    BTask bTaskIndex;

    private BTaskManager() {
        this.executor = Executors.newCachedThreadPool();
    }

    public void setThreadPoolSize(int size) throws Exception {
        if (this.isThereTaskStillRunning()) {
            throw new Exception("There are tasks still running ");
        }
        this.executor = Executors.newFixedThreadPool(size);
    }

    public static BTaskManager getInstance() {
        return instance;
    }

    public synchronized void execute(BTask bTask) {
        this.tasks.put(bTask.taskID, bTask);
        this.executor.execute(bTask);
    }

    public BTask getBTask(String taskID) {
        return (BTask)this.tasks.get(taskID);
    }

    public boolean removeBTask(String taskID) {
        if (this.tasks.containsKey(taskID)) {
            ((BTask)this.tasks.get(taskID)).clearMessageLinkForGC();
            this.tasks.remove(taskID);
            this.bTaskIndex = null;
            return true;
        }
        return false;
    }

    public ArrayList getAllBTask() {
        ArrayList bTasks = new ArrayList();
        for (String key : this.tasks.keySet()) {
            bTasks.add(this.tasks.get(key));
        }
        return bTasks;
    }

    public boolean isThereTaskStillRunning() {
        boolean isThereTaskStillRunningBoolean = false;
        for (BTask bTask : this.tasks.values()) {
            if (bTask.status == 2) continue;
            isThereTaskStillRunningBoolean = true;
        }
        if (isThereTaskStillRunningBoolean) {
            // empty if block
        }
        return isThereTaskStillRunningBoolean;
    }

    public String loopNextMessage() {
        BTask taskToPrint = null;
        if (this.tasks.size() == 0) {
            return "No message";
        }
        Iterator<BTask> iterator = this.tasks.values().iterator();
        while (iterator.hasNext()) {
            BTask bTask = iterator.next();
            if (this.bTaskIndex == null) {
                taskToPrint = this.bTaskIndex = bTask;
                break;
            }
            if (!bTask.equals(this.bTaskIndex)) continue;
            if (iterator.hasNext()) {
                this.bTaskIndex = taskToPrint = iterator.next();
                continue;
            }
            taskToPrint = this.bTaskIndex = (BTask)this.tasks.get(this.tasks.firstKey());
        }
        if (taskToPrint == null) {
            return "";
        }
        String result = taskToPrint.getMessageDisplay(true);
        return result;
    }

    public String getTaskStatusDisplay() {
        ArrayList bTasks = BTaskManager.getInstance().getAllBTask();
        if (bTasks.size() == 0) {
            return "Empty Task";
        }
        StringBuffer formatedString = new StringBuffer();
        String formatTemplate = "%6s | %-15s | %-15s | %-9s | %-7s | %4s | %-15s\n";
        formatedString.append(String.format(formatTemplate, "TaskID", "Start Time", "End Time", "Elapsed", "State", "Exit", "Command"));
        formatedString.append(String.format(formatTemplate, "------", "----------", "--------", "-------", "------", "----", "-------"));
        for (int i = 0; i < bTasks.size(); ++i) {
            String endTime;
            BTask bTask = (BTask)bTasks.get(i);
            SimpleDateFormat f = new SimpleDateFormat("MM/dd HH:mm:ss");
            String startTime = bTask.startTime != 0L ? f.format(new Date(bTask.startTime)) : "";
            String string = endTime = bTask.endTime != 0L ? f.format(new Date(bTask.endTime)) : "";
            String elapse = bTask.endTime != 0L ? BTaskManager.printTimeString(bTask.endTime - bTask.startTime) : (bTask.startTime == 0L ? "" : BTaskManager.printTimeString(Calendar.getInstance().getTime().getTime() - bTask.startTime));
            formatedString.append(String.format(formatTemplate, bTask.taskID, startTime, endTime, elapse, bTask.getStateString(), bTask.status == 2 ? Integer.valueOf(bTask.exitCode) : "", bTask.getCommandString()));
        }
        return formatedString.toString();
    }

    public static String printTimeString(long diffMillis) {
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        return "" + (leftHours >= 10L ? Long.valueOf(leftHours) : "0" + leftHours) + ":" + (leftMins >= 10L ? Long.valueOf(leftMins) : "0" + leftMins) + ":" + (leftSecs >= 10L ? Long.valueOf(leftSecs) : "0" + leftSecs);
    }

    public static void main(String[] args) {
    }

    class IntegerComparator
    implements Comparator {
        IntegerComparator() {
        }

        public int compare(Object a, Object b) {
            int x = Integer.parseInt((String)a);
            int y = Integer.parseInt((String)b);
            return x - y;
        }
    }
}

