/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMultipart
extends Multipart {
    private static boolean ignoreMissingEndBoundary = true;
    private static boolean ignoreMissingBoundaryParameter = true;
    protected DataSource ds;
    protected boolean parsed = true;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String string) {
        String string2 = UniqueValue.getUniqueBoundaryValue();
        ContentType contentType = new ContentType("multipart", string, null);
        contentType.setParameter("boundary", string2);
        this.contentType = contentType.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        if (dataSource instanceof MessageAware) {
            MessageContext messageContext = ((MessageAware)((Object)dataSource)).getMessageContext();
            this.setParent(messageContext.getPart());
        }
        if (dataSource instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)dataSource);
            return;
        }
        this.parsed = false;
        this.ds = dataSource;
        this.contentType = dataSource.getContentType();
    }

    public synchronized void setSubType(String string) throws MessagingException {
        ContentType contentType = new ContentType(this.contentType);
        contentType.setSubType(string);
        this.contentType = contentType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int n) throws MessagingException {
        this.parse();
        return super.getBodyPart(n);
    }

    public synchronized BodyPart getBodyPart(String string) throws MessagingException {
        this.parse();
        int n = this.getCount();
        int n2 = 0;
        while (n2 < n) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)this.getBodyPart(n2);
            String string2 = mimeBodyPart.getContentID();
            if (string2 != null && string2.equals(string)) {
                return mimeBodyPart;
            }
            ++n2;
        }
        return null;
    }

    protected void updateHeaders() throws MessagingException {
        int n = 0;
        while (n < this.parts.size()) {
            ((MimeBodyPart)this.parts.elementAt(n)).updateHeaders();
            ++n;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.parse();
        String string = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        int n = 0;
        while (n < this.parts.size()) {
            lineOutputStream.writeln(string);
            ((MimeBodyPart)this.parts.elementAt(n)).writeTo(outputStream);
            lineOutputStream.writeln();
            ++n;
        }
        lineOutputStream.writeln(String.valueOf(string) + "--");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        InputStream inputStream = null;
        SharedInputStream sharedInputStream = null;
        long l = 0L;
        long l2 = 0L;
        try {
            inputStream = this.ds.getInputStream();
            if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (inputStream instanceof SharedInputStream) {
            sharedInputStream = (SharedInputStream)((Object)inputStream);
        }
        ContentType contentType = new ContentType(this.contentType);
        String string = null;
        String string2 = contentType.getParameter("boundary");
        if (string2 != null) {
            string = "--" + string2;
        } else if (!ignoreMissingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            try {
                int n;
                String string3;
                LineInputStream lineInputStream = new LineInputStream(inputStream);
                while ((string3 = lineInputStream.readLine()) != null) {
                    int n2 = string3.length() - 1;
                    while (n2 >= 0 && ((n = (int)string3.charAt(n2)) == 32 || n == 9)) {
                        --n2;
                    }
                    string3 = string3.substring(0, n2 + 1);
                    if (string != null) {
                        if (!string3.equals(string)) continue;
                        break;
                    }
                    if (!string3.startsWith("--")) continue;
                    string = string3;
                    break;
                }
                if (string3 == null) {
                    throw new MessagingException("Missing start boundary");
                }
                byte[] byArray = ASCIIUtility.getBytes(string);
                n = byArray.length;
                boolean bl = false;
                while (!bl) {
                    InternetHeaders internetHeaders = null;
                    if (sharedInputStream != null) {
                        l = sharedInputStream.getPosition();
                        while ((string3 = lineInputStream.readLine()) != null && string3.length() > 0) {
                        }
                        if (string3 == null) {
                            if (!ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            break;
                        }
                    } else {
                        internetHeaders = this.createInternetHeaders(inputStream);
                    }
                    if (!inputStream.markSupported()) {
                        throw new MessagingException("Stream doesn't support mark");
                    }
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    if (sharedInputStream == null) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                    } else {
                        l2 = sharedInputStream.getPosition();
                    }
                    boolean bl2 = true;
                    int n3 = -1;
                    int n4 = -1;
                    block13: while (true) {
                        int n5;
                        if (bl2) {
                            inputStream.mark(n + 4 + 1000);
                            int n6 = 0;
                            while (n6 < n && inputStream.read() == (byArray[n6] & 0xFF)) {
                                ++n6;
                            }
                            if (n6 == n) {
                                int n7 = inputStream.read();
                                if (n7 == 45 && inputStream.read() == 45) {
                                    bl = true;
                                    break;
                                }
                                while (true) {
                                    if (n7 != 32 && n7 != 9) {
                                        if (n7 == 10) break block13;
                                        if (n7 != 13) break;
                                        inputStream.mark(1);
                                        if (inputStream.read() == 10) break block13;
                                        inputStream.reset();
                                        break block13;
                                    }
                                    n7 = inputStream.read();
                                }
                            }
                            inputStream.reset();
                            if (byteArrayOutputStream != null && n3 != -1) {
                                byteArrayOutputStream.write(n3);
                                if (n4 != -1) {
                                    byteArrayOutputStream.write(n4);
                                }
                                n4 = -1;
                                n3 = -1;
                            }
                        }
                        if ((n5 = inputStream.read()) < 0) {
                            if (!ignoreMissingEndBoundary) {
                                throw new MessagingException("missing multipart end boundary");
                            }
                            bl = true;
                            break;
                        }
                        if (n5 == 13 || n5 == 10) {
                            bl2 = true;
                            if (sharedInputStream != null) {
                                l2 = sharedInputStream.getPosition() - 1L;
                            }
                            n3 = n5;
                            if (n5 != 13) continue;
                            inputStream.mark(1);
                            n5 = inputStream.read();
                            if (n5 == 10) {
                                n4 = n5;
                                continue;
                            }
                            inputStream.reset();
                            continue;
                        }
                        bl2 = false;
                        if (byteArrayOutputStream == null) continue;
                        byteArrayOutputStream.write(n5);
                    }
                    MimeBodyPart mimeBodyPart = sharedInputStream != null ? this.createMimeBodyPart(sharedInputStream.newStream(l, l2)) : this.createMimeBodyPart(internetHeaders, byteArrayOutputStream.toByteArray());
                    this.addBodyPart(mimeBodyPart);
                }
            }
            catch (IOException iOException) {
                throw new MessagingException("IO Error", iOException);
            }
            Object var11_24 = null;
        }
        catch (Throwable throwable) {
            Object var11_25 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders(inputStream);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        return new MimeBodyPart(internetHeaders, byArray);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream inputStream) throws MessagingException {
        return new MimeBodyPart(inputStream);
    }

    static {
        try {
            String string = System.getProperty("mail.mime.multipart.ignoremissingendboundary");
            ignoreMissingEndBoundary = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.multipart.ignoremissingboundaryparameter");
            ignoreMissingBoundaryParameter = string == null || !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {}
    }
}

