/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.BMC_Manage20;
import IPMIView20.IPMIView20;
import IPMIView20.blade.RestoreOptionPanel;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

class BMC_Manage20ConfigModel
implements ActionListener {
    BMC_Manage20 view;
    IPMIInterfaceConfig ipmiInterfaceConfig;

    BMC_Manage20ConfigModel(BMC_Manage20 view, IPMIInterfaceConfig ipmiInterfaceConfig) {
        this.view = view;
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
    }

    public void setIPMIConfig(IPMIInterfaceConfig ipmiInterfaceConfig) {
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Thread thread;
        assert (this.ipmiInterfaceConfig != null);
        if (e2.getActionCommand().startsWith("Backup")) {
            thread = new Thread(){

                @Override
                public void run() {
                    BMC_Manage20ConfigModel.this.backupConfiguration();
                }
            };
            thread.start();
        }
        if (e2.getActionCommand().startsWith("Restore")) {
            thread = new Thread(){

                @Override
                public void run() {
                    BMC_Manage20ConfigModel.this.restoreConfiguration();
                }
            };
            thread.start();
        }
    }

    private boolean IsFileSelected(int result) {
        boolean bSelected = false;
        switch (result) {
            case 0: {
                bSelected = true;
            }
        }
        return bSelected;
    }

    private void restoreConfiguration() {
        boolean result = false;
        byte restoreOption = 0;
        JFileChooser chooser = new JFileChooser();
        RestoreOptionPanel restoreOptionPanel = new RestoreOptionPanel();
        chooser.add((Component)restoreOptionPanel, "North");
        if (!this.IsFileSelected(chooser.showDialog(this.view, "Restore file"))) {
            return;
        }
        File selFile = chooser.getSelectedFile();
        if (restoreOptionPanel.jRestoreAllRadioButton.isSelected()) {
            restoreOption = 0;
        } else if (restoreOptionPanel.jRestoreAllButNoLANRadioButton.isSelected()) {
            restoreOption = 1;
        }
        ISessionController sessionController = null;
        this.view.setCursor(new Cursor(3));
        this.view.backupButton.setEnabled(false);
        this.view.restoreButton.setEnabled(false);
        try {
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionController(this.ipmiInterfaceConfig, ipmiOEMCommand);
            result = ipmiOEMCommand.restoreConfiguration(selFile, true, restoreOption);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this.view, e2.getMessage(), null, 0);
        }
        sessionController.closeSession();
        this.view.setCursor(new Cursor(0));
        this.view.backupButton.setEnabled(true);
        this.view.restoreButton.setEnabled(true);
        if (result) {
            JOptionPane.showMessageDialog(this.view, selFile + " restored" + "\n(The BMC needs to reset to apply restored configuration and this session will be terminated)");
            IPMIView20.getInstance().closeActivatelySession();
        }
    }

    private void backupConfiguration() {
        boolean result = false;
        JFileChooser chooser = new JFileChooser();
        if (!this.IsFileSelected(chooser.showDialog(this.view, "Backup file"))) {
            return;
        }
        File selFile = chooser.getSelectedFile();
        ISessionController sessionController = null;
        this.view.setCursor(new Cursor(3));
        this.view.backupButton.setEnabled(false);
        this.view.restoreButton.setEnabled(false);
        try {
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionController(this.ipmiInterfaceConfig, ipmiOEMCommand);
            result = ipmiOEMCommand.backupConfiguration(selFile, true);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this.view, e2.getMessage(), null, 0);
        }
        sessionController.closeSession();
        this.view.setCursor(new Cursor(0));
        this.view.backupButton.setEnabled(true);
        this.view.restoreButton.setEnabled(true);
        if (result) {
            JOptionPane.showMessageDialog(this.view, selFile + " saved");
        }
    }
}

