/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigAccessor {
    private String fileName;
    private String path;
    private static ConfigAccessor instance = null;

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ConfigAccessor(String path, String fileName) {
        this.path = path;
        this.fileName = path + File.separator + fileName;
        File aPath = new File(this.path);
        File aFile = new File(this.fileName);
        if (!aPath.isDirectory()) {
            aPath.mkdirs();
        }
        if (!aFile.isFile()) {
            this.createFile(aFile);
        }
    }

    public static ConfigAccessor getInstance() {
        if (instance == null) {
            instance = new ConfigAccessor(".\\", "msr2.ini");
        }
        return instance;
    }

    public static ConfigAccessor getInstance(String path, String fileName) {
        if (instance == null) {
            instance = new ConfigAccessor(path, fileName);
        }
        return instance;
    }

    public static ConfigAccessor getInstance(String fileName) {
        if (instance == null) {
            instance = new ConfigAccessor(".", fileName);
        }
        return instance;
    }

    private void createFile(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            DataOutputStream dos = new DataOutputStream(fos);
            dos.close();
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.toString());
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
    }

    public void removeProperty(String key) {
        try {
            File file = new File(this.fileName);
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.remove(key);
            p.store(new FileOutputStream(file), "MyTitle");
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.toString());
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
    }

    public void setProperty(String key, String value) {
        try {
            File file = new File(this.fileName);
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.put(key, value);
            p.store(new FileOutputStream(file), "MyTitle");
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.toString());
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
    }

    public String getProperty(String key) {
        try {
            File file = new File(this.fileName);
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            String retStr = p.getProperty(key);
            fis.close();
            return retStr;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.toString());
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

