/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CipherSuite;
import IPMIView20.CipherSuitePanel;
import IPMIView20.ConfigAccessor;
import IPMIView20.ConnectConfigFrame;
import IPMIView20.ConnectConfig_jAdvancedUserCheckBox_actionAdapter;
import IPMIView20.ConnectConfig_jCheckBoxDefaultIDandPW_actionAdapter;
import IPMIView20.ConnectConfig_jComboBoxAuth_actionAdapter;
import IPMIView20.ConnectConfig_jComboBoxConf_actionAdapter;
import IPMIView20.ConnectConfig_jGetCipherSuiteButton_actionAdapter;
import IPMIView20.ConnectConfig_jRadioButtonAuto_actionAdapter;
import IPMIView20.ConnectConfig_jRadioButtonIPMI15_actionAdapter;
import IPMIView20.ConnectConfig_jRadioButtonIPMI20Plus_actionAdapter;
import IPMIView20.ConnectConfig_jRadioButtonIPMI20Plus_itemAdapter;
import IPMIView20.ConnectConfig_jRadioButtonIPMI20_actionAdapter;
import IPMIView20.L;
import IPMIView20.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class ConnectConfig
extends JPanel {
    JRadioButton jRadioButtonAuto = new JRadioButton();
    JRadioButton jRadioButtonIPMI15 = new JRadioButton();
    JRadioButton jRadioButtonIPMI20 = new JRadioButton();
    JRadioButton jRadioButtonIPMI20Plus = new JRadioButton();
    JLabel jLabel1 = new JLabel();
    JComboBox jComboBoxAuth = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JComboBox jComboBoxIntegrity = new JComboBox();
    JComboBox jComboBoxConf = new JComboBox();
    JLabel jLabel3 = new JLabel();
    JCheckBox jCheckBoxDefaultIDandPW = new JCheckBox();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    TitledBorder titledBorder1;
    JPanel jPanel1 = new JPanel();
    TitledBorder titledBorder2;
    String IP;
    JButton jGetCipherSuiteButton = new JButton();
    JCheckBox jEncryptionCheckBox = new JCheckBox();
    JCheckBox jAdvancedUserCheckBox = new JCheckBox();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();

    public ConnectConfig() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEmptyBorder(), "IPMI Protocol Selection :");
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), " Cipher Suite For RMCP+ ");
        this.jRadioButtonAuto.setForeground(Color.black);
        this.jRadioButtonAuto.setSelected(true);
        this.jRadioButtonAuto.setText(L.t("protocol.Auto_Detection"));
        this.jRadioButtonAuto.setBounds(new Rectangle(32, 25, 125, 17));
        this.jRadioButtonAuto.addActionListener(new ConnectConfig_jRadioButtonAuto_actionAdapter(this));
        this.setLayout(null);
        this.jRadioButtonIPMI15.setToolTipText("");
        this.jRadioButtonIPMI15.setActionCommand("IPMI 1.5 for Agilent");
        this.jRadioButtonIPMI15.setText(L.t("protocol.HW_colon_BMCB_FW_colon_IPMI_1.5"));
        this.jRadioButtonIPMI15.setBounds(new Rectangle(33, 74, 182, 17));
        this.jRadioButtonIPMI15.addActionListener(new ConnectConfig_jRadioButtonIPMI15_actionAdapter(this));
        this.jRadioButtonIPMI20.setFont(new Font("MS Sans Serif", 0, 11));
        this.jRadioButtonIPMI20.setToolTipText("");
        this.jRadioButtonIPMI20.setActionCommand("IPMI 2.0 for Super BMC2");
        this.jRadioButtonIPMI20.setText(L.t("protocol.HW_colon_BMC2_FW_colon_IPMI_2.0_non-RMCP_plus"));
        this.jRadioButtonIPMI20.setBounds(new Rectangle(33, 101, 233, 17));
        this.jRadioButtonIPMI20.addActionListener(new ConnectConfig_jRadioButtonIPMI20_actionAdapter(this));
        this.jRadioButtonIPMI20Plus.setToolTipText("");
        this.jRadioButtonIPMI20Plus.setSelected(false);
        this.jRadioButtonIPMI20Plus.setText(L.t("protocol.HW_colon_BMC2_FW_colon_IPMI_2.0_Standard_RMCP_plus"));
        this.jRadioButtonIPMI20Plus.setBounds(new Rectangle(33, 128, 244, 17));
        this.jRadioButtonIPMI20Plus.addItemListener(new ConnectConfig_jRadioButtonIPMI20Plus_itemAdapter(this));
        this.jRadioButtonIPMI20Plus.addActionListener(new ConnectConfig_jRadioButtonIPMI20Plus_actionAdapter(this));
        this.jLabel1.setText("AuthAlgorithm");
        this.jLabel1.setBounds(new Rectangle(17, 24, 87, 17));
        this.jComboBoxAuth.setEnabled(false);
        this.jComboBoxAuth.setBounds(new Rectangle(110, 22, 186, 21));
        this.jComboBoxAuth.addActionListener(new ConnectConfig_jComboBoxAuth_actionAdapter(this));
        this.jLabel2.setText("IntegrityAlgorithm");
        this.jLabel2.setBounds(new Rectangle(16, 51, 83, 17));
        this.jComboBoxIntegrity.setEnabled(false);
        this.jComboBoxIntegrity.setBounds(new Rectangle(110, 49, 186, 21));
        this.jComboBoxConf.setEnabled(false);
        this.jComboBoxConf.setAlignmentX(0.5f);
        this.jComboBoxConf.setBounds(new Rectangle(110, 76, 186, 21));
        this.jComboBoxConf.addActionListener(new ConnectConfig_jComboBoxConf_actionAdapter(this));
        this.jLabel3.setText("ConfAlgorithm");
        this.jLabel3.setBounds(new Rectangle(15, 78, 89, 17));
        this.jCheckBoxDefaultIDandPW.setEnabled(true);
        this.jCheckBoxDefaultIDandPW.setSelected(false);
        this.jCheckBoxDefaultIDandPW.setText("Default ID & PW Login");
        this.jCheckBoxDefaultIDandPW.setBounds(new Rectangle(310, 13, 140, 25));
        this.jCheckBoxDefaultIDandPW.addActionListener(new ConnectConfig_jCheckBoxDefaultIDandPW_actionAdapter(this));
        this.setBorder(null);
        this.setDebugGraphicsOptions(0);
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(411, 230));
        this.setRequestFocusEnabled(true);
        this.setToolTipText("");
        this.jPanel1.setBorder(this.titledBorder2);
        this.jPanel1.setBounds(new Rectangle(267, 69, 311, 118));
        this.jPanel1.setLayout(null);
        this.jGetCipherSuiteButton.setBounds(new Rectangle(332, 102, 121, 25));
        this.jGetCipherSuiteButton.setText("Advanced Setting");
        this.jGetCipherSuiteButton.addActionListener(new ConnectConfig_jGetCipherSuiteButton_actionAdapter(this));
        this.jEncryptionCheckBox.setToolTipText("");
        this.jEncryptionCheckBox.setText(L.t("protocol.Encryption"));
        this.jEncryptionCheckBox.setBounds(new Rectangle(52, 146, 210, 25));
        this.jAdvancedUserCheckBox.setFont(new Font("Dialog", 1, 11));
        this.jAdvancedUserCheckBox.setToolTipText("");
        this.jAdvancedUserCheckBox.setActionCommand("Advanced User");
        this.jAdvancedUserCheckBox.setText(L.t("protocol.For_Advanced_User_Select_Following_Protocols_based_on_HW_and_FW"));
        this.jAdvancedUserCheckBox.setBounds(new Rectangle(1, 46, 408, 25));
        this.jAdvancedUserCheckBox.addActionListener(new ConnectConfig_jAdvancedUserCheckBox_actionAdapter(this));
        this.jLabel4.setText("HW=" + L.t("protocol.Hardware"));
        this.jLabel4.setBounds(new Rectangle(7, 189, 134, 17));
        this.jLabel5.setText("FW=" + L.t("protocol.Firmware"));
        this.jLabel5.setBounds(new Rectangle(7, 205, 152, 17));
        this.jLabel6.setFont(new Font("Dialog", 1, 11));
        this.jLabel6.setText("IPMI Protocol Selection:");
        this.jLabel6.setBounds(new Rectangle(5, 0, 312, 17));
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.jComboBoxAuth, null);
        this.jPanel1.add((Component)this.jComboBoxIntegrity, null);
        this.jPanel1.add((Component)this.jComboBoxConf, null);
        this.jPanel1.add((Component)this.jLabel2, null);
        this.jPanel1.add((Component)this.jLabel3, null);
        this.add((Component)this.jPanel1, null);
        this.add((Component)this.jCheckBoxDefaultIDandPW, null);
        this.add((Component)this.jGetCipherSuiteButton, null);
        this.add((Component)this.jAdvancedUserCheckBox, null);
        this.add((Component)this.jRadioButtonAuto, null);
        this.add((Component)this.jRadioButtonIPMI15, null);
        this.add((Component)this.jRadioButtonIPMI20, null);
        this.add((Component)this.jRadioButtonIPMI20Plus, null);
        this.add((Component)this.jEncryptionCheckBox, null);
        this.add((Component)this.jLabel4, null);
        this.add((Component)this.jLabel5, null);
        this.add((Component)this.jLabel6, null);
        this.buttonGroup1.add(this.jRadioButtonAuto);
        this.buttonGroup1.add(this.jRadioButtonIPMI15);
        this.buttonGroup1.add(this.jRadioButtonIPMI20);
        this.buttonGroup1.add(this.jRadioButtonIPMI20Plus);
    }

    private void myInit() {
        this.jComboBoxAuth.addItem("RAKP-None");
        this.jComboBoxAuth.addItem("RAKP-HMAC-SHA1");
        this.jComboBoxAuth.addItem("RAKP-HMAC-MD5");
        this.jComboBoxIntegrity.addItem("None");
        this.jComboBoxIntegrity.addItem("HMAC-SHA1-96");
        this.jComboBoxIntegrity.addItem("HMAC-MD5-128");
        this.jComboBoxIntegrity.addItem("MD5-128");
        this.jComboBoxConf.addItem("None");
        this.jComboBoxConf.addItem("AES-CBC-128");
        this.jComboBoxConf.addItem("xRC-128");
        this.jComboBoxConf.addItem("xRC-40");
        this.jCheckBoxDefaultIDandPW.setVisible(false);
        this.jGetCipherSuiteButton.setEnabled(false);
        this.jPanel1.setVisible(false);
        this.jGetCipherSuiteButton.setVisible(false);
        this.jEncryptionCheckBox.setEnabled(false);
    }

    public void setIP(String IP) {
        this.IP = IP;
    }

    public void load(String systemName) {
        this.jLabel6.setText(L.t("protocol.IPMI_Protocol_for") + " " + systemName + " :");
        ConfigAccessor config = ConfigAccessor.getInstance(".\\", "version.properties");
        String setting = config.getProperty(systemName);
        if (setting != null && setting.length() > 0) {
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("Connection Setting = " + setting);
            }
            StringTokenizer st = new StringTokenizer(setting, "|");
            String version = st.nextToken();
            String defaultLogin = st.nextToken();
            switch (Integer.parseInt(version)) {
                case 0: {
                    this.jRadioButtonIPMI15.setSelected(true);
                    break;
                }
                case 1: {
                    this.jRadioButtonIPMI20.setSelected(true);
                    break;
                }
                case 2: {
                    this.jRadioButtonIPMI20Plus.setSelected(true);
                    break;
                }
                case 79: {
                    this.jRadioButtonAuto.setSelected(true);
                    break;
                }
                default: {
                    this.jRadioButtonAuto.setSelected(true);
                }
            }
            if (defaultLogin.equals("1")) {
                this.jCheckBoxDefaultIDandPW.setSelected(true);
            }
            if (version.equals("2")) {
                String cipherSuite = st.nextToken();
                st = new StringTokenizer(cipherSuite, ",");
                String auth = st.nextToken();
                String integrity = st.nextToken();
                String conf = st.nextToken();
                this.jComboBoxAuth.setSelectedIndex(Integer.parseInt(auth));
                this.jComboBoxIntegrity.setSelectedIndex(Integer.parseInt(integrity));
                this.jComboBoxConf.setSelectedIndex(Integer.parseInt(conf));
                if (this.jComboBoxAuth.getSelectedIndex() == 1 && this.jComboBoxIntegrity.getSelectedIndex() == 0 && this.jComboBoxConf.getSelectedIndex() == 0) {
                    this.jEncryptionCheckBox.setSelected(false);
                } else {
                    this.jEncryptionCheckBox.setSelected(true);
                }
            }
            if (version.equals("79")) {
                this.jAdvancedUserCheckBox.setSelected(false);
                this.jAdvancedUserCheckBox_actionPerformed(null);
            } else {
                this.jAdvancedUserCheckBox.setSelected(true);
            }
        } else {
            this.jAdvancedUserCheckBox.setSelected(false);
            this.jAdvancedUserCheckBox_actionPerformed(null);
        }
    }

    public void save(String systemName) {
        ConfigAccessor config = ConfigAccessor.getInstance(".\\", "version.properties");
        StringBuffer sb = new StringBuffer();
        if (this.jRadioButtonAuto.isSelected()) {
            sb.append("79|");
        } else if (this.jRadioButtonIPMI15.isSelected()) {
            sb.append("0|");
        } else if (this.jRadioButtonIPMI20.isSelected()) {
            sb.append("1|");
        } else if (this.jRadioButtonIPMI20Plus.isSelected()) {
            sb.append("2|");
        }
        if (this.jCheckBoxDefaultIDandPW.isSelected()) {
            sb.append("1|");
        } else {
            sb.append("0|");
        }
        if (this.jEncryptionCheckBox.isEnabled()) {
            if (this.jEncryptionCheckBox.isSelected()) {
                this.jComboBoxAuth.setSelectedIndex(1);
                this.jComboBoxIntegrity.setSelectedIndex(1);
                this.jComboBoxConf.setSelectedIndex(1);
            } else {
                this.jComboBoxAuth.setSelectedIndex(1);
                this.jComboBoxIntegrity.setSelectedIndex(0);
                this.jComboBoxConf.setSelectedIndex(0);
            }
        }
        sb.append("" + this.jComboBoxAuth.getSelectedIndex() + ",");
        sb.append("" + this.jComboBoxIntegrity.getSelectedIndex() + ",");
        sb.append("" + this.jComboBoxConf.getSelectedIndex());
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("Setting save as: " + systemName + "=" + sb.toString());
        }
        config.setProperty(systemName, sb.toString());
    }

    void jRadioButtonAuto_actionPerformed(ActionEvent e2) {
    }

    void jComboBoxAuth_actionPerformed(ActionEvent e2) {
    }

    void jCheckBoxDefaultIDandPW_actionPerformed(ActionEvent e2) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        ConnectConfig connectConfig = new ConnectConfig();
        ConnectConfigFrame frame = new ConnectConfigFrame(connectConfig);
        frame.setTitle("ConnectConfig");
        frame.setSize(new Dimension(280, 270));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setContentPane(connectConfig);
        frame.show();
    }

    void jComboBoxConf_actionPerformed(ActionEvent e2) {
    }

    void jRadioButtonIPMI20Plus_actionPerformed(ActionEvent e2) {
    }

    void jRadioButtonIPMI20Plus_itemStateChanged(ItemEvent e2) {
        if (this.jRadioButtonIPMI20Plus.isSelected()) {
            this.jComboBoxAuth.setEnabled(true);
            this.jComboBoxIntegrity.setEnabled(true);
            this.jComboBoxConf.setEnabled(true);
            this.jEncryptionCheckBox.setEnabled(true);
            this.jPanel1.setEnabled(true);
            this.jGetCipherSuiteButton.setEnabled(true);
        } else {
            this.jComboBoxAuth.setEnabled(false);
            this.jComboBoxIntegrity.setEnabled(false);
            this.jComboBoxConf.setEnabled(false);
            this.jEncryptionCheckBox.setEnabled(false);
            this.jPanel1.setEnabled(false);
            this.jGetCipherSuiteButton.setEnabled(false);
        }
    }

    void jRadioButtonIPMI20_actionPerformed(ActionEvent e2) {
    }

    void jGetCipherSuiteButton_actionPerformed(ActionEvent e2) {
        Object[] message = new Object[1];
        CipherSuitePanel cipherSuitePanel = new CipherSuitePanel();
        cipherSuitePanel.setIP(this.IP);
        this.setCursor(new Cursor(3));
        boolean getResult = cipherSuitePanel.get();
        this.setCursor(new Cursor(0));
        if (!getResult) {
            return;
        }
        message[0] = cipherSuitePanel;
        int result = JOptionPane.showOptionDialog(this, message, "Get Cipher Suite IDs", 2, 3, null, null, null);
        if (result == 0) {
            int ID2 = cipherSuitePanel.getSelectID();
            if (ID2 != -1) {
                this.jComboBoxAuth.setSelectedIndex(CipherSuite.CIPHER_SUITES[ID2][0]);
                this.jComboBoxIntegrity.setSelectedIndex(CipherSuite.CIPHER_SUITES[ID2][1]);
                this.jComboBoxConf.setSelectedIndex(CipherSuite.CIPHER_SUITES[ID2][2]);
            }
            if (this.jComboBoxAuth.getSelectedIndex() == 0 && this.jComboBoxIntegrity.getSelectedIndex() == 0 && this.jComboBoxConf.getSelectedIndex() == 0) {
                this.jEncryptionCheckBox.setSelected(false);
            } else {
                this.jEncryptionCheckBox.setSelected(true);
            }
        }
    }

    void jRadioButtonIPMI15_actionPerformed(ActionEvent e2) {
    }

    void jAdvancedUserCheckBox_actionPerformed(ActionEvent e2) {
        if (this.jAdvancedUserCheckBox.isSelected()) {
            this.jRadioButtonIPMI15.setEnabled(true);
            this.jRadioButtonIPMI20.setEnabled(true);
            this.jRadioButtonIPMI20Plus.setEnabled(true);
        } else {
            this.jRadioButtonIPMI15.setEnabled(false);
            this.jRadioButtonIPMI20.setEnabled(false);
            this.jRadioButtonIPMI20Plus.setEnabled(false);
            this.jRadioButtonAuto.setSelected(true);
        }
        this.invalidate();
    }
}

