/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.BBPDischargeSettingDialog;
import IPMIView20.ByteUtility;
import IPMIView20.CSession;
import IPMIView20.IPMIView20;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class JPMBusPanel
extends JPanel {
    String ip;
    String id;
    String pw;
    byte maxLevel;
    UneditableDefaultTableModel ts;
    Icon greenIcon = new ImageIcon(this.getClass().getResource("/images/gledon-16.jpg"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/gledoff-16.jpg"));
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    CardLayout cardLayout = new CardLayout();
    JTable jTable = new JTable();
    JLabel naLabel = new JLabel("N/A");
    BBPDischargeSettingDialog bbpDischargeSettingDialog;
    ArrayList header = new ArrayList();
    ArrayList backupHeader = new ArrayList();
    byte[] bbpSlaveAddrsFRUCopy;
    int selectedColumn = 0;

    public JPMBusPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void helpSetLANConfig(CSession Session2) {
        this.setLANConfig(Session2.SIP, Session2.userID, new String(Session2.UserPassword), Session2.MaxLevel[0]);
    }

    public void setLANConfig(String ip, String id, String pw, byte maxLevel) {
        this.ip = ip;
        this.id = id;
        this.pw = pw;
        this.maxLevel = maxLevel;
    }

    public void reloadBBP() throws Exception {
        this.loadBBP(false);
    }

    public void fullLoadBBP() throws Exception {
        this.loadBBP(true);
    }

    public void reloadFRU() throws Exception {
        this.loadFRU(false);
    }

    public void fullLoadFRU() throws Exception {
        this.loadFRU(true);
    }

    public void reload() throws Exception {
        this.load(false);
    }

    public void fullLoad() throws Exception {
        this.load(true);
    }

    public void load(boolean ifFullLoad) throws Exception {
        int i2;
        IPMIInterfaceConfig config = this.getIPMIConfig();
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        if (sessionController == null) {
            return;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return;
        }
        ipmiI2CPMBusCommand.setIPMIInterface(rmcp);
        ipmiI2CPMBusCommand.detectBusID();
        ipmiI2CPMBusCommand.detectSlaveAddress();
        this.header = ipmiI2CPMBusCommand.getAvailableSlaveAddrsName();
        if (this.header.size() == 0) {
            this.showNALabel();
            sessionController.closeSession();
            return;
        }
        this.hideNALabel();
        if (this.header.size() != this.backupHeader.size() || ifFullLoad) {
            this.setHeader(this.header);
            this.backupHeader = this.header;
        }
        ArrayList<IPMII2CPMBusCommand.PMBusHealth> pmBusHealths = new ArrayList<IPMII2CPMBusCommand.PMBusHealth>();
        for (int i3 = 0; i3 < ipmiI2CPMBusCommand.getAvailableSlaveAddrs().length; ++i3) {
            ipmiI2CPMBusCommand.setSlaveAddr(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i3]);
            IPMII2CPMBusCommand.PMBusHealth pmBusHealth = ipmiI2CPMBusCommand.getAll();
            pmBusHealths.add(pmBusHealth);
        }
        sessionController.closeSession();
        ArrayList<Object> temp = new ArrayList<Object>();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            boolean status = ((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).getSimpleStatus();
            if (status) {
                temp.add(this.greenIcon);
                continue;
            }
            temp.add(this.xRedIcon);
        }
        this.addRaw("Status", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetACInputVoltage());
        }
        this.addRaw("AC Input Voltage", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetACInputCurrent());
        }
        this.addRaw("AC Input Current", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetDC12VOutputVoltage());
        }
        this.addRaw("DC 12V Output Voltage", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetDC12VOutputCurrent());
        }
        this.addRaw("DC 12V Output Current", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetTemperature1());
        }
        this.addRaw("Temperature 1", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetTemperature2());
        }
        this.addRaw("Temperature 2", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetFan1());
        }
        this.addRaw("Fan 1", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetDC12VOutputPower());
        }
        this.addRaw("DC 12V Output Power", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetACInputPower());
        }
        this.addRaw("AC Input Power", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetPMBusRevision());
        }
        this.addRaw("PMBus Revision", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetPWSSerialNumber());
        }
        this.addRaw("PWS Serial", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetPWSModuleNumber());
        }
        this.addRaw("PWS Module", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.PMBusHealth)pmBusHealths.get(i2)).uiGetPWSRevision());
        }
        this.addRaw("PWS Revision", temp);
        temp.clear();
        for (i2 = 0; i2 < pmBusHealths.size(); ++i2) {
            temp.add(ByteUtility.byteToHex(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i2]) + "h");
        }
        this.addRaw("Slave Addr", temp);
        this.jTable.invalidate();
    }

    public void loadFRU(boolean ifFullLoad) throws Exception {
        int i2;
        IPMIInterfaceConfig config = this.getIPMIConfig();
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        if (sessionController == null) {
            return;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return;
        }
        ipmiI2CPMBusCommand.setIPMIInterface(rmcp);
        ipmiI2CPMBusCommand.detectBusID();
        ipmiI2CPMBusCommand.detectSlaveAddressFRU();
        this.header = ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUName();
        if (this.header.size() == 0) {
            this.showNALabel();
            sessionController.closeSession();
            return;
        }
        this.hideNALabel();
        if (this.header.size() != this.backupHeader.size() || ifFullLoad) {
            this.setHeader(this.header);
            this.backupHeader = this.header;
        }
        ArrayList<IPMII2CPMBusCommand.FRUHealth> fruHealths = new ArrayList<IPMII2CPMBusCommand.FRUHealth>();
        for (int i3 = 0; i3 < ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRU().length; ++i3) {
            ipmiI2CPMBusCommand.setSlaveAddrFRU(ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRU()[i3]);
            IPMII2CPMBusCommand.FRUHealth fruHealth = ipmiI2CPMBusCommand.getAllFRU();
            fruHealths.add(fruHealth);
        }
        sessionController.closeSession();
        ArrayList<Object> temp = new ArrayList<Object>();
        for (i2 = 0; i2 < fruHealths.size(); ++i2) {
            if (!((IPMII2CPMBusCommand.FRUHealth)fruHealths.get((int)i2)).isStatusByte) {
                temp.add("N/A");
                continue;
            }
            if (((IPMII2CPMBusCommand.FRUHealth)fruHealths.get(i2)).getStatus() == 1) {
                temp.add(this.greenIcon);
                continue;
            }
            if (((IPMII2CPMBusCommand.FRUHealth)fruHealths.get(i2)).getStatus() == 0) {
                temp.add(this.xRedIcon);
                continue;
            }
            temp.add("Unknown");
        }
        this.addRaw("Status", temp);
        temp.clear();
        for (i2 = 0; i2 < fruHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.FRUHealth)fruHealths.get(i2)).uiGetTemperature());
        }
        this.addRaw("Temperature", temp);
        temp.clear();
        for (i2 = 0; i2 < fruHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.FRUHealth)fruHealths.get(i2)).uiGetFan());
        }
        this.addRaw("Fan", temp);
        temp.clear();
        for (i2 = 0; i2 < fruHealths.size(); ++i2) {
            temp.add(ByteUtility.byteToHex(ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRU()[i2]) + "h");
        }
        this.addRaw("Slave Addr", temp);
        this.jTable.invalidate();
    }

    public void loadBBP(boolean ifFullLoad) throws Exception {
        int i2;
        if (this.bbpDischargeSettingDialog == null) {
            this.bbpDischargeSettingDialog = new BBPDischargeSettingDialog();
            this.bbpDischargeSettingDialog.setJPMBusPanel(this);
        }
        IPMIInterfaceConfig config = this.getIPMIConfig();
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        if (sessionController == null) {
            return;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return;
        }
        ipmiI2CPMBusCommand.setIPMIInterface(rmcp);
        ipmiI2CPMBusCommand.detectBusID();
        ipmiI2CPMBusCommand.detectSlaveAddressFRUBBP();
        this.bbpSlaveAddrsFRUCopy = ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBP();
        this.header = ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBPName();
        for (int i3 = 0; i3 < this.header.size(); ++i3) {
            String h2 = (String)this.header.get(i3);
            this.header.set(i3, h2 + " (Click Setting)");
        }
        if (this.header.size() == 0) {
            this.showNALabel();
            sessionController.closeSession();
            return;
        }
        this.hideNALabel();
        if (this.header.size() != this.backupHeader.size() || ifFullLoad) {
            this.setHeader(this.header);
            this.backupHeader = this.header;
        }
        ArrayList<IPMII2CPMBusCommand.BBPHealth> bbpHealths = new ArrayList<IPMII2CPMBusCommand.BBPHealth>();
        for (int i4 = 0; i4 < ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBP().length; ++i4) {
            ipmiI2CPMBusCommand.setSlaveAddrFRUBBP(ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBP()[i4]);
            IPMII2CPMBusCommand.BBPHealth bbpHealth = ipmiI2CPMBusCommand.getAllBBP();
            bbpHealths.add(bbpHealth);
        }
        sessionController.closeSession();
        ArrayList<String> temp = new ArrayList<String>();
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getProductManufacturer());
        }
        this.addRaw("Manufacturer", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getProductName());
        }
        this.addRaw("Model Name", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getProductSerialNumber());
        }
        this.addRaw("Serial Number", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getProductVersion());
        }
        this.addRaw("Product Version", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getFirmwareVersionDisplay());
        }
        this.addRaw("Firmware version", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryVoltageDisplay());
        }
        this.addRaw("Battery Voltage", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryCurrentDisplay());
        }
        this.addRaw("Battery Current", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryPackTemperatureDisplay());
        }
        this.addRaw("Battery Pack Temp", temp);
        if (((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(0)).getBoardTemperature() > 0) {
            temp.clear();
            for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
                temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBoardTemperatureDisplay());
            }
            this.addRaw("Board Temp", temp);
        }
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryOutputWattageDisplay());
        }
        this.addRaw("Power Wattage", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getCycleCountDisplay());
        }
        this.addRaw("Cycle Count", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryPowerStatusDisplay());
        }
        this.addRaw("Battery Power Status", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getRemainingRelativeBatteryEnergyDisplay());
        }
        this.addRaw("Remaining Energy", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryDischargeStatusDisplay());
        }
        this.addRaw("Discharge Status", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryDischargeSettingDisplay());
        }
        this.addRaw("Discharge Setting", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryDischargeRemainingDaysDisplay());
        }
        this.addRaw("Discharge Remaining Days", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryStatusNumberDisplay());
        }
        this.addRaw("Battery Status #", temp);
        temp.clear();
        for (i2 = 0; i2 < bbpHealths.size(); ++i2) {
            temp.add(((IPMII2CPMBusCommand.BBPHealth)bbpHealths.get(i2)).getBatteryStatusDescriptionsDisplay());
        }
        this.addRaw("Battery Status", temp);
        JTableHeader header = this.jTable.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                JTableHeader tableHeader = (JTableHeader)e2.getSource();
                JPMBusPanel.this.selectedColumn = tableHeader.columnAtPoint(e2.getPoint());
                if (JPMBusPanel.this.selectedColumn > 0) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                int x = IPMIView20.getInstance().getX() + (IPMIView20.getInstance().getWidth() - JPMBusPanel.this.bbpDischargeSettingDialog.getWidth()) / 2;
                                int y = IPMIView20.getInstance().getY() + (IPMIView20.getInstance().getHeight() - JPMBusPanel.this.bbpDischargeSettingDialog.getHeight()) / 2;
                                Point p = new Point(x, y);
                                JPMBusPanel.this.setCursor(new Cursor(3));
                                JPMBusPanel.this.bbpDischargeSettingDialog.setLocation(p);
                                JPMBusPanel.this.bbpDischargeSettingDialog.load(JPMBusPanel.this.getIPMIConfig(), JPMBusPanel.this.bbpSlaveAddrsFRUCopy[JPMBusPanel.this.selectedColumn - 1]);
                                JPMBusPanel.this.bbpDischargeSettingDialog.setVisible(true);
                                JPMBusPanel.this.setCursor(new Cursor(0));
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    };
                    thread.start();
                }
            }
        });
        this.jTable.invalidate();
    }

    public void setHeader(ArrayList headerList) {
        ArrayList<String> head = new ArrayList<String>();
        head.add("Item");
        head.addAll(1, headerList);
        this.ts = new UneditableDefaultTableModel(head.toArray(), 0);
        this.jTable.setModel(this.ts);
        PMBusTableRenderer r = new PMBusTableRenderer();
        for (int i2 = 0; i2 < headerList.size(); ++i2) {
            this.jTable.getColumnModel().getColumn(i2 + 1).setCellRenderer(r);
        }
    }

    public int findRow(String name) {
        int count = this.ts.getRowCount();
        for (int i2 = 0; i2 < count; ++i2) {
            if (!this.ts.getValueAt(i2, 0).equals(name)) continue;
            return i2;
        }
        return -1;
    }

    public void addRaw(String name, ArrayList data) {
        int rowIndex = this.findRow(name);
        if (rowIndex != -1) {
            for (int i2 = 0; i2 < data.size(); ++i2) {
                this.ts.setValueAt(data.get(i2), rowIndex, 1 + i2);
            }
        } else {
            ArrayList<String> raw = new ArrayList<String>();
            raw.add(name);
            for (int i3 = 0; i3 < data.size(); ++i3) {
                raw.add((String)data.get(i3));
            }
            this.ts.addRow(raw.toArray());
        }
    }

    private IPMIInterfaceConfig getIPMIConfig() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.pw);
        config.setPrivilege(this.maxLevel);
        return config;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.cardLayout);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, "table");
        this.jPanel1.add((Component)this.naLabel, "na");
        this.cardLayout.show(this.jPanel1, "table");
        this.jScrollPane1.getViewport().add(this.jTable);
        this.naLabel.setHorizontalAlignment(0);
        this.naLabel.setEnabled(false);
        this.jTable.getTableHeader().setReorderingAllowed(false);
    }

    public void showNALabel() {
        this.cardLayout.show(this.jPanel1, "na");
    }

    public void hideNALabel() {
        this.cardLayout.show(this.jPanel1, "table");
    }

    class UneditableDefaultTableModel
    extends DefaultTableModel {
        public UneditableDefaultTableModel(Object[] array, int i2) {
            super(array, i2);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class PMBusTableRenderer
    extends JPanel
    implements TableCellRenderer {
        PMBusTableRenderer() {
        }

        protected void setValue(Object value) {
        }

        public void fillColor(JTable t, JLabel l, boolean isSelected) {
            if (isSelected) {
                l.setBackground(t.getSelectionBackground());
                l.setForeground(t.getSelectionForeground());
            } else {
                l.setBackground(t.getBackground());
                l.setForeground(t.getForeground());
                l.setForeground(Color.blue);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c2 = null;
            JLabel l = null;
            if (value instanceof Icon) {
                String status = "";
                if (value.equals(JPMBusPanel.this.greenIcon)) {
                    status = "on";
                } else if (value.equals(JPMBusPanel.this.xRedIcon)) {
                    status = "off";
                }
                l = new JLabel(status, (Icon)value, 4);
                l.setOpaque(true);
                this.fillColor(table, l, isSelected);
                c2 = l;
            } else {
                l = new JLabel(value.toString(), 4);
                l.setForeground(Color.blue);
                l.setOpaque(true);
                this.fillColor(table, l, isSelected);
                c2 = l;
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add(c2);
            return jPanel;
        }
    }
}

