/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class JSensorPanel
extends JPanel {
    JLabel sensorIcon = new JLabel();
    JLabel NameLabel = new JLabel();
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    JLabel Message;
    CSession Session;
    UDPSocket udpSocket;
    int SensorNumber;
    int SensorType;
    ImageIcon ChassisOK = new ImageIcon(this.getClass().getResource("/images/chassisok.gif"));
    ImageIcon PowerSupplyOK = new ImageIcon(this.getClass().getResource("/images/powersupplyok.gif"));
    ImageIcon ChassisOpen = new ImageIcon(this.getClass().getResource("/images/chassisopen.gif"));
    ImageIcon PowerSupplyFailed = new ImageIcon(this.getClass().getResource("/images/powersupplyfailed.gif"));

    public JSensorPanel(int sensorNumber, int sensorType) {
        this.initComponents();
        this.SensorNumber = sensorNumber;
        this.SensorType = sensorType;
    }

    public void updateValue(byte value) {
        switch (this.SensorType) {
            case 5: {
                if ((value & 1) == 1) {
                    this.sensorIcon.setIcon(this.ChassisOpen);
                    this.sensorIcon.setBorder(new EtchedBorder());
                    this.NameLabel.setText(L.t("sensorpanel.Clear"));
                    this.NameLabel.setBorder(new EtchedBorder());
                    break;
                }
                this.sensorIcon.setIcon(this.ChassisOK);
                this.sensorIcon.setBorder(new EtchedBorder());
                this.NameLabel.setText(" ");
                this.NameLabel.setBorder(null);
                break;
            }
            case 8: {
                if (this.Session.isPeppercon || this.Session.isPowerSupplyFailureReverseForOSA || this.Session.isAMI || this.Session.isATEN || this.Session.isAMIX9 || this.Session.isATEN_ASPD) {
                    if (value == 0 || value == 1) {
                        this.sensorIcon.setIcon(this.PowerSupplyOK);
                        this.sensorIcon.setBorder(new EtchedBorder());
                        break;
                    }
                    this.sensorIcon.setIcon(this.PowerSupplyFailed);
                    this.sensorIcon.setBorder(new EtchedBorder());
                    break;
                }
                if ((value & 2) == 0) {
                    this.sensorIcon.setIcon(this.PowerSupplyFailed);
                    this.sensorIcon.setBorder(new EtchedBorder());
                    break;
                }
                this.sensorIcon.setIcon(this.PowerSupplyOK);
                this.sensorIcon.setBorder(new EtchedBorder());
            }
        }
        this.repaint();
    }

    public void init(UDPSocket xSocket, CSession iSession, JLabel xMessage, byte value) {
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        if (this.SensorType == 5) {
            this.NameLabel.setText(L.t("sensorpanel.Clear"));
            this.NameLabel.setBorder(new EtchedBorder());
        } else {
            this.NameLabel.setText(" ");
            this.NameLabel.setBorder(null);
        }
        this.NameLabel.setForeground(Color.blue);
        this.NameLabel.setHorizontalAlignment(0);
        this.NameLabel.setPreferredSize(new Dimension(60, 22));
        this.NameLabel.setVisible(true);
        if (this.SensorType == 5) {
            this.NameLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (JSensorPanel.this.NameLabel.getText().equals(L.t("sensorpanel.Clear"))) {
                        JSensorPanel.this.clearChassisIntrusion(evt);
                    }
                }
            });
        }
        this.add((Component)this.sensorIcon, "Center");
        if (!this.Session.isRemoveChassisIntrusionClearFlag) {
            this.add((Component)this.NameLabel, "South");
        }
        this.updateValue(value);
    }

    private void clearChassisIntrusion(MouseEvent evt) {
        if (this.Session.IPMIVersion == 0) {
            Logger.writeLog("Clear Chassis Intrusion to IPMI 1.5");
            this.NameLabelMouseClicked(evt);
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sensorpanel.Chassis_Intrusion_has_been_cleared"), L.t("sensorpanel.Information"), 1);
        } else if (this.Session.IPMIVersion == 1 || this.Session.IPMIVersion == 2) {
            Logger.writeLog("Clear Chassis Intrusion to IPMI 2.0");
            this.sendClearChassisIntrusion();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sensorpanel.Chassis_Intrusion_has_been_cleared"), L.t("sensorpanel.Information"), 1);
        }
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void NameLabelMouseClicked(MouseEvent evt) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] xCmd = new byte[]{0, 0, 0, 0, 0, 0};
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        if (evt.getClickCount() == 1 && this.NameLabel.getText().compareTo(L.t("sensorpanel.Clear")) == 0) {
            Cursor csrTemp = new Cursor(3);
            this.setCursor(csrTemp);
            CSession cSession = this.Session;
            synchronized (cSession) {
                this.Session.lockout();
                Para.removeAllElements();
                Para.addElement(AuthType);
                Para.addElement(this.Session.SessionSeq);
                Para.addElement(this.Session.SessionID);
                xCmd[0] = (byte)this.SensorNumber;
                xCmd[1] = 0;
                Para.addElement(xCmd);
                this.SIP = this.Session.SIP;
                this.Message.setText("Clearing the Chassis Intrusion Falg");
                this.rmcpPacket.RMCPSetup((byte)7, (byte)16, (byte)40, (byte)0, Para, this.Session, rawdata, length);
                if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                    this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
                    if (this.rmcpPacket.compeletecode == 0) {
                        this.Session.IncreaseSessionSeq();
                        Para.removeAllElements();
                        Para.addElement(AuthType);
                        Para.addElement(this.Session.SessionSeq);
                        Para.addElement(this.Session.SessionID);
                        xCmd[0] = (byte)this.SensorNumber;
                        xCmd[1] = -64;
                        Para.addElement(xCmd);
                        this.rmcpPacket.RMCPSetup((byte)7, (byte)16, (byte)40, (byte)0, Para, this.Session, rawdata, length);
                        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
                            if (this.rmcpPacket.compeletecode == 0) {
                                this.Session.IncreaseSessionSeq();
                                this.Message.setText("Command for Clearing the Chassis Intrusion Falg is sent");
                            } else {
                                this.Message.setText("Clear the Chassis Intrusion Falg failed");
                            }
                        } else {
                            this.Message.setText("Clear the Chassis Intrusion Falg failed");
                        }
                    } else {
                        this.Message.setText("Clear the Chassis Intrusion Falg failed");
                    }
                } else {
                    this.Message.setText("Clear the Chassis Intrusion Falg failed");
                }
                this.Session.releaselock();
            }
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
        }
    }

    private byte sendClearChassisIntrusion() {
        byte[] param = new byte[]{};
        return this.sendCommand((byte)-64, (byte)3, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte sendCommand(byte netFn, byte appCommand, byte[] param) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            if (param != null && param.length > 0) {
                Para.addElement(param);
            }
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, netFn, appCommand, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return this.rmcpPacket.compeletecode;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i2 = offset + length - 1; i2 >= offset; --i2) {
            intdes = (intdes << 8) + (bytesrc[i2] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }
}

