/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.DeviceFile;
import IPMIView20.GlobalDefine;
import IPMIView20.JFanPanel;
import IPMIView20.JPSUPanel;
import IPMIView20.JSensorPanel;
import IPMIView20.JTempPanel;
import IPMIView20.JTextTempPanel;
import IPMIView20.JVolPanel;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class Sensors20
extends JPanel {
    boolean bLoaded = false;
    boolean refreshFlag = false;
    boolean priorDone = true;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    String hostname;
    JLabel Message;
    CSession Session;
    DeviceFile Devicefile;
    int TabId;
    UDPSocket udpSocket;
    int TotalEntries = 0;
    Timer timer;
    Vector sRecords = new Vector(10);
    int FanPanelSize = 0;
    int VolPanelSize = 0;
    int TempPanelSize = 0;
    int SensorPanelSize = 0;
    int textTempPanelSize = 0;
    JFanPanel[] FanPanel;
    JVolPanel[] VolPanel;
    JTempPanel[] TempPanel;
    JSensorPanel[] SensorPanel;
    JTextTempPanel[] textTempPanel;
    private JPSUPanel PSUPanel;
    private JInternalFrame PSUFrame;
    private JDesktopPane jDesktopPane1;
    private JInternalFrame FANFrame;
    private JPanel FANGroup;
    private JInternalFrame VOLFrame;
    private JPanel VOLGroup;
    private JInternalFrame SENSORFrame;
    private JPanel SENSORGroup;
    private JInternalFrame TEMPFrame;
    private JPanel TEMPGroup;
    private JPanel jPanel8;
    private JPanel jPanel1;
    private JLabel jRefreshLabel;
    private JComboBox jAutoTimer;
    private JLabel jTimerLabel;
    private JButton jManuRefresh;
    private JButton jSaveLayout;
    private JCheckBox jHideItem;
    private JCheckBox jHistoryItem;

    public Sensors20() {
        this.initComponents();
        this.timer = new Timer();
        this.FANFrame.setVisible(false);
        this.VOLFrame.setVisible(false);
        this.TEMPFrame.setVisible(false);
        this.SENSORFrame.setVisible(false);
        this.PSUFrame.setVisible(false);
        this.FANFrame.setFrameIcon(null);
        this.VOLFrame.setFrameIcon(null);
        this.TEMPFrame.setFrameIcon(null);
        this.SENSORFrame.setFrameIcon(null);
        this.PSUFrame.setFrameIcon(null);
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                Thread th = new Thread(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Sensors20.this.jManuRefresh.setEnabled(false);
                            }
                        });
                        Sensors20.this.RefreshSensors();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Sensors20.this.jManuRefresh.setEnabled(true);
                            }
                        });
                    }
                };
                th.start();
            }
        };
        this.timer = new Timer();
        this.timer.schedule(t, 60000L, 60000L);
        this.jAutoTimer.addItem("10");
        this.jAutoTimer.addItem("20");
        this.jAutoTimer.addItem("30");
        this.jAutoTimer.addItem("45");
        this.jAutoTimer.addItem("60");
        this.jAutoTimer.addItem("90");
        this.jAutoTimer.addItem("120");
        this.jAutoTimer.setSelectedIndex(4);
        this.validate();
    }

    public void preset(String Hostname, UDPSocket xSocket, CSession iSession, JLabel xMessage, DeviceFile xDevicefile) {
        this.hostname = Hostname;
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.Devicefile = xDevicefile;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        this.PSUPanel.setLANConfig(this.Session);
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    public void setRefreshFlag(boolean xFlag) {
        this.refreshFlag = xFlag;
    }

    public void showFrame() {
        Rectangle rPos = new Rectangle();
        String layposition = "";
        try {
            layposition = (String)this.Devicefile.getDevice(this.hostname).get(3);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            System.out.println("Load Layout Error");
        }
        if (layposition.length() > 0) {
            int x = layposition.indexOf(44);
            rPos.x = Integer.parseInt(layposition.substring(0, x));
            int y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.FANFrame.setBounds(rPos);
            String xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.FANFrame.setIcon(true);
                }
                catch (PropertyVetoException pe) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.FANFrame.setMaximum(true);
                }
                catch (PropertyVetoException pe) {}
            } else {
                try {
                    this.FANFrame.setMaximum(false);
                    this.FANFrame.setIcon(false);
                }
                catch (PropertyVetoException pe) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.VOLFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.VOLFrame.setIcon(true);
                }
                catch (PropertyVetoException pe) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.VOLFrame.setMaximum(true);
                }
                catch (PropertyVetoException pe) {}
            } else {
                try {
                    this.VOLFrame.setMaximum(false);
                    this.VOLFrame.setIcon(false);
                }
                catch (PropertyVetoException pe) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.TEMPFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.TEMPFrame.setIcon(true);
                }
                catch (PropertyVetoException pe) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.TEMPFrame.setMaximum(true);
                }
                catch (PropertyVetoException pe) {}
            } else {
                try {
                    this.TEMPFrame.setMaximum(false);
                    this.TEMPFrame.setIcon(false);
                }
                catch (PropertyVetoException pe) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.SENSORFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, layposition.length());
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.SENSORFrame.setIcon(true);
                }
                catch (PropertyVetoException pe) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.SENSORFrame.setMaximum(true);
                }
                catch (PropertyVetoException pe) {}
            } else {
                try {
                    this.SENSORFrame.setMaximum(false);
                    this.SENSORFrame.setIcon(false);
                }
                catch (PropertyVetoException pe) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            this.PSUFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, layposition.length());
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.PSUFrame.setIcon(true);
                }
                catch (PropertyVetoException pe) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.PSUFrame.setMaximum(true);
                }
                catch (PropertyVetoException pe) {}
            } else {
                try {
                    this.PSUFrame.setMaximum(false);
                    this.PSUFrame.setIcon(false);
                }
                catch (PropertyVetoException pe) {
                    // empty catch block
                }
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSDRRepoInfo() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.Message.setText(L.t("sensor.Getting_SDR_Repository_Info"));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)32, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Message.setText(L.t("sensor.Get_SDR_Repository_Info_succeeded"));
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(1);
                    this.TotalEntries = this.ByteToInt(bytex, 0, 2);
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sensor.Get_SDR_Repository_Info_failed"));
                }
            } else {
                this.Message.setText(L.t("sensor.Get_SDR_Repository_Info_failed"));
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    public void GetSensors() {
        if (this.bLoaded) {
            this.Session.Loading = -1;
            return;
        }
        this.TabId = this.Session.Loading;
        this.GetSDRRepoInfo();
        if (this.TotalEntries > 0) {
            SensorRecord Sensor;
            int i2;
            this.sRecords.removeAllElements();
            if (!this.GetSDRRecords()) {
                return;
            }
            int VolIndex = 0;
            int FanIndex = 0;
            int TempIndex = 0;
            int textTempIndex = 0;
            int SensorIndex = 0;
            boolean hasFanSensor = false;
            boolean hasVolSensor = false;
            boolean hasTempSensor = false;
            boolean hasOtherSensor = false;
            boolean hasPSUSensor = true;
            this.TEMPGroup.removeAll();
            this.VOLGroup.removeAll();
            this.FANGroup.removeAll();
            this.SENSORGroup.removeAll();
            for (i2 = 0; i2 < this.sRecords.size(); ++i2) {
                Sensor = (SensorRecord)this.sRecords.get(i2);
                if (Sensor.SensorType == 1) {
                    ++this.TempPanelSize;
                }
                if (Sensor.SensorType == 192) {
                    ++this.textTempPanelSize;
                }
                if (Sensor.SensorType == 2) {
                    ++this.VolPanelSize;
                }
                if (Sensor.SensorType == 4) {
                    ++this.FanPanelSize;
                }
                if (Sensor.SensorType != 5 && Sensor.SensorType != 8) continue;
                ++this.SensorPanelSize;
            }
            this.FanPanel = new JFanPanel[this.FanPanelSize];
            this.VolPanel = new JVolPanel[this.VolPanelSize];
            this.TempPanel = new JTempPanel[this.TempPanelSize];
            this.SensorPanel = new JSensorPanel[this.SensorPanelSize];
            this.textTempPanel = new JTextTempPanel[this.textTempPanelSize];
            for (i2 = 0; i2 < this.sRecords.size(); ++i2) {
                Sensor = (SensorRecord)this.sRecords.get(i2);
                if (Sensor.SensorType == 1) {
                    hasTempSensor = true;
                    this.TempPanel[TempIndex] = new JTempPanel(Sensor.SensorNumber, Sensor.M, Sensor.B, Sensor.RExp, Sensor.BExp);
                    this.TempPanel[TempIndex].init(Sensor.SensorName, Sensor.Reading, Sensor.Maximum, Sensor.valueString, Sensor.MaxString);
                    this.TEMPGroup.add(this.TempPanel[TempIndex]);
                    ++TempIndex;
                }
                if (Sensor.SensorType == 192) {
                    this.textTempPanel[textTempIndex] = new JTextTempPanel(Sensor.SensorName, Sensor.SensorNumber);
                    this.textTempPanel[textTempIndex].reading = Sensor.Reading;
                    this.TEMPGroup.add(this.textTempPanel[textTempIndex]);
                    ++textTempIndex;
                }
                if (Sensor.SensorType == 2) {
                    hasVolSensor = true;
                    this.VolPanel[VolIndex] = new JVolPanel(Sensor.SensorNumber, Sensor.M, Sensor.B, Sensor.RExp, Sensor.BExp);
                    if (Sensor.Reading == 0 || Sensor.Reading == 255) {
                        Sensor.valueString = new String("N/A");
                    }
                    if (this.Session.isPeppercon && Sensor.SensorName.equalsIgnoreCase("-12")) {
                        this.VolPanel[VolIndex].init(Sensor.SensorName, Sensor.Reading, Sensor.Minimum, Sensor.Maximum, Sensor.valueString, Sensor.MaxString, Sensor.MinString);
                    } else {
                        this.VolPanel[VolIndex].init(Sensor.SensorName, Sensor.Reading, Sensor.Maximum, Sensor.Minimum, Sensor.valueString, Sensor.MaxString, Sensor.MinString);
                    }
                    this.VOLGroup.add(this.VolPanel[VolIndex]);
                    ++VolIndex;
                }
                if (Sensor.SensorType == 4) {
                    hasFanSensor = true;
                    this.FanPanel[FanIndex] = new JFanPanel(Sensor.SensorNumber, Sensor.M, Sensor.B, Sensor.RExp, Sensor.BExp, Sensor.Linearization, this.Session);
                    if (Sensor.Reading == 0) {
                        Sensor.Reading = (byte)-1;
                    }
                    if (Sensor.Reading == -1) {
                        Sensor.valueString = new String("N/A");
                    }
                    this.FanPanel[FanIndex].init(Sensor.SensorName, Sensor.Reading, Sensor.Minimum, Sensor.valueString, Sensor.MinString);
                    this.FANGroup.add(this.FanPanel[FanIndex]);
                    this.FanPanel[FanIndex].animation();
                    ++FanIndex;
                }
                if (Sensor.SensorType != 5 && Sensor.SensorType != 8) continue;
                hasOtherSensor = true;
                this.SensorPanel[SensorIndex] = new JSensorPanel(Sensor.SensorNumber, Sensor.SensorType);
                this.SensorPanel[SensorIndex].init(this.udpSocket, this.Session, this.Message, Sensor.Reading);
                this.SENSORGroup.add(this.SensorPanel[SensorIndex]);
                ++SensorIndex;
            }
            this.repaint();
            this.grabFocus();
            if (this.jHideItem.isSelected()) {
                for (i2 = 0; i2 < this.TempPanelSize && this.TempPanel[i2] != null; ++i2) {
                    if (this.TempPanel[i2].tempMeter.m_ShowString.compareTo("0.0") != 0 && !"N/A".equals(this.TempPanel[i2].tempMeter.m_ShowString)) continue;
                    this.TempPanel[i2].setVisible(false);
                }
                for (i2 = 0; i2 < this.textTempPanelSize && this.textTempPanel[i2] != null; ++i2) {
                    if (this.textTempPanel[i2].reading != 7) continue;
                    this.textTempPanel[i2].setVisible(false);
                }
                for (i2 = 0; i2 < this.FanPanelSize && this.FanPanel[i2] != null; ++i2) {
                    if (this.FanPanel[i2].fanMeter.m_ShowString.compareTo("N/A") != 0) continue;
                    this.FanPanel[i2].setVisible(false);
                }
                for (i2 = 0; i2 < this.VolPanelSize && this.VolPanel[i2] != null; ++i2) {
                    if (this.VolPanel[i2].volMeter.m_ShowString.compareTo("N/A") != 0) continue;
                    this.VolPanel[i2].setVisible(false);
                }
            } else {
                for (i2 = 0; i2 < this.TempPanelSize && this.TempPanel[i2] != null; ++i2) {
                    this.TempPanel[i2].setVisible(true);
                }
                for (i2 = 0; i2 < this.textTempPanelSize && this.textTempPanel[i2] != null; ++i2) {
                    this.textTempPanel[i2].setVisible(true);
                }
                for (i2 = 0; i2 < this.FanPanelSize && this.FanPanel[i2] != null; ++i2) {
                    this.FanPanel[i2].setVisible(true);
                }
                for (i2 = 0; i2 < this.VolPanelSize && this.VolPanel[i2] != null; ++i2) {
                    this.VolPanel[i2].setVisible(true);
                }
            }
            if (hasFanSensor) {
                this.FANFrame.setVisible(true);
            }
            if (hasVolSensor) {
                this.VOLFrame.setVisible(true);
            }
            if (hasTempSensor) {
                this.TEMPFrame.setVisible(true);
            }
            if (hasOtherSensor) {
                if (SensorIndex > 0) {
                    this.SENSORFrame.setVisible(true);
                } else {
                    this.SENSORFrame.setVisible(false);
                }
            }
            if (hasPSUSensor) {
                this.PSUFrame.setVisible(true);
            }
            this.jRefreshLabel.setEnabled(true);
            this.jTimerLabel.setEnabled(true);
            this.jAutoTimer.setEnabled(true);
            this.jManuRefresh.setEnabled(true);
            this.jSaveLayout.setEnabled(true);
        }
        this.TEMPFrame.pack();
        this.SENSORFrame.pack();
        this.bLoaded = true;
        this.Session.Loading = -1;
    }

    public void RefreshSensors() {
        String valueString;
        int Value;
        int X;
        int BExp;
        int RExp;
        int B;
        int M2;
        boolean result;
        int i2;
        byte[] bytey = new byte[256];
        if (!this.refreshFlag) {
            return;
        }
        if (!this.priorDone) {
            return;
        }
        this.Session.Loading = this.TabId;
        this.priorDone = false;
        this.Message.setText(L.t("sensor.Refreshing_sensors_status"));
        for (i2 = 0; i2 < this.FanPanelSize && this.FanPanel[i2] != null; ++i2) {
            result = this.GetSensor(this.FanPanel[i2].SensorNumber, bytey);
            if (!result) {
                bytey[0] = -1;
            }
            M2 = this.FanPanel[i2].M;
            B = this.FanPanel[i2].B;
            RExp = this.FanPanel[i2].RExp;
            BExp = this.FanPanel[i2].BExp;
            X = this.ByteToInt(bytey, 0, 1);
            double rawx = ((double)(M2 * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
            Value = this.FanPanel[i2].Linearization == 7 ? (int)(1.0 / rawx) : (this.FanPanel[i2].Linearization == 8 ? (int)(rawx * rawx) : (int)rawx);
            valueString = new String(Value + "");
            if (bytey[0] == 0) {
                bytey[0] = -1;
            }
            if (bytey[0] == -1) {
                valueString = "N/A";
            }
            this.FanPanel[i2].updateValue(bytey[0], valueString);
        }
        for (i2 = 0; i2 < this.VolPanelSize && this.VolPanel[i2] != null; ++i2) {
            result = this.GetSensor(this.VolPanel[i2].SensorNumber, bytey);
            M2 = this.VolPanel[i2].M;
            B = this.VolPanel[i2].B;
            RExp = this.VolPanel[i2].RExp;
            BExp = this.VolPanel[i2].BExp;
            X = this.ByteToInt(bytey, 0, 1);
            Value = (int)(((double)(M2 * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
            if (X == 0 || X == 255) {
                valueString = new String("N/A");
                bytey[0] = 0;
            } else {
                valueString = new String((double)Value / 100.0 + "");
            }
            this.VolPanel[i2].updateValue(bytey[0], valueString);
        }
        for (i2 = 0; i2 < this.TempPanelSize && this.TempPanel[i2] != null; ++i2) {
            result = this.GetSensor(this.TempPanel[i2].SensorNumber, bytey);
            M2 = this.TempPanel[i2].M;
            B = this.TempPanel[i2].B;
            RExp = this.TempPanel[i2].RExp;
            BExp = this.TempPanel[i2].BExp;
            X = this.ByteToInt(bytey, 0, 1);
            Value = (int)(((double)(M2 * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
            valueString = X == 0 || X == 255 ? new String("N/A") : new String((double)Value / 100.0 + "");
            this.TempPanel[i2].updateValue(bytey[0], valueString);
        }
        for (i2 = 0; i2 < this.textTempPanelSize && this.textTempPanel[i2] != null; ++i2) {
            result = this.GetSensor(this.textTempPanel[i2].sensorNumber, bytey);
            byte reading = -1;
            reading = (bytey[1] & 0x20) > 0 ? (byte)7 : bytey[2];
            this.textTempPanel[i2].updateStatus(reading);
        }
        for (i2 = 0; i2 < this.SensorPanelSize && this.SensorPanel[i2] != null; ++i2) {
            result = this.GetSensor(this.SensorPanel[i2].SensorNumber, bytey);
            this.SensorPanel[i2].updateValue(bytey[2]);
        }
        this.Message.setText(L.t("Getting PSU PMBus/FRU data"));
        this.helpRefreshPSU();
        this.Message.setText(L.t("sensor.Refreshing_sensors_status_completed"));
        this.priorDone = true;
        this.Session.Loading = -1;
        this.repaint();
    }

    public void helpRefreshPSU() {
        this.PSUPanel.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSensor(int SensorNum, byte[] byteResult) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] SNum = new byte[1];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            SNum[0] = (byte)SensorNum;
            Para.addElement(SNum);
            this.SIP = this.Session.SIP;
            this.Message.setText(L.t("sensor.Getting_status_of_sensor_number_colon") + SensorNum);
            this.rmcpPacket.RMCPSetup((byte)7, (byte)16, (byte)45, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(bytex, 0, byteResult, 0, bytex.length);
                    bResult = true;
                } else {
                    byteResult[0] = -1;
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSDRRecord(byte[] ReserveID, byte[] RecordID, byte[] NextRecordID, byte[] Offset, byte[] byteResult, int[] retlength, byte pByteToRead) {
        byte[] AuthType = new byte[]{2};
        byte[] ByteToRead = new byte[]{8};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        ByteToRead[0] = pByteToRead;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(ReserveID);
            Para.addElement(RecordID);
            Para.addElement(Offset);
            Para.addElement(ByteToRead);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)35, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(bytex, 0, NextRecordID, 0, 2);
                    bytex = (byte[])this.rmcpPacket.retValue.get(1);
                    System.arraycopy(bytex, 0, byteResult, 0, bytex.length);
                    retlength[0] = bytex.length;
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sensor.GetSDRRecord_error"));
                    Logger.writeLog("GetSDRRecord error");
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ReserveSDR(byte[] ReserveID) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)34, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(bytex, 0, ReserveID, 0, 2);
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sensor.ReserveSDR_error"));
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    private boolean GetSDRRecords() {
        byte[] RecordID = new byte[]{0, 0};
        byte[] NextRecordID = new byte[]{0, 0};
        byte[] ReserveID = new byte[]{0, 0};
        byte[] Offset = new byte[]{0};
        byte[] bytex = new byte[128];
        byte[] bytey = new byte[128];
        byte[] bytez = new byte[128];
        int[] lengthx = new int[1];
        int[] lengthz = new int[1];
        int StartE = 0;
        boolean EndE = false;
        int ArrayNum = 9;
        Vector Para = new Vector(1);
        boolean bResult = false;
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        StartE = 0;
        RecordID[0] = (byte)StartE;
        RecordID[1] = (byte)(StartE >> 8);
        if (this.ReserveSDR(ReserveID)) {
            int i2 = StartE;
            do {
                bResult = false;
                Object[] objs = new Object[]{"" + i2};
                this.Message.setText(L.t("sensor.Getting_SDR_Record_colon") + i2);
                Offset[0] = 0;
                if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytex, lengthx, (byte)8)) {
                    SensorRecord sensorR = new SensorRecord();
                    this.Message.setText(L.f("sensor.Get_SDR_Record__succeeded", objs));
                    if (bytex[3] == 1) {
                        int Value;
                        int BExp;
                        int RExp;
                        int B;
                        for (int totallen = bytex[4] - lengthx[0] + 5; totallen > 0; totallen -= lengthz[0]) {
                            Offset[0] = (byte)lengthx[0];
                            byte byteToRead = 0;
                            byteToRead = totallen > 8 ? (byte)8 : (byte)((byte)totallen);
                            if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytez, lengthz, byteToRead)) {
                                System.arraycopy(bytez, 0, bytex, lengthx[0], lengthz[0]);
                                lengthx[0] = lengthx[0] + lengthz[0];
                                continue;
                            }
                            this.Message.setText(L.f("sensor.Get_SDR_Record__failed", objs));
                            Logger.writeLog("Get SDR Record: " + i2 + " failed");
                            break;
                        }
                        sensorR.SensorNumber = bytex[7] & 0xFF;
                        sensorR.SensorType = this.ByteToInt(bytex, 12, 1);
                        this.GetSensor(sensorR.SensorNumber, bytey);
                        int X = this.ByteToInt(bytey, 0, 1);
                        if (sensorR.SensorType == 5 || sensorR.SensorType == 8 || sensorR.SensorType == 192) {
                            sensorR.Reading = bytey[2];
                            if (sensorR.SensorType == 192 && (bytey[1] & 0x20) > 0) {
                                sensorR.Reading = (byte)7;
                            }
                        } else {
                            sensorR.Reading = bytey[0];
                        }
                        ByteArrayOutputStream strout = new ByteArrayOutputStream();
                        int nameLength = lengthx[0] - 48;
                        strout.write(bytex, 48, nameLength);
                        sensorR.SensorName = strout.toString();
                        sensorR.Maximum = bytex[38];
                        sensorR.Minimum = bytex[41];
                        int Linear = bytex[23] & 0x7F;
                        int M2 = (bytex[25] & 0xC0) * 4 + (bytex[24] & 0xFF);
                        if (M2 >= 512) {
                            M2 = -(512 - (M2 & 0x1FF));
                        }
                        if ((B = (bytex[27] & 0xC0) * 4 + (bytex[26] & 0xFF)) >= 512) {
                            B = -(512 - (B & 0x1FF));
                        }
                        if ((RExp = (bytex[29] & 0xF0) >> 4) >= 8) {
                            RExp = -(8 - (RExp & 7));
                        }
                        if ((BExp = bytex[29] & 0xF) >= 8) {
                            BExp = -(8 - (BExp & 7));
                        }
                        if (sensorR.SensorType == 4) {
                            double rawx;
                            if (Linear == 7) {
                                rawx = ((double)(M2 * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(1.0 / rawx);
                                sensorR.valueString = new String(Value + "");
                                rawx = ((double)(M2 * this.ByteToInt(bytex, 38, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(1.0 / rawx);
                                sensorR.MaxString = new String(Value + "");
                                rawx = ((double)(M2 * this.ByteToInt(bytex, 41, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(1.0 / rawx);
                                sensorR.MinString = new String(Value + "");
                            } else if (Linear == 8) {
                                rawx = ((double)(M2 * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(rawx * rawx);
                                sensorR.valueString = new String(Value + "");
                                rawx = ((double)(M2 * this.ByteToInt(bytex, 38, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(rawx * rawx);
                                sensorR.MaxString = new String(Value + "");
                                rawx = ((double)(M2 * this.ByteToInt(bytex, 41, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(rawx * rawx);
                                sensorR.MinString = new String(Value + "");
                            } else {
                                Value = (int)(((double)(M2 * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp));
                                sensorR.valueString = new String(Value + "");
                                Value = (int)(((double)(M2 * this.ByteToInt(bytex, 38, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp));
                                sensorR.MaxString = new String(Value + "");
                                Value = (int)(((double)(M2 * this.ByteToInt(bytex, 41, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp));
                                sensorR.MinString = new String(Value + "");
                            }
                        } else {
                            Value = (int)(((double)(M2 * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                            sensorR.valueString = new String((double)Value / 100.0 + "");
                            Value = (int)(((double)(M2 * this.ByteToInt(bytex, 38, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                            sensorR.MaxString = new String((double)Value / 100.0 + "");
                            Value = (int)(((double)(M2 * this.ByteToInt(bytex, 41, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                            sensorR.MinString = new String((double)Value / 100.0 + "");
                        }
                        sensorR.Linearization = Linear;
                        sensorR.M = M2;
                        sensorR.B = B;
                        sensorR.RExp = RExp;
                        sensorR.BExp = BExp;
                        this.sRecords.addElement(sensorR);
                    }
                    System.arraycopy(NextRecordID, 0, RecordID, 0, 2);
                    bResult = true;
                    continue;
                }
                this.Message.setText(L.f("sensor.Get_SDR_Record__failed", objs));
            } while (bResult && this.ByteToInt(RecordID, 0, 2) != 65535 && ++i2 < this.TotalEntries);
        }
        if (this.ByteToInt(RecordID, 0, 2) == 65535) {
            this.Message.setText(L.t("sensor.Get_SDR_Record_successful"));
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            return bResult;
        }
        this.Message.setText(L.t("sensor.Get_SDR_Record_failed"));
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        return bResult;
    }

    private void initComponents() {
        this.PSUPanel = new JPSUPanel();
        this.PSUFrame = new JInternalFrame();
        this.jDesktopPane1 = new JDesktopPane();
        this.FANFrame = new JInternalFrame();
        this.FANGroup = new JPanel();
        this.VOLFrame = new JInternalFrame();
        this.VOLGroup = new JPanel();
        this.SENSORFrame = new JInternalFrame();
        this.SENSORGroup = new JPanel();
        this.TEMPFrame = new JInternalFrame();
        this.TEMPGroup = new JPanel();
        this.jPanel8 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jRefreshLabel = new JLabel();
        this.jAutoTimer = new JComboBox();
        this.jTimerLabel = new JLabel();
        this.jManuRefresh = new JButton();
        this.jSaveLayout = new JButton();
        this.jHideItem = new JCheckBox();
        this.jHistoryItem = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.jDesktopPane1.setBorder(new EtchedBorder());
        this.FANFrame.setMaximizable(true);
        this.FANFrame.setTitle(L.t("sensor.Fans"));
        this.FANFrame.setIconifiable(true);
        this.FANFrame.setForeground(Color.black);
        this.FANFrame.setResizable(true);
        this.FANFrame.setVisible(true);
        this.FANFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.FANFrameFocusGained(evt);
            }
        });
        this.FANFrame.getContentPane().add((Component)this.FANGroup, "Center");
        this.jDesktopPane1.add((Component)this.FANFrame, JLayeredPane.DEFAULT_LAYER);
        this.FANFrame.setBounds(0, 0, 380, 190);
        this.VOLFrame.setMaximizable(true);
        this.VOLFrame.setTitle(L.t("sensor.Voltages"));
        this.VOLFrame.setIconifiable(true);
        this.VOLFrame.setForeground(Color.black);
        this.VOLFrame.setResizable(true);
        this.VOLFrame.setVisible(true);
        this.VOLFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.VOLFrameFocusGained(evt);
            }
        });
        this.VOLFrame.getContentPane().add((Component)this.VOLGroup, "Center");
        this.jDesktopPane1.add((Component)this.VOLFrame, JLayeredPane.DEFAULT_LAYER);
        this.VOLFrame.setBounds(380, 0, 250, 240);
        this.SENSORFrame.setMaximizable(true);
        this.SENSORFrame.setTitle(L.t("sensor.Sensors"));
        this.SENSORFrame.setIconifiable(true);
        this.SENSORFrame.setResizable(true);
        this.SENSORFrame.setVisible(true);
        this.SENSORFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.SENSORFrameFocusGained(evt);
            }
        });
        this.SENSORFrame.getContentPane().add((Component)this.SENSORGroup, "Center");
        this.jDesktopPane1.add((Component)this.SENSORFrame, JLayeredPane.DEFAULT_LAYER);
        this.SENSORFrame.setBounds(370, 250, 260, 150);
        this.TEMPFrame.setMaximizable(true);
        this.TEMPFrame.setTitle(L.t("sensor.Temperatures"));
        this.TEMPFrame.setIconifiable(true);
        this.TEMPFrame.setResizable(true);
        this.TEMPFrame.setVisible(true);
        this.TEMPFrame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Sensors20.this.TEMPFrameFocusGained(evt);
            }
        });
        this.TEMPFrame.getContentPane().add((Component)this.TEMPGroup, "Center");
        this.jDesktopPane1.add((Component)this.TEMPFrame, JLayeredPane.DEFAULT_LAYER);
        this.TEMPFrame.setBounds(0, 190, 260, 210);
        this.add((Component)this.jDesktopPane1, "Center");
        this.jPanel8.setEnabled(false);
        this.jPanel1.setBorder(new EtchedBorder());
        this.jRefreshLabel.setText(L.t("sensor.Refresh_every"));
        this.jRefreshLabel.setForeground(Color.black);
        this.jRefreshLabel.setEnabled(false);
        this.jPanel1.add(this.jRefreshLabel);
        this.jAutoTimer.setPreferredSize(new Dimension(50, 26));
        this.jAutoTimer.setEnabled(false);
        this.jAutoTimer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Sensors20.this.jAutoTimerItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jAutoTimer);
        this.jTimerLabel.setText(L.t("sensor.seconds"));
        this.jTimerLabel.setForeground(Color.black);
        this.jTimerLabel.setEnabled(false);
        this.jPanel1.add(this.jTimerLabel);
        this.jManuRefresh.setText(L.t("sensor.Refresh_Now"));
        this.jManuRefresh.setEnabled(false);
        this.jManuRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sensors20.this.jManuRefreshActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jManuRefresh);
        this.jPanel8.add(this.jPanel1);
        this.jSaveLayout.setText(L.t("sensor.Save_Layout"));
        this.jSaveLayout.setEnabled(false);
        this.jSaveLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sensors20.this.jSaveLayoutActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jSaveLayout);
        this.jHideItem.setSelected(true);
        this.jHideItem.setText(L.t("sensor.Hide_inactive_item"));
        this.jHideItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Sensors20.this.jHideItemItemStateChanged(evt);
            }
        });
        this.jHistoryItem.setSelected(false);
        this.jHistoryItem.setText(L.t("sensor.Show_History"));
        this.jHistoryItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Sensors20.this.jHistoryItemItemStateChanged(evt);
            }
        });
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(2, 1));
        jPanel9.add(this.jHideItem);
        jPanel9.add(this.jHistoryItem);
        this.jPanel8.add(jPanel9);
        this.add((Component)this.jPanel8, "South");
        this.PSUFrame.getContentPane().add((Component)this.PSUPanel, "Center");
        this.PSUFrame.setBounds(0, 280, 300, 362);
        this.PSUFrame.setMaximizable(true);
        this.PSUFrame.setTitle("PSU");
        this.PSUFrame.setIconifiable(true);
        this.PSUFrame.setForeground(Color.black);
        this.PSUFrame.setResizable(true);
        this.jDesktopPane1.add((Component)this.PSUFrame, JLayeredPane.DEFAULT_LAYER);
    }

    private void SENSORFrameFocusGained(FocusEvent evt) {
        this.SENSORFrame.moveToFront();
    }

    private void TEMPFrameFocusGained(FocusEvent evt) {
        this.TEMPFrame.moveToFront();
    }

    private void VOLFrameFocusGained(FocusEvent evt) {
        this.VOLFrame.moveToFront();
    }

    private void FANFrameFocusGained(FocusEvent evt) {
        this.FANFrame.moveToFront();
    }

    private void jSaveLayoutActionPerformed(ActionEvent evt) {
        String totalstr = this.getLayoutPosition();
        this.Devicefile.SaveLayoutToFile("IPMIView", this.hostname, totalstr);
        this.Message.setText(L.t("sensor.Layout_Configuration_saved"));
    }

    private String getLayoutPosition() {
        String xstr;
        Rectangle FANp = this.FANFrame.getNormalBounds();
        String ystr = this.FANFrame.isMaximum() ? "2" : (this.FANFrame.isIcon() ? "1" : "0");
        String totalstr = xstr = FANp.x + "," + FANp.y + "," + FANp.height + "," + FANp.width + "," + ystr;
        Rectangle VOLp = this.VOLFrame.getNormalBounds();
        ystr = this.VOLFrame.isMaximum() ? "2" : (this.VOLFrame.isIcon() ? "1" : "0");
        xstr = VOLp.x + "," + VOLp.y + "," + VOLp.height + "," + VOLp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        Rectangle TEMPp = this.TEMPFrame.getNormalBounds();
        ystr = this.TEMPFrame.isMaximum() ? "2" : (this.TEMPFrame.isIcon() ? "1" : "0");
        xstr = TEMPp.x + "," + TEMPp.y + "," + TEMPp.height + "," + TEMPp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        Rectangle SNRp = this.SENSORFrame.getNormalBounds();
        ystr = this.SENSORFrame.isMaximum() ? "2" : (this.SENSORFrame.isIcon() ? "1" : "0");
        xstr = SNRp.x + "," + SNRp.y + "," + SNRp.height + "," + SNRp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        Rectangle PSUp = this.PSUFrame.getNormalBounds();
        ystr = this.PSUFrame.isMaximum() ? "2" : (this.PSUFrame.isIcon() ? "1" : "0");
        xstr = PSUp.x + "," + PSUp.y + "," + PSUp.height + "," + PSUp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        return totalstr;
    }

    private void jHideItemItemStateChanged(ItemEvent evt) {
        if (this.jHideItem.isSelected()) {
            int i2;
            for (i2 = 0; i2 < this.TempPanelSize; ++i2) {
                if (this.TempPanel[i2] == null) continue;
                if (this.TempPanel[i2].tempMeter.m_ShowString.compareTo("0.0") == 0 || "N/A".equals(this.TempPanel[i2].tempMeter.m_ShowString)) {
                    this.TempPanel[i2].setVisible(false);
                    continue;
                }
                this.TempPanel[i2].setVisible(true);
            }
            for (i2 = 0; i2 < this.textTempPanelSize && this.textTempPanel[i2] != null; ++i2) {
                if (this.textTempPanel[i2].reading != 7) continue;
                this.textTempPanel[i2].setVisible(false);
            }
            for (i2 = 0; i2 < this.FanPanelSize; ++i2) {
                if (this.FanPanel[i2] == null) continue;
                if (this.FanPanel[i2].fanMeter.m_ShowString.compareTo("N/A") == 0) {
                    this.FanPanel[i2].setVisible(false);
                    continue;
                }
                this.FanPanel[i2].setVisible(true);
            }
            for (i2 = 0; i2 < this.VolPanelSize; ++i2) {
                if (this.VolPanel[i2] == null) continue;
                if (this.VolPanel[i2].volMeter.m_ShowString.compareTo("N/A") == 0) {
                    this.VolPanel[i2].setVisible(false);
                    continue;
                }
                this.VolPanel[i2].setVisible(true);
            }
        } else {
            int i3;
            for (i3 = 0; i3 < this.TempPanelSize; ++i3) {
                if (this.TempPanel[i3] == null || this.TempPanel[i3].isVisible()) continue;
                this.TempPanel[i3].setVisible(true);
            }
            for (i3 = 0; i3 < this.textTempPanelSize; ++i3) {
                if (this.textTempPanel[i3] == null || this.textTempPanel[i3].isVisible()) continue;
                this.textTempPanel[i3].setVisible(true);
            }
            for (i3 = 0; i3 < this.FanPanelSize; ++i3) {
                if (this.FanPanel[i3] == null || this.FanPanel[i3].isVisible()) continue;
                this.FanPanel[i3].setVisible(true);
            }
            for (i3 = 0; i3 < this.VolPanelSize; ++i3) {
                if (this.VolPanel[i3] == null || this.VolPanel[i3].isVisible()) continue;
                this.VolPanel[i3].setVisible(true);
            }
        }
    }

    private void jHistoryItemItemStateChanged(ItemEvent evt) {
        if (this.jHistoryItem.isSelected()) {
            int i2;
            for (i2 = 0; i2 < this.FanPanelSize; ++i2) {
                if (this.FanPanel[i2] == null) continue;
                this.FanPanel[i2].showHistory();
                this.FanPanel[i2].invalidate();
            }
            for (i2 = 0; i2 < this.VolPanelSize; ++i2) {
                if (this.VolPanel[i2] == null) continue;
                this.VolPanel[i2].showHistory();
                this.VolPanel[i2].invalidate();
            }
            for (i2 = 0; i2 < this.TempPanelSize; ++i2) {
                if (this.TempPanel[i2] == null) continue;
                this.TempPanel[i2].showHistory();
                this.TempPanel[i2].invalidate();
            }
            Point p = this.FANFrame.getLocation();
            this.FANFrame.setLocation(p.x + 1, p.y);
            p = this.VOLFrame.getLocation();
            this.VOLFrame.setLocation(p.x + 1, p.y);
            p = this.TEMPFrame.getLocation();
            this.TEMPFrame.setLocation(p.x + 1, p.y);
        } else {
            int i3;
            for (i3 = 0; i3 < this.FanPanelSize; ++i3) {
                if (this.FanPanel[i3] == null) continue;
                this.FanPanel[i3].showMeter();
                this.FanPanel[i3].invalidate();
            }
            for (i3 = 0; i3 < this.VolPanelSize; ++i3) {
                if (this.VolPanel[i3] == null) continue;
                this.VolPanel[i3].showMeter();
                this.VolPanel[i3].invalidate();
            }
            for (i3 = 0; i3 < this.TempPanelSize; ++i3) {
                if (this.TempPanel[i3] == null) continue;
                this.TempPanel[i3].showMeter();
                this.TempPanel[i3].invalidate();
            }
            Point p = this.FANFrame.getLocation();
            this.FANFrame.setLocation(p.x - 1, p.y);
            p = this.VOLFrame.getLocation();
            this.VOLFrame.setLocation(p.x - 1, p.y);
            p = this.TEMPFrame.getLocation();
            this.TEMPFrame.setLocation(p.x - 1, p.y);
        }
        this.validate();
        this.invalidate();
    }

    public void jAutoTimerItemStateChanged(ItemEvent evt) {
        if (this.refreshFlag) {
            String x = (String)this.jAutoTimer.getSelectedItem();
            int xx = Integer.parseInt(x);
            TimerTask t = new TimerTask(){

                @Override
                public void run() {
                    Thread th = new Thread(){

                        @Override
                        public void run() {
                            Sensors20.this.jManuRefresh.setEnabled(false);
                            Sensors20.this.RefreshSensors();
                            Sensors20.this.jManuRefresh.setEnabled(true);
                        }
                    };
                    th.start();
                }
            };
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule(t, xx * 1000, (long)(xx * 1000));
        }
    }

    private void jManuRefreshActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            @Override
            public void run() {
                Cursor csrTemp = new Cursor(3);
                Sensors20.this.setCursor(csrTemp);
                Sensors20.this.jManuRefresh.setEnabled(false);
                Sensors20.this.RefreshSensors();
                Sensors20.this.jManuRefresh.setEnabled(true);
                csrTemp = new Cursor(0);
                Sensors20.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i2 = offset + length - 1; i2 >= offset; --i2) {
            intdes = (intdes << 8) + (bytesrc[i2] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public static void main(String[] argv) {
        System.out.println("\u4e2d\u6587\u6e2c\u8a66 abc test");
    }

    class SensorRecord {
        int SensorNumber;
        int SensorType;
        byte Reading;
        byte Maximum;
        byte Minimum;
        String valueString;
        String MaxString;
        String MinString;
        String SensorName;
        byte UpperLimit;
        byte LowerLimit;
        int Linearization;
        int M;
        int B;
        int RExp;
        int BExp;

        SensorRecord() {
        }
    }
}

