/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.Logger;
import IPMIView20.UOLDebug;
import IPMIView20.UOLImageFile;
import IPMIView20.UOLMessage;
import IPMIView20.UOLMessageFactory;
import IPMIView20.UOLOutputInterface;
import IPMIView20.UOLSession;
import IPMIView20.UOLUDPSocket;
import IPMIView20.uol.UOLStorage;

public class UOL_UFIMessageHandler {
    UOLSession session;
    UOLUDPSocket udpSocket;
    UOLImageFile file;
    UOLOutputInterface output = null;
    byte[] ufi;
    int packetbufferLimit = 64;
    UOLStorage uolStorage;
    int count = 0;
    boolean forceKeepSessionFlag = true;
    boolean keepSessionSendFailed = false;
    byte replySeq = (byte)-1;
    int beginIndex = 0;
    int orgBeginIndex = 0;
    int endIndex = 0;
    byte seq28h = (byte)-1;
    int bulkCommandReadCount = 0;
    int bulkCommandReadSize = 0;
    int bulkDataSegmentCount = 0;
    int count03h = 0;
    UOLMessage sentUOLMessage = null;

    public UOL_UFIMessageHandler(UOLSession session, UOLUDPSocket udpSocket, UOLImageFile file, UOLOutputInterface output, UOLStorage uolStorage) {
        this.session = session;
        this.udpSocket = udpSocket;
        this.file = file;
        this.output = output;
        this.uolStorage = uolStorage;
    }

    public void process(UOLMessage message) {
        this.ufi = new byte[message.dataSizeToInt() - 2];
        System.arraycopy(message.getData(), 2, this.ufi, 0, this.ufi.length);
        switch (this.ufi[0]) {
            case 4: {
                this.UFICommandFormatUnit04h(message);
                break;
            }
            case 18: {
                this.UFICommandInquiry12h(message);
                break;
            }
            case 85: {
                this.UFICommandModeSelect55h(message);
                break;
            }
            case 90: {
                this.UFICommandModeSense5Ah(message);
                break;
            }
            case 30: {
                this.UFICommandPrevntAllowMediumRemoval1Eh(message);
                break;
            }
            case 40: {
                this.UFICommandRead28h(message);
                break;
            }
            case -88: {
                this.UFICommandReadA8h(message);
                break;
            }
            case 37: {
                this.UFICommandReadyCapacity25h(message);
                break;
            }
            case 35: {
                this.UFICommandreadFormatCapacities23h(message);
                break;
            }
            case 3: {
                this.UFICommandRequestSense03h(message);
                break;
            }
            case 1: {
                this.UFICommandRezero01h(message);
                break;
            }
            case 43: {
                this.UFICommandSeek2Bh(message);
                break;
            }
            case 29: {
                this.UFICommandSendDiagnostic1Dh(message);
                break;
            }
            case 27: {
                this.UFICommandStartStopUnit1Bh(message);
                break;
            }
            case 0: {
                this.UFICommandTestUnitReady00h(message);
                break;
            }
            case 47: {
                this.UFICommandVerify2Fh(message);
                break;
            }
            case 42: {
                this.UFICommandWrite2Ah(message);
                break;
            }
            case -86: {
                this.UFICommandWriteAAh(message);
                break;
            }
            case 46: {
                this.UFICommandWriteAndVerify2Eh(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReply(UOLMessage message) {
        if (UOLDebug.debugLevel == 1) {
            Logger.writeLog("B=" + this.beginIndex + ", E=" + this.endIndex);
        }
        if (this.replySeq == message.getPacketSequenceNumber()) {
            Logger.writeLog("repeat seq, don't proess it. just return");
            return;
        }
        this.replySeq = message.getPacketSequenceNumber();
        if (this.beginIndex == this.endIndex) {
            return;
        }
        Logger.writeLog("{Transfer " + this.bulkCommandReadSize + " \u2013 " + ++this.bulkDataSegmentCount + ":}");
        byte[] data = this.file.getContent(this.beginIndex, this.packetbufferLimit);
        this.beginIndex += this.packetbufferLimit;
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            message.setPacketSequenceNumber(this.session.incSequence());
            message.setData(data);
            message.setDataSize(data.length);
            message.setState((byte)34);
            message.setStatus((byte)1);
            this.uolStorage.put(message);
            ++this.count;
        }
        int readbytes = this.beginIndex - this.orgBeginIndex;
        String readByteValue = "";
        if (readbytes > 1000) {
            readByteValue = "" + readbytes;
        }
        if (readbytes < 1000) {
            readByteValue = " " + readbytes;
        }
        if (readbytes < 100) {
            readByteValue = " " + readByteValue;
        }
        if (this.output != null) {
            this.output.outputLog("Get data bytes from " + this.orgBeginIndex + " to " + this.endIndex + " ( " + readByteValue + "/" + (this.endIndex - this.orgBeginIndex) + " bytes) ");
        }
        if (this.count > 120 || this.keepSessionSendFailed) {
            UOLSession uOLSession2 = this.session;
            synchronized (uOLSession2) {
                if (UOLDebug.debugLevel == 1) {
                    Logger.writeLog("Send keep session UOL_UFI(Forced):");
                }
                if (this.keepSessionSendFailed) {
                    Logger.writeLog("This keep session is caused by failed sending in last keep command, Just try to resend");
                }
                UOLMessage keepSessionMessage = UOLMessageFactory.keepSessionMessage(this.session);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    System.out.println("Error in forced keep session");
                }
                this.udpSocket.sendPacket(keepSessionMessage.toByteArray());
                new ResponseChecker(this.session, keepSessionMessage, this).start();
                this.session.setSendKeepSession(true);
                this.count = 1;
                this.keepSessionSendFailed = false;
            }
        }
    }

    public void UFICommandFormatUnit04h(UOLMessage message) {
        this.replyACK(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UFICommandInquiry12h(UOLMessage message) {
        this.replyACK(message);
        byte[] data = new byte[]{0, -128, 0, 1, 31, 0, 0, 0, 79, 83, 65, 32, 85, 79, 76, 32, 86, 105, 114, 116, 117, 97, 108, 32, 70, 108, 111, 112, 112, 121, 32, 32, 48, 46, 48, 49};
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            byte tempSeq = this.session.getPacketSequence();
            if (this.session.getKeepSessionPacketSequence() == -1) {
                this.session.setPacketSequence((byte)0);
                this.session.setKeepSessionPacketSequence(tempSeq);
                message.setPacketSequenceNumber(this.session.incSequence());
            } else {
                message.setPacketSequenceNumber(this.session.incSequence());
            }
            message.setData(data);
            message.setDataSize(data.length);
            message.setState((byte)34);
            message.setStatus((byte)1);
            this.uolStorage.put(message);
        }
    }

    public void UFICommandModeSelect55h(UOLMessage message) {
        this.replyACK(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UFICommandModeSense5Ah(UOLMessage message) {
        this.replyACK(message);
        byte[] data = new byte[]{0, 38, -108, 0, 0, 0, 0, 0, 5, 30, 1, -12, 2, 18, 2, 0, 0, 80};
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            message.setPacketSequenceNumber(this.session.incSequence());
            message.setData(data);
            message.setDataSize(data.length);
            message.setState((byte)34);
            message.setStatus((byte)1);
            this.uolStorage.put(message);
        }
    }

    public void UFICommandPrevntAllowMediumRemoval1Eh(UOLMessage message) {
        this.replyACK(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UFICommandRead28h(UOLMessage message) {
        Logger.writeLog("A 28H command start");
        if (!this.uolStorage.isAllowGet()) {
            Logger.writeLog("Force command occurs here");
        }
        if (this.seq28h == message.getPacketSequenceNumber()) {
            Logger.writeLog("28H command seq repeat. seq =" + UOL_UFIMessageHandler.byteToString(message.getPacketSequenceNumber()) + ". Only ACK it.");
            this.replyACK(message);
            return;
        }
        if (this.beginIndex != this.endIndex) {
            Logger.writeLog("A force command in the middle of 28H command");
        }
        this.seq28h = message.getPacketSequenceNumber();
        this.replyACK(message);
        int lba = (this.ufi[2] & 0xFF) * 0x1000000 + (this.ufi[3] & 0xFF) * 65536 + (this.ufi[4] & 0xFF) * 256 + (this.ufi[5] & 0xFF);
        int length = this.ufi[7] * 256 + this.ufi[8];
        if (UOLDebug.debugLevel > 1) {
            Logger.writeLog("LBA =" + lba);
        }
        if (UOLDebug.debugLevel > 1) {
            Logger.writeLog("Length =" + length);
        }
        this.orgBeginIndex = this.beginIndex = lba * 512;
        this.endIndex = this.beginIndex + length * 512;
        byte[] data = this.file.getContent(this.beginIndex, this.packetbufferLimit);
        this.beginIndex += this.packetbufferLimit;
        ++this.bulkCommandReadCount;
        this.bulkDataSegmentCount = 0;
        this.bulkCommandReadSize = length * 512 / this.packetbufferLimit;
        Logger.writeLog("{Bulk Command Read " + this.bulkCommandReadCount + " (Reads " + this.bulkCommandReadSize + " logical block):}");
        Logger.writeLog("{Transfer " + this.bulkCommandReadSize + " \u2013 " + ++this.bulkDataSegmentCount + ":}");
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            message.setPacketSequenceNumber(this.session.incSequence());
            message.setData(data);
            message.setDataSize(data.length);
            message.setState((byte)34);
            message.setStatus((byte)1);
            this.uolStorage.put(message);
        }
        int readbytes = 64;
        String readByteValue = "";
        if (readbytes > 1000) {
            readByteValue = "" + readbytes;
        }
        if (readbytes < 1000) {
            readByteValue = " " + readbytes;
        }
        if (readbytes < 100) {
            readByteValue = " " + readByteValue;
        }
        if (this.output != null) {
            this.output.outputLog("Get data bytes from " + this.orgBeginIndex + " to " + this.endIndex + " ( " + readByteValue + "/" + (this.endIndex - this.orgBeginIndex) + " bytes) ");
        }
    }

    public void UFICommandReadA8h(UOLMessage message) {
        this.replyACK(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UFICommandReadyCapacity25h(UOLMessage message) {
        this.replyACK(message);
        byte[] data = new byte[]{0, 0, 11, 63, 0, 0, 2, 0};
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            message.setPacketSequenceNumber(this.session.incSequence());
            message.setData(data);
            message.setDataSize(data.length);
            message.setState((byte)34);
            message.setStatus((byte)1);
            this.uolStorage.put(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UFICommandreadFormatCapacities23h(UOLMessage message) {
        this.replyACK(message);
        byte[] data = new byte[]{0, 0, 0, 32, 0, 0, 11, 64, 2, 0, 2, 0};
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            message.setPacketSequenceNumber(this.session.incSequence());
            message.setData(data);
            message.setDataSize(data.length);
            message.setState((byte)34);
            message.setStatus((byte)1);
            this.uolStorage.put(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UFICommandRequestSense03h(UOLMessage message) {
        this.replyACK(message);
        byte[] data = new byte[]{112, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            if (this.count03h == 0) {
                data[12] = 41;
                data[2] = 6;
                if (this.output != null) {
                    this.output.outputLog("Host " + this.udpSocket.address.getHostAddress() + " is booting ...");
                    Thread th = new Thread(){

                        @Override
                        public void run() {
                            UOL_UFIMessageHandler.this.output.booting();
                        }
                    };
                    th.start();
                }
            } else if (this.count03h == 1) {
                data[12] = 40;
                data[2] = 6;
            }
            byte tempSeq = this.session.getPacketSequence();
            if (this.session.getKeepSessionPacketSequence() == -1) {
                this.session.setPacketSequence((byte)0);
                this.session.setKeepSessionPacketSequence(tempSeq);
                message.setPacketSequenceNumber(this.session.incSequence());
            } else {
                message.setPacketSequenceNumber(this.session.incSequence());
            }
            this.beginIndex = 0;
            this.endIndex = 0;
            message.setData(data);
            message.setDataSize(data.length);
            message.setState((byte)34);
            message.setStatus((byte)1);
            Logger.writeLog("0x03 command. queue size =" + this.uolStorage.size() + ",allowGet =" + this.uolStorage.isAllowGet() + ",beginIndex =" + this.beginIndex + ",endIndex =" + this.endIndex);
            if (!this.uolStorage.isAllowGet()) {
                this.session.setPacketSequence(this.uolStorage.getCurrentPacketSequence());
                message.setPacketSequenceNumber(this.uolStorage.getCurrentPacketSequence());
            }
            this.uolStorage.clear();
            this.uolStorage.allowGet();
            this.beginIndex = this.endIndex;
            this.uolStorage.put(message);
        }
        ++this.count03h;
    }

    public void UFICommandRezero01h(UOLMessage message) {
        this.replyACK(message);
    }

    public void UFICommandSeek2Bh(UOLMessage message) {
        this.replyACK(message);
    }

    public void UFICommandSendDiagnostic1Dh(UOLMessage message) {
        this.replyACK(message);
    }

    public void UFICommandStartStopUnit1Bh(UOLMessage message) {
        this.replyACK(message);
    }

    public void UFICommandTestUnitReady00h(UOLMessage message) {
        this.replyACK(message);
    }

    public void UFICommandVerify2Fh(UOLMessage message) {
        this.replyACK(message);
    }

    public void UFICommandWrite2Ah(UOLMessage message) {
        this.replyACK(message);
    }

    public void UFICommandWriteAAh(UOLMessage message) {
        this.replyACK(message);
    }

    public void UFICommandWriteAndVerify2Eh(UOLMessage message) {
        this.replyACK(message);
    }

    public static String byteToString(byte b2) {
        int i2 = b2 & 0xFF;
        String strByte = Integer.toHexString(i2);
        if (strByte.length() == 1) {
            strByte = "0" + strByte;
        }
        if (strByte.length() > 2) {
            strByte = strByte.substring(strByte.length() - 1, strByte.length());
        }
        strByte = strByte.toUpperCase();
        return strByte;
    }

    public void replyACK(UOLMessage message) {
        UOLMessage reply = message.replyACKOnlyMessage();
        reply.setState((byte)((byte)(reply.getState() & 0xF0) | this.session.getState()));
        this.udpSocket.sendPacket(reply.toByteArray());
    }

    public static void main(String[] args) {
        byte[] ufi = new byte[]{0, 0, 1, 11};
        System.out.println((ufi[3] & 0xFF) * 0x1000000);
        System.out.println((ufi[2] & 0xFF) * 65536);
        System.out.println((ufi[1] & 0xFF) * 256);
        System.out.println(ufi[0] & 0xFF);
        int lba = (ufi[3] & 0xFF) * 0x1000000 + (ufi[2] & 0xFF) * 65536 + (ufi[1] & 0xFF) * 256 + (ufi[0] & 0xFF);
        System.out.println(lba);
    }

    public class ResponseChecker
    extends Thread {
        UOLMessage message;
        UOLSession session;
        UOL_UFIMessageHandler ufiHandler;

        public ResponseChecker(UOLSession session, UOLMessage message, UOL_UFIMessageHandler ufiHandler) {
            this.session = session;
            this.message = message;
            this.ufiHandler = ufiHandler;
        }

        @Override
        public void run() {
            boolean count = false;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.session.getKeepSessionPacketSequence() != this.message.getPacketSequenceNumber()) {
                this.ufiHandler.keepSessionSendFailed = true;
            }
        }
    }
}

