/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.blade.SIMBLLANSettingDialogPanel_jDHCPRadioButton_itemAdapter;
import IPMIView20.blade.SIMBLLANSettingDialogPanel_jEnableVLANCheckBox_itemAdapter;
import IPMIView20.blade.SIMBLLANSettingDialogPanel_jReloadLabel_mouseAdapter;
import IPMIView20.blade.SIMBLLANSettingDialogPanel_jStaticIPRadioButton_itemAdapter;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SIMBLLANSettingDialogPanel
extends JPanel {
    IPMIInterfaceConfig config = null;
    int bladeIndex = 0;
    boolean isVLANSupported = false;
    byte lantype = 0;
    String ip = null;
    String subnetMask = null;
    String gateway = null;
    boolean isVLANEnabled = false;
    int vlanTag = 0;
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jReloadLabel = new JLabel();
    JPanel jCenterPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jIPPanel = new JPanel();
    JPanel jVLANPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    JRadioButton jDHCPRadioButton = new JRadioButton();
    JRadioButton jStaticIPRadioButton = new JRadioButton();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JLabel jIPLabel = new JLabel();
    JTextField jIPTextField = new JTextField();
    JCheckBox jEnableVLANCheckBox = new JCheckBox();
    JLabel jVLANTagLabel = new JLabel();
    JTextField jVLANTagTextField = new JTextField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField jSubnetMaskTextField = new JTextField();
    JTextField jGatewayTextField = new JTextField();

    public SIMBLLANSettingDialogPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setIPMIInterfaceConfig(IPMIInterfaceConfig config) {
        this.config = config;
    }

    private void jbInit() throws Exception {
        this.titledBorder2 = new TitledBorder(L.t("cmm.dialog.simblLAN.VLAN_Setting"));
        this.titledBorder1 = new TitledBorder(L.t("cmm.dialog.simblLAN.IP_Setting"));
        this.setLayout(this.borderLayout1);
        this.jReloadLabel.setForeground(Color.blue);
        this.jReloadLabel.setToolTipText("");
        this.jReloadLabel.setHorizontalAlignment(11);
        this.jReloadLabel.setText("<html>" + L.t("cmm.dialog.simblLAN.Reload") + "</html>");
        this.jReloadLabel.addMouseListener(new SIMBLLANSettingDialogPanel_jReloadLabel_mouseAdapter(this));
        this.jCenterPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.jIPPanel.setBorder(this.titledBorder1);
        this.jIPPanel.setLayout(null);
        this.jVLANPanel.setBorder(this.titledBorder2);
        this.jVLANPanel.setLayout(null);
        this.jDHCPRadioButton.setText(L.t("cmm.dialog.simblLAN.DHCP"));
        this.jDHCPRadioButton.setBounds(new Rectangle(10, 23, 67, 23));
        this.jDHCPRadioButton.addItemListener(new SIMBLLANSettingDialogPanel_jDHCPRadioButton_itemAdapter(this));
        this.jStaticIPRadioButton.setText(L.t("cmm.dialog.simblLAN.Static_IP"));
        this.jStaticIPRadioButton.setBounds(new Rectangle(88, 23, 95, 23));
        this.jStaticIPRadioButton.addItemListener(new SIMBLLANSettingDialogPanel_jStaticIPRadioButton_itemAdapter(this));
        this.jIPLabel.setText(L.t("cmm.dialog.simblLAN.IP"));
        this.jIPLabel.setBounds(new Rectangle(14, 53, 35, 15));
        this.jIPTextField.setBounds(new Rectangle(105, 49, 141, 20));
        this.jEnableVLANCheckBox.setText(L.t("cmm.dialog.simblLAN.Enable_VLAN_Tagging"));
        this.jEnableVLANCheckBox.setBounds(new Rectangle(10, 24, 206, 23));
        this.jEnableVLANCheckBox.addItemListener(new SIMBLLANSettingDialogPanel_jEnableVLANCheckBox_itemAdapter(this));
        this.jVLANTagLabel.setText(L.t("cmm.dialog.simblLAN.VLAN_Tag"));
        this.jVLANTagLabel.setBounds(new Rectangle(14, 59, 88, 15));
        this.jVLANTagTextField.setBounds(new Rectangle(108, 59, 138, 20));
        this.setPreferredSize(new Dimension(265, 277));
        this.jLabel1.setText(L.t("cmm.dialog.simblLAN.Subnet_Mask"));
        this.jLabel1.setBounds(new Rectangle(14, 74, 88, 15));
        this.jLabel2.setText(L.t("cmm.dialog.simblLAN.Gateway"));
        this.jLabel2.setBounds(new Rectangle(14, 99, 88, 15));
        this.jSubnetMaskTextField.setBounds(new Rectangle(105, 74, 141, 20));
        this.jGatewayTextField.setBounds(new Rectangle(105, 99, 141, 20));
        this.add((Component)this.jCenterPanel, "Center");
        this.jCenterPanel.add(this.jIPPanel);
        this.jIPPanel.add(this.jDHCPRadioButton);
        this.jIPPanel.add(this.jIPTextField);
        this.jIPPanel.add(this.jIPLabel);
        this.jIPPanel.add(this.jSubnetMaskTextField);
        this.jIPPanel.add(this.jLabel1);
        this.jIPPanel.add(this.jLabel2);
        this.jIPPanel.add(this.jGatewayTextField);
        this.jIPPanel.add(this.jStaticIPRadioButton);
        this.jCenterPanel.add(this.jVLANPanel);
        this.jVLANPanel.add(this.jEnableVLANCheckBox);
        this.jVLANPanel.add(this.jVLANTagLabel);
        this.jVLANPanel.add(this.jVLANTagTextField);
        this.add((Component)this.jReloadLabel, "South");
        this.buttonGroup1.add(this.jDHCPRadioButton);
        this.buttonGroup1.add(this.jStaticIPRadioButton);
    }

    public boolean validateUserInput() {
        if (this.jStaticIPRadioButton.isSelected()) {
            if (!IPMILanCommand.isIPAddress(this.jIPTextField.getText())) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.dialog.simblLAN.IP_format_error"), L.t("cmm.dialog.simblLAN.error"), 0);
                return false;
            }
            if (!IPMILanCommand.isIPAddress(this.jSubnetMaskTextField.getText())) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.dialog.simblLAN.Subnet_Mask_format_error"), L.t("cmm.dialog.simblLAN.error"), 0);
                return false;
            }
            if (!IPMILanCommand.isIPAddress(this.jGatewayTextField.getText())) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.dialog.simblLAN.Gateway_format_error"), L.t("cmm.dialog.simblLAN.error"), 0);
                return false;
            }
        }
        if (this.jEnableVLANCheckBox.isSelected()) {
            int vlanTag = 0;
            try {
                vlanTag = Integer.parseInt(this.jVLANTagTextField.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.dialog.simblLAN.VLAN_Tag_should_be_Integer"), L.t("cmm.dialog.simblLAN.error"), 0);
                return false;
            }
            if (vlanTag > 4094 || vlanTag < 0) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.dialog.simblLAN.VLAN_Tag_Invalid"), L.t("cmm.dialog.simblLAN.error"), 0);
                return false;
            }
        }
        return true;
    }

    public boolean loadData() {
        int timeout = this.config.getTimeout();
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiLanCommand);
        if (sessionController == null) {
            return false;
        }
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmiOEMCommand.setIPMIInterface(ipmb);
        ipmb.setChannel((byte)this.bladeIndex);
        if (sessionController != null) {
            IPMIOEMCommand.NetworkInfo networkInfo = null;
            int retry = 10;
            boolean inLoop = true;
            do {
                try {
                    this.isVLANSupported = ipmiOEMCommand.isVLANCommandSupported();
                    networkInfo = ipmiOEMCommand.getAllNetworkInfo();
                    inLoop = false;
                }
                catch (IPMIException ex) {
                    --retry;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException iex) {}
                }
                catch (ArrayIndexOutOfBoundsException exa) {
                    --retry;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                }
                if (retry != 0) continue;
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.dialog.simblLAN.IPMB_error"), L.t("cmm.dialog.simblLAN.error"), 0);
                sessionController.closeSession();
                return false;
            } while (inLoop);
            this.lantype = networkInfo.ipSource;
            this.ip = networkInfo.ip;
            this.subnetMask = networkInfo.subnet;
            this.gateway = networkInfo.gateway;
            this.isVLANEnabled = networkInfo.isVLANEnabled;
            this.vlanTag = networkInfo.vLanID;
        }
        sessionController.closeSession();
        if (this.lantype == 1) {
            this.jStaticIPRadioButton.setSelected(true);
            this.jIPTextField.setEnabled(true);
            this.jSubnetMaskTextField.setEnabled(true);
            this.jGatewayTextField.setEnabled(true);
        } else {
            this.jDHCPRadioButton.setSelected(true);
            this.jIPTextField.setEnabled(false);
            this.jSubnetMaskTextField.setEnabled(false);
            this.jGatewayTextField.setEnabled(false);
        }
        this.jIPTextField.setText(this.ip);
        this.jSubnetMaskTextField.setText(this.subnetMask);
        this.jGatewayTextField.setText(this.gateway);
        if (this.isVLANSupported) {
            this.jEnableVLANCheckBox.setSelected(this.isVLANEnabled);
            this.jVLANTagTextField.setText("" + this.vlanTag);
            if (this.isVLANEnabled) {
                this.jVLANTagTextField.setEnabled(true);
            } else {
                this.jVLANTagTextField.setEnabled(false);
            }
        } else {
            this.jEnableVLANCheckBox.setEnabled(false);
            this.jVLANTagTextField.setEnabled(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setData() {
        int timeout = this.config.getTimeout();
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiLanCommand);
        if (sessionController == null) {
            return false;
        }
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmiOEMCommand.setIPMIInterface(ipmb);
        ipmb.setChannel((byte)this.bladeIndex);
        if (sessionController != null) {
            try {
                this.setVLANandIPConfigOEM(ipmiOEMCommand);
            }
            catch (IPMIException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("cmm.dialog.simblLAN.IPMB_call_failed"));
                boolean bl = false;
                return bl;
            }
            finally {
                sessionController.closeSession();
            }
        }
        return true;
    }

    private void setVLANandIPConfigOEM(IPMIOEMCommand ipmiOEMCommand) throws IPMIException {
        IPMIOEMCommand.NetworkInfo networkInfo = ipmiOEMCommand.createNetworkInfo();
        networkInfo.ipSource = this.jDHCPRadioButton.isSelected() ? (byte)2 : (byte)1;
        networkInfo.isVLANEnabled = this.jEnableVLANCheckBox.isSelected();
        networkInfo.ip = this.jIPTextField.getText();
        networkInfo.subnet = this.jSubnetMaskTextField.getText();
        networkInfo.gateway = this.jGatewayTextField.getText();
        networkInfo.vLanID = this.jVLANTagTextField.getText().length() != 0 ? Integer.parseInt(this.jVLANTagTextField.getText()) : 0;
        ipmiOEMCommand.setAllNetworkInfo(networkInfo);
    }

    private void setVLANandIPConfig(IPMILanCommand ipmiLanCommand) throws IPMIException, NumberFormatException {
        if (this.isVLANSupported) {
            if (this.jEnableVLANCheckBox.isSelected()) {
                int vlanTag = Integer.parseInt(this.jVLANTagTextField.getText());
                ipmiLanCommand.setVLANEnabled(true, vlanTag);
            } else {
                int vlanTag = Integer.parseInt(this.jVLANTagTextField.getText());
                ipmiLanCommand.setVLANEnabled(false, vlanTag);
            }
        }
        if (this.jDHCPRadioButton.isSelected()) {
            ipmiLanCommand.setLanSettingType((byte)2);
        } else {
            ipmiLanCommand.setLanSettingType((byte)1);
            ipmiLanCommand.setIP(this.jIPTextField.getText());
            ipmiLanCommand.setSubnetMask(this.jSubnetMaskTextField.getText());
            ipmiLanCommand.setGatewayIP(this.jGatewayTextField.getText());
        }
    }

    public void jStaticIPRadioButton_itemStateChanged(ItemEvent e2) {
        this.helpChangeIPTextState();
    }

    public void jDHCPRadioButton_itemStateChanged(ItemEvent e2) {
        this.helpChangeIPTextState();
    }

    private void helpChangeIPTextState() {
        if (this.jStaticIPRadioButton.isSelected()) {
            this.jIPTextField.setEnabled(true);
            this.jSubnetMaskTextField.setEnabled(true);
            this.jGatewayTextField.setEnabled(true);
        }
        if (this.jDHCPRadioButton.isSelected()) {
            this.jIPTextField.setEnabled(false);
            this.jSubnetMaskTextField.setEnabled(false);
            this.jGatewayTextField.setEnabled(false);
        }
    }

    public void jEnableVLANCheckBox_itemStateChanged(ItemEvent e2) {
        if (this.jEnableVLANCheckBox.isSelected()) {
            this.jVLANTagTextField.setEnabled(true);
        } else {
            this.jVLANTagTextField.setEnabled(false);
        }
    }

    public void setBladeIndex(int bladeIndex) {
        this.bladeIndex = bladeIndex;
    }

    public void jReloadLabel_mouseEntered(MouseEvent e2) {
        this.jReloadLabel.setText(this.underLineString(L.t("cmm.dialog.simblLAN.Reload")));
        this.jReloadLabel.setCursor(new Cursor(12));
    }

    public void jReloadLabel_mouseExited(MouseEvent e2) {
        this.jReloadLabel.setText(this.htmlString(L.t("cmm.dialog.simblLAN.Reload")));
        this.jReloadLabel.setCursor(new Cursor(0));
    }

    public void jReloadLabel_mouseClicked(MouseEvent e2) {
        this.setCursor(new Cursor(3));
        this.loadData();
        this.setCursor(new Cursor(0));
    }

    private String htmlString(String string) {
        String s = "<html>" + string + "</html>";
        return s;
    }

    private String underLineString(String string) {
        String s = "<html><u>" + string + "</u></html>";
        return s;
    }
}

