/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.BrowserControl;
import IPMIView20.CMMDebug;
import IPMIView20.CMMSessionPanel;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.blade.JTempPanel;
import IPMIView20.blade.JVolPanel;
import IPMIView20.blade.LabelGigabitSwitch;
import IPMIView20.blade.Single10GigabitSwitchPanel_jCursorHereMenuItem_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jDHCPRadioButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jPopupManagementWindowMenuItem_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jPowerOffButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jPowerOffMenuItem_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jPowerOnButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jPowerOnMenuItem_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jResetButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jResetMenuItem_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jResetToDefaultButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jResetUsernamePasswordButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jSoftResetButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jStaticIPRadioButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jWSSGoButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jWSSIPGetButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jWSSIPSetButton_actionAdapter;
import IPMIView20.blade.Single10GigabitSwitchPanel_jWebManagementMenuItem_actionAdapter;
import IPMIView20.blade.SingleGigabitSwitchResetAccountPanel;
import IPMIView20.blade.SingleModuleAbstractPanel;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.blade.TenGSwitchEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class Single10GigabitSwitchPanel
extends SingleModuleAbstractPanel {
    public static int TEMPERATURE_FULL_SCALE = 100;
    public static int VOLTAGE_3V3_FULL_SCALE = 5;
    public static int VOLTAGE_1V25_FULL_SCALE = 3;
    SingleGigabitSwitchResetAccountPanel resetAccountPanel = new SingleGigabitSwitchResetAccountPanel();
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    Icon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    JTempPanel switchTemperature = new JTempPanel();
    JTempPanel boardTemperature = new JTempPanel();
    JVolPanel p3v3Voltage = new JVolPanel();
    JVolPanel p1v25Voltage = new JVolPanel();
    ButtonGroup ipModeButtonGroup = new ButtonGroup();
    boolean isPowerOffFlag = false;
    boolean isGBV1_5CmdSupported = false;
    JLabel notPresent = new JLabel(L.t("cmm.single.switch.Module_not_present"));
    JPanel jCenterPanel = new JPanel();
    JPanel jLeftPanel = new JPanel();
    JPanel jRightPanel = new JPanel();
    JPanel jVoltagePanel = new JPanel();
    JPanel jTemperaturePanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    JPanel jManagementPanel = new JPanel();
    JPanel jStatusPanel = new JPanel();
    TitledBorder titledBorder3 = new TitledBorder("");
    TitledBorder titledBorder4 = new TitledBorder("");
    GridLayout gridLayout4 = new GridLayout();
    JLabel jLabel1 = new JLabel();
    JLabel j3v3StatusLabel = new JLabel();
    JLabel j3v3StatusStringLabel = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jInitializedLabel = new JLabel();
    JLabel jInitializedStringLabel = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel jErrorLEDLabel = new JLabel();
    JLabel jErrorLEDStringLabel = new JLabel();
    JLabel jPowerStatusTailLabel = new JLabel();
    JLabel jPowerStatusLabel = new JLabel();
    JLabel jPowerStatusStringLabel = new JLabel();
    JPanel jWebManagementPanel = new JPanel();
    JPanel jPowerControlPanel = new JPanel();
    TitledBorder titledBorder5 = new TitledBorder("");
    JButton jResetButton = new JButton();
    JButton jPowerOffButton = new JButton();
    JButton jPowerOnButton = new JButton();
    GridLayout gridLayout6 = new GridLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jBoardTempLabel = new JLabel();
    JLabel jBoardTempStringLabel = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jSwitchTempLabel = new JLabel();
    JLabel jSwitchTempStringLabel = new JLabel();
    JLabel jLabel12 = new JLabel();
    JLabel jLabel14 = new JLabel();
    JLabel j1v25StatusLabel = new JLabel();
    JLabel j1v25StatusStringLabel = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    boolean initSensors = false;
    JPanel jWebWSSIPPanel = new JPanel();
    GridLayout gridLayout5 = new GridLayout();
    JLabel jLabel3 = new JLabel();
    JTextField jWSSIPTextField = new JTextField();
    JPanel jWebButtonPanel = new JPanel();
    GridLayout gridLayout7 = new GridLayout();
    JPanel jPanel4 = new JPanel();
    GridLayout gridLayout8 = new GridLayout();
    JButton jWSSIPSetButton = new JButton();
    JButton jWSSIPGetButton = new JButton();
    JPanel jWebDatatimePanel = new JPanel();
    JPanel jWebGatewayPanel = new JPanel();
    JPanel jWebNetmaskPanel = new JPanel();
    GridLayout gridLayout9 = new GridLayout();
    GridLayout gridLayout10 = new GridLayout();
    GridLayout gridLayout11 = new GridLayout();
    JLabel jLabel2 = new JLabel();
    JTextField jNetmaskTextField = new JTextField();
    JLabel jLabel5 = new JLabel();
    JTextField jGatewayTextField = new JTextField();
    JLabel jLabel6 = new JLabel();
    JTextField jDatetimeTextField = new JTextField();
    JButton jWSSGoButton = new JButton();
    JLabel jLabel13 = new JLabel();
    boolean runHelpGetWSSConfigurationFirst = false;
    JPopupMenu jPopupMenuForLabel = new JPopupMenu();
    JMenuItem jPowerOnMenuItem = new JMenuItem();
    JMenuItem jPowerOffMenuItem = new JMenuItem();
    JMenuItem jResetMenuItem = new JMenuItem();
    JMenuItem jWebManagementMenuItem = new JMenuItem();
    JMenuItem jPopupManagementWindowMenuItem = new JMenuItem();
    JMenuItem jCursorHereMenuItem = new JMenuItem();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    JPopupMenu jPopupMenu1 = new JPopupMenu();
    JPanel jResetUsernamePasswordPanel = new JPanel();
    JButton jResetUsernamePasswordButton = new JButton();
    JLabel jLabel11 = new JLabel();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jSeparatePanel = new JPanel();
    TitledBorder titledBorder6 = new TitledBorder("");
    byte lastFlag = 0;
    BladeSystemEntity bladeSystemEntity = null;
    JButton jSoftResetButton = new JButton();
    JButton jResetToDefaultButton = new JButton();
    JLabel jIPModeLabel = new JLabel();
    JRadioButton jStaticIPRadioButton = new JRadioButton();
    JRadioButton jDHCPRadioButton = new JRadioButton();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout7 = new BorderLayout();

    public Single10GigabitSwitchPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void myInit() {
        this.switchTemperature.tempMeter.setPreferredSize(new Dimension(120, 28));
        this.boardTemperature.tempMeter.setPreferredSize(new Dimension(120, 28));
        this.p3v3Voltage.volMeter.setPreferredSize(new Dimension(98, 58));
        this.p1v25Voltage.volMeter.setPreferredSize(new Dimension(98, 58));
        this.jTemperaturePanel.add(this.switchTemperature);
        this.jTemperaturePanel.add(this.boardTemperature);
        this.jVoltagePanel.add(this.p1v25Voltage);
        this.jVoltagePanel.add(this.p3v3Voltage);
        this.switchTemperature.init(L.t("cmm.single.switch.Swtich_CPU"), (byte)0, (byte)0, "", "");
        this.boardTemperature.init(L.t("cmm.single.switch.Board"), (byte)0, (byte)0, "", "");
        this.p3v3Voltage.init("3.3 V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.p1v25Voltage.init("1.25 V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.jBoardTempLabel.setVisible(false);
        this.jBoardTempStringLabel.setVisible(false);
        this.boardTemperature.setVisible(false);
        if (IPMIView20.acer) {
            this.titledBorder5.setTitle("ACER Switch Configuration");
            this.jLabel3.setText("IP");
        }
        if (IPMIView20.gateway) {
            this.titledBorder5.setTitle("Gateway Switch Configuration");
            this.jLabel3.setText("IP");
        }
    }

    @Override
    public void setUserPrivilege() {
        this.jPowerOnButton.setEnabled(false);
        this.jPowerOffButton.setEnabled(false);
        this.jResetButton.setEnabled(false);
        this.jWebManagementPanel.setVisible(false);
        this.jPowerOnMenuItem.setEnabled(false);
        this.jPowerOffMenuItem.setEnabled(false);
        this.jResetMenuItem.setEnabled(false);
        this.jWebManagementMenuItem.setEnabled(false);
    }

    @Override
    public void setOperatorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
        this.jWebManagementPanel.setVisible(true);
    }

    @Override
    public void setAdministratorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
        this.jWebManagementPanel.setVisible(true);
    }

    public void setPresentUI(boolean isPresent) {
        if (isPresent) {
            if (this.getComponent(0).equals(this.jCenterPanel)) {
                return;
            }
            this.remove(this.notPresent);
            this.add((Component)this.jCenterPanel, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            if (this.getComponent(0).equals(this.notPresent)) {
                return;
            }
            this.remove(this.jCenterPanel);
            this.add((Component)this.notPresent, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void setEnableControls(boolean isEnable) {
        this.jPowerOnButton.setEnabled(isEnable);
        this.jPowerOffButton.setEnabled(isEnable);
        this.jResetButton.setEnabled(isEnable);
        this.jWSSIPSetButton.setEnabled(isEnable);
        this.jWSSIPGetButton.setEnabled(isEnable);
        this.jWSSGoButton.setEnabled(isEnable);
    }

    private void jbInit() throws Exception {
        this.titledBorder5 = new TitledBorder(L.t("cmm.single.switch.WebSuperSmart_Configuration"));
        this.titledBorder4 = new TitledBorder(L.t("cmm.single.switch.Power_Control"));
        this.titledBorder3 = new TitledBorder(L.t("cmm.single.switch.Status"));
        this.titledBorder2 = new TitledBorder(L.t("cmm.single.switch.Voltage"));
        this.titledBorder1 = new TitledBorder(L.t("cmm.single.switch.Temperature"));
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.jRightPanel.setLayout(this.borderLayout3);
        this.jTemperaturePanel.setBorder(this.titledBorder1);
        this.jTemperaturePanel.setLayout(this.flowLayout1);
        this.jVoltagePanel.setBorder(this.titledBorder2);
        this.jLeftPanel.setLayout(this.borderLayout4);
        this.jStatusPanel.setBorder(this.titledBorder3);
        this.jStatusPanel.setLayout(this.gridLayout4);
        this.jManagementPanel.setLayout(this.borderLayout1);
        this.gridLayout4.setColumns(3);
        this.gridLayout4.setRows(6);
        this.jInitializedStringLabel.setForeground(Color.blue);
        this.jInitializedStringLabel.setText(L.t("cmm.single.switch.Initialized"));
        this.jErrorLEDStringLabel.setForeground(Color.blue);
        this.jErrorLEDStringLabel.setText(L.t("cmm.single.switch.Error_LED"));
        this.jPowerStatusStringLabel.setForeground(Color.blue);
        this.jPowerStatusStringLabel.setDisplayedMnemonic('0');
        this.jPowerStatusStringLabel.setText(L.t("cmm.single.switch.Power_Status"));
        this.jManagementPanel.setBorder(null);
        this.jPowerControlPanel.setBorder(this.titledBorder4);
        this.jPowerControlPanel.setLayout(this.gridLayout6);
        this.jWebManagementPanel.setBorder(this.titledBorder5);
        this.jWebManagementPanel.setLayout(this.gridLayout1);
        this.jResetButton.setFont(new Font("Dialog", 1, 12));
        this.jResetButton.setForeground(Color.red);
        this.jResetButton.setMargin(new Insets(0, 14, 0, 14));
        this.jResetButton.setText(L.t("cmm.single.switch.Reset"));
        this.jResetButton.addActionListener(new Single10GigabitSwitchPanel_jResetButton_actionAdapter(this));
        this.jPowerOffButton.setFont(new Font("Dialog", 1, 12));
        this.jPowerOffButton.setForeground(Color.red);
        this.jPowerOffButton.setMargin(new Insets(0, 14, 0, 14));
        this.jPowerOffButton.setText(L.t("cmm.single.switch.Power_Off"));
        this.jPowerOffButton.addActionListener(new Single10GigabitSwitchPanel_jPowerOffButton_actionAdapter(this));
        this.jPowerOnButton.setFont(new Font("Dialog", 0, 12));
        this.jPowerOnButton.setMargin(new Insets(0, 14, 0, 14));
        this.jPowerOnButton.setText(L.t("cmm.single.switch.Power_On"));
        this.jPowerOnButton.addActionListener(new Single10GigabitSwitchPanel_jPowerOnButton_actionAdapter(this));
        this.gridLayout6.setColumns(2);
        this.gridLayout6.setRows(3);
        this.jSwitchTempStringLabel.setForeground(Color.blue);
        this.jSwitchTempStringLabel.setText(L.t("cmm.single.switch.Switch_Temp"));
        this.jBoardTempStringLabel.setForeground(Color.blue);
        this.jBoardTempStringLabel.setText(L.t("cmm.single.switch.Board_Temp"));
        this.j3v3StatusStringLabel.setForeground(Color.blue);
        this.j3v3StatusStringLabel.setText("3.3V Status:");
        this.j1v25StatusStringLabel.setForeground(Color.blue);
        this.j1v25StatusStringLabel.setText(L.t("cmm.single.switch.1.25V_Status"));
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(7);
        this.gridLayout1.setVgap(1);
        this.jWebWSSIPPanel.setLayout(this.gridLayout5);
        this.jLabel3.setText(L.t("cmm.single.switch.WSS_IP"));
        this.jWebButtonPanel.setLayout(this.gridLayout7);
        this.gridLayout7.setColumns(2);
        this.jPanel4.setLayout(this.gridLayout8);
        this.gridLayout8.setColumns(4);
        this.gridLayout8.setHgap(1);
        this.gridLayout8.setRows(0);
        this.jWSSIPSetButton.setText(L.t("cmm.single.switch.Update"));
        this.jWSSIPSetButton.addActionListener(new Single10GigabitSwitchPanel_jWSSIPSetButton_actionAdapter(this));
        this.jWSSIPGetButton.setText("Refresh");
        this.jWSSIPGetButton.addActionListener(new Single10GigabitSwitchPanel_jWSSIPGetButton_actionAdapter(this));
        this.jWebNetmaskPanel.setLayout(this.gridLayout9);
        this.jWebGatewayPanel.setLayout(this.gridLayout10);
        this.jWebDatatimePanel.setLayout(this.gridLayout11);
        this.gridLayout9.setColumns(2);
        this.gridLayout10.setColumns(2);
        this.gridLayout11.setColumns(2);
        this.jLabel2.setText(L.t("cmm.single.switch.Netmask"));
        this.jLabel5.setText(L.t("cmm.single.switch.Gateway"));
        this.jLabel6.setText(L.t("cmm.single.switch.Datetime"));
        this.jWSSGoButton.setText("Open Web");
        this.jWSSGoButton.addActionListener(new Single10GigabitSwitchPanel_jWSSGoButton_actionAdapter(this));
        this.jPowerOnMenuItem.setText(L.t("cmm.single.switch.Power_On"));
        this.jPowerOnMenuItem.addActionListener(new Single10GigabitSwitchPanel_jPowerOnMenuItem_actionAdapter(this));
        this.jPowerOffMenuItem.setText(L.t("cmm.single.switch.Power_Off"));
        this.jPowerOffMenuItem.addActionListener(new Single10GigabitSwitchPanel_jPowerOffMenuItem_actionAdapter(this));
        this.jResetMenuItem.setText(L.t("cmm.single.switch.Reset"));
        this.jResetMenuItem.addActionListener(new Single10GigabitSwitchPanel_jResetMenuItem_actionAdapter(this));
        this.jWebManagementMenuItem.setText(L.t("cmm.single.switch.Web_Management"));
        this.jWebManagementMenuItem.addActionListener(new Single10GigabitSwitchPanel_jWebManagementMenuItem_actionAdapter(this));
        this.jPopupManagementWindowMenuItem.setText(L.t("cmm.single.switch.Popup_Management_Window"));
        this.jPopupManagementWindowMenuItem.addActionListener(new Single10GigabitSwitchPanel_jPopupManagementWindowMenuItem_actionAdapter(this));
        this.jCursorHereMenuItem.setText(L.t("cmm.single.switch.Focus_Here"));
        this.jCursorHereMenuItem.addActionListener(new Single10GigabitSwitchPanel_jCursorHereMenuItem_actionAdapter(this));
        this.jResetUsernamePasswordButton.setText(L.t("cmm.single.switch.Reset") + "...");
        this.jResetUsernamePasswordButton.addActionListener(new Single10GigabitSwitchPanel_jResetUsernamePasswordButton_actionAdapter(this));
        this.jResetUsernamePasswordPanel.setLayout(this.borderLayout5);
        this.jLabel11.setFont(new Font("Dialog", 1, 12));
        this.jLabel11.setText(L.t("cmm.single.switch.Username_and_Password"));
        this.jSeparatePanel.setBorder(null);
        this.jSeparatePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 1));
        this.jSeparatePanel.setMinimumSize(new Dimension(12, 1));
        this.jSeparatePanel.setLayout(this.borderLayout6);
        this.jSoftResetButton.setFont(new Font("Dialog", 1, 12));
        this.jSoftResetButton.setForeground(Color.red);
        this.jSoftResetButton.setMargin(new Insets(0, 14, 0, 14));
        this.jSoftResetButton.setText("Soft Reset");
        this.jSoftResetButton.addActionListener(new Single10GigabitSwitchPanel_jSoftResetButton_actionAdapter(this));
        this.jResetToDefaultButton.setFont(new Font("Dialog", 1, 12));
        this.jResetToDefaultButton.setForeground(Color.red);
        this.jResetToDefaultButton.setMargin(new Insets(0, 14, 0, 14));
        this.jResetToDefaultButton.setText("Reset Default");
        this.jResetToDefaultButton.addActionListener(new Single10GigabitSwitchPanel_jResetToDefaultButton_actionAdapter(this));
        this.jIPModeLabel.setText("IP Mode:");
        this.jStaticIPRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.jStaticIPRadioButton.setText("Static IP");
        this.jStaticIPRadioButton.addActionListener(new Single10GigabitSwitchPanel_jStaticIPRadioButton_actionAdapter(this));
        this.jDHCPRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.jDHCPRadioButton.setText("DHCP");
        this.jDHCPRadioButton.addActionListener(new Single10GigabitSwitchPanel_jDHCPRadioButton_actionAdapter(this));
        this.ipModeButtonGroup.add(this.jStaticIPRadioButton);
        this.ipModeButtonGroup.add(this.jDHCPRadioButton);
        this.jPanel1.setLayout(this.borderLayout7);
        this.add((Component)this.jCenterPanel, "Center");
        this.jStatusPanel.add(this.jPowerStatusStringLabel);
        this.jStatusPanel.add(this.jPowerStatusLabel);
        this.jStatusPanel.add(this.jPowerStatusTailLabel);
        this.jStatusPanel.add(this.jErrorLEDStringLabel);
        this.jStatusPanel.add(this.jErrorLEDLabel);
        this.jStatusPanel.add(this.jLabel7);
        this.jStatusPanel.add(this.jInitializedStringLabel);
        this.jStatusPanel.add(this.jInitializedLabel);
        this.jStatusPanel.add(this.jLabel12);
        this.jStatusPanel.add(this.jSwitchTempStringLabel);
        this.jStatusPanel.add(this.jSwitchTempLabel);
        this.jStatusPanel.add(this.jLabel8);
        this.jStatusPanel.add(this.j3v3StatusStringLabel);
        this.jStatusPanel.add(this.j3v3StatusLabel);
        this.jStatusPanel.add(this.jLabel1);
        this.jStatusPanel.add(this.j1v25StatusStringLabel);
        this.jStatusPanel.add(this.j1v25StatusLabel);
        this.jStatusPanel.add(this.jLabel14);
        this.jPowerControlPanel.add(this.jPowerOnButton);
        this.jPowerControlPanel.add(this.jPowerOffButton);
        this.jPowerControlPanel.add(this.jResetButton);
        this.jPowerControlPanel.add(this.jSoftResetButton);
        this.jPowerControlPanel.add(this.jResetToDefaultButton);
        this.jWebManagementPanel.add(this.jResetUsernamePasswordPanel);
        this.jWebManagementPanel.add(this.jSeparatePanel);
        this.jWebManagementPanel.add(this.jWebWSSIPPanel);
        this.jWebManagementPanel.add(this.jWebNetmaskPanel);
        this.jWebManagementPanel.add(this.jWebGatewayPanel);
        this.jWebManagementPanel.add(this.jWebDatatimePanel);
        this.jWebManagementPanel.add(this.jWebButtonPanel);
        this.jWebNetmaskPanel.add(this.jLabel2);
        this.jWebNetmaskPanel.add(this.jNetmaskTextField);
        this.jWebGatewayPanel.add(this.jLabel5);
        this.jWebGatewayPanel.add(this.jGatewayTextField);
        this.jWebDatatimePanel.add(this.jLabel6);
        this.jWebDatatimePanel.add(this.jDatetimeTextField);
        this.jWebButtonPanel.add(this.jPanel4);
        this.jPanel4.add(this.jLabel13);
        this.jPanel4.add(this.jWSSIPGetButton);
        this.jPanel4.add(this.jWSSIPSetButton);
        this.jPanel4.add(this.jWSSGoButton);
        this.jWebWSSIPPanel.add(this.jLabel3);
        this.jWebWSSIPPanel.add(this.jWSSIPTextField);
        this.jCenterPanel.add((Component)this.jRightPanel, "Center");
        this.jCenterPanel.add((Component)this.jLeftPanel, "West");
        this.jPopupMenuForLabel.add(this.jPowerOnMenuItem);
        this.jPopupMenuForLabel.add(this.jPowerOffMenuItem);
        this.jPopupMenuForLabel.add(this.jResetMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jWebManagementMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jPopupManagementWindowMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jCursorHereMenuItem);
        this.jLeftPanel.add((Component)this.jStatusPanel, "North");
        this.jLeftPanel.add((Component)this.jManagementPanel, "Center");
        this.jRightPanel.add((Component)this.jWebManagementPanel, "Center");
        this.jRightPanel.add((Component)this.jVoltagePanel, "South");
        this.jManagementPanel.add((Component)this.jPowerControlPanel, "North");
        this.jManagementPanel.add((Component)this.jTemperaturePanel, "Center");
        this.jResetUsernamePasswordPanel.add((Component)this.jLabel11, "West");
        this.jResetUsernamePasswordPanel.add((Component)this.jResetUsernamePasswordButton, "East");
        this.jSeparatePanel.add((Component)this.jIPModeLabel, "West");
        this.jSeparatePanel.add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jDHCPRadioButton, "West");
        this.jPanel1.add((Component)this.jStaticIPRadioButton, "Center");
    }

    @Override
    public void preset(CMMSessionPanel cmmSessionPanel, JLabel xMessage) {
        super.preset(cmmSessionPanel, xMessage);
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[Single10GigabitSwitchPanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Single10GigabitSwitchPanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        TenGSwitchEntity tenGSwitchEntity = this.bladeSystemEntity.getTenGSwitches()[this.moduleIndex - 1];
        if (tenGSwitchEntity.getPresent() == 0) {
            this.runHelpGetWSSConfigurationFirst = false;
            this.setPresentUI(false);
            return;
        }
        this.setPresentUI(true);
        this.lastFlag = tenGSwitchEntity.getFlag();
        if (tenGSwitchEntity.is10GSwitch() && tenGSwitchEntity.getPresent() == 1 && tenGSwitchEntity.isPowerOnCheckedByVoltage() && tenGSwitchEntity.isInitOK() && this.bladeSystemEntity.getIsMaster() && !this.runHelpGetWSSConfigurationFirst) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Single10GigabitSwitchPanel.this.helpGetWSSConfiguration();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        }
        if (tenGSwitchEntity.isPowerOnCheckedByVoltage()) {
            this.jPowerStatusLabel.setIcon(this.powerOnIcon);
            this.jPowerStatusLabel.setText(L.t("cmm.single.switch.On"));
            if (this.isPowerOffFlag) {
                this.helpShowUIForPowerOn();
            }
        } else {
            this.jPowerStatusLabel.setIcon(this.powerOffIcon);
            this.jPowerStatusLabel.setText(L.t("cmm.single.switch.Off"));
            if (!this.isPowerOffFlag) {
                this.runHelpGetWSSConfigurationFirst = false;
                this.helpHideUIForPowerOff();
            }
        }
        if (tenGSwitchEntity.isError()) {
            this.jErrorLEDLabel.setIcon(this.xRedIcon);
            this.jErrorLEDLabel.setForeground(Color.RED);
            this.jErrorLEDLabel.setText(L.t("cmm.single.switch.Error"));
        } else {
            this.jErrorLEDLabel.setIcon(this.okGreenIcon);
            this.jErrorLEDLabel.setForeground(Color.GREEN);
            this.jErrorLEDLabel.setText(L.t("cmm.single.switch.Normal"));
        }
        if (tenGSwitchEntity.isInitOK() && tenGSwitchEntity.isPowerOnCheckedByVoltage() && tenGSwitchEntity.getPresent() > 0) {
            this.jInitializedLabel.setIcon(this.okGreenIcon);
            this.jInitializedLabel.setForeground(Color.GREEN);
            this.jInitializedLabel.setText(L.t("cmm.single.switch.OK"));
            this.jWSSIPGetButton.setEnabled(true);
            this.jWSSIPSetButton.setEnabled(true);
            this.jWSSGoButton.setEnabled(true);
            this.jResetUsernamePasswordButton.setEnabled(true);
            this.jDatetimeTextField.setEnabled(true);
            if (this.isGBV1_5CmdSupported) {
                this.jStaticIPRadioButton.setEnabled(true);
                this.jDHCPRadioButton.setEnabled(true);
            }
            if (!this.isGBV1_5CmdSupported || !this.jDHCPRadioButton.isSelected()) {
                this.jWSSIPTextField.setEnabled(true);
                this.jGatewayTextField.setEnabled(true);
                this.jNetmaskTextField.setEnabled(true);
            }
        } else {
            this.jInitializedLabel.setIcon(this.xRedIcon);
            this.jInitializedLabel.setForeground(Color.RED);
            this.jInitializedLabel.setText(L.t("cmm.single.switch.Not_Ready"));
            this.jWSSIPGetButton.setEnabled(false);
            this.jWSSIPSetButton.setEnabled(false);
            this.jWSSGoButton.setEnabled(false);
            this.jResetUsernamePasswordButton.setEnabled(false);
            this.jWSSIPTextField.setEnabled(false);
            this.jGatewayTextField.setEnabled(false);
            this.jNetmaskTextField.setEnabled(false);
            this.jDatetimeTextField.setEnabled(false);
            if (this.isGBV1_5CmdSupported) {
                this.jStaticIPRadioButton.setEnabled(false);
                this.jDHCPRadioButton.setEnabled(false);
            }
            this.runHelpGetWSSConfigurationFirst = false;
        }
        if (tenGSwitchEntity.getSwitchTemperature() < 80) {
            this.jSwitchTempLabel.setIcon(this.okGreenIcon);
            this.jSwitchTempLabel.setForeground(Color.GREEN);
            this.jSwitchTempLabel.setText(L.t("cmm.single.switch.Normal"));
        } else {
            this.jSwitchTempLabel.setIcon(this.xRedIcon);
            this.jSwitchTempLabel.setForeground(Color.RED);
            this.jSwitchTempLabel.setText(L.t("cmm.single.switch.Error"));
        }
        if (tenGSwitchEntity.getBoardTemperature() < 80) {
            this.jBoardTempLabel.setIcon(this.okGreenIcon);
            this.jBoardTempLabel.setForeground(Color.GREEN);
            this.jBoardTempLabel.setText(L.t("cmm.single.switch.Normal"));
        } else {
            this.jBoardTempLabel.setIcon(this.xRedIcon);
            this.jBoardTempLabel.setForeground(Color.RED);
            this.jBoardTempLabel.setText(L.t("cmm.single.switch.Error"));
        }
        byte switchTemp = tenGSwitchEntity.getSwitchTemperature();
        byte switchTempLimit = 80;
        byte boardTemp = tenGSwitchEntity.getBoardTemperature();
        byte boardTempLimit = 80;
        double p3v3 = tenGSwitchEntity.p3v3Formula();
        double p3v3LowLimit = 2.97;
        double p3v3HighLimit = 3.63;
        byte p3v3Ratio = (byte)(p3v3 * 256.0 / (double)VOLTAGE_3V3_FULL_SCALE);
        byte p3v3LowLimitRatio = (byte)(p3v3LowLimit * 256.0 / (double)VOLTAGE_3V3_FULL_SCALE);
        byte p3v3HighLimitRatio = (byte)(p3v3HighLimit * 256.0 / (double)VOLTAGE_3V3_FULL_SCALE);
        String p3v3String = this.doubleToString(p3v3);
        String p3v3LowLimitString = "" + p3v3LowLimit;
        String p3v3HighLimitString = "" + p3v3HighLimit;
        double p1v25 = tenGSwitchEntity.p1v25Formula();
        double p1v25LowLimit = 1.025;
        double p1v25HighLimit = 1.375;
        byte p1v25Ratio = (byte)(p1v25 * 256.0 / (double)VOLTAGE_1V25_FULL_SCALE);
        byte p1v25LowLimitRatio = (byte)(p1v25LowLimit * 256.0 / (double)VOLTAGE_1V25_FULL_SCALE);
        byte p1v25HighLimitRatio = (byte)(p1v25HighLimit * 256.0 / (double)VOLTAGE_1V25_FULL_SCALE);
        String p1v25String = this.doubleToString4(p1v25);
        String p1v25LowLimitString = "" + p1v25LowLimit;
        String p1v25HighLimitString = "" + p1v25HighLimit;
        if (!this.initSensors) {
            this.switchTemperature.init(L.t("cmm.single.switch.Switch") + " ", switchTemp, switchTempLimit, "" + switchTemp, "" + switchTempLimit);
            this.boardTemperature.init(L.t("cmm.single.switch.Board") + " ", boardTemp, boardTempLimit, "" + boardTemp, "" + boardTempLimit);
            this.p3v3Voltage.init("3.3 V", p3v3Ratio, p3v3HighLimitRatio, p3v3LowLimitRatio, p3v3String, p3v3HighLimitString, p3v3LowLimitString);
            this.p1v25Voltage.init("1.25 V", p1v25Ratio, p1v25HighLimitRatio, p1v25LowLimitRatio, p1v25String, p1v25HighLimitString, p1v25LowLimitString);
            this.initSensors = true;
        }
        if (p3v3 < p3v3LowLimit || p3v3 > p3v3HighLimit) {
            this.j3v3StatusLabel.setIcon(this.xRedIcon);
            this.j3v3StatusLabel.setForeground(Color.RED);
            this.j3v3StatusLabel.setText(L.t("cmm.single.switch.Abnormal"));
        } else {
            this.j3v3StatusLabel.setIcon(this.okGreenIcon);
            this.j3v3StatusLabel.setForeground(Color.GREEN);
            this.j3v3StatusLabel.setText(L.t("cmm.single.switch.Normal"));
        }
        if (p1v25 < p1v25LowLimit || p1v25 > p1v25HighLimit) {
            this.j1v25StatusLabel.setIcon(this.xRedIcon);
            this.j1v25StatusLabel.setForeground(Color.RED);
            this.j1v25StatusLabel.setText(L.t("cmm.single.switch.Abnormal"));
        } else {
            this.j1v25StatusLabel.setIcon(this.okGreenIcon);
            this.j1v25StatusLabel.setForeground(Color.GREEN);
            this.j1v25StatusLabel.setText(L.t("cmm.single.switch.Normal"));
        }
        if (tenGSwitchEntity.isPowerOnCheckedByVoltage()) {
            this.switchTemperature.updateValue(switchTemp, "" + switchTemp);
            this.boardTemperature.updateValue(boardTemp, "" + boardTemp);
            this.p3v3Voltage.updateValue(p3v3Ratio, p3v3String);
            this.p1v25Voltage.updateValue(p1v25Ratio, p1v25String);
        }
        if (this.isGBV1_5CmdSupported) {
            this.setGBV1_5UIVisible(true);
        } else {
            this.setGBV1_5UIVisible(false);
        }
    }

    public void helpHideUIForPowerOff() {
        this.jErrorLEDLabel.setVisible(false);
        this.jInitializedLabel.setVisible(false);
        this.jSwitchTempLabel.setVisible(false);
        this.j3v3StatusLabel.setVisible(false);
        this.j1v25StatusLabel.setVisible(false);
        this.jWSSIPTextField.setEnabled(false);
        this.jNetmaskTextField.setEnabled(false);
        this.jGatewayTextField.setEnabled(false);
        this.jDatetimeTextField.setEnabled(false);
        this.jWSSIPGetButton.setEnabled(false);
        this.jWSSIPSetButton.setEnabled(false);
        this.jWSSGoButton.setEnabled(false);
        this.jResetUsernamePasswordButton.setEnabled(false);
        this.jDHCPRadioButton.setEnabled(false);
        this.jStaticIPRadioButton.setEnabled(false);
        this.switchTemperature.setNA();
        this.p3v3Voltage.setNA();
        this.p1v25Voltage.setNA();
        this.isPowerOffFlag = true;
    }

    public void helpShowUIForPowerOn() {
        this.jErrorLEDLabel.setVisible(true);
        this.jInitializedLabel.setVisible(true);
        this.jSwitchTempLabel.setVisible(true);
        this.j3v3StatusLabel.setVisible(true);
        this.j1v25StatusLabel.setVisible(true);
        if (this.isGBV1_5CmdSupported) {
            this.jDHCPRadioButton.setEnabled(true);
            this.jStaticIPRadioButton.setEnabled(true);
            if (!this.jDHCPRadioButton.isSelected()) {
                this.jWSSIPTextField.setEnabled(true);
                this.jGatewayTextField.setEnabled(true);
                this.jNetmaskTextField.setEnabled(true);
            }
        }
        this.jDatetimeTextField.setEnabled(true);
        this.jWSSIPGetButton.setEnabled(true);
        this.jWSSIPSetButton.setEnabled(true);
        this.jWSSGoButton.setEnabled(true);
        this.jResetUsernamePasswordButton.setEnabled(true);
        this.isPowerOffFlag = false;
    }

    public String doubleToString(double value) {
        int temp = (int)(value * 100.0);
        double d2 = (double)temp / 100.0;
        return "" + d2;
    }

    public String doubleToString4(double value) {
        int temp = (int)(value * 10000.0);
        double d2 = (double)temp / 10000.0;
        return "" + d2;
    }

    public void jPowerOnButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(Single10GigabitSwitchPanel.this.findParentFrame(), L.t("cmm.single.switch.Are_you_sure_power_on"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                Single10GigabitSwitchPanel.this.powerOn();
            }
        };
        thread.start();
    }

    private void powerOn() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b2 = false;
            try {
                b2 = ipmiCMMOEMCommand.enableGigabitSwitchPower((byte)(this.moduleIndex + 2), (byte)1);
                if (!b2) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Power_on_failed"));
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jPowerOffButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(Single10GigabitSwitchPanel.this.findParentFrame(), L.t("cmm.single.switch.Are_you_sure_power_off"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                Single10GigabitSwitchPanel.this.powerOff();
            }
        };
        thread.start();
    }

    private void powerOff() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b2 = false;
            try {
                b2 = ipmiCMMOEMCommand.enableGigabitSwitchPower((byte)(this.moduleIndex + 2), (byte)0);
                if (!b2) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Power_off_failed"));
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jResetButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(Single10GigabitSwitchPanel.this.findParentFrame(), L.t("cmm.single.switch.Are_you_sure_reset"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                Single10GigabitSwitchPanel.this.reset();
            }
        };
        thread.start();
    }

    private void reset() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b2 = false;
            try {
                b2 = ipmiCMMOEMCommand.resetGigabitSwitch((byte)(this.moduleIndex + 2));
                if (!b2) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Reset_failed"));
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jSoftResetButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(Single10GigabitSwitchPanel.this.findParentFrame(), "Are you sure soft reset ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                Single10GigabitSwitchPanel.this.softReset();
            }
        };
        thread.start();
    }

    private void softReset() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b2 = false;
            try {
                b2 = ipmiCMMOEMCommand.setGBRestart((byte)(this.moduleIndex + 2));
                if (!b2) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Soft reset failed. Command is not supported");
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jResetToDefaultButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(Single10GigabitSwitchPanel.this.findParentFrame(), "Are you sure reset to default ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                Single10GigabitSwitchPanel.this.resetToDefault();
            }
        };
        thread.start();
    }

    private void resetToDefault() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b2 = false;
            try {
                b2 = ipmiCMMOEMCommand.setGBResetToDefault((byte)(this.moduleIndex + 2));
                if (!b2) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Reset to default failed. Command is not supported");
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public Object clone() {
        Single10GigabitSwitchPanel singleGigabitSwitchPanel = new Single10GigabitSwitchPanel();
        singleGigabitSwitchPanel.moduleIndex = this.moduleIndex;
        return singleGigabitSwitchPanel;
    }

    public void jWSSIPGetButton_actionPerformed(ActionEvent e2) {
        this.helpGetWSSConfiguration();
    }

    private void helpGetWSSConfiguration() {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            try {
                String ip = ipmiCMMOEMCommand.getGBIP((byte)(this.moduleIndex + 2));
                this.jWSSIPTextField.setText(ip);
            }
            catch (IPMIException ex) {
                this.xMessage.setText(ex.getMessage());
            }
            try {
                String gateway = ipmiCMMOEMCommand.getGBGateway((byte)(this.moduleIndex + 2));
                this.jGatewayTextField.setText(gateway);
            }
            catch (IPMIException ex1) {
                this.xMessage.setText(ex1.getMessage());
            }
            try {
                String netMask = ipmiCMMOEMCommand.getGBNetMask((byte)(this.moduleIndex + 2));
                this.jNetmaskTextField.setText(netMask);
            }
            catch (IPMIException ex2) {
                this.xMessage.setText(ex2.getMessage());
            }
            try {
                Calendar c2 = ipmiCMMOEMCommand.getGBTime((byte)(this.moduleIndex + 2));
                SimpleDateFormat f2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                String dateStr = f2.format(c2.getTime());
                this.jDatetimeTextField.setText(dateStr);
            }
            catch (IPMIException ex5) {
                // empty catch block
            }
            try {
                byte b2 = ipmiCMMOEMCommand.getGBIPMode((byte)(this.moduleIndex + 2));
                if (b2 == 1) {
                    this.jDHCPRadioButton.setSelected(false);
                    this.jStaticIPRadioButton.setSelected(true);
                    this.jStaticIPRadioButton_actionPerformed(null);
                } else if (b2 == 2) {
                    this.jDHCPRadioButton.setSelected(true);
                    this.jStaticIPRadioButton.setSelected(false);
                    this.jDHCPRadioButton_actionPerformed(null);
                } else {
                    throw new IPMIException("");
                }
                this.isGBV1_5CmdSupported = true;
                this.setGBV1_5UIVisible(true);
            }
            catch (IPMIException ex5) {
                this.isGBV1_5CmdSupported = false;
                this.jDHCPRadioButton.setSelected(false);
                this.jStaticIPRadioButton.setSelected(false);
                this.setGBV1_5UIVisible(false);
            }
        }
        sessionController.closeSession();
        this.runHelpGetWSSConfigurationFirst = true;
    }

    private void setGBV1_5UIVisible(boolean isEnabled) {
        this.jDHCPRadioButton.setVisible(isEnabled);
        this.jStaticIPRadioButton.setVisible(isEnabled);
        this.jIPModeLabel.setVisible(isEnabled);
        this.jSoftResetButton.setVisible(isEnabled);
        this.jResetToDefaultButton.setVisible(isEnabled);
    }

    public void jWSSIPSetButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(Single10GigabitSwitchPanel.this.findParentFrame(), L.t("cmm.single.switch.Are_you_sure_update") + " Please make sure date time is correct", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                Single10GigabitSwitchPanel.this.helpSetWSSConfiguration();
            }
        };
        thread.start();
    }

    private void helpSetWSSConfiguration() {
        String ip = this.jWSSIPTextField.getText();
        String gateway = this.jGatewayTextField.getText();
        String netmask = this.jNetmaskTextField.getText();
        String time = this.jDatetimeTextField.getText();
        if (!this.jDHCPRadioButton.isSelected()) {
            if (!IPMILanCommand.isIPAddress(ip)) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.IP_format_error"));
                return;
            }
            if (!IPMILanCommand.isIPAddress(gateway)) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Gateway_format_error"));
                return;
            }
            if (!IPMILanCommand.isIPAddress(netmask)) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Netmask_format_error"));
                return;
            }
            if (ip.equals("0.0.0.0")) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.IP_cannot_be_0"));
                return;
            }
            if (gateway.equals("0.0.0.0")) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Gateway_cannot_be_0"));
                return;
            }
            if (netmask.equals("0.0.0.0")) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Netmask_cannot_be_0"));
                return;
            }
            if (time.length() == 0) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Time_cannot_empty"));
                return;
            }
            int intValue = ByteUtility.ipToInt(netmask);
            if (((0 - intValue & intValue) - 1 | intValue) != -1) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Wrong_netmask"));
                return;
            }
            int _ip = ByteUtility.ipToInt(ip);
            int _gw = ByteUtility.ipToInt(gateway);
            int _nm = ByteUtility.ipToInt(netmask);
            if ((_ip & _nm) != (_gw & _nm)) {
                JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.IP_and_Gateway_not_same_subnet"));
                return;
            }
        }
        try {
            SimpleDateFormat f2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            f2.setLenient(false);
            Date date = f2.parse(this.jDatetimeTextField.getText());
        }
        catch (ParseException ex1) {
            JOptionPane.showMessageDialog(this.findParentFrame(), ex1.getMessage());
            return;
        }
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            if (this.isGBV1_5CmdSupported) {
                try {
                    if (this.jDHCPRadioButton.isSelected()) {
                        ipmiCMMOEMCommand.setGBIPMode((byte)(this.moduleIndex + 2), (byte)2);
                    } else {
                        ipmiCMMOEMCommand.setGBIPMode((byte)(this.moduleIndex + 2), (byte)1);
                    }
                    ipmiCMMOEMCommand.setGBCommit((byte)(this.moduleIndex + 2));
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {}
                }
                catch (Exception ex5) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), ex5.getMessage());
                }
            }
            if (!this.isGBV1_5CmdSupported || !this.jDHCPRadioButton.isSelected()) {
                try {
                    ipmiCMMOEMCommand.setGBIP((byte)(this.moduleIndex + 2), this.jWSSIPTextField.getText());
                }
                catch (IPMIException ex2) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), ex2.getMessage());
                }
                try {
                    ipmiCMMOEMCommand.setGBGateway((byte)(this.moduleIndex + 2), this.jGatewayTextField.getText());
                }
                catch (IPMIException ex3) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), ex3.getMessage());
                }
                try {
                    ipmiCMMOEMCommand.setGBNetMask((byte)(this.moduleIndex + 2), this.jNetmaskTextField.getText());
                }
                catch (IPMIException ex4) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), ex4.getMessage());
                }
            }
            try {
                ipmiCMMOEMCommand.setGBCommit((byte)(this.moduleIndex + 2));
            }
            catch (IPMIException ex7) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex7.getMessage());
            }
            sessionController.closeSession();
            this.xMessage.setText(L.t("cmm.single.switch.Update_configuration_successfully"));
        }
        try {
            Thread.sleep(5000L);
            this.helpGetWSSConfiguration();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public void jWSSGoButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                BrowserControl.displayURL("http://" + Single10GigabitSwitchPanel.this.jWSSIPTextField.getText());
            }
        };
        thread.start();
    }

    public JPopupMenu getJPopupMenuForLabel() {
        return this.jPopupMenuForLabel;
    }

    public void jPowerOnMenuItem_actionPerformed(ActionEvent e2) {
        this.jPowerOnButton_actionPerformed(null);
    }

    public void jPowerOffMenuItem_actionPerformed(ActionEvent e2) {
        this.jPowerOffButton_actionPerformed(null);
    }

    public void jResetMenuItem_actionPerformed(ActionEvent e2) {
        this.jResetButton_actionPerformed(null);
    }

    public void jWebManagementMenuItem_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String ip = Single10GigabitSwitchPanel.this.helpGetWSSIP((byte)1);
                    if (ip == null) {
                        return;
                    }
                    BrowserControl.displayURL("http://" + ip);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Single10GigabitSwitchPanel.this.findParentFrame(), ex.getMessage());
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String helpGetWSSIP(byte moduleIndex) throws Exception {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            try {
                String ip;
                String string = ip = ipmiCMMOEMCommand.getGBIP((byte)(moduleIndex + 2));
                return string;
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
                String string = null;
                return string;
            }
            finally {
                sessionController.closeSession();
            }
        }
        return null;
    }

    public void jPopupManagementWindowMenuItem_actionPerformed(ActionEvent e2) {
        this.cmmSessionPanel.cmmBladeSystemPanel.helpTakeSinglePanelOut(this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelGigibitSwitch[this.moduleIndex + 2 - 1]);
    }

    public void jCursorHereMenuItem_actionPerformed(ActionEvent e2) {
        LabelGigabitSwitch c2 = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelGigibitSwitch[this.moduleIndex + 2 - 1];
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c2.getModuleName() + " " + c2.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleSideLabel.setText("Side: Rear");
        c2.labelBladeGroup.setIndicatorUnique(true);
        c2.setIndicatorVisible(true);
        String label = c2.getModuleName() + " " + c2.getNumber();
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setIcon(this.cmmSessionPanel.cmmBladeSystemPanel.bookmarkIcon);
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setText("[ " + label + " ]");
        this.cmmSessionPanel.cmmBladeSystemPanel.cardLayout.show(this.cmmSessionPanel.cmmBladeSystemPanel.jSinglePanel, c2.getModuleName() + c2.getNumber());
    }

    public void jResetUsernamePasswordButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Single10GigabitSwitchPanel.this.showResetAccountDialog();
                Single10GigabitSwitchPanel.this.setCursor(new Cursor(0));
            }
        };
        thread.start();
    }

    public void showResetAccountDialog() {
        int result;
        Object[] message = new Object[1];
        this.resetAccountPanel.clear();
        message[0] = this.resetAccountPanel;
        boolean flag = true;
        while (flag && (result = JOptionPane.showOptionDialog(this.findParentFrame(), message, L.t("cmm.single.switch.Username_and_Password_Reset"), 2, 1, null, null, null)) == 0) {
            boolean b2 = this.helpResetAccount();
            if (!b2) continue;
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Reset_user_pw_successfully"));
            flag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean helpResetAccount() {
        String passwordConfirm;
        if (this.resetAccountPanel.jUsernameTextField.getText() == null || this.resetAccountPanel.jUsernameTextField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Username_cannot_be_empty"));
            return false;
        }
        if (this.resetAccountPanel.jPasswordField.getPassword().length == 0 || this.resetAccountPanel.jPasswordField.getPassword().length < 5) {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Password_cannot_be_empty"));
            return false;
        }
        if (this.resetAccountPanel.jPasswordConfirmField.getPassword().length == 0 || this.resetAccountPanel.jPasswordConfirmField.getPassword().length < 5) {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Password_Confirm_cannot_be_empty"));
            return false;
        }
        if (this.resetAccountPanel.jPasswordField.getPassword().length != this.resetAccountPanel.jPasswordConfirmField.getPassword().length) {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Two_password_did_not_match"));
            return false;
        }
        String username = this.resetAccountPanel.jUsernameTextField.getText();
        String password = new String(this.resetAccountPanel.jPasswordField.getPassword());
        if (!password.equals(passwordConfirm = new String(this.resetAccountPanel.jPasswordConfirmField.getPassword()))) {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Two_password_did_not_match"));
            return false;
        }
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        if (sessionController != null) {
            try {
                b1 = ipmiCMMOEMCommand.setGBUsername((byte)(this.moduleIndex + 2), username);
                b2 = ipmiCMMOEMCommand.setGBPassword((byte)(this.moduleIndex + 2), password);
                b3 = ipmiCMMOEMCommand.setGBCommit((byte)(this.moduleIndex + 2));
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                sessionController.closeSession();
            }
        } else {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.switch.Update_failed"));
            return false;
        }
        return b1 & b2 & b3;
    }

    public void changeToPassThroughUI(GigabitSwitchEntity gigabitSwitchEntity) {
        this.jWebManagementPanel.setVisible(false);
        if (gigabitSwitchEntity.getFlag() == 1) {
            this.jPowerStatusTailLabel.setText(L.t("cmm.single.switch.GB_Pass_Thru"));
        } else if (gigabitSwitchEntity.getFlag() == 4) {
            this.jPowerStatusTailLabel.setText(L.t("[20x Pass Thru]"));
        }
    }

    public void changeToL3SwitchUI() {
        this.jWebManagementPanel.setVisible(true);
        this.jPowerStatusTailLabel.setText(L.t("cmm.single.switch.L3_Switch"));
    }

    public void changeToGBSwitchUI() {
        this.jWebManagementPanel.setVisible(true);
        this.jPowerStatusTailLabel.setText("");
    }

    public void jDHCPRadioButton_actionPerformed(ActionEvent e2) {
        this.jWSSIPTextField.setEnabled(false);
        this.jNetmaskTextField.setEnabled(false);
        this.jGatewayTextField.setEnabled(false);
        this.jDatetimeTextField.setEnabled(true);
    }

    public void jStaticIPRadioButton_actionPerformed(ActionEvent e2) {
        this.jWSSIPTextField.setEnabled(true);
        this.jNetmaskTextField.setEnabled(true);
        this.jGatewayTextField.setEnabled(true);
        this.jDatetimeTextField.setEnabled(true);
    }
}

