/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.L;
import IPMIView20.blade.RestoreOptionPanel;
import IPMIView20.blade.SingleCMMPanel;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

class SingleCMMPanelConfigModel
implements ActionListener {
    SingleCMMPanel view;
    IPMIInterfaceConfig ipmiInterfaceConfig;

    SingleCMMPanelConfigModel(SingleCMMPanel view, IPMIInterfaceConfig ipmiInterfaceConfig) {
        this.view = view;
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
    }

    public void setIPMIConfig(IPMIInterfaceConfig ipmiInterfaceConfig) {
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Thread thread;
        assert (this.ipmiInterfaceConfig != null);
        if (e2.getActionCommand().startsWith(L.t("cmm.single.cmm.Sync"))) {
            thread = new Thread(){

                @Override
                public void run() {
                    SingleCMMPanelConfigModel.this.syncConfiguration();
                }
            };
            thread.start();
        }
        if (e2.getActionCommand().startsWith(L.t("cmm.single.cmm.Backup"))) {
            thread = new Thread(){

                @Override
                public void run() {
                    SingleCMMPanelConfigModel.this.backupConfiguration();
                }
            };
            thread.start();
        }
        if (e2.getActionCommand().startsWith(L.t("cmm.single.cmm.Restore"))) {
            thread = new Thread(){

                @Override
                public void run() {
                    SingleCMMPanelConfigModel.this.restoreConfiguration();
                }
            };
            thread.start();
        }
    }

    private boolean isFileSelected(int result) {
        boolean bSelected = false;
        switch (result) {
            case 0: {
                bSelected = true;
            }
        }
        return bSelected;
    }

    private void restoreConfiguration() {
        boolean result = false;
        byte restoreOption = 0;
        JFileChooser chooser = new JFileChooser();
        RestoreOptionPanel restoreOptionPanel = new RestoreOptionPanel();
        chooser.add((Component)restoreOptionPanel, "South");
        if (!this.isFileSelected(chooser.showDialog(this.view, L.t("cmm.single.cmm.Restore_file")))) {
            return;
        }
        File selFile = chooser.getSelectedFile();
        if (restoreOptionPanel.jRestoreAllRadioButton.isSelected()) {
            restoreOption = 0;
        } else if (restoreOptionPanel.jRestoreAllButNoLANRadioButton.isSelected()) {
            restoreOption = 1;
        }
        ISessionController sessionController = null;
        this.view.setCursor(new Cursor(3));
        this.view.restoreButton.setEnabled(false);
        this.view.backupButton.setEnabled(false);
        this.view.syncButton.setEnabled(false);
        try {
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionController(this.ipmiInterfaceConfig, ipmiOEMCommand);
            result = ipmiOEMCommand.restoreConfiguration(selFile, true, restoreOption);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this.view, e2.getMessage(), null, 0);
        }
        sessionController.closeSession();
        this.view.setCursor(new Cursor(0));
        this.view.restoreButton.setEnabled(true);
        this.view.backupButton.setEnabled(true);
        this.view.syncButton.setEnabled(true);
        if (result) {
            JOptionPane.showMessageDialog(this.view, selFile + " " + L.t("cmm.single.cmm.restored"));
        } else {
            JOptionPane.showMessageDialog(this.view, L.t("cmm.single.cmm.Restore_failed"));
        }
    }

    private void backupConfiguration() {
        boolean result = false;
        JFileChooser chooser = new JFileChooser();
        if (!this.isFileSelected(chooser.showDialog(this.view, L.t("cmm.single.cmm.Backup_file")))) {
            return;
        }
        File selFile = chooser.getSelectedFile();
        ISessionController sessionController = null;
        this.view.setCursor(new Cursor(3));
        this.view.restoreButton.setEnabled(false);
        this.view.backupButton.setEnabled(false);
        this.view.syncButton.setEnabled(false);
        try {
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionController(this.ipmiInterfaceConfig, ipmiOEMCommand);
            result = ipmiOEMCommand.backupConfiguration(selFile, true);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this.view, e2.getMessage(), null, 0);
        }
        sessionController.closeSession();
        this.view.setCursor(new Cursor(0));
        this.view.restoreButton.setEnabled(true);
        this.view.backupButton.setEnabled(true);
        this.view.syncButton.setEnabled(true);
        if (result) {
            JOptionPane.showMessageDialog(this.view, selFile + " " + L.t("cmm.single.cmm.saved"));
        } else {
            JOptionPane.showMessageDialog(this.view, L.t("cmm.single.cmm.Backup_failed"));
        }
    }

    private void syncConfiguration() {
        boolean result = false;
        int confirm = JOptionPane.showConfirmDialog(this.view, L.t("cmm.single.cmm.Are_you_sure_sync_CMM"), "Confirmation", 0);
        if (confirm == 1) {
            return;
        }
        ISessionController sessionController = null;
        this.view.setCursor(new Cursor(3));
        this.view.restoreButton.setEnabled(false);
        this.view.backupButton.setEnabled(false);
        this.view.syncButton.setEnabled(false);
        try {
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            sessionController = SessionControllerFactory.createSessionController(this.ipmiInterfaceConfig, ipmiOEMCommand);
            result = ipmiOEMCommand.syncCMMCoinfiguration();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this.view, e2.getMessage(), null, 0);
        }
        sessionController.closeSession();
        this.view.setCursor(new Cursor(0));
        this.view.restoreButton.setEnabled(true);
        this.view.backupButton.setEnabled(true);
        this.view.syncButton.setEnabled(true);
        if (result) {
            JOptionPane.showMessageDialog(this.view, L.t("cmm.single.cmm.The_Sync_executed_successfully"));
        } else {
            JOptionPane.showMessageDialog(this.view, L.t("cmm.single.cmm.Sync_failed"));
        }
    }
}

