/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.blade.JTempPanel;
import IPMIView20.blade.JVolPanel;
import IPMIView20.blade.LabelIBFDR;
import IPMIView20.blade.SingleIBFDRPanel_jMenuItem1_actionAdapter;
import IPMIView20.blade.SingleIBFDRPanel_jPopupManagementWindowMenuItem_actionAdapter;
import IPMIView20.blade.SingleIBFDRPanel_jPowerOffButton_actionAdapter;
import IPMIView20.blade.SingleIBFDRPanel_jPowerOffMenuItem_actionAdapter;
import IPMIView20.blade.SingleIBFDRPanel_jPowerOnButton_actionAdapter;
import IPMIView20.blade.SingleIBFDRPanel_jPowerOnMenuItem_actionAdapter;
import IPMIView20.blade.SingleIBFDRPanel_jPowerResetButton_actionAdapter;
import IPMIView20.blade.SingleIBFDRPanel_jResetMenuItem_actionAdapter;
import IPMIView20.blade.SingleModuleAbstractPanel;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.IBFDREntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SingleIBFDRPanel
extends SingleModuleAbstractPanel {
    public static int TEMPERATURE_FULL_SCALE = 100;
    public static int VOLTAGE_V33_FULL_SCALE = 5;
    public static int VOLTAGE_V12_FULL_SCALE = 2;
    public static int VOLTAGE_V09_FULL_SCALE = 2;
    boolean initSensors = false;
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    Icon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    JTempPanel tempSwitchPanel = new JTempPanel();
    JTempPanel tempBoardPanel = new JTempPanel();
    JVolPanel p3v3VoltagePanel = new JVolPanel();
    JVolPanel p1v25VoltagePanel = new JVolPanel();
    JVolPanel p0v9VoltagePanel = new JVolPanel();
    JPanel jRightPanel = new JPanel();
    JPanel jCenterPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    JPanel jLeftPanel = new JPanel();
    TitledBorder titledBorder3 = new TitledBorder("");
    JPanel jStatusPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    Border border1 = BorderFactory.createEmptyBorder();
    Border border2 = new TitledBorder(this.border1, "Status");
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout4 = new GridLayout();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();
    GridLayout gridLayout7 = new GridLayout();
    JLabel jTempBoardStringLabel = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jTempBoardLabel = new JLabel();
    JLabel jPowerStatusStringLabel = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jPowerStatusLabel = new JLabel();
    JLabel j3v3StringLabel = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel j3v3Label = new JLabel();
    JLabel j1v25StringLabel = new JLabel();
    JLabel jLabel11 = new JLabel();
    JLabel j1v25Label = new JLabel();
    JLabel j0v9Label = new JLabel();
    JLabel j0v9StringLabel = new JLabel();
    JLabel jTempSwitchStringLabel = new JLabel();
    JLabel jTempSwitchLabel = new JLabel();
    JLabel jLabel15 = new JLabel();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JLabel jLabel09Dummy = new JLabel();
    JLabel notPresent = new JLabel("Module not present");
    BladeSystemEntity bladeSystemEntity = null;
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jVoltagePanel = new JPanel();
    JPanel jTempPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPopupMenu jPopupMenuForLabel = new JPopupMenu();
    JMenuItem jFocusHereMenuItem = new JMenuItem();
    JPanel jPanel8 = new JPanel();
    TitledBorder titledBorder4 = new TitledBorder("");
    JButton jPowerResetButton = new JButton();
    JButton jPowerOffButton = new JButton();
    JButton jPowerOnButton = new JButton();
    JMenuItem jPowerOnMenuItem = new JMenuItem();
    JMenuItem jPowerOffMenuItem = new JMenuItem();
    JMenuItem jResetMenuItem = new JMenuItem();
    JMenuItem jPopupManagementWindowMenuItem = new JMenuItem();
    GridLayout gridLayout8 = new GridLayout();

    public SingleIBFDRPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void myInit() {
        this.tempSwitchPanel.tempMeter.setPreferredSize(new Dimension(120, 35));
        this.tempBoardPanel.tempMeter.setPreferredSize(new Dimension(120, 35));
        this.p3v3VoltagePanel.volMeter.setPreferredSize(new Dimension(117, 69));
        this.p1v25VoltagePanel.volMeter.setPreferredSize(new Dimension(117, 69));
        this.p0v9VoltagePanel.volMeter.setPreferredSize(new Dimension(117, 69));
        this.jTempPanel.add(this.tempBoardPanel);
        this.jTempPanel.add(this.tempSwitchPanel);
        this.jVoltagePanel.add(this.p3v3VoltagePanel);
        this.jVoltagePanel.add(this.p1v25VoltagePanel);
        this.jVoltagePanel.add(this.p0v9VoltagePanel);
        this.tempSwitchPanel.init("Temp. Switch", (byte)0, (byte)0, "", "");
        this.tempBoardPanel.init("Temp. Board", (byte)0, (byte)0, "", "");
        this.p3v3VoltagePanel.init("3.3V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.p1v25VoltagePanel.init("1.2V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.p0v9VoltagePanel.init("0.9V", (byte)0, (byte)0, (byte)0, "", "", "");
    }

    public void setEnableControls(boolean isEnable) {
        this.jPowerOnButton.setEnabled(isEnable);
        this.jPowerOffButton.setEnabled(isEnable);
        this.jPowerResetButton.setEnabled(isEnable);
    }

    @Override
    public void setUserPrivilege() {
        this.jPowerOnButton.setEnabled(false);
        this.jPowerOffButton.setEnabled(false);
        this.jPowerResetButton.setEnabled(false);
        this.jPowerOnMenuItem.setEnabled(false);
        this.jPowerOffMenuItem.setEnabled(false);
        this.jResetMenuItem.setEnabled(false);
    }

    @Override
    public void setOperatorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jPowerResetButton.setEnabled(true);
    }

    @Override
    public void setAdministratorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jPowerResetButton.setEnabled(true);
    }

    public void setPresentUI(boolean isPresent) {
        if (isPresent) {
            if (this.getComponent(0).equals(this.jCenterPanel)) {
                return;
            }
            this.remove(this.notPresent);
            this.add((Component)this.jCenterPanel, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            if (this.getComponent(0).equals(this.notPresent)) {
                return;
            }
            this.remove(this.jCenterPanel);
            this.add((Component)this.notPresent, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SingleIBFDRPanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SingleIBFDRPanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        IBFDREntity ibFDREntity = this.bladeSystemEntity.getIBFDRs()[this.moduleIndex - 1];
        boolean present = ibFDREntity.getPresent() != 0 && ibFDREntity.isIBFDR();
        byte tempLimit = 80;
        if (!present) {
            this.setPresentUI(false);
            return;
        }
        this.setPresentUI(true);
        if (!ibFDREntity.isPowerOn()) {
            this.jPowerStatusLabel.setText("Off");
            this.jPowerStatusLabel.setIcon(this.powerOffIcon);
            this.helpHideUIForPowerOff();
            return;
        }
        this.jPowerStatusLabel.setText("On");
        this.jPowerStatusLabel.setIcon(this.powerOnIcon);
        this.helpShowUIForPowerOn();
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jPowerResetButton.setEnabled(true);
        this.jPowerOnMenuItem.setEnabled(true);
        this.jPowerOffMenuItem.setEnabled(true);
        this.jResetMenuItem.setEnabled(true);
        if (ibFDREntity.getSwitchTempFormula() < 80) {
            this.jTempSwitchLabel.setIcon(this.okGreenIcon);
            this.jTempSwitchLabel.setForeground(Color.GREEN);
            this.jTempSwitchLabel.setText("Normal");
        } else {
            this.jTempSwitchLabel.setIcon(this.xRedIcon);
            this.jTempSwitchLabel.setForeground(Color.RED);
            this.jTempSwitchLabel.setText("Error");
        }
        if (ibFDREntity.getBoardTempFormula() < 80) {
            this.jTempBoardLabel.setIcon(this.okGreenIcon);
            this.jTempBoardLabel.setForeground(Color.GREEN);
            this.jTempBoardLabel.setText("Normal");
        } else {
            this.jTempBoardLabel.setIcon(this.xRedIcon);
            this.jTempBoardLabel.setForeground(Color.RED);
            this.jTempBoardLabel.setText("Error");
        }
        double v33 = ibFDREntity.getP3v3Formula();
        double v33LowLimit = 2.9699999999999998;
        double v33HighLimit = 3.63;
        byte v33Ratio = (byte)(v33 * 256.0 / (double)VOLTAGE_V33_FULL_SCALE);
        byte v33LowLimitRatio = (byte)(v33LowLimit * 256.0 / (double)VOLTAGE_V33_FULL_SCALE);
        byte v33HighLimitRatio = (byte)(v33HighLimit * 256.0 / (double)VOLTAGE_V33_FULL_SCALE);
        String v33String = this.doubleToString(v33);
        String v33LowLimitString = this.doubleToString(v33LowLimit);
        String v33HighLimitString = this.doubleToString(v33HighLimit);
        double v125 = ibFDREntity.getP1v25Formula();
        double v125LowLimit = 1.08;
        double v125HighLimit = 1.32;
        byte v12Ratio = (byte)(v125 * 256.0 / (double)VOLTAGE_V12_FULL_SCALE);
        byte v12LowLimitRatio = (byte)(v125LowLimit * 256.0 / (double)VOLTAGE_V12_FULL_SCALE);
        byte v12HighLimitRatio = (byte)(v125HighLimit * 256.0 / (double)VOLTAGE_V12_FULL_SCALE);
        String v12String = this.doubleToString(v125);
        String v12LowLimitString = this.doubleToString(v125LowLimit);
        String v12HighLimitString = this.doubleToString(v125HighLimit);
        double v09 = ibFDREntity.getP0v9Formula();
        double v09LowLimit = 0.81;
        double v09HighLimit = 0.9900000000000001;
        byte v09Ratio = (byte)(v09 * 256.0 / (double)VOLTAGE_V09_FULL_SCALE);
        byte v09LowLimitRatio = (byte)(v09LowLimit * 256.0 / (double)VOLTAGE_V09_FULL_SCALE);
        byte v09HighLimitRatio = (byte)(v09HighLimit * 256.0 / (double)VOLTAGE_V09_FULL_SCALE);
        String v09String = this.doubleToString(v09);
        String v09LowLimitString = this.doubleToString(v09LowLimit);
        String v09HighLimitString = this.doubleToString(v09HighLimit);
        if (!this.initSensors) {
            this.tempSwitchPanel.init("Temp. Switch", ibFDREntity.getSwitchTemp(), tempLimit, "" + ibFDREntity.getSwitchTemp(), "" + tempLimit);
            this.tempBoardPanel.init("Temp. Board", ibFDREntity.getBoardTemp(), tempLimit, "" + ibFDREntity.getBoardTemp(), "" + tempLimit);
            this.p3v3VoltagePanel.init("3.3V", v33Ratio, v33HighLimitRatio, v33LowLimitRatio, v33String, v33HighLimitString, v33LowLimitString);
            this.p1v25VoltagePanel.init("1.25V", v12Ratio, v12HighLimitRatio, v12LowLimitRatio, v12String, v12HighLimitString, v12LowLimitString);
            this.p0v9VoltagePanel.init("0.9V", v09Ratio, v09HighLimitRatio, v09LowLimitRatio, v09String, v09HighLimitString, v09LowLimitString);
            this.initSensors = true;
        }
        if (v33 < v33LowLimit || v33 > v33HighLimit) {
            this.j3v3Label.setIcon(this.xRedIcon);
            this.j3v3Label.setForeground(Color.RED);
            this.j3v3Label.setText("Abnormal");
        } else {
            this.j3v3Label.setIcon(this.okGreenIcon);
            this.j3v3Label.setForeground(Color.GREEN);
            this.j3v3Label.setText("Normal");
        }
        if (v125 < v125LowLimit || v125 > v125HighLimit) {
            this.j1v25Label.setIcon(this.xRedIcon);
            this.j1v25Label.setForeground(Color.RED);
            this.j1v25Label.setText("Abnormal");
        } else {
            this.j1v25Label.setIcon(this.okGreenIcon);
            this.j1v25Label.setForeground(Color.GREEN);
            this.j1v25Label.setText("Normal");
        }
        if (v09 < v09LowLimit || v09 > v09HighLimit) {
            this.j0v9Label.setIcon(this.xRedIcon);
            this.j0v9Label.setForeground(Color.RED);
            this.j0v9Label.setText("Abnormal");
        } else {
            this.j0v9Label.setIcon(this.okGreenIcon);
            this.j0v9Label.setForeground(Color.GREEN);
            this.j0v9Label.setText("Normal");
        }
        if (present) {
            this.tempSwitchPanel.updateValue(ibFDREntity.getSwitchTemp(), "" + ibFDREntity.getSwitchTemp());
            this.tempBoardPanel.updateValue(ibFDREntity.getBoardTemp(), "" + ibFDREntity.getBoardTemp());
            this.p3v3VoltagePanel.updateValue(v33Ratio, v33String);
            this.p1v25VoltagePanel.updateValue(v12Ratio, v12String);
            this.p0v9VoltagePanel.updateValue(v09Ratio, v09String);
        }
    }

    public void helpHideUIForPowerOff() {
        this.j3v3Label.setVisible(false);
        this.j1v25Label.setVisible(false);
        this.j0v9Label.setVisible(false);
        this.jTempSwitchLabel.setVisible(false);
        this.jTempBoardLabel.setVisible(false);
        this.tempSwitchPanel.setNA();
        this.tempBoardPanel.setNA();
        this.p3v3VoltagePanel.setNA();
        this.p1v25VoltagePanel.setNA();
        this.p0v9VoltagePanel.setNA();
    }

    public void helpShowUIForPowerOn() {
        this.j3v3Label.setVisible(true);
        this.j1v25Label.setVisible(true);
        this.j0v9Label.setVisible(true);
        this.jTempSwitchLabel.setVisible(true);
        this.jTempBoardLabel.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.titledBorder4 = new TitledBorder(L.t("cmm.single.ib.Power_Control"));
        this.titledBorder3 = new TitledBorder("Status");
        this.titledBorder1 = new TitledBorder("Voltage and Temperature");
        this.jRightPanel.setBorder(this.titledBorder1);
        this.jRightPanel.setLayout(this.gridLayout1);
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.jLeftPanel.setLayout(this.borderLayout1);
        this.jCenterPanel.setBorder(null);
        this.jLeftPanel.setBorder(null);
        this.jStatusPanel.setBorder(this.titledBorder3);
        this.jStatusPanel.setLayout(this.gridLayout2);
        this.gridLayout2.setRows(8);
        this.jPanel5.setLayout(this.gridLayout3);
        this.jPanel4.setLayout(this.gridLayout4);
        this.jPanel3.setLayout(this.gridLayout5);
        this.jPanel2.setLayout(this.gridLayout6);
        this.jPanel1.setLayout(this.gridLayout7);
        this.gridLayout3.setColumns(3);
        this.gridLayout3.setRows(0);
        this.gridLayout4.setColumns(3);
        this.gridLayout4.setRows(0);
        this.gridLayout6.setColumns(3);
        this.gridLayout6.setRows(0);
        this.gridLayout7.setColumns(3);
        this.gridLayout7.setRows(0);
        this.jTempBoardStringLabel.setForeground(Color.blue);
        this.jTempBoardStringLabel.setText("Temp. Board:");
        this.gridLayout5.setColumns(3);
        this.gridLayout5.setRows(0);
        this.jPowerStatusStringLabel.setForeground(Color.blue);
        this.jPowerStatusStringLabel.setText("Power Status:");
        this.j3v3StringLabel.setForeground(Color.blue);
        this.j3v3StringLabel.setText("3.3V:");
        this.j1v25StringLabel.setForeground(Color.blue);
        this.j1v25StringLabel.setText("1.25V:");
        this.j0v9StringLabel.setForeground(Color.blue);
        this.j0v9StringLabel.setText("0.9V:");
        this.jTempSwitchStringLabel.setForeground(Color.blue);
        this.jTempSwitchStringLabel.setText("Temp. Switch:");
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.jFocusHereMenuItem.setText("Focus Here");
        this.jFocusHereMenuItem.addActionListener(new SingleIBFDRPanel_jMenuItem1_actionAdapter(this));
        this.jPanel8.setBorder(this.titledBorder4);
        this.jPowerResetButton.setFont(new Font("Dialog", 1, 12));
        this.jPowerResetButton.setForeground(Color.red);
        this.jPowerResetButton.setText(L.t("cmm.single.ib.Reset"));
        this.jPowerResetButton.addActionListener(new SingleIBFDRPanel_jPowerResetButton_actionAdapter(this));
        this.jPowerOffButton.setFont(new Font("Dialog", 1, 12));
        this.jPowerOffButton.setForeground(Color.red);
        this.jPowerOffButton.setText(L.t("cmm.single.ib.Power_Off"));
        this.jPowerOffButton.addActionListener(new SingleIBFDRPanel_jPowerOffButton_actionAdapter(this));
        this.jPowerOnButton.setText(L.t("cmm.single.ib.Power_On"));
        this.jPowerOnButton.addActionListener(new SingleIBFDRPanel_jPowerOnButton_actionAdapter(this));
        this.jPowerOnMenuItem.setText(L.t("cmm.single.ib.Power_On"));
        this.jPowerOnMenuItem.addActionListener(new SingleIBFDRPanel_jPowerOnMenuItem_actionAdapter(this));
        this.jPowerOffMenuItem.setText(L.t("cmm.single.ib.Power_Off"));
        this.jPowerOffMenuItem.addActionListener(new SingleIBFDRPanel_jPowerOffMenuItem_actionAdapter(this));
        this.jResetMenuItem.setText(L.t("cmm.single.ib.Reset"));
        this.jResetMenuItem.addActionListener(new SingleIBFDRPanel_jResetMenuItem_actionAdapter(this));
        this.jPopupManagementWindowMenuItem.setText(L.t("cmm.single.ib.Popup_Management_Window"));
        this.jPopupManagementWindowMenuItem.addActionListener(new SingleIBFDRPanel_jPopupManagementWindowMenuItem_actionAdapter(this));
        this.jPanel7.setLayout(this.gridLayout8);
        this.add((Component)this.jCenterPanel, "Center");
        this.jLeftPanel.add((Component)this.jStatusPanel, "Center");
        this.jStatusPanel.add(this.jPanel4);
        this.jPanel4.add(this.jPowerStatusStringLabel);
        this.jPanel4.add(this.jPowerStatusLabel);
        this.jPanel4.add(this.jLabel5);
        this.jStatusPanel.add(this.jPanel3);
        this.jPanel3.add(this.j3v3StringLabel);
        this.jPanel3.add(this.j3v3Label);
        this.jPanel3.add(this.jLabel8);
        this.jStatusPanel.add(this.jPanel2);
        this.jPanel2.add(this.j1v25StringLabel);
        this.jPanel2.add(this.j1v25Label);
        this.jPanel2.add(this.jLabel11);
        this.jStatusPanel.add(this.jPanel7);
        this.jPanel7.add(this.j0v9StringLabel);
        this.jPanel7.add(this.j0v9Label);
        this.jPanel7.add(this.jLabel09Dummy);
        this.jStatusPanel.add(this.jPanel1);
        this.jPanel1.add(this.jTempSwitchStringLabel);
        this.jPanel1.add(this.jTempSwitchLabel);
        this.jStatusPanel.add(this.jPanel5);
        this.jPanel5.add(this.jTempBoardStringLabel);
        this.jPanel5.add(this.jTempBoardLabel);
        this.jPanel5.add(this.jLabel2);
        this.jPanel1.add(this.jLabel15);
        this.jStatusPanel.add(this.jPanel6);
        this.jCenterPanel.add((Component)this.jRightPanel, "Center");
        this.jRightPanel.add(this.jTempPanel);
        this.jRightPanel.add(this.jVoltagePanel);
        this.jCenterPanel.add((Component)this.jLeftPanel, "West");
        this.jPopupMenuForLabel.add(this.jPowerOnMenuItem);
        this.jPopupMenuForLabel.add(this.jPowerOffMenuItem);
        this.jPopupMenuForLabel.add(this.jResetMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jPopupManagementWindowMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jFocusHereMenuItem);
        this.jLeftPanel.add((Component)this.jPanel8, "South");
        this.jPanel8.add(this.jPowerOffButton);
        this.jPanel8.add(this.jPowerOnButton);
        this.jPanel8.add(this.jPowerResetButton);
    }

    public String doubleToString(double value) {
        int temp = (int)(value * 100.0);
        double d2 = (double)temp / 100.0;
        return "" + d2;
    }

    public String doubleToString4(double value) {
        int temp = (int)(value * 10000.0);
        double d2 = (double)temp / 10000.0;
        return "" + d2;
    }

    public JPopupMenu getJPopupMenuForLabel() {
        return this.jPopupMenuForLabel;
    }

    public void jMenuItem1_actionPerformed(ActionEvent e2) {
        LabelIBFDR c2 = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelIBFDR[this.moduleIndex - 1];
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c2.getModuleName() + " " + c2.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c2.getModuleName() + " " + c2.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleSideLabel.setText("Side: Rear");
        c2.labelBladeGroup.setIndicatorUnique(true);
        c2.setIndicatorVisible(true);
        String label = c2.getModuleName() + " " + c2.getNumber();
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setIcon(this.cmmSessionPanel.cmmBladeSystemPanel.bookmarkIcon);
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setText("[ " + label + " ]");
        this.cmmSessionPanel.cmmBladeSystemPanel.cardLayout.show(this.cmmSessionPanel.cmmBladeSystemPanel.jSinglePanel, c2.getModuleName() + c2.getNumber());
    }

    public void jPowerOffButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleIBFDRPanel.this.findParentFrame(), L.t("cmm.single.ib.Are_you_power_off"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleIBFDRPanel.this.powerOff();
            }
        };
        thread.start();
    }

    public void jPowerOnButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleIBFDRPanel.this.findParentFrame(), L.t("cmm.single.ib.Are_you_power_on"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleIBFDRPanel.this.powerOn();
            }
        };
        thread.start();
    }

    public void jPowerResetButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleIBFDRPanel.this.findParentFrame(), L.t("cmm.single.ib.Are_you_reset"), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleIBFDRPanel.this.reset();
            }
        };
        thread.start();
    }

    private void powerOn() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b2 = false;
            try {
                b2 = ipmiCMMOEMCommand.enableInfinibandPower((byte)this.moduleIndex, (byte)1);
                if (!b2) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.ib.Power_on_failed"));
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    private void powerOff() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b2 = false;
            try {
                b2 = ipmiCMMOEMCommand.enableInfinibandPower((byte)this.moduleIndex, (byte)0);
                if (!b2) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.ib.Power_off_failed"));
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    private void reset() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b2 = false;
            try {
                b2 = ipmiCMMOEMCommand.resetInfiniband((byte)this.moduleIndex);
                if (!b2) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.single.ib.Reset_failed"));
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jPowerOnMenuItem_actionPerformed(ActionEvent e2) {
        this.jPowerOnButton_actionPerformed(null);
    }

    public void jPowerOffMenuItem_actionPerformed(ActionEvent e2) {
        this.jPowerOffButton_actionPerformed(null);
    }

    public void jResetMenuItem_actionPerformed(ActionEvent e2) {
        this.jResetMenuItem_actionPerformed(null);
    }

    public void jPopupManagementWindowMenuItem_actionPerformed(ActionEvent e2) {
        this.cmmSessionPanel.cmmBladeSystemPanel.helpTakeSinglePanelOut(this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelIBFDR[this.moduleIndex - 1]);
    }
}

