/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.blade.UTCTimeDialog_jSynchronizeNTPRadioButton_actionAdapter;
import IPMIView20.blade.UTCTimeDialog_jUserSpecifiedRadioButton_actionAdapter;
import IPMIView20.blade.UTCTimePanel_jResetLabel_mouseAdapter;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class UTCTimePanel
extends JPanel {
    IPMIInterfaceConfig config = null;
    ButtonGroup buttonGroup = new ButtonGroup();
    String resetStr = L.t("cmm.dialog.utc.Reload");
    boolean isDHCP = false;
    int iMonth;
    int iDate;
    int iYear;
    int iHour;
    int iMinute;
    int iSecond;
    JComboBox jUTFOffsetComboBox = new JComboBox();
    JLabel jLabel1 = new JLabel();
    JRadioButton jUserSpecifiedRadioButton = new JRadioButton();
    JTextField jMonthTextField = new JTextField();
    JTextField jDateTextField = new JTextField();
    JTextField jYearTextField = new JTextField();
    JTextField jMinuteTextField = new JTextField();
    JTextField jHourTextField = new JTextField();
    JTextField jSecondTextField = new JTextField();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JRadioButton jSynchronizeNTPRadioButton = new JRadioButton();
    JLabel jLabel10 = new JLabel();
    JLabel jLabel11 = new JLabel();
    JTextField jPrimaryTimeServerTextField = new JTextField();
    JTextField jSecondaryTimeServerTextField = new JTextField();
    JLabel jLabel12 = new JLabel();
    JLabel jReloadLabel = new JLabel();
    JLabel jDHCPMsg1Label = new JLabel();
    JLabel jDHCPMsg2Label = new JLabel();
    JLabel jDHCPMsg3Label = new JLabel();

    public UTCTimePanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setIPMIInterfaceConfig(IPMIInterfaceConfig config) {
        this.config = config;
    }

    private void myInit() throws Exception {
        this.jUTFOffsetComboBox.addItem("-11h");
        this.jUTFOffsetComboBox.addItem("-10h");
        this.jUTFOffsetComboBox.addItem("-9h");
        this.jUTFOffsetComboBox.addItem("-8h");
        this.jUTFOffsetComboBox.addItem("-7h");
        this.jUTFOffsetComboBox.addItem("-6h");
        this.jUTFOffsetComboBox.addItem("-5h");
        this.jUTFOffsetComboBox.addItem("-4h");
        this.jUTFOffsetComboBox.addItem("-3h");
        this.jUTFOffsetComboBox.addItem("-2h");
        this.jUTFOffsetComboBox.addItem("-1h");
        this.jUTFOffsetComboBox.addItem("+/- 0h");
        this.jUTFOffsetComboBox.addItem("+1h");
        this.jUTFOffsetComboBox.addItem("+2h");
        this.jUTFOffsetComboBox.addItem("+3h");
        this.jUTFOffsetComboBox.addItem("+4h");
        this.jUTFOffsetComboBox.addItem("+5h");
        this.jUTFOffsetComboBox.addItem("+6h");
        this.jUTFOffsetComboBox.addItem("+7h");
        this.jUTFOffsetComboBox.addItem("+8h");
        this.jUTFOffsetComboBox.addItem("+9h");
        this.jUTFOffsetComboBox.addItem("+10h");
        this.jUTFOffsetComboBox.addItem("+11h");
        this.jUTFOffsetComboBox.addItem("+12h");
        this.jUTFOffsetComboBox.setSelectedItem("+/- 0h");
        this.buttonGroup.add(this.jUserSpecifiedRadioButton);
        this.buttonGroup.add(this.jSynchronizeNTPRadioButton);
        this.jUserSpecifiedRadioButton.setSelected(true);
        this.selectUserSepcifiedTime();
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.jUTFOffsetComboBox.setBounds(new Rectangle(173, 200, 85, 23));
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText(L.t("cmm.dialog.utc.UTC_Offset"));
        this.jLabel1.setBounds(new Rectangle(98, 204, 63, 15));
        this.jUserSpecifiedRadioButton.setFont(new Font("Dialog", 1, 12));
        this.jUserSpecifiedRadioButton.setText(L.t("cmm.dialog.utc.User_Specified_time"));
        this.jUserSpecifiedRadioButton.setBounds(new Rectangle(23, 19, 167, 23));
        this.jUserSpecifiedRadioButton.addActionListener(new UTCTimeDialog_jUserSpecifiedRadioButton_actionAdapter(this));
        this.jMonthTextField.setBounds(new Rectangle(80, 50, 39, 20));
        this.jDateTextField.setBounds(new Rectangle(152, 50, 39, 20));
        this.jYearTextField.setBounds(new Rectangle(227, 50, 51, 20));
        this.jMinuteTextField.setBounds(new Rectangle(152, 79, 39, 20));
        this.jHourTextField.setBounds(new Rectangle(81, 79, 39, 20));
        this.jSecondTextField.setBounds(new Rectangle(227, 79, 39, 20));
        this.jLabel2.setText(L.t("cmm.dialog.utc.Date"));
        this.jLabel2.setBounds(new Rectangle(39, 54, 42, 15));
        this.jLabel3.setText(L.t("cmm.dialog.utc.Time"));
        this.jLabel3.setBounds(new Rectangle(39, 81, 42, 15));
        this.jLabel4.setText(":");
        this.jLabel4.setBounds(new Rectangle(198, 81, 22, 15));
        this.jLabel5.setText("/");
        this.jLabel5.setBounds(new Rectangle(198, 51, 22, 15));
        this.jLabel6.setText("/");
        this.jLabel6.setBounds(new Rectangle(127, 52, 22, 15));
        this.jLabel7.setText(":");
        this.jLabel7.setBounds(new Rectangle(125, 79, 22, 15));
        this.jLabel8.setText("(mm/dd/yyyy)");
        this.jLabel8.setBounds(new Rectangle(283, 52, 93, 15));
        this.jLabel9.setText("(hh:mm:ss)");
        this.jLabel9.setBounds(new Rectangle(283, 81, 91, 15));
        this.jSynchronizeNTPRadioButton.setFont(new Font("Dialog", 1, 12));
        this.jSynchronizeNTPRadioButton.setText(L.t("cmm.dialog.utc.Synchronize_with_NTP_Server"));
        this.jSynchronizeNTPRadioButton.setBounds(new Rectangle(23, 110, 202, 23));
        this.jSynchronizeNTPRadioButton.addActionListener(new UTCTimeDialog_jSynchronizeNTPRadioButton_actionAdapter(this));
        this.jLabel10.setHorizontalAlignment(11);
        this.jLabel10.setText(L.t("cmm.dialog.utc.Primary_Time_server"));
        this.jLabel10.setBounds(new Rectangle(51, 141, 109, 15));
        this.jLabel11.setHorizontalAlignment(11);
        this.jLabel11.setText(L.t("cmm.dialog.utc.Secondary_Time_server"));
        this.jLabel11.setBounds(new Rectangle(47, 171, 114, 15));
        this.jPrimaryTimeServerTextField.setBounds(new Rectangle(174, 141, 179, 20));
        this.jSecondaryTimeServerTextField.setBounds(new Rectangle(173, 171, 180, 20));
        this.jLabel12.setForeground(Color.gray);
        this.jLabel12.setText(L.t("cmm.dialog.utc.Daylight_saving"));
        this.jLabel12.setBounds(new Rectangle(29, 234, 324, 15));
        this.setPreferredSize(new Dimension(400, 343));
        this.jReloadLabel.setForeground(Color.blue);
        this.jReloadLabel.setHorizontalAlignment(11);
        this.jReloadLabel.setText(this.htmlString(this.resetStr));
        this.jReloadLabel.setBounds(new Rectangle(243, 309, 111, 15));
        this.jReloadLabel.addMouseListener(new UTCTimePanel_jResetLabel_mouseAdapter(this));
        this.jDHCPMsg1Label.setForeground(Color.red);
        this.jDHCPMsg1Label.setText(L.t("cmm.dialog.utc.The_NTP_Server"));
        this.jDHCPMsg1Label.setBounds(new Rectangle(30, 255, 350, 15));
        this.jDHCPMsg2Label.setForeground(Color.red);
        this.jDHCPMsg2Label.setText(L.t("cmm.dialog.utc.function_please"));
        this.jDHCPMsg2Label.setBounds(new Rectangle(30, 273, 350, 15));
        this.jDHCPMsg3Label.setForeground(Color.red);
        this.jDHCPMsg3Label.setText(L.t("cmm.dialog.utc.this_device"));
        this.jDHCPMsg3Label.setBounds(new Rectangle(30, 292, 343, 15));
        this.add(this.jUserSpecifiedRadioButton);
        this.add(this.jMonthTextField);
        this.add(this.jDateTextField);
        this.add(this.jYearTextField);
        this.add(this.jHourTextField);
        this.add(this.jLabel2);
        this.add(this.jLabel3);
        this.add(this.jLabel5);
        this.add(this.jLabel6);
        this.add(this.jLabel4);
        this.add(this.jLabel7);
        this.add(this.jLabel8);
        this.add(this.jLabel9);
        this.add(this.jSynchronizeNTPRadioButton);
        this.add(this.jLabel10);
        this.add(this.jPrimaryTimeServerTextField);
        this.add(this.jSecondaryTimeServerTextField);
        this.add(this.jLabel11);
        this.add(this.jMinuteTextField);
        this.add(this.jSecondTextField);
        this.add(this.jUTFOffsetComboBox);
        this.add(this.jLabel1);
        this.add(this.jLabel12);
        this.add(this.jDHCPMsg1Label);
        this.add(this.jDHCPMsg2Label);
        this.add(this.jDHCPMsg3Label);
        this.add(this.jReloadLabel);
    }

    public void jUserSpecifiedRadioButton_actionPerformed(ActionEvent e2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UTCTimePanel.this.selectUserSepcifiedTime();
            }
        });
    }

    public void jSynchronizeNTPRadioButton_actionPerformed(ActionEvent e2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UTCTimePanel.this.selectSynchornizedNTP();
            }
        });
    }

    public void selectUserSepcifiedTime() {
        this.jMonthTextField.setEnabled(true);
        this.jDateTextField.setEnabled(true);
        this.jYearTextField.setEnabled(true);
        this.jHourTextField.setEnabled(true);
        this.jMinuteTextField.setEnabled(true);
        this.jSecondTextField.setEnabled(true);
        this.jPrimaryTimeServerTextField.setEnabled(false);
        this.jSecondaryTimeServerTextField.setEnabled(false);
        this.jUTFOffsetComboBox.setEnabled(false);
    }

    public void selectSynchornizedNTP() {
        this.jMonthTextField.setEnabled(false);
        this.jDateTextField.setEnabled(false);
        this.jYearTextField.setEnabled(false);
        this.jHourTextField.setEnabled(false);
        this.jMinuteTextField.setEnabled(false);
        this.jSecondTextField.setEnabled(false);
        if (!this.isDHCP) {
            this.jPrimaryTimeServerTextField.setEnabled(true);
            this.jSecondaryTimeServerTextField.setEnabled(true);
        } else {
            this.jPrimaryTimeServerTextField.setEnabled(false);
            this.jSecondaryTimeServerTextField.setEnabled(false);
        }
        this.jUTFOffsetComboBox.setEnabled(true);
    }

    public void setUIForDHCPMode(boolean isDHCP) {
        if (isDHCP) {
            this.jDHCPMsg1Label.setVisible(true);
            this.jDHCPMsg2Label.setVisible(true);
            this.jDHCPMsg3Label.setVisible(true);
        } else {
            this.jDHCPMsg1Label.setVisible(false);
            this.jDHCPMsg2Label.setVisible(false);
            this.jDHCPMsg3Label.setVisible(false);
        }
    }

    private String htmlString(String string) {
        String s = "<html>" + string + "</html>";
        return s;
    }

    private String underLineString(String string) {
        String s = "<html><u>" + string + "</u></html>";
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadData() {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiCMMOEMCommand);
        if (sessionController == null) {
            return false;
        }
        try {
            ipmiLanCommand.setIPMIInterface(ipmiCMMOEMCommand.getIPMIInterface());
            byte type = ipmiLanCommand.getLanSettingType();
            if (type == 2) {
                this.isDHCP = true;
            } else if (type == 1) {
                this.isDHCP = false;
            }
            this.setUIForDHCPMode(this.isDHCP);
            Calendar c2 = ipmiCMMOEMCommand.getCMMTimeByCalendar();
            String primaryNTPServer = ipmiCMMOEMCommand.getNTPServerPrimary();
            String secondaryNTPServer = ipmiCMMOEMCommand.getNTPServerSecondary();
            byte syncMode = ipmiCMMOEMCommand.getCMMTimeSyncMode();
            byte utcOffset = ipmiCMMOEMCommand.getUTCOffset();
            if (syncMode == 0) {
                this.jUserSpecifiedRadioButton.setSelected(true);
                this.selectUserSepcifiedTime();
            } else {
                this.jSynchronizeNTPRadioButton.setSelected(true);
                this.selectSynchornizedNTP();
            }
            this.jMonthTextField.setText("" + (c2.get(2) + 1));
            this.jDateTextField.setText("" + c2.get(5));
            this.jYearTextField.setText("" + c2.get(1));
            this.jHourTextField.setText("" + c2.get(11));
            this.jMinuteTextField.setText("" + c2.get(12));
            this.jSecondTextField.setText("" + c2.get(13));
            this.jPrimaryTimeServerTextField.setText(primaryNTPServer);
            this.jSecondaryTimeServerTextField.setText(secondaryNTPServer);
            this.jUTFOffsetComboBox.setSelectedIndex(utcOffset + 11);
        }
        catch (IPMIException ex) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            sessionController.closeSession();
        }
        return true;
    }

    public boolean validateUserInput() {
        if (this.jUserSpecifiedRadioButton.isSelected()) {
            return this.validateUserSpecificDataInput();
        }
        if (this.jSynchronizeNTPRadioButton.isSelected()) {
            return this.validateSyncWithNTPInput();
        }
        return false;
    }

    public boolean validateSyncWithNTPInput() {
        if (this.isDHCP) {
            return true;
        }
        if (this.jPrimaryTimeServerTextField.getText() == null || this.jPrimaryTimeServerTextField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.Primary_Timer_Server_is_empty"));
            return false;
        }
        return true;
    }

    public boolean validateUserSpecificDataInput() {
        String month = this.jMonthTextField.getText();
        String date = this.jDateTextField.getText();
        String year = this.jYearTextField.getText();
        String hour = this.jHourTextField.getText();
        String minute = this.jMinuteTextField.getText();
        String second = this.jSecondTextField.getText();
        if (month == null || month.length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_month_cannot_empty"));
            this.jMonthTextField.requestFocusInWindow();
            return false;
        }
        if (date == null || date.length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_date_cannot_empty"));
            this.jDateTextField.requestFocusInWindow();
            return false;
        }
        if (year == null || year.length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_year_cannot_empty"));
            this.jYearTextField.requestFocusInWindow();
            return false;
        }
        if (hour == null || hour.length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_hour_cannot_empty"));
            this.jHourTextField.requestFocusInWindow();
            return false;
        }
        if (minute == null || minute.length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_minute_cannot_empty"));
            this.jMinuteTextField.requestFocusInWindow();
            return false;
        }
        if (second == null || second.length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_second_cannot_empty"));
            this.jSecondTextField.requestFocusInWindow();
            return false;
        }
        try {
            this.iMonth = Integer.parseInt(month);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_month_is_invalid"));
            this.jMonthTextField.requestFocusInWindow();
            return false;
        }
        try {
            this.iDate = Integer.parseInt(date);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_date_is_invalid"));
            this.jDateTextField.requestFocusInWindow();
            return false;
        }
        try {
            this.iYear = Integer.parseInt(year);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_year_is_invalid"));
            this.jYearTextField.requestFocusInWindow();
            return false;
        }
        try {
            this.iHour = Integer.parseInt(hour);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_hour_is_invalid"));
            this.jHourTextField.requestFocusInWindow();
            return false;
        }
        try {
            this.iMinute = Integer.parseInt(minute);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_minute_is_invalid"));
            this.jMinuteTextField.requestFocusInWindow();
            return false;
        }
        try {
            this.iSecond = Integer.parseInt(second);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_second_is_invalid"));
            this.jSecondTextField.requestFocusInWindow();
            return false;
        }
        if (this.iMonth > 12 || this.iMonth < 1) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_month_is_out_of_range"));
            this.jMonthTextField.requestFocusInWindow();
            return false;
        }
        if (this.iDate > 31 || this.iDate < 1) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_date_is_out_of_range"));
            this.jDateTextField.requestFocusInWindow();
            return false;
        }
        if (this.iYear < 2000) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_year_cannot_below_then_2000"));
            this.jYearTextField.requestFocusInWindow();
            return false;
        }
        if (this.iHour > 23 || this.iHour < 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_hour_is_out_of_range"));
            this.jHourTextField.requestFocusInWindow();
            return false;
        }
        if (this.iMinute > 59 || this.iMinute < 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_minute_is_out_of_range"));
            this.jMinuteTextField.requestFocusInWindow();
            return false;
        }
        if (this.iSecond > 59 || this.iSecond < 0) {
            JOptionPane.showMessageDialog(this, L.t("cmm.dialog.utc.The_second_is_out_of_range"));
            this.jSecondTextField.requestFocusInWindow();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setData() {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiCMMOEMCommand);
        if (sessionController == null) {
            return false;
        }
        try {
            if (this.jUserSpecifiedRadioButton.isSelected()) {
                Calendar c2 = Calendar.getInstance();
                c2.set(this.iYear, this.iMonth - 1, this.iDate, this.iHour, this.iMinute, this.iSecond);
                ipmiCMMOEMCommand.setCMMTime(c2);
            } else if (this.isDHCP) {
                byte offset = (byte)this.jUTFOffsetComboBox.getSelectedIndex();
                ipmiCMMOEMCommand.setUTCOffset((byte)(offset - 11));
                ipmiCMMOEMCommand.setNTPMode();
            } else {
                String ntp2;
                String ntp1 = this.jPrimaryTimeServerTextField.getText();
                if (ntp1 == null || ntp1.length() == 0) {
                    ntp1 = "";
                }
                if ((ntp2 = this.jSecondaryTimeServerTextField.getText()) == null || ntp2.length() == 0) {
                    ntp2 = "";
                }
                byte offset = (byte)this.jUTFOffsetComboBox.getSelectedIndex();
                ipmiCMMOEMCommand.setAllNTPServer((byte)(offset - 11), ntp1, ntp2);
            }
        }
        catch (IPMIException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            sessionController.closeSession();
        }
        return true;
    }

    public void jReloadLabel_mouseClicked(MouseEvent e2) {
        this.setCursor(new Cursor(3));
        this.loadData();
        this.setCursor(new Cursor(0));
    }

    public void jReloadLabel_mouseEntered(MouseEvent e2) {
        this.jReloadLabel.setText(this.underLineString(this.resetStr));
        this.jReloadLabel.setCursor(new Cursor(12));
    }

    public void jReloadLabel_mouseExited(MouseEvent e2) {
        this.jReloadLabel.setText(this.htmlString(this.resetStr));
        this.jReloadLabel.setCursor(new Cursor(0));
    }
}

