/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.reStartTftpdIFace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class tftpd
extends JDialog {
    reStartTftpdIFace iface = null;
    JFileChooser fileChooser = new JFileChooser();
    myFilter filter = new myFilter();
    tftpDeamon tftpd;
    Vector vRecord = new Vector(10);
    JTable jLogTable = null;
    String filename;
    long filesize;
    DefaultTableModel dm;
    private JPanel jPanel1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JButton jButton1;
    private JLabel jStatus;
    private JPanel jLog;
    private JScrollPane jScrollPane1;
    private JButton jClearLog;
    private JPanel jPanel2;
    private JLabel jLabel10;
    private JLabel jBIOSName;
    private JButton jButton3;
    private JLabel jFileSize;
    private JLabel jLabel4;
    public static final int RRQ_PACKET = 1;
    public static final int WRQ_PACKET = 2;
    public static final int DATA_PACKET = 3;
    public static final int ACK_PACKET = 4;
    public static final int ERR_PACKET = 5;
    public static final int ERR_NO_ERROR = -1;
    public static final int ERR_NOT_DEFINED = 0;
    public static final int ERR_FILE_NOT_FOUND = 1;
    public static final int ERR_ACCESS_VIOLATION = 2;
    public static final int ERR_DISK_FULL = 3;
    public static final int ERR_ILLEGAL_OP = 4;
    public static final int ERR_UNKNOWN_TRANS_ID = 5;
    public static final int ERR_FILE_EXISTS = 6;
    public static final int ERR_NO_SUCH_USER = 7;
    public static final int ASCII_MODE = 1;
    public static final int OCTET_MODE = 2;
    public static final int UNKNOWN_MODE = 3;
    public static final int BLOCK_SIZE = 512;
    public static final int BEGIN = 1;
    public static final int RUNT_PACKET = 2;
    public static final int COMPLETE = 10;

    public tftpd(reStartTftpdIFace pface, boolean modal) {
        this.setModal(modal);
        this.iface = pface;
        this.initComponents();
        this.jStatus.setText("Status: STOP");
        this.getRootPane().setDefaultButton(this.jButton1);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jStatus = new JLabel();
        this.jLog = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jClearLog = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jBIOSName = new JLabel();
        this.jButton3 = new JButton();
        this.jFileSize = new JLabel();
        this.jLabel4 = new JLabel();
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.setTitle("BIOS Refresh Service");
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.jButton2.setText("Close");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                tftpd.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton2, new AbsoluteConstraints(150, 270, 90, -1));
        this.jLabel1.setText("Do not close this dialog until all transferring are done");
        this.jLabel1.setForeground(Color.red);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setFont(new Font("Dialog", 0, 14));
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(30, 300, 370, -1));
        this.jButton1.setText("Start");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                tftpd.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButton1, new AbsoluteConstraints(60, 270, 90, -1));
        this.jStatus.setText("Status: STOP");
        this.jStatus.setForeground(Color.blue);
        this.jPanel1.add((Component)this.jStatus, new AbsoluteConstraints(340, 260, 90, -1));
        this.jLog.setLayout(new BoxLayout(this.jLog, 0));
        this.jLog.setBorder(new TitledBorder("Log"));
        this.jLog.add(this.jScrollPane1);
        this.jPanel1.add((Component)this.jLog, new AbsoluteConstraints(10, 120, 420, 140));
        this.jClearLog.setText("Clear Log");
        this.jClearLog.setEnabled(false);
        this.jClearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                tftpd.this.jClearLogActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jClearLog, new AbsoluteConstraints(240, 270, -1, -1));
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.jPanel2.setBorder(new TitledBorder("Cab File to be downloaded"));
        this.jLabel10.setText("Cab File Name");
        this.jLabel10.setHorizontalAlignment(4);
        this.jPanel2.add((Component)this.jLabel10, new AbsoluteConstraints(20, 20, 100, -1));
        this.jBIOSName.setBorder(new EtchedBorder(0));
        this.jPanel2.add((Component)this.jBIOSName, new AbsoluteConstraints(130, 20, 200, 24));
        this.jButton3.setText("Browse");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                tftpd.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.jButton3, new AbsoluteConstraints(330, 20, -1, 24));
        this.jFileSize.setBorder(new EtchedBorder(0));
        this.jPanel2.add((Component)this.jFileSize, new AbsoluteConstraints(130, 50, 110, 24));
        this.jLabel4.setText("Cab File Size");
        this.jLabel4.setHorizontalAlignment(4);
        this.jPanel2.add((Component)this.jLabel4, new AbsoluteConstraints(10, 50, 110, -1));
        this.jPanel1.add((Component)this.jPanel2, new AbsoluteConstraints(10, 20, 420, 100));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(0, 0, 440, 330));
        this.pack();
    }

    private void jClearLogActionPerformed(ActionEvent evt) {
        this.vRecord.removeAllElements();
        while (this.dm.getRowCount() > 0) {
            this.dm.removeRow(0);
        }
        this.jClearLog.setEnabled(false);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.tftpd = new tftpDeamon();
        this.tftpd.start();
        this.jButton1.setEnabled(false);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        boolean open = false;
        String PathName = "";
        JOptionPane MBox = new JOptionPane();
        this.fileChooser.setFileFilter(this.filter);
        this.fileChooser.setFileSelectionMode(0);
        if (this.fileChooser.showOpenDialog(null) == 0) {
            PathName = this.fileChooser.getSelectedFile().getAbsolutePath();
            File xfi = new File(PathName);
            if (!xfi.exists()) {
                JOptionPane.showMessageDialog(this, "File does not exist!", "Error", 0);
                open = false;
            } else {
                this.jBIOSName.setText(PathName);
                this.filename = PathName;
                this.jFileSize.setText("" + xfi.length() + " bytes");
                this.filesize = xfi.length();
                this.jButton1.setEnabled(true);
            }
        }
    }

    public void closeService() {
        if (this.tftpd != null) {
            this.tftpd.shutdown();
            tftpDeamon moribund = this.tftpd;
            this.tftpd = null;
            moribund.interrupt();
        }
        this.iface.reStartTftpd();
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.closeService();
    }

    private void closeDialog(WindowEvent evt) {
        this.closeService();
    }

    private class myFilter
    extends FileFilter {
        private myFilter() {
        }

        @Override
        public boolean accept(File file) {
            String fileName = file.getName();
            return fileName.toUpperCase().endsWith(".CAB") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "cab file (*.cab)";
        }
    }

    public class ServiceThread
    extends Thread {
        BufferedInputStream fis = null;
        tftpDeamon server;
        DatagramSocket rec = null;
        DatagramPacket revPacket;
        DatagramPacket ackPacket;
        byte[] revBuffer;
        byte[] ackBuffer;
        DatagramPacket packet1;
        InetAddress peerAddr;
        int peerPort;
        int sourcePort;
        int state;
        int OPCode;
        int fileMode;
        int blockNumber = 0;
        int retransmits = 0;
        String mode;
        String[] xRecord = new String[3];
        int currRecord;

        public ServiceThread(tftpDeamon server, DatagramPacket dp) {
            this.server = server;
            this.packet1 = dp;
            this.peerAddr = dp.getAddress();
            this.peerPort = dp.getPort();
            this.sourcePort = 0;
            this.xRecord[0] = this.peerAddr.getHostAddress();
            this.xRecord[1] = this.peerAddr.getHostName();
            this.xRecord[2] = "Connected";
            this.currRecord = tftpd.this.vRecord.size();
            tftpd.this.vRecord.addElement(this.xRecord);
            if (this.currRecord == 0) {
                tftpd.this.dm = new DefaultTableModel(){

                    public Class getColumnClass(int col) {
                        switch (col) {
                            case 0: {
                                return String.class;
                            }
                            case 1: {
                                return String.class;
                            }
                            case 2: {
                                return String.class;
                            }
                        }
                        return Object.class;
                    }

                    @Override
                    public boolean isCellEditable(int row, int col) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object obj, int row, int col) {
                        super.setValueAt(obj, row, col);
                    }
                };
                String[] ColumnHead = new String[]{"Server IP", "Server Name", "Status"};
                tftpd.this.dm.setDataVector(new Object[][]{{this.xRecord[0], this.xRecord[1], this.xRecord[2]}}, ColumnHead);
                tftpd.this.jLogTable = new JTable(tftpd.this.dm);
                tftpd.this.jLogTable.setAutoResizeMode(4);
                tftpd.this.jScrollPane1.setViewportView(tftpd.this.jLogTable);
                TableColumn tc = tftpd.this.jLogTable.getColumn("Server IP");
                tc.setPreferredWidth(60);
                tc = tftpd.this.jLogTable.getColumn("Server Name");
                tc.setPreferredWidth(120);
                tc = tftpd.this.jLogTable.getColumn("Status");
                tc.setPreferredWidth(100);
            } else {
                tftpd.this.dm.addRow(this.xRecord);
            }
            this.buildPacketInfo(dp);
            this.revBuffer = new byte[528];
            this.ackBuffer = new byte[528];
        }

        @Override
        public void run() {
            this.xRecord[2] = "Start to download";
            this.state = 1;
            int setup = this.setupFileReader();
            if (setup != -1) {
                if (setup != 0) {
                    this.sendPacket(this.peerAddr, this.sourcePort, this.peerPort, 5, setup, new String("Could not open file " + tftpd.this.filename).getBytes(), null);
                }
                this.xRecord[2] = "Open file (" + tftpd.this.filename + ") error.";
                this.buildLogTable();
                this.terminate();
                return;
            }
            this.buildLogTable();
            this.blockNumber = 1;
            try {
                this.rec = new DatagramSocket(this.sourcePort);
                this.rec.setSoTimeout(10000);
            }
            catch (SocketException e2) {
                e2.printStackTrace();
            }
            this.revBuffer = this.readDataFromFile(512);
            if (this.revBuffer == null) {
                this.sendPacket(this.peerAddr, this.sourcePort, this.peerPort, 5, 0, new String("Could not read file " + tftpd.this.filename).getBytes(), this.rec);
                this.xRecord[2] = "Read file (" + tftpd.this.filename + ") error.";
                this.buildLogTable();
                this.terminate();
                return;
            }
            while (this.state != 10) {
                this.sendPacket(this.peerAddr, this.sourcePort, this.peerPort, 3, this.blockNumber, this.revBuffer, this.rec);
                this.xRecord[2] = "Sent Block #" + this.blockNumber + " (" + (long)(this.blockNumber * 100) / (tftpd.this.filesize / 512L + 1L) + "%)";
                this.buildLogTable();
                try {
                    this.ackPacket = new DatagramPacket(this.ackBuffer, this.ackBuffer.length);
                    this.receive(this.rec, this.ackPacket);
                    int inBlockNumber = this.GetBlockNumber(this.ackPacket.getData());
                    this.OPCode = this.GetOpcode(this.ackPacket.getData());
                    if (this.OPCode == 5) {
                        this.xRecord[2] = "NAck Block #" + inBlockNumber;
                        this.buildLogTable();
                        this.terminate();
                        return;
                    }
                    if (inBlockNumber != this.blockNumber) {
                        this.xRecord[2] = "Resend Block #" + this.blockNumber;
                        this.buildLogTable();
                        continue;
                    }
                }
                catch (InterruptedIOException ios) {
                    if (++this.retransmits <= 3) continue;
                    this.sendPacket(this.peerAddr, this.sourcePort, this.peerPort, 5, 0, new String("Retransmit limit exceeded").getBytes(), this.rec);
                    this.xRecord[2] = "Retransmit " + this.retransmits + " times failed";
                    this.buildLogTable();
                    this.terminate();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                if (this.state == 2) {
                    this.state = 10;
                    this.xRecord[2] = "Download Completed";
                    this.buildLogTable();
                    continue;
                }
                int rsize = this.readAvailable();
                this.revBuffer = this.readDataFromFile(512);
                if (rsize < 512) {
                    this.state = 2;
                }
                ++this.blockNumber;
            }
            this.terminate();
        }

        private void terminate() {
            this.sendPacket(this.peerAddr, this.sourcePort, this.peerPort, 5, 0, new String("Transmission canceled").getBytes(), this.rec);
            if (this.fis != null) {
                this.dismantleFileReader();
            }
            if (this.rec != null) {
                this.rec.close();
                this.rec = null;
            }
            this.state = 10;
        }

        private int setupFileReader() {
            File f2 = new File(tftpd.this.filename);
            if (!f2.exists()) {
                return 1;
            }
            if (!f2.canRead()) {
                return 2;
            }
            try {
                this.fis = new BufferedInputStream(new FileInputStream(f2));
            }
            catch (FileNotFoundException fnf) {
                this.badFile("Could not open file" + tftpd.this.filename);
                return 0;
            }
            return -1;
        }

        private void dismantleFileReader() {
            try {
                this.fis.close();
                this.fis = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void badFile(String message) {
            this.sendPacket(this.peerAddr, this.sourcePort, this.peerPort, 5, this.blockNumber, message.getBytes(), null);
        }

        private void buildLogTable() {
            int numdone = 0;
            tftpd.this.vRecord.setElementAt(this.xRecord, this.currRecord);
            tftpd.this.jLogTable.setValueAt(this.xRecord[2], this.currRecord, 2);
            for (int i2 = 0; i2 < tftpd.this.vRecord.size(); ++i2) {
                if (((String[])tftpd.this.vRecord.get(i2))[2].compareToIgnoreCase("Download Completed") != 0 && ((String[])tftpd.this.vRecord.get(i2))[2].compareToIgnoreCase("Retransmit 4 times failed") != 0) continue;
                ++numdone;
            }
            if (numdone == tftpd.this.vRecord.size()) {
                tftpd.this.jStatus.setText("Status: Waiting");
                tftpd.this.jClearLog.setEnabled(true);
            } else {
                tftpd.this.jStatus.setText("Status: Serving");
                tftpd.this.jClearLog.setEnabled(false);
            }
        }

        private void buildPacketInfo(DatagramPacket inpacket) {
            byte[] data = inpacket.getData();
            this.OPCode = this.GetOpcode(data);
            if (this.OPCode == 1) {
                this.mode = new String("octet");
            }
            this.fileMode = 2;
        }

        public void sendPacket(InetAddress destAddr, int sourcePort, int destPort, int opcode, int blockNumber, byte[] data, DatagramSocket inSock) {
            byte[] rv;
            if (data != null || opcode != 5 || blockNumber < 0 || blockNumber < 8) {
                // empty if block
            }
            int refSize = data != null ? data.length : 0;
            switch (opcode) {
                case 3: {
                    rv = new byte[refSize + 4];
                    break;
                }
                case 4: {
                    rv = new byte[4];
                    break;
                }
                case 5: {
                    rv = new byte[refSize + 5];
                    break;
                }
                default: {
                    rv = null;
                }
            }
            if (rv == null) {
                return;
            }
            rv[0] = (byte)(opcode >> 8 & 0xFF);
            rv[1] = (byte)(opcode & 0xFF);
            rv[2] = (byte)(blockNumber >> 8 & 0xFF);
            rv[3] = (byte)(blockNumber & 0xFF);
            switch (opcode) {
                case 1: {
                    rv = null;
                    break;
                }
                case 2: {
                    rv = null;
                    break;
                }
                case 3: {
                    int i2;
                    for (i2 = 0; i2 < refSize; ++i2) {
                        rv[4 + i2] = data[i2];
                    }
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    int i2;
                    for (i2 = 0; i2 < refSize; ++i2) {
                        rv[4 + i2] = data[i2];
                    }
                    rv[rv.length - 1] = 0;
                }
            }
            try {
                DatagramSocket ds = inSock == null ? new DatagramSocket(sourcePort) : inSock;
                DatagramPacket dp = new DatagramPacket(rv, rv.length, destAddr, destPort);
                ds.send(dp);
                if (inSock == null) {
                    ds.close();
                    ds = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        public void receive(DatagramSocket rec, DatagramPacket pack) throws InterruptedIOException, IOException {
            if (rec != null) {
                try {
                    rec.receive(pack);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        }

        private byte[] readDataFromFile(int len) {
            int useLen = Math.min(this.readAvailable(), len);
            if (useLen >= 0 && this.fis != null) {
                byte[] rv = new byte[useLen];
                try {
                    this.fis.read(rv, 0, useLen);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return null;
                }
                return rv;
            }
            return null;
        }

        private int readAvailable() {
            if (this.fis == null) {
                return -1;
            }
            try {
                return this.fis.available();
            }
            catch (IOException ioe) {
                return -1;
            }
        }

        public int GetBlockNumber(byte[] data) {
            return data[2] << 8 & 0xFF00 | data[3] & 0xFF;
        }

        private int GetOpcode(byte[] data) {
            return (data[0] << 8 | data[1]) & 0xFFFF;
        }
    }

    public class tftpDeamon
    extends Thread {
        DatagramSocket tftpdsocket;
        DatagramPacket incoming;
        int defaultPort = 69;
        boolean running;
        Vector serviceThreadList = new Vector(10);
        int len;
        static final int PACKETSIZE = 528;

        public tftpDeamon() {
            try {
                this.tftpdsocket = new DatagramSocket(this.defaultPort);
                this.incoming = new DatagramPacket(new byte[528], 528);
            }
            catch (SocketException se) {
                JOptionPane MBox = new JOptionPane();
                JOptionPane.showMessageDialog(null, "Cannot create service socket on port 69! Start failed!", "Error", 2);
                tftpd.this.jStatus.setText("Status: STOP");
                return;
            }
            tftpd.this.jStatus.setText("Status: Waiting");
        }

        @Override
        public void run() {
            System.out.println("tftpd run");
            this.running = true;
            this.serviceThreadList.removeAllElements();
            while (this.running) {
                try {
                    this.tftpdsocket.receive(this.incoming);
                    if (!this.running) continue;
                    ServiceThread ct = new ServiceThread(this, this.incoming);
                    System.out.println("new serviceThread");
                    this.serviceThreadList.addElement(ct);
                    ct.start();
                }
                catch (IOException iOException) {}
            }
        }

        public void shutdown() {
            this.running = false;
            while (!this.serviceThreadList.isEmpty()) {
                ServiceThread ct = (ServiceThread)this.serviceThreadList.get(0);
                ct.terminate();
                this.serviceThreadList.removeElementAt(0);
            }
            if (this.tftpdsocket != null) {
                this.tftpdsocket.close();
            }
        }
    }
}

