/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.ByteUtility;
import IPMIView20.Logger;
import IPMIView20.trap.Trap;
import IPMIView20.trap.TrapCollector;
import IPMIView20.trap.TrapReceiverListener;
import com.supermicro.ipmi.GlobalDefine;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;

public class Receiver {
    ArrayList trapReceiverListeners;
    TrapCollector trapCollector;
    BerDecoder berDecoder = new BerDecoder();
    GlobalDefine gd = new GlobalDefine();

    public Receiver() {
        this.trapReceiverListeners = new ArrayList();
        this.trapCollector = new TrapCollector();
    }

    public void addTrapReceiverListener(TrapReceiverListener l) {
        this.trapReceiverListeners.add(l);
    }

    public void removeTrapReceiverListener(TrapReceiverListener l) {
        this.trapReceiverListeners.remove(l);
    }

    public TrapCollector getTrapCollector() {
        return this.trapCollector;
    }

    public ArrayList getTrapReceiverListeners() {
        return this.trapReceiverListeners;
    }

    public void setTrapCollector(TrapCollector trapCollector) {
        this.trapCollector = trapCollector;
    }

    public void setTrapReceiverListeners(ArrayList trapReceiverListeners) {
        this.trapReceiverListeners = trapReceiverListeners;
    }

    public boolean startReceiver() {
        try {
            TrapListener trapListener = new TrapListener();
            trapListener.setTrapCollector(this.trapCollector);
            trapListener.setTrapReceiverListeners(this.trapReceiverListeners);
            trapListener.start();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public void stopReceiver() {
        byte[] buff = new byte[]{0};
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        DatagramPacket dp = new DatagramPacket(buff, 1, ia, 162);
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.send(dp);
        }
        catch (SocketException ex1) {
        }
        catch (IOException ex1) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Logger.displayLog = true;
        Receiver r = new Receiver();
        boolean b2 = r.startReceiver();
        if (b2) {
            System.out.println("start Receiver successful");
        } else {
            System.out.println("start Receiver failed");
        }
        try {
            Thread.sleep(10000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Trap decodeTrap(byte[] databuff, int datalength) throws Exception {
        int offset = 0;
        Trap trap = new Trap();
        offset = this.getMessagePreamble(trap, databuff, offset);
        offset = this.getPDUHeader(trap, databuff, offset);
        offset = this.getPDUBody(trap, databuff, offset, datalength);
        trap.copyDataBuff(databuff);
        trap.setDataLength(datalength);
        return trap;
    }

    private int getMessagePreamble(Trap trap, byte[] databuff, int offset) throws Exception {
        try {
            offset = this.getMessageLength(trap, this.berDecoder.parseHeader(databuff, offset));
            offset = this.getMessageVersion(trap, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getCommunity(trap, this.berDecoder.parseString(databuff, offset));
        }
        catch (AsnDecodingException ae) {
            ae.printStackTrace();
            throw ae;
        }
        return offset;
    }

    private void printData(Object[] data) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (data[i2] instanceof Integer) {
                System.out.print(ByteUtility.byteToHex((byte)((Integer)data[i2]).intValue()) + " ");
                continue;
            }
            if (data[i2] instanceof Byte) {
                System.out.print(ByteUtility.byteToHex((byte)((Byte)data[i2]).intValue()) + " ");
                continue;
            }
            System.out.print("**");
        }
        System.out.println("");
    }

    private int getPDUHeader(Trap trap, byte[] databuff, int offset) throws Exception {
        try {
            offset = this.getPDUType(trap, this.berDecoder.parseHeader(databuff, offset));
            offset = this.getEnterpriseMIB(trap, this.berDecoder.parseObjectId(databuff, offset));
            offset = this.getAgentIP(trap, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getGTrapType(trap, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getSTrapType(trap, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getTimeStamp(trap, this.berDecoder.parseUInteger64(databuff, offset));
        }
        catch (AsnDecodingException ae) {
            ae.printStackTrace();
            throw ae;
        }
        return offset;
    }

    private int getPDUBody(Trap trap, byte[] databuff, int offset, int datalength) throws Exception {
        try {
            offset = this.getLengthBind(trap, this.berDecoder.parseHeader(databuff, offset));
            while (offset < datalength) {
                offset = this.getBindLength(trap, this.berDecoder.parseHeader(databuff, offset));
                offset = this.getBind(trap, databuff, offset);
            }
        }
        catch (AsnDecodingException ae) {
            ae.printStackTrace();
            throw ae;
        }
        return offset;
    }

    private int getMessageLength(Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Message Length: " + xx);
        Logger.writeLog(string);
        trap.setMessageLength(Integer.parseInt("" + xx));
        xx = (Integer)value[0];
        return xx;
    }

    private int getMessageVersion(Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Message Version: v" + (xx + 1));
        Logger.writeLog(string);
        xx = (Integer)value[0];
        return xx;
    }

    private int getCommunity(Trap trap, Object[] value) {
        ByteArrayOutputStream strout = new ByteArrayOutputStream();
        try {
            strout.write((byte[])value[2]);
        }
        catch (IOException ie) {
            // empty catch block
        }
        String yy = strout.toString();
        String string = new String("Community: " + yy);
        Logger.writeLog(string);
        trap.setCommunity(yy);
        int xx = (Integer)value[0];
        return xx;
    }

    private int getPDUType(Trap trap, Object[] value) {
        byte zz = (Byte)value[1];
        String string = zz == -92 ? new String("Type: Trap") : new String("Type: unknown");
        int xx = (Integer)value[2];
        string = new String("length: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getEnterpriseMIB(Trap trap, Object[] value) {
        String string = new String("");
        int[] xx = (int[])value[2];
        int xxl = xx.length;
        string = "" + xx[0];
        for (int i2 = 1; i2 < xxl; ++i2) {
            string = string + "." + xx[i2];
        }
        trap.setEnterprise(string);
        string = new String("Enterprise: " + string);
        Logger.writeLog(string);
        int yy = (Integer)value[0];
        return yy;
    }

    private int getAgentIP(Trap trap, Object[] value) {
        String string = new String("");
        int xx = (Integer)value[2];
        StringBuffer buf = new StringBuffer();
        buf.append(xx >> 24 & 0xFF);
        buf.append('.');
        buf.append(xx >> 16 & 0xFF);
        buf.append('.');
        buf.append(xx >> 8 & 0xFF);
        buf.append('.');
        buf.append(xx & 0xFF);
        trap.setIp(buf.toString());
        string = new String("Agent IP: " + buf);
        Logger.writeLog(string);
        xx = (Integer)value[0];
        return xx;
    }

    private int getGTrapType(Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Generic Trap Type: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getSTrapType(Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        if ((xx & 0x80) == 128) {
            trap.setAssertionType(1);
        } else {
            trap.setAssertionType(0);
        }
        trap.setEventSensorType((byte)(xx >> 16));
        trap.setEventType((byte)(xx >> 8));
        trap.setEventOffset((byte)xx);
        String string = new String("Specific Trap Type: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getTimeStamp(Trap trap, Object[] value) {
        long yy = ((BigInteger)value[2]).longValue();
        String string = new String("Timeticks : " + yy);
        Logger.writeLog(string);
        int xx = (Integer)value[0];
        return xx;
    }

    private int getLengthBind(Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Total Length of Variable Binding: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getBindLength(Trap trap, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Length of Binding: " + xx);
        xx = (Integer)value[0];
        return xx;
    }

    private int getBind(Trap trap, byte[] databuff, int offset) {
        Object[] value = new Object[3];
        String string = new String("");
        try {
            value = this.berDecoder.parseObjectId(databuff, offset);
            int[] xx = (int[])value[2];
            int xxl = xx.length;
            string = "" + xx[0];
            for (int i2 = 1; i2 < xxl; ++i2) {
                string = string + "." + xx[i2];
            }
            trap.setOid(string);
            string = new String("OID: " + string);
            offset = (Integer)value[0];
            value = this.berDecoder.parseString(databuff, offset);
            if (string.compareTo("OID: 1.3.6.1.4.1.3183.1.1.1") == 0) {
                this.parsePET(trap, (byte[])value[2]);
            } else {
                ByteArrayOutputStream strout = new ByteArrayOutputStream();
                try {
                    strout.write((byte[])value[2]);
                }
                catch (IOException ie) {
                    // empty catch block
                }
                String yy = strout.toString();
                string = new String("Value: " + yy);
                trap.setDescription(string);
            }
            offset = (Integer)value[0];
        }
        catch (AsnDecodingException ae) {
            // empty catch block
        }
        return offset;
    }

    private void parsePET(Trap trap, byte[] value) {
        ByteArrayOutputStream strout = new ByteArrayOutputStream();
        byte[] b2 = new byte[4];
        System.arraycopy(value, 18, b2, 0, 4);
        long localTimeStamp = ByteUtility.fourBytesToLong(b2);
        SimpleTimeZone stz = new SimpleTimeZone(0, "PST");
        SimpleDateFormat f2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss EEE");
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(0L);
        c2.add(1, 28);
        c2.add(13, (int)localTimeStamp);
        Date d2 = c2.getTime();
        f2.setTimeZone(stz);
        trap.setTime(f2.format(d2));
        byte[] eventData = null;
        byte genericOffset = 0;
        byte sensorNumber = 0;
        int length = 0;
        byte recordType = 0;
        byte sensorType = 0;
        long timeStamp = 0L;
        byte[] sensorName = null;
        String description = null;
        for (int j2 = 46; j2 < value.length; ++j2) {
            if ((value[j2] & 0xFF) != 128) continue;
            eventData = new byte[3];
            System.arraycopy(value, 31, eventData, 0, 3);
            genericOffset = (byte)(eventData[0] & 0xF);
            sensorNumber = value[28];
            length = value[j2 + 1] & 0x3F;
            if (length < 0) continue;
            recordType = value[j2 + 2];
            sensorType = value[j2 + 3];
            sensorName = new byte[length];
            if (trap.getEventSensorType() == -36) {
                description = GlobalDefine.LookupMEEventType(sensorNumber, trap.getEventType(), trap.getEventOffset(), eventData[0], eventData[1], eventData[2]);
                trap.setSensor(GlobalDefine.LookupMESensor(sensorNumber));
            } else if (sensorType == 1 || sensorType == 2 || sensorType == 3 || sensorType == 4) {
                description = GlobalDefine.LookupEventType((byte)1, genericOffset);
                System.arraycopy(value, j2 + 4, sensorName, 0, length);
                trap.setSensor(new String(sensorName));
            } else {
                description = GlobalDefine.LookupSensorType(sensorType, eventData[0], eventData[1], eventData[2]);
                System.arraycopy(value, j2 + 4, sensorName, 0, length);
                trap.setSensor(new String(sensorName));
            }
            String str = "[ " + new String(sensorName) + " ] " + description;
            Logger.writeLog(str);
            trap.setDescription(description);
            break;
        }
        String string = "";
        boolean quota = false;
        boolean square = false;
        for (int i2 = 0; i2 < value.length; ++i2) {
            if (value[i2] < 32 || value[i2] > 126) {
                if (!square) {
                    if (quota) {
                        string = string + "\"";
                        quota = false;
                    }
                    string = string + "[";
                    square = true;
                }
                string = string + "x" + new String(Integer.toHexString(this.byteToInt(value[i2]))).toUpperCase();
                continue;
            }
            if (!quota) {
                if (square) {
                    string = string + "]";
                    square = false;
                }
                string = string + "\"";
                quota = true;
            }
            strout.write(value, i2, 1);
            String yy = strout.toString();
            string = string + yy;
        }
        if (square) {
            string = string + "]";
        }
        if (quota) {
            string = string + "\"";
        }
    }

    public int byteToInt(byte b2) {
        return b2 < 0 ? 256 + b2 : b2;
    }

    public class AsnDecodingException
    extends Exception {
        public AsnDecodingException() {
        }

        public AsnDecodingException(String why) {
            super(why);
        }
    }

    public class BerDecoder {
        private static final byte LONG_LENGTH = -128;
        private static final byte HIGH_BIT = -128;
        private static final byte EXTENSION_ID = 31;
        private static final byte CONSTRUCTOR = 32;

        public Object[] ASNDecode(byte[] databuff, int[] startoffset) {
            Object[] rVar;
            int n = startoffset[0];
            startoffset[0] = n + 1;
            switch (databuff[n]) {
                case 2: {
                    rVar = new Object[1];
                    break;
                }
                default: {
                    rVar = new Object[2];
                }
            }
            return rVar;
        }

        protected int byteToInt(byte b2) {
            return b2 < 0 ? 256 + b2 : b2;
        }

        protected long byteToLong(byte b2) {
            return b2 < 0 ? 256L + (long)b2 : (long)b2;
        }

        protected boolean isConstructor(byte b2) {
            return (b2 & 0x20) == 32;
        }

        protected boolean isExtensionId(byte b2) {
            return (b2 & 0x1F) == 31;
        }

        public Object[] parseLength(byte[] buf, int startOffset) throws AsnDecodingException {
            byte numBytes;
            if (buf.length - startOffset < 1) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            Object[] retVals = new Object[2];
            if (((numBytes = buf[startOffset++]) & 0xFFFFFF80) == 0) {
                numBytes = (byte)(numBytes & 0x7F);
                retVals[1] = new Integer(this.byteToInt(numBytes));
            } else if ((numBytes = (byte)(numBytes & 0x7F)) == 1) {
                if (buf.length - startOffset < 1) {
                    throw new AsnDecodingException("Buffer underflow error");
                }
                retVals[1] = new Integer(this.byteToInt(buf[startOffset++]));
            } else if (numBytes == 2) {
                if (buf.length - startOffset < 2) {
                    throw new AsnDecodingException("Buffer underflow error");
                }
                int val = this.byteToInt(buf[startOffset++]) << 8 | this.byteToInt(buf[startOffset++]);
                retVals[1] = new Integer(val);
            } else {
                throw new AsnDecodingException("Invalid ASN.1 length");
            }
            retVals[0] = new Integer(startOffset);
            return retVals;
        }

        public Object[] parseHeader(byte[] buf, int startOffset) throws AsnDecodingException {
            byte asnType;
            if (buf.length - startOffset < 1) {
                throw new AsnDecodingException("Insufficent buffer length");
            }
            if (this.isExtensionId(asnType = buf[startOffset++])) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            Object[] lenVals = this.parseLength(buf, startOffset);
            Object[] rVals = new Object[]{lenVals[0], new Byte(asnType), lenVals[1]};
            return rVals;
        }

        public Object[] parseInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength > 4) {
                throw new AsnDecodingException("Integer too large: cannot decode. asnLength =" + asnLength);
            }
            int asnValue = 0;
            if ((buf[startOffset] & 0xFFFFFF80) == -128) {
                asnValue = -1;
            }
            while (asnLength-- > 0) {
                asnValue = asnValue << 8 | this.byteToInt(buf[startOffset++]);
            }
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Integer(asnValue)};
            return rVals;
        }

        public Object[] parseUInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength > 5) {
                throw new AsnDecodingException("Integer too large: cannot decode");
            }
            long asnValue = 0L;
            if ((buf[startOffset] & 0xFFFFFF80) == -128) {
                asnValue = -1L;
            }
            while (asnLength-- > 0) {
                asnValue = asnValue << 8 | this.byteToLong(buf[startOffset++]);
            }
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Long(asnValue &= 0xFFFFFFFFL)};
            return rVals;
        }

        public Object[] parseUInteger64(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength > 9) {
                throw new AsnDecodingException("Integer too large: cannot decode");
            }
            byte[] asnBuf = new byte[asnLength];
            for (int i2 = 0; i2 < asnLength; ++i2) {
                asnBuf[i2] = buf[startOffset++];
            }
            BigInteger asnValue = new BigInteger(asnBuf);
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, asnValue};
            return rVals;
        }

        public Object[] parseNull(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            if ((Integer)hdrVals[2] != 0) {
                throw new AsnDecodingException("Malformed ASN.1 Type");
            }
            Object[] rVals = new Object[]{hdrVals[0], hdrVals[1]};
            return rVals;
        }

        public Object[] parseString(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Insufficent buffer length");
            }
            byte[] opaque = new byte[asnLength];
            try {
                this.copy(buf, startOffset, opaque, 0, asnLength);
            }
            catch (ArrayIndexOutOfBoundsException err) {
                throw new AsnDecodingException("Buffer underflow exception");
            }
            Object[] rVals = new Object[]{new Integer(startOffset + asnLength), asnType, opaque};
            return rVals;
        }

        public Object[] parseObjectId(byte[] buf, int startOffset) throws AsnDecodingException {
            int[] retOids;
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength == 0) {
                int[] ids = new int[2];
                ids[1] = 0;
                ids[0] = 0;
                Object[] rVals = new Object[]{new Integer(startOffset), asnType, ids};
                return rVals;
            }
            int idsOff = 0;
            int[] ids = new int[asnLength + 1];
            --asnLength;
            int oid = this.byteToInt(buf[startOffset++]);
            ids[idsOff++] = oid / 40;
            ids[idsOff++] = oid % 40;
            while (asnLength > 0) {
                oid = 0;
                boolean done = false;
                do {
                    --asnLength;
                    byte b2 = buf[startOffset++];
                    oid = oid << 7 | b2 & 0x7F;
                    if ((b2 & 0xFFFFFF80) != 0) continue;
                    done = true;
                } while (!done);
                ids[idsOff++] = oid;
            }
            if (idsOff == ids.length) {
                retOids = ids;
            } else {
                retOids = new int[idsOff];
                this.copy(ids, 0, retOids, 0, idsOff);
            }
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, retOids};
            return rVals;
        }

        protected void copy(byte[] src, int srcOff, byte[] dest, int destOff, int bytesToCopy) throws ArrayIndexOutOfBoundsException {
            if (dest.length - destOff < bytesToCopy || src.length - srcOff < bytesToCopy) {
                throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
            }
            for (int x = bytesToCopy - 1; x >= 0; --x) {
                dest[destOff + x] = src[srcOff + x];
            }
        }

        protected void copy(int[] src, int srcOff, int[] dest, int destOff, int intsToCopy) throws ArrayIndexOutOfBoundsException {
            if (dest.length - destOff < intsToCopy || src.length - srcOff < intsToCopy) {
                throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
            }
            for (int x = intsToCopy - 1; x >= 0; --x) {
                dest[destOff + x] = src[srcOff + x];
            }
        }
    }

    private class TrapListener
    extends Thread {
        protected DatagramSocket socket = new DatagramSocket(162);
        protected BufferedReader in = null;
        protected boolean KeepWaiting = true;
        ArrayList trapReceiverListeners = new ArrayList();
        TrapCollector trapCollector = new TrapCollector();

        public void setTrapReceiverListeners(ArrayList trapReceiverListeners) {
            this.trapReceiverListeners = trapReceiverListeners;
        }

        public void setTrapCollector(TrapCollector trapCollector) {
            this.trapCollector = trapCollector;
        }

        @Override
        public void run() {
            byte[] bufin = new byte[256];
            try {
                this.socket.setSoTimeout(5000);
            }
            catch (SocketException e2) {
                e2.printStackTrace();
            }
            while (this.KeepWaiting) {
                try {
                    DatagramPacket packet = new DatagramPacket(bufin, bufin.length);
                    this.socket.receive(packet);
                    int dataLength = packet.getLength();
                    if (dataLength == 1 && bufin[0] == 0) break;
                    Trap trap = null;
                    trap = Receiver.this.decodeTrap(bufin, dataLength);
                    for (TrapReceiverListener item : this.trapReceiverListeners) {
                        item.action(trap);
                    }
                    this.trapCollector.put(trap);
                }
                catch (IOException e3) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.socket.close();
        }

        public void stopTR() {
            this.KeepWaiting = false;
        }
    }
}

