/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.trap.TrapViewFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

class SplashWindow
extends Window {
    ImageIcon splashIm = new ImageIcon(TrapViewFrame.class.getResource("Warn.gif"));
    String msg1;
    String msg2;
    String msg3;
    int width = 400;
    int height = 80;
    WatchDog watchDog;

    public SplashWindow(Frame parent, String msg1, String msg2, String msg3) {
        super(parent);
        this.setSize(this.width, this.height);
        this.msg1 = msg1;
        this.msg2 = msg2;
        this.msg3 = msg3;
        this.watchDog = new WatchDog(this, 10);
        this.watchDog.start();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle winDim = this.getBounds();
        this.setLocation((screenDim.width - winDim.width) / 2, (screenDim.height - winDim.height) / 2);
        this.setVisible(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                SplashWindow.this.hide();
                SplashWindow.this.showParent();
            }
        });
    }

    public void showParent() {
        this.getParent().setVisible(true);
    }

    public void setMessage(String msg1, String msg2, String msg3) {
        this.msg1 = msg1;
        this.msg2 = msg2;
        this.msg3 = msg3;
    }

    public void setWatchDogTime(int time) {
        this.watchDog.reset();
        this.watchDog.setcountLimit(time);
    }

    @Override
    public void paint(Graphics g2) {
        if (this.splashIm != null) {
            g2.setColor(new Color(204, 204, 255));
            g2.fillRect(0, 0, this.width, this.height);
            g2.setColor(Color.lightGray);
            g2.drawLine(0, 0, this.width - 1, 0);
            g2.drawLine(0, 0, 0, this.height - 1);
            g2.setColor(Color.GRAY);
            g2.drawLine(this.width - 1, this.height - 1, this.width - 1, 0);
            g2.drawLine(this.width - 1, this.height - 1, 0, this.height - 1);
            g2.drawImage(this.splashIm.getImage(), 20, 20, this);
            g2.setFont(Font.getFont("Arrial"));
            g2.setColor(Color.black);
            g2.drawString(this.msg1, 70, 20);
            g2.drawString(this.msg2, 70, 40);
            g2.drawString(this.msg3, 70, 60);
        }
    }

    class WatchDog
    extends Thread {
        SplashWindow w;
        int count = 0;
        int countLimit = 0;

        public WatchDog(SplashWindow w, int countLimit) {
            this.w = w;
            this.countLimit = countLimit;
        }

        public void setcountLimit(int countLimit) {
            this.countLimit = countLimit;
        }

        public void reset() {
            this.count = 0;
        }

        public void timeUp() {
            this.w.hide();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.count;
                if (this.count != this.countLimit) continue;
                this.timeUp();
            }
        }
    }
}

