/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.update;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Observable;
import java.util.StringTokenizer;

public class FTPConnection
extends Observable {
    public long fileSize = 0L;
    private static boolean PRINT_DEBUG_INFO = false;
    private Socket connectionSocket = null;
    private PrintStream outputStream = null;
    private BufferedReader inputStream = null;
    private long restartPoint = 0L;
    private boolean loggedIn = false;
    public String lineTerm = "\n";
    private static int BLOCK_SIZE = 4096;

    public FTPConnection() {
    }

    public FTPConnection(boolean debugOut) {
        PRINT_DEBUG_INFO = debugOut;
    }

    private void debugPrint(String message) {
        if (PRINT_DEBUG_INFO) {
            System.err.println(message);
        }
    }

    public boolean connect(String host) throws UnknownHostException, IOException {
        return this.connect(host, 21);
    }

    public boolean connect(String host, int port) throws UnknownHostException, IOException {
        this.connectionSocket = new Socket(host, port);
        this.outputStream = new PrintStream(this.connectionSocket.getOutputStream());
        this.inputStream = new BufferedReader(new InputStreamReader(this.connectionSocket.getInputStream()));
        if (!this.isPositiveCompleteResponse(this.getServerReply())) {
            this.disconnect();
            return false;
        }
        return true;
    }

    public void disconnect() {
        if (this.outputStream != null) {
            try {
                if (this.loggedIn) {
                    this.logout();
                }
                this.outputStream.close();
                this.inputStream.close();
                this.connectionSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = null;
            this.inputStream = null;
            this.connectionSocket = null;
        }
    }

    public boolean login(String username, String password) throws IOException {
        int response = this.executeCommand("user " + username);
        if (!this.isPositiveIntermediateResponse(response)) {
            return false;
        }
        response = this.executeCommand("pass " + password);
        this.loggedIn = this.isPositiveCompleteResponse(response);
        return this.loggedIn;
    }

    public boolean logout() throws IOException {
        int response = this.executeCommand("quit");
        this.loggedIn = !this.isPositiveCompleteResponse(response);
        return !this.loggedIn;
    }

    public boolean changeDirectory(String directory) throws IOException {
        int response = this.executeCommand("cwd " + directory);
        return this.isPositiveCompleteResponse(response);
    }

    public boolean renameFile(String oldName, String newName) throws IOException {
        int response = this.executeCommand("rnfr " + oldName);
        if (!this.isPositiveIntermediateResponse(response)) {
            return false;
        }
        response = this.executeCommand("rnto " + newName);
        return this.isPositiveCompleteResponse(response);
    }

    public boolean makeDirectory(String directory) throws IOException {
        int response = this.executeCommand("mkd " + directory);
        return this.isPositiveCompleteResponse(response);
    }

    public boolean removeDirectory(String directory) throws IOException {
        int response = this.executeCommand("rmd " + directory);
        return this.isPositiveCompleteResponse(response);
    }

    public boolean parentDirectory() throws IOException {
        int response = this.executeCommand("cdup");
        return this.isPositiveCompleteResponse(response);
    }

    public boolean deleteFile(String fileName) throws IOException {
        int response = this.executeCommand("dele " + fileName);
        return this.isPositiveCompleteResponse(response);
    }

    public String getCurrentDirectory() throws IOException {
        String response = this.getExecutionResponse("pwd");
        StringTokenizer strtok = new StringTokenizer(response);
        if (strtok.countTokens() < 2) {
            return null;
        }
        strtok.nextToken();
        String directoryName = strtok.nextToken();
        int strlen = directoryName.length();
        if (strlen == 0) {
            return null;
        }
        if (directoryName.charAt(0) == '\"') {
            directoryName = directoryName.substring(1);
            --strlen;
        }
        if (directoryName.charAt(strlen - 1) == '\"') {
            return directoryName.substring(0, strlen - 1);
        }
        return directoryName;
    }

    public String getSystemType() throws IOException {
        return this.excludeCode(this.getExecutionResponse("syst"));
    }

    public long getModificationTime(String fileName) throws IOException {
        String response = this.excludeCode(this.getExecutionResponse("mdtm " + fileName));
        try {
            return Long.parseLong(response);
        }
        catch (Exception e2) {
            return -1L;
        }
    }

    public long getFileSize(String fileName) throws IOException {
        String response = this.excludeCode(this.getExecutionResponse("size " + fileName));
        try {
            return Long.parseLong(response);
        }
        catch (Exception e2) {
            return -1L;
        }
    }

    public boolean downloadFile(String fileName) throws IOException {
        return this.readDataToFile("retr " + fileName, fileName);
    }

    public boolean downloadFile(String serverPath, String localPath) throws IOException {
        return this.readDataToFile("retr " + serverPath, localPath);
    }

    public boolean uploadFile(String fileName) throws IOException {
        return this.writeDataFromFile("stor " + fileName, fileName);
    }

    public boolean uploadFile(String serverPath, String localPath) throws IOException {
        return this.writeDataFromFile("stor " + serverPath, localPath);
    }

    public void setRestartPoint(int point) {
        this.restartPoint = point;
        this.debugPrint("Restart noted");
    }

    private int getServerReply() throws IOException {
        return Integer.parseInt(this.getFullServerReply().substring(0, 3));
    }

    private String getFullServerReply() throws IOException {
        String reply;
        do {
            reply = this.inputStream.readLine();
            this.debugPrint(reply);
        } while (!Character.isDigit(reply.charAt(0)) || !Character.isDigit(reply.charAt(1)) || !Character.isDigit(reply.charAt(2)) || reply.charAt(3) != ' ');
        return reply;
    }

    private String getFullServerReply(StringBuffer fullReply) throws IOException {
        String reply;
        fullReply.setLength(0);
        do {
            reply = this.inputStream.readLine();
            this.debugPrint(reply);
            fullReply.append(reply + this.lineTerm);
        } while (!Character.isDigit(reply.charAt(0)) || !Character.isDigit(reply.charAt(1)) || !Character.isDigit(reply.charAt(2)) || reply.charAt(3) != ' ');
        if (fullReply.length() > 0) {
            fullReply.setLength(fullReply.length() - this.lineTerm.length());
        }
        return reply;
    }

    public String listFiles() throws IOException {
        return this.listFiles("");
    }

    public String listFiles(String params) throws IOException {
        StringBuffer files = new StringBuffer();
        StringBuffer dirs = new StringBuffer();
        if (!this.getAndParseDirList(params, files, dirs)) {
            this.debugPrint("Error getting file list");
        }
        return files.toString();
    }

    public String listSubdirectories() throws IOException {
        return this.listSubdirectories("");
    }

    public String listSubdirectories(String params) throws IOException {
        StringBuffer files = new StringBuffer();
        StringBuffer dirs = new StringBuffer();
        if (!this.getAndParseDirList(params, files, dirs)) {
            this.debugPrint("Error getting dir list");
        }
        return dirs.toString();
    }

    private String processFileListCommand(String command) throws IOException {
        StringBuffer reply = new StringBuffer();
        boolean success = this.executeDataCommand(command, reply);
        if (!success) {
            return "";
        }
        String replyString = reply.toString();
        if (reply.length() > 0) {
            return replyString.substring(0, reply.length() - 1);
        }
        return replyString;
    }

    private boolean getAndParseDirList(String params, StringBuffer files, StringBuffer dirs) throws IOException {
        files.setLength(0);
        dirs.setLength(0);
        String shortList = this.processFileListCommand("nlst " + params);
        String longList = this.processFileListCommand("list " + params);
        StringTokenizer sList = new StringTokenizer(shortList, "\n");
        StringTokenizer lList = new StringTokenizer(longList, "\n");
        while (sList.hasMoreTokens() && lList.hasMoreTokens()) {
            String sString = sList.nextToken();
            String lString = lList.nextToken();
            if (lString.length() <= 0) continue;
            if (lString.startsWith("d")) {
                dirs.append(sString.trim() + this.lineTerm);
                this.debugPrint("Dir: " + sString);
                continue;
            }
            if (lString.startsWith("-")) {
                files.append(sString.trim() + this.lineTerm);
                this.debugPrint("File: " + sString);
                continue;
            }
            this.debugPrint("Unknown: " + lString);
        }
        if (files.length() > 0) {
            files.setLength(files.length() - this.lineTerm.length());
        }
        if (dirs.length() > 0) {
            dirs.setLength(dirs.length() - this.lineTerm.length());
        }
        return true;
    }

    public int executeCommand(String command) throws IOException {
        this.outputStream.println(command);
        return this.getServerReply();
    }

    public String getExecutionResponse(String command) throws IOException {
        this.outputStream.println(command);
        return this.getFullServerReply();
    }

    public boolean readDataToFile(String command, String fileName) throws IOException {
        RandomAccessFile outfile = new RandomAccessFile(fileName, "rw");
        if (this.restartPoint != 0L) {
            this.debugPrint("Seeking to " + this.restartPoint);
            outfile.seek(this.restartPoint);
        }
        FileOutputStream fileStream = new FileOutputStream(outfile.getFD());
        boolean success = this.executeDataCommand(command, fileStream);
        outfile.close();
        return success;
    }

    public boolean writeDataFromFile(String command, String fileName) throws IOException {
        RandomAccessFile infile = new RandomAccessFile(fileName, "r");
        if (this.restartPoint != 0L) {
            this.debugPrint("Seeking to " + this.restartPoint);
            infile.seek(this.restartPoint);
        }
        FileInputStream fileStream = new FileInputStream(infile.getFD());
        boolean success = this.executeDataCommand(command, fileStream);
        infile.close();
        return success;
    }

    public boolean executeDataCommand(String command, OutputStream out) throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        if (!this.setupDataPort(command, serverSocket)) {
            return false;
        }
        Socket clientSocket = serverSocket.accept();
        InputStream in = clientSocket.getInputStream();
        this.transferData(in, out);
        in.close();
        clientSocket.close();
        serverSocket.close();
        return this.isPositiveCompleteResponse(this.getServerReply());
    }

    public boolean executeDataCommand(String command, InputStream in) throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        if (!this.setupDataPort(command, serverSocket)) {
            return false;
        }
        Socket clientSocket = serverSocket.accept();
        OutputStream out = clientSocket.getOutputStream();
        this.transferData(in, out);
        out.close();
        clientSocket.close();
        serverSocket.close();
        return this.isPositiveCompleteResponse(this.getServerReply());
    }

    public boolean executeDataCommand(String command, StringBuffer sb) throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        if (!this.setupDataPort(command, serverSocket)) {
            return false;
        }
        Socket clientSocket = serverSocket.accept();
        InputStream in = clientSocket.getInputStream();
        this.transferData(in, sb);
        in.close();
        clientSocket.close();
        serverSocket.close();
        return this.isPositiveCompleteResponse(this.getServerReply());
    }

    private void transferData(InputStream in, OutputStream out) throws IOException {
        byte[] b2 = new byte[BLOCK_SIZE];
        int amount = 0;
        int total = 0;
        while ((amount = in.read(b2)) > 0) {
            out.write(b2, 0, amount);
            if (this.fileSize == 0L) continue;
            int percent = (int)((double)(total += amount) / (double)this.fileSize * 100.0);
            this.setChanged();
            this.notifyObservers(new Integer(percent));
        }
    }

    private void transferData(InputStream in, StringBuffer sb) throws IOException {
        int amount;
        byte[] b2 = new byte[BLOCK_SIZE];
        while ((amount = in.read(b2)) > 0) {
            sb.append(new String(b2, 0, amount));
        }
    }

    private boolean setupDataPort(String command, ServerSocket serverSocket) throws IOException {
        if (!this.openPort(serverSocket)) {
            return false;
        }
        this.outputStream.println("type i");
        if (!this.isPositiveCompleteResponse(this.getServerReply())) {
            this.debugPrint("Could not set transfer type");
            return false;
        }
        if (this.restartPoint != 0L) {
            this.outputStream.println("rest " + this.restartPoint);
            this.restartPoint = 0L;
            this.getServerReply();
        }
        this.outputStream.println(command);
        return this.isPositivePreliminaryResponse(this.getServerReply());
    }

    private boolean openPort(ServerSocket serverSocket) throws IOException {
        InetAddress localip;
        int localport = serverSocket.getLocalPort();
        InetAddress inetaddress = serverSocket.getInetAddress();
        try {
            localip = inetaddress.getLocalHost();
        }
        catch (UnknownHostException e2) {
            this.debugPrint("Can't get local host");
            return false;
        }
        byte[] addrbytes = localip.getAddress();
        short[] addrshorts = new short[4];
        for (int i2 = 0; i2 <= 3; ++i2) {
            addrshorts[i2] = addrbytes[i2];
            if (addrshorts[i2] >= 0) continue;
            int n = i2;
            addrshorts[n] = (short)(addrshorts[n] + 256);
        }
        this.outputStream.println("port " + addrshorts[0] + "," + addrshorts[1] + "," + addrshorts[2] + "," + addrshorts[3] + "," + ((localport & 0xFF00) >> 8) + "," + (localport & 0xFF));
        return this.isPositiveCompleteResponse(this.getServerReply());
    }

    private boolean isPositivePreliminaryResponse(int response) {
        return response >= 100 && response < 200;
    }

    private boolean isPositiveIntermediateResponse(int response) {
        return response >= 300 && response < 400;
    }

    private boolean isPositiveCompleteResponse(int response) {
        return response >= 200 && response < 300;
    }

    private boolean isTransientNegativeResponse(int response) {
        return response >= 400 && response < 500;
    }

    private boolean isPermanentNegativeResponse(int response) {
        return response >= 500 && response < 600;
    }

    private String excludeCode(String response) {
        if (response.length() < 5) {
            return response;
        }
        return response.substring(4);
    }

    public static void main(String[] args) {
        FTPConnection connection = new FTPConnection();
        try {
            if (connection.connect("ftp.supermicro.com.tw")) {
                if (connection.login("", "")) {
                    long size;
                    connection.fileSize = size = connection.getFileSize("IPMIView20-linux.bak");
                    connection.downloadFile("IPMIView20-linux.bak");
                    System.out.println("size =" + size);
                }
                connection.disconnect();
            }
        }
        catch (UnknownHostException e2) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("done");
    }
}

