/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.SMCUtil;
import com.ami.iusb.protocol.CDROMProtocol;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CDROMRedir
extends Thread {
    JViewerApp app;
    private PacketMaster packetMaster;
    private CDROMProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean physicalDrive;
    private boolean running = false;
    private boolean stopRunning = false;
    private long nativeReaderPointer = -1L;
    private Thread redirThread;
    private String sourceCDROM = null;
    private int nBytesRedirected = 0;
    private static final int PORT = 5120;
    private static final int START_LOCAL_IMAGE_REDIRECTION = 240;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    public static final int AUTH_CMD = 242;
    private static final int TRANSFER_CMD = 243;
    private static final int CONNECTION_ACCEPTED = 1;
    private static final int CONNECTION_DENIED = 2;
    private static final int LOGIN_FAILED = 3;
    private static final int CONNECTION_IN_USE = 4;
    private static final int CONNECTION_PERM_DENIED = 5;
    private static final int OTHER_ERROR = 6;
    private static final int MEDIA_IN_DETACH_STATE = 7;
    private static final int MAX_READ_SECTORS = 64;
    private static final int MAX_READ_SIZE = 131072;

    public CDROMRedir(boolean bl, JViewerApp jViewerApp) {
        this.app = jViewerApp;
        this.physicalDrive = bl;
        this.protocol = new CDROMProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(0x800000);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131133);
    }

    private void cdromConnect(String string, int n, boolean bl) throws IOException {
        this.packetMaster = new PacketMaster(string, n, false, this.protocol, bl);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        this.packetMaster.connect();
    }

    private void cdromDisconnect() {
        try {
            this.packetMaster.close();
        }
        catch (IOException iOException) {
            System.err.println(LocaleStrings.GetString("4_2_CDROMREDIR") + iOException.getMessage());
        }
    }

    public boolean startRedirection(String string, int n, boolean bl, String string2, String string3) throws RedirectionException {
        block15: {
            if (this.running) {
                return true;
            }
            try {
                this.cdromConnect(string, n, bl);
                this.SendAuth_SessionToken(string2);
                Debug.out.println("waiting to receive request");
                IUSBSCSI iUSBSCSI = this.recvRequest();
                Debug.out.println("out of receive request");
                if (iUSBSCSI.opcode == 241) {
                    if (iUSBSCSI.connectionStatus != 1) {
                        this.cdromDisconnect();
                        if (iUSBSCSI.connectionStatus == 5) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_3_CDROMREDIR"));
                        } else if (iUSBSCSI.connectionStatus == 7) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_10_CDROMREDIR"));
                        } else if (iUSBSCSI.connectionStatus == 3) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_11_CDROMREDIR"));
                        } else if (iUSBSCSI.m_otherIP != null) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_4_CDROMREDIR") + iUSBSCSI.m_otherIP);
                        } else {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_5_CDROMREDIR"));
                        }
                        return false;
                    }
                    break block15;
                }
                this.cdromDisconnect();
                throw new RedirProtocolException(LocaleStrings.GetString("4_6_CDROMREDIR") + iUSBSCSI.opcode);
            }
            catch (IOException iOException) {
                Debug.out.println("Exception CDROMRedir:startRedirection");
                throw new RedirectionException(iOException.getMessage());
            }
        }
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(this.physicalDrive);
        }
        this.sourceCDROM = string3;
        if (!this.openCDROM(string3)) {
            System.err.println(LocaleStrings.GetString("4_7_CDROMREDIR"));
            this.deleteCDROMReader();
            this.cdromDisconnect();
            return false;
        }
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        this.running = true;
        return true;
    }

    public boolean stopRedirection() {
        if (this.running) {
            this.stopRunning = true;
            try {
                this.packetMaster.wakeup();
                this.redirThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.err.println(LocaleStrings.GetString("4_8_CDROMREDIR"));
            }
            this.cdromDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeCDROM();
            this.deleteCDROMReader();
        }
        this.nBytesRedirected = 0;
        return true;
    }

    private IUSBSCSI recvRequest() throws IOException, RedirectionException {
        return (IUSBSCSI)this.packetMaster.receivePacket();
    }

    public boolean isRedirActive() {
        return this.running;
    }

    public void stopRedirectionAbnormal() {
        if (this.running) {
            this.stopRunning = true;
            this.cdromDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeCDROM();
            this.deleteCDROMReader();
            this.app.reportCDROMAbnormal();
        }
    }

    @Override
    public void run() {
        int n = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI iUSBSCSI = this.recvRequest();
                if (iUSBSCSI == null) continue;
                int n2 = this.executeCDROMSCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                this.packetWriteBuffer.limit(n2);
                IUSBSCSI iUSBSCSI2 = new IUSBSCSI(this.packetWriteBuffer, true);
                this.packetMaster.sendPacket(iUSBSCSI2);
                this.nBytesRedirected += (n += n2) / 1024;
                n %= 1024;
            }
            catch (IOException iOException) {
                if (this.stopRunning) continue;
                this.stopRedirectionAbnormal();
                this.handleError(iOException.getMessage());
                return;
            }
            catch (RedirectionException redirectionException) {
                if (this.stopRunning) continue;
                this.stopRedirectionAbnormal();
                this.handleError(redirectionException.getMessage());
                return;
            }
        }
        Debug.out.println("Exiting the CDROM/ISO Redirection thread");
    }

    public String[] getCDROMList() throws RedirectionException {
        if (!this.physicalDrive) {
            this.DisplayErrorMsg(LocaleStrings.GetString("4_9_CDROMREDIR"));
            return null;
        }
        String[] stringArray = null;
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(true);
            stringArray = this.listCDROMDrives();
            this.deleteCDROMReader();
        }
        return stringArray;
    }

    public String getLIBCDROMVersion() {
        String string;
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(false);
            string = this.getVersion();
            this.deleteCDROMReader();
        } else {
            string = this.getVersion();
        }
        return string;
    }

    public void DisplayErrorMsg(String string) {
        this.app.generalErrorMessage(string);
    }

    public void handleError(String string) {
        this.DisplayErrorMsg(string);
    }

    public boolean isPhysicalDevice() {
        return this.physicalDrive;
    }

    public String getSourceDrive() {
        return this.sourceCDROM;
    }

    public void SendAuth_SessionToken(String string) throws RedirectionException, IOException {
        int n = 128;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(160);
        IUSBHeader iUSBHeader = IUSBHeader.createCDROMHeader(n);
        iUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(string.getBytes());
        this.packetWriteBuffer.position(0);
        IUSBSCSI iUSBSCSI = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(iUSBSCSI);
    }

    public void sendTransferCmd() throws RedirectionException, IOException {
        int n = 30;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(62);
        IUSBHeader iUSBHeader = IUSBHeader.createCDROMHeader(n);
        iUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-13);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.position(0);
        IUSBSCSI iUSBSCSI = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(iUSBSCSI);
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    private native String[] listCDROMDrives();

    private native void newCDROMReader(boolean var1);

    private native void deleteCDROMReader();

    private native boolean openCDROM(String var1);

    private native void closeCDROM();

    private native int executeCDROMSCSICmd(ByteBuffer var1, ByteBuffer var2);

    private native String getVersion();

    static {
        String string = System.getProperty("os.name");
        File file = string.startsWith("Windows") ? new File("javacdromwrapper.dll") : new File("libjavacdromwrapper.so");
        if (file.exists()) {
            try {
                System.loadLibrary("javacdromwrapper");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println(LocaleStrings.GetString("4_1_CDROMREDIR"));
            }
        } else {
            try {
                SMCUtil.loadLib("javacdromwrapper");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

