/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.util.HashMap;

public class SMCVMManager {
    private static SMCVMManager instance = new SMCVMManager();
    public HashMap<String, IUSBRedirSession> hosts = new HashMap();
    public HashMap<String, String> tokens = new HashMap();

    private SMCVMManager() {
    }

    public static SMCVMManager getInstance() {
        return instance;
    }

    public IUSBRedirSession createIUSBRedirSession(String string) {
        if (this.hosts.get(string) != null) {
            return this.hosts.get(string);
        }
        JDummyViewerApp jDummyViewerApp = new JDummyViewerApp(null);
        IUSBRedirSession iUSBRedirSession = new IUSBRedirSession(jDummyViewerApp);
        jDummyViewerApp.setIUSBRedirSession(iUSBRedirSession);
        this.hosts.put(string, iUSBRedirSession);
        return iUSBRedirSession;
    }

    public String helpGetKVMSessionToken(String string, String string2, String string3) throws Exception {
        if (this.tokens.get(string) != null) {
            return this.tokens.get(string);
        }
        IPMIInterfaceConfig iPMIInterfaceConfig = new IPMIInterfaceConfig();
        iPMIInterfaceConfig.setIp(string);
        iPMIInterfaceConfig.setUserName(string2);
        iPMIInterfaceConfig.setPassword(string3);
        iPMIInterfaceConfig.setPrivilege((byte)4);
        ISessionController iSessionController = IPMIVersion.getSessionController(iPMIInterfaceConfig);
        IPMIAMIOEMCommand iPMIAMIOEMCommand = new IPMIAMIOEMCommand(null);
        IPMINetworkInterface iPMINetworkInterface = iSessionController.startup(iPMIInterfaceConfig);
        if (iPMINetworkInterface == null) {
            throw new Exception("Can't login");
        }
        iPMIAMIOEMCommand.setIPMIInterface(iPMINetworkInterface);
        String string4 = iPMIAMIOEMCommand.getKVMSessionToken();
        iSessionController.closeSession();
        this.tokens.put(string, string4);
        return string4;
    }

    public void clearToken(String string) {
        this.tokens.remove(string);
    }

    public void clearAllTokens() {
        this.tokens.clear();
    }

    public void clearIUSBRedirSession(String string) {
        this.hosts.remove(string);
    }

    public void clearAllIUSBRedirSession() {
        this.hosts.clear();
    }

    public static void main(String[] stringArray) {
        String string = "192.168.12.177";
        String string2 = "ADMIN";
        String string3 = "ADMIN";
        try {
            SMCVMManager sMCVMManager = SMCVMManager.getInstance();
            IUSBRedirSession iUSBRedirSession = sMCVMManager.createIUSBRedirSession(string);
            String string4 = sMCVMManager.helpGetKVMSessionToken(string, string2, string3);
            boolean bl = iUSBRedirSession.simpleStartFloppyImageRedir(string, string4, "C:\\DOS50.img");
            System.out.println(bl);
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class JDummyViewerApp
    extends JViewerApp {
        IUSBRedirSession usbRedireSession;
        boolean isDebug = true;

        public JDummyViewerApp(IUSBRedirSession iUSBRedirSession) {
            this.usbRedireSession = iUSBRedirSession;
        }

        public void setIUSBRedirSession(IUSBRedirSession iUSBRedirSession) {
            this.usbRedireSession = iUSBRedirSession;
        }

        @Override
        public void generalErrorMessage(String string) {
            if (this.isDebug) {
                System.out.println(string);
            }
        }

        @Override
        public void reportFloppyAbnormal() {
            this.usbRedireSession.stopFloppyAbnormal();
        }

        @Override
        public void reportCDROMAbnormal() {
            this.usbRedireSession.stopCDROMAbnormal();
        }
    }
}

