/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.IUSBRedirSession;
import com.ami.iusb.SMCVMManager;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.CommandPlugIn;
import com.supermicro.ipmi.text.MOut;

public class SMCVMPlugIn
extends CommandPlugIn {
    public SMCVMPlugIn() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"floppy", "usbkey", "iso", "cd", "stopFloppy", "stopUsbkey", "stopCD", "stopISO", "status"};
    }

    @Override
    public void execute() throws Exception {
        if (!this.isVirutalMediaSupported()) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        if (this.parameters == null || this.parameters.length == 0) {
            this.usage();
            return;
        }
        String string = this.parameters[0];
        if (string.equalsIgnoreCase("floppy")) {
            if (this.parameters.length < 2) {
                this.usage();
                return;
            }
            this.setFloppy(this.parameters[1]);
        } else if (string.equalsIgnoreCase("usbkey")) {
            if (this.parameters.length < 2) {
                this.usage();
                return;
            }
            this.setUSBKey(this.parameters[1]);
        } else if (string.equalsIgnoreCase("iso")) {
            if (this.parameters.length < 2) {
                this.usage();
                return;
            }
            this.setISO(this.parameters[1]);
        } else if (string.equalsIgnoreCase("cd")) {
            if (this.parameters.length < 2) {
                this.usage();
                return;
            }
            this.setCD(this.parameters[1]);
        } else if (string.equalsIgnoreCase("stopFloppy")) {
            this.stopFloppy();
        } else if (string.equalsIgnoreCase("stopUsbkey")) {
            this.stopFloppy();
        } else if (string.equalsIgnoreCase("stopCD")) {
            this.stopCD();
        } else if (string.equalsIgnoreCase("stopISO")) {
            this.stopCD();
        } else if (string.equalsIgnoreCase("status") || string.equalsIgnoreCase("st")) {
            try {
                this.showStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.usage();
            return;
        }
    }

    public boolean isVirutalMediaSupported() {
        byte[] byArray = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (byArray == null) {
            return false;
        }
        if (IPMIMessagingCommand.isAMIGUID(byArray)) {
            return true;
        }
        return IPMIMessagingCommand.isAMISIMBLGUID(byArray);
    }

    public void printSlaveCMMUnavailableMessage() {
        MOut.G().println("This function is unavailable for this device");
    }

    public void usage() {
        MOut.G().printf("Available commands:\n", new Object[0]);
        MOut.G().printf("%-25s \t %-20s \n", "vmw floppy <image file>", "Floppy image as virtual media");
        MOut.G().printf("%-25s \t %-20s \n", "vmw usbkey <drive letter>", "USB key as virutal media");
        MOut.G().printf("%-25s \t %-20s \n", "vmw iso    <ISO file>", "ISO file as virtual media");
        MOut.G().printf("%-25s \t %-20s \n", "vmw cd     <drive letter>", "CD/DVD drive as virutal media");
        MOut.G().printf("%-25s \t %-20s \n", "vmw stopFloppy", "Stop connected floppy");
        MOut.G().printf("%-25s \t %-20s \n", "vmw stopUsbkey", "Stop connected USBKey");
        MOut.G().printf("%-25s \t %-20s \n", "vmw stopISO", "Stop connected ISO");
        MOut.G().printf("%-25s \t %-20s \n", "vmw stopCD", "Stop connected CD/DVD");
        MOut.G().printf("%-25s \t %-20s \n", "vmw status(st)", "Virtual Media status");
        MOut.G().println("Note:");
        MOut.G().println("1: These virtual media functions are dediated for SIMSOW series IPMI device");
        MOut.G().println("2: If your path include space, please place double quote");
        MOut.G().println("   at begin and end of <file>");
        MOut.G().println("3: The drive redirection will stop once you quit shell mode");
    }

    private IUSBRedirSession getIUSBRedirSession() {
        String string = this.config.getIp();
        IUSBRedirSession iUSBRedirSession = SMCVMManager.getInstance().createIUSBRedirSession(string);
        return iUSBRedirSession;
    }

    private String getToken() throws Exception {
        String string = this.config.getIp();
        String string2 = this.config.getUserName();
        String string3 = this.config.getPassword();
        String string4 = SMCVMManager.getInstance().helpGetKVMSessionToken(string, string2, string3);
        return string4;
    }

    public void setFloppy(String string) throws Exception {
        MOut.G().printf("Connecting ...", new Object[0]);
        String string2 = this.getToken();
        boolean bl = this.getIUSBRedirSession().simpleStartFloppyImageRedir(this.config.getIp(), string2, string);
        if (bl) {
            MOut.G().println("Done");
        }
    }

    public void setUSBKey(String string) throws Exception {
        string = string.toUpperCase();
        MOut.G().printf("Connecting ...", new Object[0]);
        String string2 = this.getToken();
        boolean bl = this.getIUSBRedirSession().simpleStartFloppyRedir(this.config.getIp(), string2, string);
        if (bl) {
            MOut.G().println("Done");
        }
    }

    public void setISO(String string) throws Exception {
        MOut.G().printf("Connecting ...", new Object[0]);
        String string2 = this.getToken();
        boolean bl = this.getIUSBRedirSession().simpleStartISORedir(this.config.getIp(), string2, string);
        if (bl) {
            MOut.G().println("Done");
        }
    }

    public void setCD(String string) throws Exception {
        string = string.toUpperCase();
        MOut.G().printf("Connecting ...", new Object[0]);
        String string2 = this.getToken();
        boolean bl = this.getIUSBRedirSession().simpleStartCDROMRedir(this.config.getIp(), string2, string);
        if (bl) {
            MOut.G().println("Done");
        }
    }

    public void stopFloppy() throws Exception {
        MOut.G().printf("Disconnecting ...", new Object[0]);
        this.getIUSBRedirSession().StopFloppyRedir();
        MOut.G().println("Done");
    }

    public void stopCD() throws Exception {
        MOut.G().printf("Disconnecting ...", new Object[0]);
        this.getIUSBRedirSession().StopCDROMRedir();
        MOut.G().println("Done");
    }

    public void showStatus() {
        if (SMCVMManager.getInstance().hosts.size() == 0) {
            MOut.G().println("empty");
        }
        for (String string : SMCVMManager.getInstance().hosts.keySet()) {
            IUSBRedirSession iUSBRedirSession = SMCVMManager.getInstance().hosts.get(string);
            this.showStatus(string, iUSBRedirSession);
        }
    }

    private void showStatus(String string, IUSBRedirSession iUSBRedirSession) {
        String string2 = iUSBRedirSession.getFloppyReadBytes() + "KB";
        String string3 = iUSBRedirSession.getFloppySource();
        String string4 = "";
        switch (iUSBRedirSession.getFloppyRedirStatus()) {
            case 0: {
                string4 = "Not Connected";
                string2 = "n/a";
                break;
            }
            case 1: {
                string4 = "Connected";
                break;
            }
            case 2: {
                string4 = "Transfering";
            }
        }
        String string5 = iUSBRedirSession.getCDROMReadBytes() + "KB";
        String string6 = iUSBRedirSession.getCDROMSource();
        String string7 = "";
        switch (iUSBRedirSession.getCDROMRedirStatus()) {
            case 0: {
                string7 = "Not Connected";
                string5 = "n/a";
                break;
            }
            case 1: {
                string7 = "Connected";
                break;
            }
            case 2: {
                string7 = "Transfering";
            }
        }
        MOut.G().println("\nIP           : " + string);
        MOut.G().println("Target Drive : Virtual Floppy");
        MOut.G().println("Read Bytes   : " + string2);
        MOut.G().println("Status       : " + string4);
        MOut.G().println("Connected to : " + string3);
        MOut.G().println("");
        MOut.G().println("Target Drive : Virtual CD");
        MOut.G().println("Read Bytes   : " + string5);
        MOut.G().println("Status       : " + string7);
        MOut.G().println("Connected to : " + string6);
    }

    @Override
    public String getAlternateValue() {
        return null;
    }

    @Override
    public String getComment() {
        return "SIM(W) Virtual Media";
    }

    @Override
    public String getName() {
        return "vmw";
    }

    @Override
    public String getValue() {
        return "vmw";
    }

    @Override
    public boolean isSupportCLIMode() {
        return false;
    }

    @Override
    public boolean isSupportShellMode() {
        return true;
    }

    public static void main(String[] stringArray) {
    }
}

