/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.EncryptionException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.RedirPacket;
import com.ami.iusb.protocol.RedirProtocol;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class PacketMaster {
    private SocketChannel packetSock;
    private Selector packetSel;
    private RedirProtocol protocol;
    private boolean sslEncryption;
    private SSLEngine engine;
    private SSLSession session;
    private ByteBuffer netIn;
    private ByteBuffer netOut;
    private ByteBuffer appIn;
    private ByteBuffer appOut;
    private boolean debug = false;
    private static final int RECEIVE_TIMEOUT = 60;
    private String host;
    private int port;
    private boolean blocking;
    private boolean wakeup = false;
    private static final int IUSB_HDR_SIZE = 32;

    public PacketMaster(String string, int n, boolean bl, RedirProtocol redirProtocol, boolean bl2) {
        this.host = string;
        this.port = n;
        this.blocking = bl;
        this.protocol = redirProtocol;
        this.sslEncryption = bl2;
        if (bl2) {
            this.CreateSSLEngine();
            if (this.engine == null) {
                System.out.println("engine = null");
            } else {
                this.session = this.engine.getSession();
            }
        }
    }

    public void setupBuffers(int n, int n2) {
        if (this.sslEncryption) {
            this.appIn = ByteBuffer.allocateDirect(n);
            this.appOut = ByteBuffer.allocateDirect(n2);
            this.netIn = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netOut = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.debugOut("Allocating SSL network buffers and application buffers");
            this.debugOut("Allocated netOut buffer of " + this.netOut.capacity() + " bytes");
            this.debugOut("Allocated appOut buffer of " + this.appOut.capacity() + " bytes");
            this.debugOut("Allocated netIn buffer of " + this.netIn.capacity() + " bytes");
            this.debugOut("Allocated appIn buffer of " + this.appIn.capacity() + " bytes");
        } else {
            this.netIn = ByteBuffer.allocateDirect(n);
            this.netOut = ByteBuffer.allocateDirect(n2);
            this.appIn = this.netIn;
            this.appOut = this.netOut;
            this.debugOut("No SSL, allocating only netIn and netOut...");
            this.debugOut("Allocated netOut buffer of " + this.netOut.capacity() + " bytes");
            this.debugOut("Allocated netIn buffer of " + this.netIn.capacity() + " bytes");
        }
    }

    public void setupBuffers(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (this.sslEncryption) {
            this.appIn = byteBuffer;
            this.appOut = byteBuffer2;
            this.netIn = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netOut = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netIn.order(ByteOrder.LITTLE_ENDIAN);
            this.netOut.order(ByteOrder.LITTLE_ENDIAN);
            this.appIn.clear();
            this.appOut.clear();
            this.debugOut("Using SSL, allocating netIn and netOut buffers");
            this.debugOut("Using provided appIn and appOut buffers");
        } else {
            this.netIn = byteBuffer;
            this.netOut = byteBuffer2;
            this.appIn = this.netIn;
            this.appOut = this.netOut;
            this.netIn.clear();
            this.netOut.clear();
            this.debugOut("No SSL, using provided buffers exclusively");
        }
    }

    public void setBufferEndianness(ByteOrder byteOrder, ByteOrder byteOrder2) {
        this.appIn.order(byteOrder);
        this.appOut.order(byteOrder2);
    }

    public void connect() throws IOException {
        try {
            this.packetSock = SocketChannel.open(new InetSocketAddress(this.host, this.port));
        }
        catch (UnresolvedAddressException unresolvedAddressException) {
            throw new IOException(LocaleStrings.GetString("8_1_PACKETMAST") + this.host);
        }
        if (!this.blocking) {
            this.packetSock.configureBlocking(false);
        }
        this.packetSock.socket().setTcpNoDelay(true);
        this.packetSel = Selector.open();
        this.packetSock.register(this.packetSel, 1);
        if (this.sslEncryption) {
            this.initSSL();
        }
    }

    private void CreateSSLEngine() {
        SSLContext sSLContext = null;
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            SSLContext sSLContext2 = SSLContext.getInstance("SSL");
            sSLContext2.init(null, trustManagerArray, new SecureRandom());
            sSLContext = sSLContext2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println(LocaleStrings.GetString("8_2_PACKETMAST") + noSuchAlgorithmException.getMessage());
        }
        catch (KeyManagementException keyManagementException) {
            System.err.println(LocaleStrings.GetString("8_3_PACKETMAST") + keyManagementException.getMessage());
        }
        this.engine = sSLContext.createSSLEngine();
        this.engine.setUseClientMode(true);
    }

    private void initSSL() throws IOException {
        try {
            this.engine.beginHandshake();
            while (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                Runnable runnable;
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    Debug.out.println("######## NEED_WRAP ################\n");
                    Debug.out.println("appOut.position=" + this.appOut.position());
                    this.netOut.clear();
                    Debug.out.println("Wrapping: " + this.engine.wrap(this.appOut, this.netOut));
                    this.netOut.flip();
                    Debug.out.println("Wrote " + this.packetSock.write(this.netOut) + " bytes");
                    continue;
                }
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    Debug.out.println("######## NEED_UNWRAP ################\n");
                    if (this.netIn.position() == 0) {
                        Debug.out.println("Read " + this.packetSock.read(this.netIn) + " bytes");
                    }
                    this.netIn.flip();
                    Debug.out.println("Unwrapping: " + this.engine.unwrap(this.netIn, this.appIn));
                    this.netIn.compact();
                    Debug.out.println("netIn.position(): " + this.netIn.position());
                    continue;
                }
                if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                Debug.out.println("######## NEED_TASK ################\n");
                while ((runnable = this.engine.getDelegatedTask()) != null) {
                    runnable.run();
                }
            }
        }
        catch (SSLException sSLException) {
            System.err.println(LocaleStrings.GetString("8_4_PACKETMAST") + sSLException.getMessage());
        }
        this.debugOut("Handshaking is complete!");
    }

    public void close() throws IOException {
        this.packetSock.close();
        this.packetSel.close();
    }

    public void wakeup() {
        this.wakeup = true;
        this.packetSel.wakeup();
    }

    public void sendPacket(RedirPacket redirPacket) throws IOException, EncryptionException {
        this.appOut.clear();
        this.netOut.clear();
        redirPacket.writePacket(this.appOut);
        this.appOut.flip();
        if (this.engine != null) {
            while (this.appOut.hasRemaining()) {
                this.netOut.clear();
                SSLEngineResult sSLEngineResult = this.engine.wrap(this.appOut, this.netOut);
                this.netOut.flip();
                while (this.netOut.hasRemaining() && this.packetSock.write(this.netOut) != -1) {
                }
            }
        } else {
            while (this.netOut.hasRemaining() && this.packetSock.write(this.netOut) != -1) {
            }
        }
    }

    public RedirPacket receivePacket(boolean bl) throws IOException, RedirectionException {
        int n = 0;
        RedirPacket redirPacket = null;
        if (this.appIn.position() != 0) {
            this.appIn.flip();
            redirPacket = this.protocol.getPacket(this.appIn);
            if (redirPacket == null) {
                this.appIn.position(this.appIn.limit());
                this.appIn.limit(this.appIn.capacity());
            } else {
                this.debugOut("Got a packet!");
            }
        }
        while (redirPacket == null) {
            if (!this.packetSock.isOpen()) {
                throw new IOException(LocaleStrings.GetString("8_5_PACKETMAST"));
            }
            int n2 = this.packetSel.select(60000L);
            if (this.wakeup) {
                this.wakeup = false;
                return null;
            }
            if (n2 > 0) {
                Iterator<SelectionKey> iterator = this.packetSel.selectedKeys().iterator();
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                n = this.packetSock.read(this.netIn);
                if (n < 0) {
                    throw new IOException(LocaleStrings.GetString("8_5_PACKETMAST"));
                }
            } else {
                if (this.isConnectionAlive()) continue;
                this.close();
                throw new RedirectionException(LocaleStrings.GetString("8_6_PACKETMAST"));
            }
            this.debugOut("Read " + this.netIn.position() + " bytes");
            if (this.engine != null) {
                this.netIn.flip();
                SSLEngineResult sSLEngineResult = this.engine.unwrap(this.netIn, this.appIn);
                if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                    this.netIn.compact();
                } else {
                    this.netIn.position(this.netIn.limit());
                    this.netIn.limit(this.netIn.capacity());
                }
            }
            this.appIn.flip();
            redirPacket = this.protocol.getPacket(this.appIn);
            if (redirPacket == null) {
                this.debugOut("Can't build a packet from input data");
                this.appIn.position(this.appIn.limit());
                this.appIn.limit(this.appIn.capacity());
                continue;
            }
            this.debugOut("Got a packet!");
        }
        if (bl) {
            this.appIn.compact();
        }
        return redirPacket;
    }

    public RedirPacket receivePacket(boolean bl, boolean bl2) throws IOException, RedirectionException {
        Object object;
        int n;
        RedirPacket redirPacket = null;
        this.netIn.limit(32);
        this.netIn.position(0);
        int n2 = 32;
        int n3 = 0;
        while (n3 < n2) {
            n = this.packetSel.select(60000L);
            if (this.wakeup) {
                this.wakeup = false;
                this.debugOut("(Header ) wakeup is true ");
                return null;
            }
            if (n > 0) {
                Iterator<SelectionKey> iterator = this.packetSel.selectedKeys().iterator();
                object = iterator.next();
                iterator.remove();
                int n4 = this.packetSock.read(this.netIn);
                this.debugOut("Read " + n4 + " bytes");
                if (n4 <= 0) continue;
                n3 += n4;
                continue;
            }
            if (this.isConnectionAlive()) continue;
            this.close();
            throw new RedirectionException(LocaleStrings.GetString("8_6_PACKETMAST"));
        }
        this.netIn.position(0);
        n = this.protocol.getDataLen(this.appIn);
        if (n < 0) {
            this.debugOut("Data size is less than zero");
            return null;
        }
        if (n > 0) {
            this.netIn.limit(32 + n);
            this.netIn.position(32);
            n2 = n;
            n3 = 0;
            while (n3 < n2) {
                int n5 = this.packetSel.select(60000L);
                if (this.wakeup) {
                    this.wakeup = false;
                    this.debugOut("(Data) Wakeup is true");
                    return null;
                }
                if (n5 > 0) {
                    object = this.packetSel.selectedKeys().iterator();
                    SelectionKey selectionKey = (SelectionKey)object.next();
                    object.remove();
                    int n6 = this.packetSock.read(this.netIn);
                    this.debugOut("Read " + n6 + " bytes");
                    if (n6 <= 0) continue;
                    n3 += n6;
                    continue;
                }
                if (this.isConnectionAlive()) continue;
                this.close();
                throw new RedirectionException(LocaleStrings.GetString("8_6_PACKETMAST"));
            }
        }
        this.netIn.flip();
        if (this.engine != null) {
            SSLEngineResult sSLEngineResult = this.engine.unwrap(this.netIn, this.appIn);
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                this.appIn.flip();
            }
            this.netIn.compact();
        }
        if ((redirPacket = this.protocol.getPacket(this.appIn)) == null) {
            this.debugOut("Can't build a packet from input data");
            return null;
        }
        this.debugOut("Got a packet!");
        if (bl) {
            this.appIn.compact();
        }
        return redirPacket;
    }

    public RedirPacket receivePacket() throws IOException, RedirectionException {
        return this.receivePacket(true);
    }

    public void clearBuffer() {
        this.appIn.compact();
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectionAlive() {
        boolean bl = true;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            abstractInterruptibleChannel = SocketChannel.open(new InetSocketAddress(this.host, this.port));
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            try {
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("Error closing test socket: " + iOException.getMessage());
            }
        }
        return bl;
    }

    private void debugOut(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }
}

