/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

public class Debug {
    public static Debug out = new Debug();
    public static final int DEBUG = 1;
    public static final int RELEASE = 2;
    public static int MODE;
    private static final char[] kHexChars;

    private Debug() {
        MODE = 2;
    }

    public boolean isInDebugMode() {
        return MODE == 1;
    }

    public void print(Object object) {
        if (MODE == 1) {
            System.out.print(object);
        }
    }

    public void println(Object object) {
        if (MODE == 1) {
            System.out.println(object);
        }
    }

    public void dump(byte[] byArray) {
        if (MODE == 1) {
            this.dump(byArray, byArray.length);
        }
    }

    public void dump(byte[] byArray, int n) {
        if (MODE == 1) {
            this.dump(byArray, 0, n);
        }
    }

    public void dump(byte[] byArray, int n, int n2) {
        if (MODE == 1) {
            int n3;
            if (byArray.length - n < n2) {
                System.out.println("Invalid buffer");
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(2 * n2);
            for (n3 = n; n3 < n + n2; ++n3) {
                Debug.appendHexPair(byArray[n3], stringBuffer);
            }
            for (n3 = 0; n3 < stringBuffer.length(); n3 += 60) {
                int n4 = n3 + 60;
                if (n4 > stringBuffer.length()) {
                    n4 = stringBuffer.length();
                }
                System.out.println(stringBuffer.substring(n3, n4));
            }
        }
    }

    public static void appendHexPair(byte by, StringBuffer stringBuffer) {
        char c2 = kHexChars[(by & 0xF0) >> 4];
        char c3 = kHexChars[by & 0xF];
        stringBuffer.append(c2);
        stringBuffer.append(c3);
        stringBuffer.append(' ');
    }

    static {
        kHexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

