/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class JViewer {
    public static void main(String[] stringArray) {
        if (stringArray.length < 11) {
            JViewer.printUsage();
            return;
        }
        int n = 7578;
        int n2 = 5678;
        byte[] byArray = JViewer.getServerIP(stringArray[0]);
        if (byArray == null) {
            JViewer.printUsage();
            return;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
            n2 = Integer.parseInt(stringArray[8]);
        }
        catch (NumberFormatException numberFormatException) {
            JViewer.printUsage();
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            n3 = Integer.parseInt(stringArray[3]);
            n4 = Integer.parseInt(stringArray[4]);
            n5 = Integer.parseInt(stringArray[7]);
            n6 = Integer.parseInt(stringArray[9]);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(LocaleStrings.GetString("1_1_JVIEWER"));
            JViewer.printUsage();
            return;
        }
        if (n3 != 0 && n3 != 1 || n4 != 0 && n4 != 1) {
            JViewer.printUsage();
            return;
        }
        boolean bl = n3 == 1;
        boolean bl2 = n4 == 1;
        int n7 = 0;
        try {
            n7 = Integer.parseInt(stringArray[5]);
        }
        catch (NumberFormatException numberFormatException) {
            JViewer.printUsage();
            return;
        }
        int n8 = 0;
        try {
            n8 = Integer.parseInt(stringArray[6]);
        }
        catch (NumberFormatException numberFormatException) {
            JViewer.printUsage();
            return;
        }
        System.out.println("VKVM Connecting to " + stringArray[0] + ":" + n + (bl ? " (SSL)" : " (Non-SSL)"));
        System.out.println("HID to " + stringArray[0] + ":" + n2);
        System.out.println("VMedia Connecting to CD:" + n7 + " FD:" + n8 + (bl2 ? " (SSL)" : " (Non-SSL)"));
        System.out.println("UserPrivileges " + n5);
        JViewerApp jViewerApp = new JViewerApp();
        jViewerApp.setPanelMode(false);
        jViewerApp.getParams().SetUserPriv(n5);
        jViewerApp.getParams().SetKVMEnabled(n6);
        jViewerApp.createUI();
        LocaleStrings.SetLanguageID(stringArray[10]);
        jViewerApp.OnConnectToServer(byArray, n, n2, stringArray[2], bl, bl2, n7, n8, n5);
    }

    public static void printUsage() {
        Debug.out.println("Invalid arguments, please try again");
        Debug.out.println("Usage: java -jar JViewer.jar <ip address> <port number> <token> <ssl for vdeo> <ssl for vmedia> <cdserver port> <fdserver port> <user privileges> <hid_port> <is kvm enabled> <language>");
        Debug.out.println("<ssl for video> 1 for secure connection and 0 for non-secure ");
        Debug.out.println("<ssl for vmedia> 1 for secure connection and 0 for non-secure ");
        Debug.out.println("<user privileges> ");
        Debug.out.println("                  0x00000020 - VKVM permissions only");
        Debug.out.println("                  0x00000040 - VMedia permissions only");
        Debug.out.println("                  0x00000060 - VKVM & VMedia permissions");
        Debug.out.println("<language> ");
        Debug.out.println("                  EN - English");
        Debug.out.println("                  ES - Spanish");
        Debug.out.println("                  FR - French");
        Debug.out.println("                  DE - Dutch");
        Debug.out.println("                  ZH - Chinese");
        Debug.out.println("                  JA - Japanese");
    }

    private static byte[] getServerIP(String string) {
        String[] stringArray;
        boolean bl = false;
        try {
            stringArray = InetAddress.getByName(string);
            string = stringArray.getHostAddress();
            Debug.out.println("Resolving to IPAddress " + string);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string.trim().length() <= 0) {
            return null;
        }
        stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        for (int k = 0; k < 4; ++k) {
            try {
                byArray[k] = (byte)Short.parseShort(stringArray[k]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (byArray[k] <= 255) continue;
            return null;
        }
        return byArray;
    }
}

