/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.CommandPlugIn;
import com.supermicro.ipmi.text.MOut;
import java.awt.GraphicsEnvironment;
import java.io.IOException;

public class SMCJViewerPlugIn
extends CommandPlugIn {
    @Override
    public void execute() throws Exception {
        if (!this.isKVMSupported()) {
            this.printUnavailableMessage();
            return;
        }
        boolean bl = GraphicsEnvironment.isHeadless();
        if (bl) {
            MOut.G().print("No graphic environment here !");
            return;
        }
        MOut.G().print("Starting JViewer Process...");
        try {
            Process process = Runtime.getRuntime().exec("java -jar JViewerSMC.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword());
        }
        catch (IOException iOException) {
            MOut.G().println(" Failed");
            return;
        }
        MOut.G().println("Done");
        MOut.G().println("Please wait for JViewer window");
    }

    public boolean isKVMSupported() {
        byte[] byArray = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (byArray == null) {
            return false;
        }
        if (IPMIMessagingCommand.isAMIGUID(byArray)) {
            return true;
        }
        return IPMIMessagingCommand.isAMISIMBLGUID(byArray);
    }

    public void printUnavailableMessage() {
        MOut.G().println("This function is unavailable for this device.");
    }

    @Override
    public String getAlternateValue() {
        return null;
    }

    @Override
    public String getComment() {
        return "SIM(W) KVM console (graphic mode)";
    }

    @Override
    public String getName() {
        return "kvmw";
    }

    @Override
    public String getValue() {
        return "kvmw";
    }

    @Override
    public boolean isSupportCLIMode() {
        return true;
    }

    @Override
    public boolean isSupportShellMode() {
        return true;
    }

    public static void main(String[] stringArray) {
    }
}

