/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerContainer;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public abstract class JVFrame
extends JFrame
implements JViewerContainer {
    JViewerApp app;
    protected JScrollPane m_viewSP;
    protected static String m_serverIP;

    public static void setServerIP(byte[] byArray) {
        try {
            m_serverIP = InetAddress.getByAddress(byArray).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            m_serverIP = LocaleStrings.GetString("C_1_JVF");
        }
    }

    public static String getServerIP() {
        if (m_serverIP != null && !m_serverIP.equalsIgnoreCase(new String(LocaleStrings.GetString("C_1_JVF")))) {
            return m_serverIP;
        }
        return null;
    }

    public void attachView() {
        this.m_viewSP = new JScrollPane(this.app.getRCView());
        this.m_viewSP.getHorizontalScrollBar().setUnitIncrement(10);
        this.m_viewSP.getVerticalScrollBar().setUnitIncrement(10);
        this.m_viewSP.setViewportBorder(null);
        this.m_viewSP.setBorder(null);
        this.getContentPane().add(this.m_viewSP);
        this.setVisible(true);
    }

    public void detachView() {
        if (this.m_viewSP != null) {
            this.getContentPane().remove(this.m_viewSP);
            this.setVisible(false);
        }
    }

    protected boolean windowClosed() {
        int n;
        if ((this.app.IsCDROMRedirRunning() || this.app.IsFloppyRedirRunning()) && (n = JOptionPane.showConfirmDialog(this, LocaleStrings.GetString("C_2_JVF"), LocaleStrings.GetString("C_3_JVF"), 0)) == 1) {
            Debug.out.println("Returning false\n");
            return false;
        }
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.app.OnVideoStopRedirection();
        }
        System.exit(0);
        return true;
    }
}

