/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JVStatusBar;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.WindowMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;

public class WindowFrame
extends JVFrame {
    private WindowMenu m_menu;
    private JVStatusBar m_status;

    public WindowFrame(JViewerApp jViewerApp) {
        this.app = jViewerApp;
        this.setTitle(LocaleStrings.GetString("A_1_GLOBAL"));
        this.setSize(new Dimension(1024, 768));
        this.setExtendedState(this.getExtendedState() | 6);
        this.constructUserIf();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WindowFrame.this.windowClosed();
            }
        });
    }

    @Override
    public JVMenu getMenu() {
        return this.m_menu;
    }

    @Override
    public void setStatus(String string) {
        this.m_status.setStatus(string);
    }

    @Override
    public void resetStatus() {
        this.m_status.resetStatus();
    }

    @Override
    public void exitApp() {
        this.windowClosed();
    }

    @Override
    public void setWndLabel(String string) {
        this.setTitle(LocaleStrings.GetString("A_1_GLOBAL") + "[" + m_serverIP + "]" + string);
    }

    private void constructUserIf() {
        Container container = this.getContentPane();
        container.removeAll();
        container.setLayout(new BorderLayout());
        this.m_menu = new WindowMenu(this.app);
        this.setJMenuBar(this.m_menu.getMenuBar());
        this.m_status = new JVStatusBar();
        container.add((Component)this.m_status.getStatusBar(), "Last");
        this.m_status.setStatus(LocaleStrings.GetString("A_1_GLOBAL") + LocaleStrings.GetString("Z_1_MISC") + "... ");
        URL uRL = JViewer.class.getResource("res/jviewer.jpg");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
    }
}

