/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import com.ami.kvm.jviewer.hid.HIDHeaderReader;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.hid.KVMReader;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class HIDCtrlReader
implements KVMReader {
    private static final int CTRL_MSG_BODY_SIZE = 128;
    private KVMClient m_client;
    private int m_ctrlIx;
    private ByteBuffer m_ctrlBuf;

    public HIDCtrlReader(KVMClient kVMClient) {
        this.m_client = kVMClient;
        this.m_ctrlIx = 0;
        this.m_ctrlBuf = ByteBuffer.allocate(128);
    }

    @Override
    public void initialize() {
        this.m_ctrlIx = 0;
        this.m_ctrlBuf.clear();
        this.m_ctrlBuf.limit(this.m_client.m_HIDpktHdr.pktSize);
        this.m_ctrlBuf.position(0);
    }

    @Override
    public int read(SocketChannel socketChannel, SSLWrapper sSLWrapper) {
        if (this.m_client.m_HIDpktHdr.pktSize <= 0) {
            return -1;
        }
        try {
            this.m_ctrlIx = sSLWrapper != null ? (this.m_ctrlIx += sSLWrapper.GetBytes(this.m_ctrlBuf)) : (this.m_ctrlIx += socketChannel.read(this.m_ctrlBuf));
            if (this.m_client.m_HIDpktHdr.pktSize <= this.m_ctrlIx) {
                this.m_client.m_HIDctrlMsg = this.m_ctrlBuf;
                this.m_client.onHIDPacket();
                HIDHeaderReader hIDHeaderReader = this.m_client.getHIDHdrReader();
                hIDHeaderReader.initialize();
                this.m_client.setHIDState(hIDHeaderReader);
            }
        }
        catch (Exception exception) {
            Debug.out.println("CTRL_RDR " + exception);
            return -1;
        }
        return 0;
    }
}

