/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.hid.HIDCtrlReader;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.hid.KVMReader;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.swing.JOptionPane;

public class HIDHeaderReader
implements KVMReader {
    private KVMClient m_client;
    private byte[] m_hdrBuf;
    private ByteBuffer m_hdrByteBuf;
    private IVTPPktHdr m_pktHdr;
    private int m_hdrIx;

    public HIDHeaderReader(KVMClient kVMClient) {
        this.m_client = kVMClient;
        this.m_hdrBuf = new byte[7];
        this.m_hdrByteBuf = ByteBuffer.wrap(this.m_hdrBuf);
        this.m_pktHdr = new IVTPPktHdr();
        this.m_hdrIx = 0;
    }

    @Override
    public void initialize() {
        this.m_hdrIx = 0;
        this.m_hdrByteBuf.clear();
    }

    @Override
    public int read(SocketChannel socketChannel, SSLWrapper sSLWrapper) {
        try {
            this.m_hdrIx = sSLWrapper != null ? (this.m_hdrIx += sSLWrapper.GetBytes(this.m_hdrByteBuf)) : (this.m_hdrIx += socketChannel.read(this.m_hdrByteBuf));
            if (7 <= this.m_hdrIx) {
                this.m_pktHdr.set(this.m_hdrByteBuf);
                this.m_client.m_HIDpktHdr = this.m_pktHdr;
                if (this.m_pktHdr.pktSize > 0) {
                    HIDCtrlReader hIDCtrlReader = this.m_client.getHIDCtrlReader();
                    hIDCtrlReader.initialize();
                    this.m_client.setHIDState(hIDCtrlReader);
                } else {
                    this.m_client.onHIDPacket();
                    HIDHeaderReader hIDHeaderReader = this.m_client.getHIDHdrReader();
                    hIDHeaderReader.initialize();
                    this.m_client.setHIDState(hIDHeaderReader);
                }
            }
        }
        catch (Exception exception) {
            Debug.out.println("HID_HDR_RDR " + exception);
            JOptionPane.showMessageDialog(null, LocaleStrings.GetString("H_1_HR"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            return -1;
        }
        return 0;
    }
}

