/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.USBKeyProcessor;
import com.ami.kvm.jviewer.kvmpkts.USBMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class USBKeyboardRep
extends USBMessage {
    private int keyCode;
    private int keyLocation;
    private boolean keyPress;
    private byte[] m_report;
    private byte[] m_encReport;
    private ByteBuffer m_repBuf;
    private byte[] m_usbHdr;
    private USBKeyProcessor m_USBKeyProcessor;
    static int SeqNum = 0;

    public USBKeyboardRep() {
        this(0, 0, true);
    }

    public USBKeyboardRep(int n, int n2, boolean bl) {
        this.m_vHdr = new IVTPPktHdr(4, 41, 0);
        this.m_devType = (byte)48;
        this.m_protocol = (byte)16;
        this.m_dataLen = 8;
        this.m_usbHdr = new byte[33];
        this.m_report = new byte[48];
        this.m_encReport = new byte[48];
        this.m_USBKeyProcessor = USBKeyProcessor.getInstance();
        this.setAutoKeybreakMode(true);
    }

    public void set(int n, int n2, boolean bl) {
        this.keyCode = n;
        this.keyLocation = n2;
        this.keyPress = bl;
    }

    @Override
    public byte[] report() {
        int n = 9;
        this.m_repBuf = ByteBuffer.wrap(this.m_report);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.position(0);
        this.m_vHdr.setSize(41);
        this.m_vHdr.setStatus((short)0);
        this.m_repBuf.put(this.m_vHdr.array());
        this.m_repBuf.put(this.m_signature);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(n);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)48);
        this.m_repBuf.put((byte)16);
        this.m_repBuf.put((byte)-128);
        this.m_repBuf.put((byte)2);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(SeqNum);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)8);
        byte[] byArray = this.m_USBKeyProcessor.convertKeyCode(this.keyCode, this.keyLocation, this.keyPress);
        if (byArray == null) {
            this.m_repBuf.put(new byte[6]);
        } else {
            this.m_repBuf.put(byArray);
        }
        int n2 = 0;
        for (int k = 7; k < 39; ++k) {
            n2 = n2 + (this.m_repBuf.get(k) & 0xFF) & 0xFF;
        }
        this.m_repBuf.put(18, -((byte)(n2 & 0xFF)));
        ++SeqNum;
        return this.m_report;
    }

    public void setAutoKeybreakMode(boolean bl) {
        this.m_USBKeyProcessor.setAutoKeybreakMode(bl);
    }

    public boolean getAutoKeybreakMode() {
        return this.m_USBKeyProcessor.getAutoKeybreakMode();
    }

    public byte getModifiers() {
        return this.m_USBKeyProcessor.getModifiers();
    }
}

