/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.video;

import com.ami.kvm.jviewer.kvmpkts.FrameHdr;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

public class VSCDecoder {
    public static final int VSC_RECT_HDR_SIZE = 16;
    public static final int TILE_WIDTH = 16;
    public static final int TILE_HEIGHT = 16;
    public static final byte LRLE_COLOR_15BIT_DIRECT = 8;
    public static final byte LRLE_COLOR_7BIT_DIRECT = 9;
    public static final byte LRLE_COLOR_4BIT_PALETTE = 10;
    public static final byte LRLE_COLOR_4BIT_GREY = 3;
    public static final byte LRLE_COLOR_3BIT_GREY = 2;
    public static final byte NO_COMPRESSION = 0;
    public static final byte LRLE_8BIT = 1;
    public static final byte LRLE_16BIT = 2;
    public static final byte LRLE_32BIT = 3;
    public static final byte DEFAULT_COLOR_MODE = 8;

    public static void UnCompress(short[] sArray, byte[] byArray, short[] sArray2, byte[] byArray2, ByteBuffer byteBuffer, FrameHdr frameHdr, Vector<Rectangle> vector) {
        int n;
        byte[] byArray3 = new byte[]{0, 3, 2, 1};
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int k = 0; k < frameHdr.frameSize; k += 16 + n) {
            short s = byteBuffer.getShort();
            short s2 = byteBuffer.getShort();
            short s3 = byteBuffer.getShort();
            short s4 = byteBuffer.getShort();
            int n2 = s3 * s4;
            int n3 = byteBuffer.getInt();
            n = byteBuffer.getInt();
            if (frameHdr.color_mode == 8) {
                if (n3 == 2) {
                    VSCDecoder.UnCompressLRLE_15_direct_16(sArray2, byteBuffer, n, n2);
                } else if (n3 == 3) {
                    VSCDecoder.UnCompressLRLE_15_direct_32(sArray2, byteBuffer, n, n2);
                } else if (n3 == 0) {
                    VSCDecoder.UnCompressLRLE_15_direct(sArray2, byteBuffer, n);
                }
                VSCDecoder.Draw_15_direct(sArray, sArray2, s, s2, s3, s4, frameHdr.resX, frameHdr.resY);
            } else if (frameHdr.color_mode == 9) {
                if (n3 == 2) {
                    VSCDecoder.UnCompressLRLE_7_direct_16(byArray2, byteBuffer, n, n2);
                } else if (n3 == 3) {
                    VSCDecoder.UnCompressLRLE_7_direct_32(byArray2, byteBuffer, n, n2);
                } else if (n3 == 0) {
                    VSCDecoder.UnCompressLRLE_7_direct(byArray2, byteBuffer, n);
                }
                VSCDecoder.Draw_7_direct(byArray, byArray2, s, s2, s3, s4, frameHdr.resX, frameHdr.resY);
            } else if (frameHdr.color_mode == 10 || frameHdr.color_mode == 3) {
                VSCDecoder.UnCompressLRLE_CRLE_4(byArray2, byteBuffer, n);
                VSCDecoder.Draw_7_direct(byArray, byArray2, s, s2, s3, s4, frameHdr.resX, frameHdr.resY);
            } else if (frameHdr.color_mode == 2) {
                VSCDecoder.UnCompressLRLE_CRLE_3(byArray2, byteBuffer, n);
                VSCDecoder.Draw_7_direct(byArray, byArray2, s, s2, s3, s4, frameHdr.resX, frameHdr.resY);
            } else {
                byteBuffer.position(byteBuffer.position() + n);
            }
            byte by = byArray3[n % 4];
            vector.add(new Rectangle(s, s2, s3, s4));
        }
    }

    public static void Draw_15_RAW(short[] sArray, ByteBuffer byteBuffer, short n, short n2, short s, short s2, int n3, int n4) {
        for (int k = n2; k < n2 + s2; k += 16) {
            for (int i2 = n; i2 < n + s; i2 += 16) {
                int n5 = k * n3 + i2;
                for (int i3 = 0; i3 < 16; ++i3) {
                    for (int i4 = 0; i4 < 16; ++i4) {
                        sArray[n5 + i4] = byteBuffer.getShort();
                    }
                    n5 += n3;
                }
            }
        }
    }

    public static void UnCompressLRLE_15_direct(short[] sArray, ByteBuffer byteBuffer, int n) {
        int n2 = 0;
        boolean bl = false;
        short s = 0;
        for (int k = 0; k < n; ++k) {
            s = (short)(0xFF & byteBuffer.get());
            ++k;
            s = (short)(s | (short)(0xFF & byteBuffer.get()) << 8);
            sArray[n2++] = s;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void UnCompressLRLE_15_direct_16(short[] var0, ByteBuffer var1_1, int var2_2, int var3_3) {
        var4_4 = var3_3 - 1;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = var1_1.position();
        var8_8 = var7_7 + (var2_2 - 2);
        block0: while (true) {
            var6_6 = var1_1.getShort(var8_8);
            if ((var8_8 -= 2) < var7_7) break;
            if (0 != (32768 & var6_6)) {
                var6_6 = (short)(var6_6 & 32767);
                var5_5 = var1_1.getShort(var8_8);
                var8_8 -= 2;
                while (true) {
                    if (0 == var6_6 || var4_4 < 0) continue block0;
                    var0[var4_4--] = var5_5;
                    var6_6 = (short)(var6_6 - 1);
                }
            }
            while (true) {
                if (0 != var6_6 && var4_4 >= 0 && var8_8 >= var7_7) ** break;
                continue block0;
                var5_5 = var1_1.getShort(var8_8);
                var8_8 -= 2;
                var0[var4_4--] = var5_5;
                var6_6 = (short)(var6_6 - 1);
            }
            break;
        }
        var1_1.position(var1_1.position() + var2_2);
    }

    /*
     * Unable to fully structure code
     */
    public static void UnCompressLRLE_15_direct_32(short[] var0, ByteBuffer var1_1, int var2_2, int var3_3) {
        var4_4 = var3_3 - 1;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = var1_1.position();
        var10_10 = var9_9 + (var2_2 - 4);
        block0: while (true) {
            var8_8 = var1_1.getInt(var10_10);
            if ((var10_10 -= 4) < var9_9) break;
            if (0 != (-2147483648 & var8_8)) {
                var8_8 = (short)(var8_8 & 0x7FFFFFFF);
                var7_7 = var1_1.getInt(var10_10);
                var10_10 -= 4;
                var6_6 = (short)(65535 & var7_7 >> 16);
                var5_5 = (short)(65535 & var7_7);
                while (true) {
                    if (0 == var8_8 || var4_4 < 0) continue block0;
                    var0[var4_4--] = var6_6;
                    var0[var4_4--] = var5_5;
                    --var8_8;
                }
            }
            while (true) {
                if (0 != var8_8 && var4_4 >= 0 && var10_10 >= var9_9) ** break;
                continue block0;
                var7_7 = var1_1.getInt(var10_10);
                var10_10 -= 4;
                var6_6 = (short)(65535 & var7_7 >> 16);
                var5_5 = (short)(65535 & var7_7);
                var0[var4_4--] = var6_6;
                var0[var4_4--] = var5_5;
                --var8_8;
            }
            break;
        }
        var1_1.position(var1_1.position() + var2_2);
    }

    public static void Draw_15_direct(short[] sArray, short[] sArray2, short s, short n, short n2, short s2, int n3, int n4) {
        int n5 = 0;
        for (int k = n; k < n + s2; ++k) {
            short s3 = s;
            int n6 = k * n3 + s3;
            for (int i2 = 0; i2 < n2; ++i2) {
                sArray[n6 + i2] = sArray2[n5++];
            }
        }
    }

    public static void Draw_7_direct(byte[] byArray, byte[] byArray2, short s, short n, short n2, short s2, int n3, int n4) {
        int n5 = 0;
        for (int k = n; k < n + s2; ++k) {
            short s3 = s;
            int n6 = k * n3 + s3;
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[n6 + i2] = byArray2[n5++];
            }
        }
    }

    public static void UnCompressLRLE_7_direct(byte[] byArray, ByteBuffer byteBuffer, int n) {
        int n2 = 0;
        byte by = 0;
        for (int k = 0; k < n; ++k) {
            by = byteBuffer.get();
            byArray[n2++] = by;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void UnCompressLRLE_7_direct_16(byte[] var0, ByteBuffer var1_1, int var2_2, int var3_3) {
        var4_4 = var3_3 - 1;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = var1_1.position();
        var10_10 = var9_9 + (var2_2 - 2);
        block0: while (true) {
            var8_8 = var1_1.getShort(var10_10);
            if ((var10_10 -= 2) < var9_9) break;
            if (0 != (32768 & var8_8)) {
                var8_8 = (short)(var8_8 & 32767);
                var7_7 = var1_1.getShort(var10_10);
                var10_10 -= 2;
                var6_6 = (byte)(255 & var7_7 >> 8);
                var5_5 = (byte)(255 & var7_7);
                while (true) {
                    if (0 == var8_8 || var4_4 < 0) continue block0;
                    var0[var4_4--] = var6_6;
                    var0[var4_4--] = var5_5;
                    var8_8 = (short)(var8_8 - 1);
                }
            }
            while (true) {
                if (0 != var8_8 && var4_4 >= 0 && var10_10 >= var9_9) ** break;
                continue block0;
                var7_7 = var1_1.getShort(var10_10);
                var10_10 -= 2;
                var6_6 = (byte)(255 & var7_7 >> 8);
                var5_5 = (byte)(255 & var7_7);
                var0[var4_4--] = var6_6;
                var0[var4_4--] = var5_5;
                var8_8 = (short)(var8_8 - 1);
            }
            break;
        }
        var1_1.position(var1_1.position() + var2_2);
    }

    /*
     * Unable to fully structure code
     */
    public static void UnCompressLRLE_7_direct_32(byte[] var0, ByteBuffer var1_1, int var2_2, int var3_3) {
        var4_4 = var3_3 - 1;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = var1_1.position();
        var12_12 = var11_11 + (var2_2 - 4);
        block0: while (true) {
            var10_10 = var1_1.getInt(var12_12);
            if ((var12_12 -= 4) < var11_11) break;
            if (0 != (-2147483648 & var10_10)) {
                var10_10 = (short)(var10_10 & 0x7FFFFFFF);
                var9_9 = var1_1.getInt(var12_12);
                var12_12 -= 4;
                var8_8 = (byte)(255 & var9_9 >> 24);
                var7_7 = (byte)(255 & var9_9 >> 16);
                var6_6 = (byte)(255 & var9_9 >> 8);
                var5_5 = (byte)(255 & var9_9);
                while (true) {
                    if (0 == var10_10 || var4_4 < 0) continue block0;
                    var0[var4_4--] = var8_8;
                    var0[var4_4--] = var7_7;
                    var0[var4_4--] = var6_6;
                    var0[var4_4--] = var5_5;
                    --var10_10;
                }
            }
            while (true) {
                if (0 != var10_10 && var4_4 >= 0 && var12_12 >= var11_11) ** break;
                continue block0;
                var9_9 = var1_1.getInt(var12_12);
                var12_12 -= 4;
                var8_8 = (byte)(255 & var9_9 >> 24);
                var7_7 = (byte)(255 & var9_9 >> 16);
                var6_6 = (byte)(255 & var9_9 >> 8);
                var5_5 = (byte)(255 & var9_9);
                var0[var4_4--] = var8_8;
                var0[var4_4--] = var7_7;
                var0[var4_4--] = var6_6;
                var0[var4_4--] = var5_5;
                --var10_10;
            }
            break;
        }
        var1_1.position(var1_1.position() + var2_2);
    }

    public static void UnCompressLRLE_CRLE_4(byte[] byArray, ByteBuffer byteBuffer, int n) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        byte by = 0;
        while (n3 < n) {
            int n4;
            int n5;
            by = byteBuffer.get();
            ++n3;
            if ((0xE0 & by) == 224) {
                n5 = 0;
                if ((0xFF & by) == 255) {
                    n5 = (0xFF & byteBuffer.get()) + 1;
                    ++n3;
                } else {
                    n5 = (0x1F & by) + 1;
                }
                n4 = n2 - 16;
                while (n5 > 0) {
                    byArray[n2++] = byArray[n4++];
                    --n5;
                }
                continue;
            }
            n4 = 0xF & by;
            for (n5 = ((0xF0 & by) >> 4) + 1; n5 > 0; --n5) {
                byArray[n2++] = n4;
            }
        }
    }

    public static void UnCompressLRLE_CRLE_3(byte[] byArray, ByteBuffer byteBuffer, int n) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        byte by = 0;
        while (n3 < n) {
            int n4;
            int n5;
            by = byteBuffer.get();
            ++n3;
            if ((0xE0 & by) == 224) {
                n5 = 0;
                if ((0xFF & by) == 255) {
                    n5 = (0xFF & byteBuffer.get()) + 1;
                    ++n3;
                } else {
                    n5 = (0x1F & by) + 1;
                }
                n4 = n2 - 16;
                while (n5 > 0) {
                    byArray[n2++] = byArray[n4++];
                    --n5;
                }
                continue;
            }
            n4 = 7 & by;
            for (n5 = ((0xF8 & by) >> 3) + 1; n5 > 0; --n5) {
                byArray[n2++] = n4;
            }
        }
    }
}

