/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.LinkedTreeNode;
import java.io.Serializable;
import java.util.Enumeration;

public class LinkedTreeIterator
implements Enumeration,
Serializable {
    protected LinkedTreeNode firstSibling;
    protected LinkedTreeNode sibling;

    public LinkedTreeIterator(LinkedTreeNode firstSibling) {
        this.firstSibling = firstSibling;
        this.sibling = firstSibling;
    }

    public Object nextElement() {
        LinkedTreeNode cur = this.sibling;
        this.advance();
        return cur;
    }

    public boolean hasMoreElements() {
        return this.sibling != null;
    }

    public boolean atBegin() {
        return this.sibling == this.firstSibling;
    }

    public boolean atEnd() {
        return this.sibling == null;
    }

    public Object get() {
        return this.sibling;
    }

    public void advance() {
        if (this.sibling != null) {
            this.sibling = this.sibling.nextSibling;
        }
    }

    public void advance(int offset) {
        for (int i2 = 0; i2 < offset && this.sibling != null; ++i2) {
            this.advance();
        }
    }

    public Object clone() {
        LinkedTreeIterator that = new LinkedTreeIterator(this.firstSibling);
        that.sibling = this.sibling;
        return that;
    }

    public boolean equals(LinkedTreeIterator that) {
        return that.sibling == this.sibling && that.firstSibling == this.firstSibling;
    }

    public void put(Object data) {
        if (this.sibling == null) {
            this.firstSibling.appendChild((LinkedTreeNode)data);
        } else {
            this.firstSibling.insertChild((LinkedTreeNode)data, this.sibling);
        }
    }

    public int distance(LinkedTreeIterator that) {
        int d2 = 0;
        LinkedTreeNode c2 = that.sibling;
        while (c2 != this.sibling && c2 != null) {
            c2 = c2.nextSibling;
            ++d2;
        }
        return c2 == this.sibling ? d2 : -1;
    }

    public void put(int offset, Object object) {
        this.advance(offset);
        this.put(object);
    }

    public Object get(int offset) {
        this.advance(offset);
        return this.get();
    }
}

