/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.view.TreeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class TreeEvent
extends DispatchableEvent
implements Serializable {
    public static final int NODE_EXPANDED = 1000;
    public static final int NODE_COLLAPSED = 1001;
    private int id;
    private transient GraphLocation node;

    public TreeEvent(Object source, int id, GraphLocation node) {
        super(source);
        this.id = id;
        this.node = node;
    }

    public GraphLocation getLocation() {
        return this.node;
    }

    public int getID() {
        return this.id;
    }

    public void dispatch(EventListener listener) {
        switch (this.id) {
            case 1000: {
                ((TreeListener)listener).nodeExpanded(this);
                break;
            }
            case 1001: {
                ((TreeListener)listener).nodeCollapsed(this);
                break;
            }
        }
    }

    protected String paramString() {
        String idStr;
        switch (this.id) {
            case 1000: {
                idStr = "NODE_EXPANDED";
                break;
            }
            case 1001: {
                idStr = "NODE_COLLAPSED";
                break;
            }
            default: {
                idStr = "<INVALID>";
            }
        }
        return super.paramString() + "id=" + idStr + ",location=" + this.node;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.node instanceof Serializable ? this.node : null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof GraphLocation) {
            this.node = (GraphLocation)data;
        }
    }
}

