/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class IPMIBMCFileCommand
extends IPMICommand {
    MOut mout = MOut.G();

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    public IPMIBMCFileCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void BMC_FILE_UPLOAD_CMD_________() {
    }

    public IPMIMessage getUploadResvIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage startFileUploadCommand(byte[] reservationID, byte[] fileSize) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[reservationID.length + fileSize.length + 1];
        data[0] = 2;
        System.arraycopy(reservationID, 0, data, 1, reservationID.length);
        System.arraycopy(fileSize, 0, data, 3, fileSize.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage fileUploadCommand(byte[] reservationID, byte[] offset, byte[] file) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[reservationID.length + offset.length + file.length + 1];
        data[0] = 3;
        System.arraycopy(reservationID, 0, data, 1, reservationID.length);
        System.arraycopy(offset, 0, data, 3, offset.length);
        System.arraycopy(file, 0, data, 7, file.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage applyFileCommand(byte[] reservationID, byte optionCode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[reservationID.length + 2];
        data[0] = 4;
        System.arraycopy(reservationID, 0, data, 1, reservationID.length);
        data[3] = optionCode;
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void BMC_FILE_DOWNLOAD_CMD_________() {
    }

    public IPMIMessage prepareFileDownloadCommand(byte optionCode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{5, optionCode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage prepareFileDownloadDoneCommand(byte[] reservationID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[reservationID.length + 1];
        data[0] = 6;
        System.arraycopy(reservationID, 0, data, 1, reservationID.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage fileDownloadCommand(byte[] reservationID, byte[] offset, byte[] fileSize) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[reservationID.length + offset.length + fileSize.length + 1];
        data[0] = 7;
        System.arraycopy(reservationID, 0, data, 1, reservationID.length);
        System.arraycopy(offset, 0, data, 3, offset.length);
        System.arraycopy(fileSize, 0, data, 7, fileSize.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage fileDownloadDoneCommand(byte[] reservationID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[reservationID.length + 1];
        data[0] = 8;
        System.arraycopy(reservationID, 0, data, 1, reservationID.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBIOSNVUpdateStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemConfigurationCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-101, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBIOSCurrentSettingStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSetBIOSOOBCapabilityCommand(byte optionCode, byte[] capability) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[7];
        data[0] = 17;
        data[1] = optionCode;
        System.arraycopy(capability, 0, data, 2, capability.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{24};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBIOSDATFileStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{22};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void BMC_FILE_UPLOAD_API_________() {
    }

    public byte[] getUploadResvID() throws Exception {
        IPMIMessage resMessage = this.getUploadResvIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call getUploadResvIDCommand failed");
    }

    public void startFileUpload(byte[] reservationID, byte[] fileSize) throws Exception {
        IPMIMessage resMessage = this.startFileUploadCommand(reservationID, fileSize);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call startFileUploadCommand failed");
    }

    public void fileUpload(byte[] reservationID, byte[] offset, byte[] file) throws Exception {
        IPMIMessage resMessage = this.fileUploadCommand(reservationID, offset, file);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call fileUploadCommand failed");
    }

    public void applyFile(byte[] reservationID, byte optionCode) throws Exception {
        IPMIMessage resMessage = this.applyFileCommand(reservationID, optionCode);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call applyFileCommand failed");
    }

    private void BMC_FILE_DOWNLOAD_API_________() {
    }

    public byte[] prepareFileDownload(byte optionCode) throws Exception {
        IPMIMessage resMessage = this.prepareFileDownloadCommand(optionCode);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call prepareFileDownloadCommand failed");
    }

    public byte[] prepareFileDownloadDone(byte[] reservationID) throws Exception {
        IPMIMessage resMessage = this.prepareFileDownloadDoneCommand(reservationID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data[0] == 0) {
                    byte[] tempAry = new byte[4];
                    System.arraycopy(resMessage.data, 1, tempAry, 0, 4);
                    return tempAry;
                }
                return null;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call prepareFileDownloadDoneCommand failed");
    }

    public byte[] fileDownload(byte[] reservationID, byte[] offset, byte[] fileSize) throws IPMIException {
        IPMIMessage resMessage = this.fileDownloadCommand(reservationID, offset, fileSize);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call fileDownloadCommand failed");
    }

    public void fileDownloadDone(byte[] reservationID) throws Exception {
        IPMIMessage resMessage = this.fileDownloadDoneCommand(reservationID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call fileDownloadDoneCommand failed");
    }

    private void BMC_FILE_CONFIRM_API_________() {
    }

    public byte getBIOSNVUpdateStatus() throws Exception {
        IPMIMessage resMessage = this.getBIOSNVUpdateStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call getBIOSNVUpdateStatusCommand failed");
    }

    public byte getSystemConfiguration() throws Exception {
        IPMIMessage resMessage = this.getSystemConfigurationCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call getSystemConfigurationCommand failed");
    }

    public byte getBIOSCurrentSettingStatus() throws Exception {
        IPMIMessage resMessage = this.getBIOSCurrentSettingStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call getBIOSCurrentSettingStatusCommand failed");
    }

    public byte[] getSetBIOSOOBCapability(byte optionCode, byte[] capability) throws Exception {
        IPMIMessage resMessage = this.getSetBIOSOOBCapabilityCommand(optionCode, capability);
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data;
        }
        throw new IPMIException(resMessage, "Call getSetBIOSOOBCapabilityCommand failed");
    }

    public byte getPowerStatus() throws Exception {
        IPMIMessage resMessage = this.getPowerStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call getPowerStatusCommand failed");
    }

    public byte getBIOSDATFileStatus() throws Exception {
        IPMIMessage resMessage = this.getBIOSDATFileStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call getBIOSDATFileStatusCommand failed");
    }

    private void API_________() {
    }

    public boolean generalFileUpload(byte optionCode, String fileName) throws Exception {
        return this.generalFileUpload(optionCode, fileName, true);
    }

    public boolean generalFileUpload(byte optionCode, String fileName, boolean debugFlag) throws Exception {
        byte[] reservationID;
        File file = new File(fileName);
        byte[] fileSizeByteArray = new byte[4];
        int chunkSize = 1024;
        int totalRead = 0;
        int readCount = 0;
        int currentProgress = 0;
        int lastProgress = 0;
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        long startTime = System.currentTimeMillis();
        if (optionCode == 2 || optionCode == 4) {
            this.mout.println("====================================");
            this.mout.println("Confirm OOB license support");
            this.mout.println("====================================");
            IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiInterface);
            try {
                if (ipmiX9BIOSOEMCommand.checkIfProductNotActivated()) {
                    throw new Exception("The product key needs to be activated for this device");
                }
                this.mout.println("Product key confirmed successfully");
            }
            catch (IPMIException ex) {
                throw new Exception("Confirm BIOS OOB support error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
            }
            this.mout.println();
        }
        if (debugFlag) {
            this.mout.println("====================================");
            this.mout.println("Prepare reservation ID");
            this.mout.println("====================================");
        }
        try {
            reservationID = this.getUploadResvID();
            if (debugFlag) {
                this.mout.println("Reservation ID: " + ByteUtility.bytesToHex(reservationID));
            }
        }
        catch (IPMIException ex) {
            if (optionCode == 1 || optionCode == 5) {
                this.mout.println("Not a supported command");
                return false;
            }
            throw new Exception("Prepare reservation ID failed(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        if (debugFlag) {
            this.mout.println();
        }
        if (debugFlag) {
            this.mout.println("====================================");
            this.mout.println("Start file upload");
            this.mout.println("====================================");
        }
        long fileSize = file.length();
        ByteUtility.intTo4Bytes(fileSizeByteArray, 0, (int)fileSize);
        try {
            this.startFileUpload(reservationID, fileSizeByteArray);
            if (debugFlag) {
                this.mout.println("File Size: " + fileSize + " bytes");
            }
        }
        catch (IPMIException ex) {
            throw new Exception("Start file upload failed(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        if (debugFlag) {
            this.mout.println();
        }
        if (debugFlag) {
            this.mout.println("====================================");
            this.mout.println("Uploading file");
            this.mout.println("====================================");
        }
        this.mout.print("Progress:|");
        byte[] chunk = new byte[chunkSize];
        while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
            byte[] currentChunk = new byte[4];
            ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
            if (readCount != chunkSize) {
                byte[] lastChunk = new byte[readCount];
                System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                chunk = lastChunk;
            }
            try {
                this.fileUpload(reservationID, currentChunk, chunk);
            }
            catch (IPMIException ex) {
                throw new Exception("File upload error. Location = " + totalRead + "(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
            }
            currentProgress = (int)((long)((totalRead += readCount) * 100) / file.length());
            if (currentProgress <= lastProgress) continue;
            if (currentProgress % 2 == 0) {
                this.mout.print(">");
            }
            lastProgress = currentProgress;
        }
        this.mout.println("| 100%");
        this.mout.println();
        if (debugFlag) {
            this.mout.println("====================================");
            this.mout.println("Apply file");
            this.mout.println("====================================");
        }
        try {
            this.applyFile(reservationID, optionCode);
            this.printTimeString("Upload Time", System.currentTimeMillis() - startTime);
            this.mout.println("Upload successfully");
        }
        catch (IPMIException ex) {
            throw new Exception("File upload done error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println();
        return true;
    }

    public boolean generalFileDownload(byte optionCode, String fileName) throws Exception {
        return this.generalFileDownload(optionCode, fileName, true);
    }

    public boolean generalFileDownload(byte optionCode, String fileName, boolean debugFlag) throws Exception {
        Object fileData;
        byte[] maxChunkSize;
        byte[] reservationID;
        int retryCount = 0;
        int chunkSize = 1024;
        int totalRead = 0;
        int currentProgress = 0;
        int lastProgress = 0;
        long startTime = System.currentTimeMillis();
        if (optionCode == 2 || optionCode == 3 || optionCode == 4) {
            this.mout.println("====================================");
            this.mout.println("Confirm OOB license support");
            this.mout.println("====================================");
            IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiInterface);
            try {
                if (ipmiX9BIOSOEMCommand.checkIfProductNotActivated()) {
                    throw new Exception("The product key needs to be activated for this device");
                }
                this.mout.println("Product key confirmed successfully");
            }
            catch (IPMIException ex) {
                throw new Exception("Confirm BIOS OOB support error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
            }
            this.mout.println();
        }
        if (debugFlag) {
            this.mout.println("====================================");
            this.mout.println("Prepare reservation ID");
            this.mout.println("====================================");
        }
        try {
            reservationID = this.prepareFileDownload(optionCode);
            if (debugFlag) {
                this.mout.println("Reservation ID: " + ByteUtility.bytesToHex(reservationID));
            }
        }
        catch (IPMIException ex) {
            if (optionCode == 1 || optionCode == 5) {
                this.mout.println("Not a supported command");
                return false;
            }
            throw new Exception("Prepare reservation ID failed(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        if (debugFlag) {
            this.mout.println();
        }
        if (debugFlag) {
            this.mout.println("====================================");
            this.mout.println("Prepare download file");
            this.mout.println("====================================");
        }
        try {
            while ((maxChunkSize = this.prepareFileDownloadDone(reservationID)) == null) {
                if (retryCount++ == 30) {
                    if (optionCode == 1 || optionCode == 5) {
                        this.mout.println("Not a supported command");
                        return false;
                    }
                    throw new Exception("Prepare download file timeout");
                }
                Thread.sleep(250L);
                if (retryCount <= 0 || retryCount % 4 != 0 || !debugFlag) continue;
                this.mout.print(".");
            }
            if (debugFlag) {
                this.mout.println();
                this.mout.println("Max Chunk Size = " + ByteUtility.bytesToHex(maxChunkSize));
            }
        }
        catch (IPMIException ex) {
            throw new Exception("Prepare download file failed(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        if (debugFlag) {
            this.mout.println();
        }
        if (debugFlag) {
            this.mout.println("====================================");
            this.mout.println("Download file");
            this.mout.println("====================================");
        }
        int fileSize = (maxChunkSize[0] & 0xFF) + ((maxChunkSize[1] & 0xFF) << 8) + ((maxChunkSize[2] & 0xFF) << 16) + ((maxChunkSize[3] & 0xFF) << 24);
        byte[] fileAry = new byte[fileSize];
        if (debugFlag) {
            this.mout.println("File Size: " + fileSize + " bytes");
        }
        this.mout.print("Downloading progress:|");
        while (totalRead < fileSize) {
            byte[] fileOffset = new byte[4];
            byte[] fileLength = new byte[2];
            ByteUtility.intTo4Bytes(fileOffset, 0, totalRead);
            if (fileSize - totalRead < 1024) {
                ByteUtility.intTo2Bytes(fileLength, 0, fileSize - totalRead);
            } else {
                ByteUtility.intTo2Bytes(fileLength, 0, chunkSize);
            }
            try {
                fileData = this.fileDownload(reservationID, fileOffset, fileLength);
            }
            catch (IPMIException ex) {
                throw new Exception("Download file failed(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
            }
            System.arraycopy(fileData, 0, fileAry, totalRead, ((Object)fileData).length);
            currentProgress = (totalRead += ((Object)fileData).length) * 100 / fileSize;
            if (currentProgress <= lastProgress) continue;
            if (currentProgress % 2 == 0) {
                this.mout.print(">");
            }
            lastProgress = currentProgress;
        }
        this.mout.println("| 100%");
        fileData = new FileOutputStream(fileName);
        ((OutputStream)fileData).write(fileAry);
        ((OutputStream)fileData).close();
        this.mout.println();
        if (debugFlag) {
            this.mout.println("====================================");
            this.mout.println("Download file done");
            this.mout.println("====================================");
        }
        try {
            this.fileDownloadDone(reservationID);
            this.printTimeString("Download Time", System.currentTimeMillis() - startTime);
            this.mout.println("Download successfully");
        }
        catch (IPMIException ex) {
            throw new Exception("File download done error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println();
        return true;
    }

    public boolean fileUpload(String fileName) throws Exception {
        byte[] reservationID;
        File file = new File(fileName);
        long firstStart = System.currentTimeMillis();
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Verify support for OOB feature");
        this.mout.println("====================================");
        try {
            this.getBIOSNVUpdateStatus();
            this.mout.println("BMC supports OOB features");
        }
        catch (IPMIException ex) {
            throw new Exception("BMC does not support OOB feature");
        }
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Get reservation ID");
        this.mout.println("====================================");
        try {
            reservationID = this.getUploadResvID();
        }
        catch (IPMIException ex) {
            throw new Exception("Get reservation ID error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("Reservation ID = " + ByteUtility.bytesToHex(reservationID));
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Start IPMI configuration file upload");
        this.mout.println("====================================");
        long fileSize = file.length();
        byte[] fileSizeByteArray = new byte[4];
        ByteUtility.intTo4Bytes(fileSizeByteArray, 0, (int)fileSize);
        try {
            this.startFileUpload(reservationID, fileSizeByteArray);
        }
        catch (IPMIException ex) {
            throw new Exception("Start file upload error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("File Size: " + fileSize + " bytes");
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Uploading IPMI configuration file");
        this.mout.println("====================================");
        this.mout.print("Progress:|");
        long start = System.currentTimeMillis();
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        int chunkSize = 1024;
        int totalRead = 0;
        int readCount = 0;
        int currentProgress = 0;
        int lastProgress = 0;
        byte[] chunk = new byte[chunkSize];
        while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
            byte[] currentChunk = new byte[4];
            ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
            if (readCount != chunkSize) {
                byte[] lastChunk = new byte[readCount];
                System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                chunk = lastChunk;
            }
            try {
                this.fileUpload(reservationID, currentChunk, chunk);
            }
            catch (IPMIException ex) {
                throw new Exception("File upload error. Location = " + totalRead + "(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
            }
            currentProgress = (int)((long)((totalRead += readCount) * 100) / file.length());
            if (currentProgress <= lastProgress) continue;
            if (currentProgress % 2 == 0) {
                this.mout.print(">");
            }
            lastProgress = currentProgress;
        }
        this.mout.println("| 100%");
        this.printTimeString("Upload Time", System.currentTimeMillis() - start);
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Apply file");
        this.mout.println("====================================");
        try {
            this.applyFile(reservationID, (byte)1);
        }
        catch (IPMIException ex) {
            throw new Exception("Apply IPMI configuration file error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("Done");
        this.printTimeString("Total Elapse Time", System.currentTimeMillis() - firstStart);
        return true;
    }

    public boolean fileDownload(String fileName) throws Exception {
        Object fileData;
        byte[] maxChunkSize;
        byte[] reservationID;
        long firstStart = System.currentTimeMillis();
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Verify support for OOB feature");
        this.mout.println("====================================");
        try {
            this.getBIOSNVUpdateStatus();
            this.mout.println("BMC supports OOB features");
        }
        catch (IPMIException ex) {
            throw new Exception("BMC does not support OOB feature");
        }
        this.mout.println("");
        this.mout.println("=========================================");
        this.mout.println("Prepare IPMI configuration file download");
        this.mout.println("=========================================");
        try {
            reservationID = this.prepareFileDownload((byte)1);
        }
        catch (IPMIException ex) {
            throw new Exception("Get prepare file download error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("Reservation ID = " + ByteUtility.bytesToHex(reservationID));
        this.mout.println("");
        this.mout.println("=========================================");
        this.mout.println("Prepare IPMI configure file download done");
        this.mout.println("=========================================");
        int count = 0;
        try {
            while ((maxChunkSize = this.prepareFileDownloadDone(reservationID)) == null) {
                if (count++ == 30) {
                    throw new Exception("File prepare timeout");
                }
                Thread.sleep(1000L);
                this.mout.print(".");
            }
        }
        catch (IPMIException ex) {
            throw new Exception("Get prepare file download done error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("");
        this.mout.println("Max Chunk Size = " + ByteUtility.bytesToHex(maxChunkSize));
        this.mout.println("");
        this.mout.println("=========================================");
        this.mout.println("IPMI configure file download");
        this.mout.println("=========================================");
        this.mout.print("Progress:|");
        long start = System.currentTimeMillis();
        int fileSize = (maxChunkSize[0] & 0xFF) + ((maxChunkSize[1] & 0xFF) << 8) + ((maxChunkSize[2] & 0xFF) << 16) + ((maxChunkSize[3] & 0xFF) << 24);
        this.mout.println("File Size: " + fileSize + " bytes");
        byte[] fileAry = new byte[fileSize];
        int chunkSize = 1024;
        int totalRead = 0;
        int currentProgress = 0;
        int lastProgress = 0;
        while (totalRead < fileSize) {
            byte[] fileOffset = new byte[4];
            byte[] fileLength = new byte[2];
            ByteUtility.intTo4Bytes(fileOffset, 0, totalRead);
            if (fileSize - totalRead < 1024) {
                ByteUtility.intTo2Bytes(fileLength, 0, fileSize - totalRead);
            } else {
                ByteUtility.intTo2Bytes(fileLength, 0, chunkSize);
            }
            try {
                fileData = this.fileDownload(reservationID, fileOffset, fileLength);
            }
            catch (IPMIException ex) {
                throw new Exception("File download error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
            }
            System.arraycopy(fileData, 0, fileAry, totalRead, ((Object)fileData).length);
            currentProgress = (totalRead += ((Object)fileData).length) * 100 / fileSize;
            if (currentProgress <= lastProgress) continue;
            if (currentProgress % 2 == 0) {
                this.mout.print(">");
            }
            lastProgress = currentProgress;
        }
        this.mout.println("| 100%");
        fileData = new FileOutputStream(fileName);
        ((OutputStream)fileData).write(fileAry);
        ((OutputStream)fileData).close();
        this.printTimeString("Download Time", System.currentTimeMillis() - start);
        this.mout.println("");
        this.mout.println("=========================================");
        this.mout.println("IPMI configuration file download done");
        this.mout.println("=========================================");
        try {
            this.fileDownloadDone(reservationID);
        }
        catch (IPMIException ex) {
            throw new Exception("File download done error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("Done");
        this.printTimeString("Total Elapse Time", System.currentTimeMillis() - firstStart);
        return true;
    }

    public boolean biosConfigurationUpload(String fileName, int optionFlag) throws Exception {
        byte[] reservationID;
        File file = new File(fileName);
        boolean rebootFeature = false;
        boolean forceResetFeature = true;
        if ((optionFlag & 1) == 1) {
            rebootFeature = true;
        }
        long firstStart = System.currentTimeMillis();
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Verify support for OOB feature");
        this.mout.println("====================================");
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiInterface);
        try {
            if (ipmiX9BIOSOEMCommand.checkIfProductNotActivated()) {
                throw new Exception("The product key needs to be activated for this device");
            }
            this.mout.println("Product key confirmed successfully");
        }
        catch (IPMIException ex) {
            throw new Exception("Confirm BIOS OOB support error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        try {
            if ((this.getSystemConfiguration() & 0x10) != 16) {
                throw new Exception("BIOS does not support OOB feature");
            }
            this.mout.println("BIOS supports OOB features");
        }
        catch (IPMIException ex) {
            throw new Exception("Confirm BIOS OOB support error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        try {
            this.getBIOSNVUpdateStatus();
            this.mout.println("BMC supports OOB features");
        }
        catch (IPMIException ex) {
            throw new Exception("BMC does not support OOB feature");
        }
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Get reservation ID");
        this.mout.println("====================================");
        try {
            reservationID = this.getUploadResvID();
        }
        catch (IPMIException ex) {
            throw new Exception("Get reservation ID error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("Reservation ID = " + ByteUtility.bytesToHex(reservationID));
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Start uploading BIOS configuration file");
        this.mout.println("====================================");
        long fileSize = file.length();
        byte[] fileSizeByteArray = new byte[4];
        ByteUtility.intTo4Bytes(fileSizeByteArray, 0, (int)fileSize);
        try {
            this.startFileUpload(reservationID, fileSizeByteArray);
        }
        catch (IPMIException ex) {
            throw new Exception("Start file upload error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("File Size: " + fileSize + " bytes");
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Uploading BIOS configuration file");
        this.mout.println("====================================");
        this.mout.print("Progress:|");
        long start = System.currentTimeMillis();
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        int chunkSize = 1024;
        int totalRead = 0;
        int readCount = 0;
        int currentProgress = 0;
        int lastProgress = 0;
        byte[] chunk = new byte[chunkSize];
        while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
            byte[] currentChunk = new byte[4];
            ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
            if (readCount != chunkSize) {
                byte[] lastChunk = new byte[readCount];
                System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                chunk = lastChunk;
            }
            try {
                this.fileUpload(reservationID, currentChunk, chunk);
            }
            catch (IPMIException ex) {
                throw new Exception("File upload error. Location = " + totalRead + "(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
            }
            currentProgress = (int)((long)((totalRead += readCount) * 100) / file.length());
            if (currentProgress <= lastProgress) continue;
            if (currentProgress % 2 == 0) {
                this.mout.print(">");
            }
            lastProgress = currentProgress;
        }
        this.mout.println("| 100%");
        this.printTimeString("Upload Time", System.currentTimeMillis() - start);
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Save BIOS configuration");
        this.mout.println("====================================");
        try {
            this.applyFile(reservationID, (byte)2);
        }
        catch (IPMIException ex) {
            throw new Exception("Apply BIOS configuration file error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("Success");
        if (!rebootFeature) {
            return true;
        }
        int softShutdownWaitingSecs = 300;
        int resetWaitingSecs = 300;
        int detectServerPowerUpSecs = 60;
        int count = 0;
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Reboot & check system power status");
        this.mout.println("====================================");
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiInterface);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiInterface);
        if (this.getPowerStatus() == 1) {
            ipmiChassisCommand.softShutdown();
            this.mout.println("Going to shutdown the system softly");
            if (forceResetFeature) {
                this.mout.println("Wait " + softShutdownWaitingSecs + " seconds for soft shutdown. If the system does not respond, it will be forced to restart automatically.");
            }
            while (count++ != softShutdownWaitingSecs && (count <= 10 || this.getPowerStatus() != 0)) {
                if (count % 60 == 0) {
                    if (count != softShutdownWaitingSecs) {
                        this.mout.println();
                        this.mout.println("Going to shutdown the system softly");
                        ipmiChassisCommand.softShutdown();
                    }
                } else {
                    this.mout.print(".");
                }
                Thread.sleep(1000L);
            }
            this.mout.println("");
        }
        if (this.getPowerStatus() == 0) {
            ipmiChassisCommand.powerUp();
            this.mout.println("Going to power up the system");
        } else if (forceResetFeature) {
            this.mout.println("\nGoing to force shutdown the system");
            ipmiChassisCommand.powerDown();
            Thread.sleep(2000L);
            int i2 = 0;
            this.mout.print("Detecting system power status");
            while (this.getPowerStatus() == 1) {
                if (i2 < 10) {
                    Thread.sleep(1000L);
                    ++i2;
                    continue;
                }
                throw new Exception("Can not shut down this system");
            }
            this.mout.println("\nSystem power status: off");
            Thread.sleep(2000L);
            this.mout.print("\nGoing to power up the system");
            ipmiChassisCommand.powerUp();
        } else {
            throw new Exception("System power status is not soft-off");
        }
        this.mout.println("");
        this.mout.print("Detecting system power status");
        count = 0;
        while (this.getPowerStatus() == 0) {
            if (count++ == detectServerPowerUpSecs) {
                throw new Exception("Can not turn on this system\nDetect system power status timeout");
            }
            this.mout.print(".");
            Thread.sleep(1000L);
        }
        this.mout.println("");
        this.mout.println("System power status: on");
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Confirming BIOS configuration had been applied");
        this.mout.println("====================================");
        count = 0;
        try {
            byte updateStatus;
            while ((updateStatus = this.getBIOSNVUpdateStatus()) == 2) {
                if (count++ == 180) {
                    throw new Exception("Confirm BIOS configuration applied timeout");
                }
                Thread.sleep(1000L);
                this.mout.print(".");
            }
            this.mout.println("");
            if (updateStatus == 0) {
                this.mout.println("Done");
            } else if (updateStatus == 1) {
                throw new Exception("Update BIOS configuration failure");
            }
        }
        catch (IPMIException ex) {
            throw new Exception("Confirm BIOS configuration applied error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.printTimeString("Total Elapse Time", System.currentTimeMillis() - firstStart);
        return true;
    }

    public boolean biosConfigurationDownload(String fileName) throws Exception {
        Object fileData;
        byte[] maxChunkSize;
        byte[] reservationID;
        long firstStart = System.currentTimeMillis();
        this.mout.println("");
        this.mout.println("====================================");
        this.mout.println("Verify support for OOB feature");
        this.mout.println("====================================");
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiInterface);
        try {
            if (ipmiX9BIOSOEMCommand.checkIfProductNotActivated()) {
                throw new Exception("The product key needs to be activated for this device");
            }
            this.mout.println("Product key confirmed successfully");
        }
        catch (IPMIException ex) {
            throw new Exception("Confirm BIOS OOB support error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        try {
            if ((this.getSystemConfiguration() & 0x10) != 16) {
                throw new Exception("BIOS does not support OOB feature");
            }
            this.mout.println("BIOS supports OOB features");
        }
        catch (IPMIException ex) {
            throw new Exception("Confirm BIOS OOB support error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        try {
            this.getBIOSNVUpdateStatus();
            this.mout.println("BMC supports OOB features");
        }
        catch (IPMIException ex) {
            throw new Exception("BMC does not support OOB feature");
        }
        try {
            if ((this.getSetBIOSOOBCapability((byte)0, new byte[]{1, 0, 0, 0, 0})[0] & 1) != 1) {
                throw new Exception("Not support get BIOS settings.");
            }
            this.mout.println("Support get BIOS settings.");
        }
        catch (IPMIException ex) {
            throw new Exception("Get BIOS OOB capability feature error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        try {
            if (this.getBIOSCurrentSettingStatus() == 0) {
                throw new Exception("BIOS NV update status is not available, you must reboot your system");
            }
        }
        catch (IPMIException ex) {
            throw new Exception("Confirm BIOS current setting status error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("BIOS NV update status is available");
        this.mout.println("");
        this.mout.println("=========================================");
        this.mout.println("Prepare BIOS configuration file download");
        this.mout.println("=========================================");
        try {
            reservationID = this.prepareFileDownload((byte)2);
        }
        catch (IPMIException ex) {
            throw new Exception("Get prepare file download error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("Reservation ID = " + ByteUtility.bytesToHex(reservationID));
        this.mout.println("");
        this.mout.println("=========================================");
        this.mout.println("Prepare BIOS configure file download done");
        this.mout.println("=========================================");
        int count = 0;
        try {
            while ((maxChunkSize = this.prepareFileDownloadDone(reservationID)) == null) {
                if (count++ == 30) {
                    throw new Exception("File prepare timeout");
                }
                Thread.sleep(1000L);
                this.mout.print(".");
            }
        }
        catch (IPMIException ex) {
            throw new Exception("Get prepare file download done error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("");
        this.mout.println("Max Chunk Size = " + ByteUtility.bytesToHex(maxChunkSize));
        this.mout.println("");
        this.mout.println("=========================================");
        this.mout.println("BIOS configure file download");
        this.mout.println("=========================================");
        this.mout.print("Progress:|");
        long start = System.currentTimeMillis();
        int fileSize = (maxChunkSize[0] & 0xFF) + ((maxChunkSize[1] & 0xFF) << 8) + ((maxChunkSize[2] & 0xFF) << 16) + ((maxChunkSize[3] & 0xFF) << 24);
        this.mout.println("File Size: " + fileSize + " bytes");
        byte[] fileAry = new byte[fileSize];
        int chunkSize = 1024;
        int totalRead = 0;
        int currentProgress = 0;
        int lastProgress = 0;
        while (totalRead < fileSize) {
            byte[] fileOffset = new byte[4];
            byte[] fileLength = new byte[2];
            ByteUtility.intTo4Bytes(fileOffset, 0, totalRead);
            if (fileSize - totalRead < 1024) {
                ByteUtility.intTo2Bytes(fileLength, 0, fileSize - totalRead);
            } else {
                ByteUtility.intTo2Bytes(fileLength, 0, chunkSize);
            }
            try {
                fileData = this.fileDownload(reservationID, fileOffset, fileLength);
            }
            catch (IPMIException ex) {
                throw new Exception("File download error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
            }
            System.arraycopy(fileData, 0, fileAry, totalRead, ((Object)fileData).length);
            currentProgress = (totalRead += ((Object)fileData).length) * 100 / fileSize;
            if (currentProgress <= lastProgress) continue;
            if (currentProgress % 2 == 0) {
                this.mout.print(">");
            }
            lastProgress = currentProgress;
        }
        this.mout.println("| 100%");
        fileData = new FileOutputStream(fileName);
        ((OutputStream)fileData).write(fileAry);
        ((OutputStream)fileData).close();
        this.printTimeString("Download Time", System.currentTimeMillis() - start);
        this.mout.println("");
        this.mout.println("=========================================");
        this.mout.println("BIOS configuration file download done");
        this.mout.println("=========================================");
        try {
            this.fileDownloadDone(reservationID);
        }
        catch (IPMIException ex) {
            throw new Exception("File download done error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("Done");
        this.printTimeString("Total Elapse Time", System.currentTimeMillis() - firstStart);
        return true;
    }

    public boolean uploadIPMIConfiguration(String fileName) throws Exception {
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiInterface);
        try {
            ipmiBMCFileCommand.fileUpload(fileName);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean downloadIPMIConfiguration(String fileName) throws Exception {
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiInterface);
        try {
            ipmiBMCFileCommand.fileDownload(fileName);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean uploadBIOSConfiguration(String fileName, int optionFlag) throws Exception {
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiInterface);
        try {
            ipmiBMCFileCommand.biosConfigurationUpload(fileName, optionFlag);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean downloadBIOSConfiguration(String fileName) throws Exception {
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiInterface);
        try {
            ipmiBMCFileCommand.biosConfigurationDownload(fileName);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.mout.println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }

    public static void main(String[] args) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiBMCFileCommand.setIPMIInterface(rmcp);
    }
}

