/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCPPlus;

public class IPMIDCMICommand
extends IPMICommand {
    public static final byte GROUP_EXTENSION_ID = -36;

    public IPMIDCMICommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public void CMD_______________________() {
    }

    public IPMIMessage getDCMICapInfoCommand(byte parameter) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-36, parameter};
        ipmiMessage.setCommandAndData((byte)-80, (byte)1, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getAssetTagCommand(byte offset, byte byte2Read) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-36, offset, byte2Read};
        ipmiMessage.setCommandAndData((byte)-80, (byte)6, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAssetTagCommand(byte offset, byte dataLength, byte[] data2Write) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + data2Write.length];
        data[0] = -36;
        data[1] = offset;
        data[2] = dataLength;
        System.arraycopy(data2Write, 0, data, 3, data2Write.length);
        ipmiMessage.setCommandAndData((byte)-80, (byte)8, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMagControllerIdStringCommand(byte offset, byte byte2Read) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-36, offset, byte2Read};
        ipmiMessage.setCommandAndData((byte)-80, (byte)9, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setMagControllerIdStringCommand(byte offset, byte dataLength, byte[] data2Write) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + data2Write.length];
        data[0] = -36;
        data[1] = offset;
        data[2] = dataLength;
        System.arraycopy(data2Write, 0, data, 3, data2Write.length);
        ipmiMessage.setCommandAndData((byte)-80, (byte)10, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDCMISensorInfoCommand(byte sensorType, byte entityID, byte entityInstance, byte entityInstanceStart) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-36, sensorType, entityID, entityInstance, entityInstanceStart};
        ipmiMessage.setCommandAndData((byte)-80, (byte)7, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerReadingCommand(byte mode, byte attribute, byte rev) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-36, mode, attribute, rev};
        ipmiMessage.setCommandAndData((byte)-80, (byte)2, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerLimitCommand(byte rev1, byte rev2) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-36, rev1, rev2};
        ipmiMessage.setCommandAndData((byte)-80, (byte)2, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPowerLimitCommand(byte rev1, byte rev2, byte rev3, byte action, byte[] limitWatts, byte[] correctionTime, byte rev4, byte rev5, byte[] period) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-36, rev1, rev2, rev3, action, limitWatts[0], limitWatts[1], correctionTime[0], correctionTime[1], correctionTime[2], correctionTime[3], rev4, rev5, period[0], period[1]};
        ipmiMessage.setCommandAndData((byte)-80, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void API_______________________() {
    }

    public static DCMICapabilitiesInfo getDCMICapabilitiesInfoByIP(String ip, int timeout, int retry) throws IPMIException {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setTimeout(timeout);
        config.setRetry(retry);
        config.setIp(ip);
        config.setCipherSuiteID((byte)0);
        RMCPPlus rmcp = new RMCPPlus();
        rmcp.initialize(config);
        IPMIDCMICommand ipmiDCMICommand = new IPMIDCMICommand(rmcp);
        DCMICapabilitiesInfo d2 = ipmiDCMICommand.getDCMICapabilitiesInfo();
        rmcp.closeSocket();
        return d2;
    }

    public DCMICapabilitiesInfo getDCMICapabilitiesInfo() throws IPMIException {
        byte[] byteArray1 = this.getDCMICapabilities();
        byte[] byteArray2 = this.getPlatformAttrbutes();
        byte[] byteArray3 = this.getOptPlatformAttrbutes();
        byte[] byteArray4 = this.getManageAccessAttrbutes();
        byte major = byteArray1[1];
        byte minor = byteArray1[2];
        DCMICapabilitiesInfo dcmiCap = new DCMICapabilitiesInfo(major, minor);
        dcmiCap.dcmiCapabilities.fromRaw(byteArray1);
        dcmiCap.platformAttributes.fromRaw(byteArray2);
        dcmiCap.optPlatformAttributes.fromRaw(byteArray3);
        dcmiCap.manageAccessAttributes.fromRaw(byteArray4);
        return dcmiCap;
    }

    public byte[] getDCMICapabilities() throws IPMIException {
        IPMIMessage resMessage = this.getDCMICapInfoCommand((byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getDCMICapInfoCommand(1) failed");
    }

    public byte[] getPlatformAttrbutes() throws IPMIException {
        IPMIMessage resMessage = this.getDCMICapInfoCommand((byte)2);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getDCMICapInfoCommand(2) failed");
    }

    public byte[] getOptPlatformAttrbutes() throws IPMIException {
        IPMIMessage resMessage = this.getDCMICapInfoCommand((byte)3);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getDCMICapInfoCommand(3) failed");
    }

    public byte[] getManageAccessAttrbutes() throws IPMIException {
        IPMIMessage resMessage = this.getDCMICapInfoCommand((byte)4);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getDCMICapInfoCommand(4) failed");
    }

    public void ENTITY_______________________() {
    }

    public static void main_main(String[] args) throws IPMIException {
        if (args.length <= 1) {
            System.out.println("Param: [IP] [command]");
            System.out.println("0 -> test System GUID");
            System.out.println("1 -> test DCMI CAP");
            return;
        }
        String ip = args[0];
        String cmd = args[1];
        if (cmd.equals("0")) {
            byte[] byteArray = IPMIMessagingCommand.getSystemGUIDByIP(args[0]);
            System.out.println(ByteUtility.bytesToHex(byteArray));
        } else if (cmd.equals("1")) {
            System.out.println(IPMIDCMICommand.getDCMICapabilitiesInfoByIP(args[0], 5, 2).toString());
        }
    }

    public static void main(String[] args) throws IPMIException {
        System.out.println(IPMIDCMICommand.getDCMICapabilitiesInfoByIP("192.168.12.151", 5, 2).toString());
    }

    public static void main_______(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.151");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIDCMICommand ipmiDCMICommand = new IPMIDCMICommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiDCMICommand.setIPMIInterface(rmcp);
        DCMICapabilitiesInfo d2 = null;
        try {
            d2 = ipmiDCMICommand.getDCMICapabilitiesInfo();
        }
        catch (IPMIException ex) {
            // empty catch block
        }
        System.out.println(d2.toString());
    }

    public class DCMICapabilitiesInfo {
        public byte majorVersion;
        public byte minorVersion;
        public DCMICapabilities dcmiCapabilities;
        public ManageAccessAttributes manageAccessAttributes;
        public OptPlatformAttributes optPlatformAttributes;
        public PlatformAttributes platformAttributes;

        public String getDCMIVersion() {
            return "" + this.majorVersion + "." + this.minorVersion;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DCMI Version = " + this.getDCMIVersion() + "\n");
            sb.append(this.dcmiCapabilities.toString());
            sb.append(this.platformAttributes.toString());
            sb.append(this.optPlatformAttributes.toString());
            sb.append(this.manageAccessAttributes.toString());
            return sb.toString();
        }

        public DCMICapabilitiesInfo(byte major, byte minor) {
            this.setVersion(major, minor);
            this.dcmiCapabilities = new DCMICapabilities();
            this.manageAccessAttributes = new ManageAccessAttributes();
            this.optPlatformAttributes = new OptPlatformAttributes();
            this.platformAttributes = new PlatformAttributes();
        }

        public void setVersion(byte major, byte minor) {
            this.majorVersion = major;
            this.minorVersion = minor;
        }

        public String BS(byte b2) {
            return ByteUtility.byteToHex(b2) + " ";
        }

        public class ManageAccessAttributes {
            public byte byte1;
            public byte byte2;
            public byte byte3;

            public void fromRaw(byte[] raw) {
                this.byte1 = raw[4];
                this.byte2 = raw[5];
                this.byte3 = raw[6];
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append("Manageability Access Attributes\n");
                sb.append("Mandatory Primary LAN OOB Support(RMCP+ Support Only) :" + (this.byte1 == 255 ? "Not supported" : "supported") + "\n");
                sb.append("Optional Secondary LAN OOB Support(RMCP+ Support Only):" + (this.byte2 == 255 ? "Not supported" : "supported") + "\n");
                sb.append("Optional Serial OOB TMODE Capability                  :" + (this.byte3 == 255 ? "Not supported" : "supported") + "\n");
                return sb.toString();
            }
        }

        public class OptPlatformAttributes {
            public byte byte1;
            public byte byte2;

            public void fromRaw(byte[] raw) {
                this.byte1 = raw[4];
                this.byte2 = raw[5];
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append("Power Management Device Slave Address\n");
                sb.append("7-bit I2C Slave Address of device on IPMB  :" + ByteUtility.byteToHex((byte)(this.byte1 >> 1)) + "\n\n");
                sb.append("Power Management Controller Channel Number\n");
                sb.append("Channel Number    :" + ByteUtility.byteToHex((byte)(this.byte2 >> 4)) + "\n");
                sb.append("Device Revision   :" + ByteUtility.byteToHex((byte)(this.byte2 & 0xF)) + "\n\n");
                return sb.toString();
            }
        }

        public class PlatformAttributes {
            public byte byte1;
            public byte byte2;
            public byte byte3;
            public byte byte4;
            public byte byte5;

            public void fromRaw(byte[] raw) {
                this.byte1 = raw[4];
                this.byte2 = raw[5];
                this.byte3 = raw[6];
                this.byte4 = raw[7];
                if (DCMICapabilitiesInfo.this.majorVersion == 1 && DCMICapabilitiesInfo.this.minorVersion > 1) {
                    this.byte5 = raw[4];
                }
            }

            public String toString() {
                String NP = "Not presnt";
                String A = "Available";
                StringBuffer sb = new StringBuffer();
                sb.append("SEL Attributes\n");
                sb.append("SEL automatic rollover enabled    :" + ((byte)(this.byte1 & 0x80) == -128 ? A : NP) + "\n");
                sb.append("Number of SEL entries             :" + (this.byte1 << 8 & 3840 + this.byte2) + "\n\n");
                sb.append("Identification Attributes\n");
                sb.append("Asset Tag Support       :" + ((byte)(this.byte3 & 4) == 4 ? A : NP) + "\n");
                sb.append("DHCP Host Name Support  :" + ((byte)(this.byte3 & 2) == 2 ? A : NP) + "\n");
                sb.append("GUID Support            :" + ((byte)(this.byte3 & 1) == 1 ? A : NP) + "\n\n");
                sb.append("Temperature Monitoring\n");
                sb.append("Baseboard temperature   :" + ((byte)(this.byte4 & 4) == 4 ? "At least 1" : NP) + "\n");
                sb.append("Processors temperature  :" + ((byte)(this.byte4 & 2) == 2 ? "At least 1" : NP) + "\n");
                sb.append("Inlet temperature       :" + ((byte)(this.byte4 & 1) == 1 ? "At least 1" : NP) + "\n\n");
                return sb.toString();
            }
        }

        public class DCMICapabilities {
            public byte byte1;
            public byte byte2;
            public byte byte3;

            public void fromRaw(byte[] raw) {
                this.byte1 = raw[4];
                this.byte2 = raw[5];
                this.byte3 = raw[6];
            }

            public String toString() {
                String NC = "Not Compliant";
                String C = "Compliant";
                String NP = "Not present";
                String A = "Available";
                StringBuffer sb = new StringBuffer();
                sb.append("Mandatory Platform capabilities\n");
                sb.append("Temperature Monitor    :" + ((byte)(this.byte1 & 8) == 8 ? C : NC) + "\n");
                sb.append("Chassis Power          :" + ((byte)(this.byte1 & 4) == 4 ? C : NC) + "\n");
                sb.append("SEL logging            :" + ((byte)(this.byte1 & 2) == 2 ? C : NC) + "\n");
                sb.append("Identification Support :" + ((byte)(this.byte1 & 1) == 1 ? C : NC) + "\n\n");
                sb.append("Optional Platform capabilities\n");
                sb.append("Power Management       :" + ((byte)(this.byte2 & 1) == 1 ? C : NC) + "\n\n");
                sb.append("Manageability Access Capabilities\n");
                sb.append("VLAN Capable                           :" + ((byte)(this.byte3 & 0x20) == 32 ? A : NP) + "\n");
                sb.append("SOL Supported                          :" + ((byte)(this.byte3 & 0x10) == 16 ? A : NP) + "\n");
                sb.append("OOB Primary LAN Channel Available      :" + ((byte)(this.byte3 & 8) == 8 ? A : NP) + "\n");
                sb.append("OOB Secondary LAN Channel Available    :" + ((byte)(this.byte3 & 4) == 4 ? A : NP) + "\n");
                sb.append("OOB Serial TMODE Available             :" + ((byte)(this.byte3 & 2) == 2 ? A : NP) + "\n");
                sb.append("In-Band KCS Channel Available          :" + ((byte)(this.byte3 & 1) == 1 ? A : NP) + "\n\n");
                return sb.toString();
            }
        }
    }
}

