/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.FRU_Internal;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class IPMII2CPMBusCommand
extends IPMICommand {
    IPMIMessagingCommand ipmiMessageCommand;
    byte busID;
    public byte[] slaveAddrs = new byte[]{120, 122, 124, 126, -80, -78, -76, -74};
    byte[] availableSlaveAddrs;
    byte slaveAddr;
    HashMap slaveAddrsToModuleName;
    public byte[] slaveAddrsFRU = new byte[]{112, 114, 116, 118, -96, -94, -92, -90};
    byte[] availableSlaveAddrsFRU;
    byte slaveAddrFRU;
    HashMap slaveAddrsFruToModuleName;
    public byte[] slaveAddrsFRUBBP = new byte[]{112, 114, 116, 118};
    byte[] availableSlaveAddrsFRUBBP;
    byte slaveAddrFRUBBP;
    HashMap slaveAddrsFruBBPToModuleName;
    String[] noneStandardSMCPowerSupplies = new String[]{"PWS-721P", "PWS-703P", "PWS-704P", "PWS-1K41P", "PWS-1K41F", "PWS-1K21P", "PWS-1K62P", "PWS-504P-RR", "PWS-920P-1R", "PWS-1K11P"};

    public IPMII2CPMBusCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
        this.slaveAddrsToModuleName = new HashMap();
        this.slaveAddrsFruToModuleName = new HashMap();
        this.slaveAddrsFruBBPToModuleName = new HashMap();
        this.slaveAddrsToModuleName.put(new Byte(-80), "PS 1");
        this.slaveAddrsToModuleName.put(new Byte(-78), "PS 2");
        this.slaveAddrsToModuleName.put(new Byte(-76), "PS 3");
        this.slaveAddrsToModuleName.put(new Byte(-74), "PS 4");
        this.slaveAddrsToModuleName.put(new Byte(120), "PS 1");
        this.slaveAddrsToModuleName.put(new Byte(122), "PS 2");
        this.slaveAddrsToModuleName.put(new Byte(124), "PS 3");
        this.slaveAddrsToModuleName.put(new Byte(126), "PS 4");
        this.slaveAddrsFruToModuleName.put(new Byte(112), "PS 1");
        this.slaveAddrsFruToModuleName.put(new Byte(114), "PS 2");
        this.slaveAddrsFruToModuleName.put(new Byte(116), "PS 3");
        this.slaveAddrsFruToModuleName.put(new Byte(118), "PS 4");
        this.slaveAddrsFruToModuleName.put(new Byte(-96), "PS 1");
        this.slaveAddrsFruToModuleName.put(new Byte(-94), "PS 2");
        this.slaveAddrsFruToModuleName.put(new Byte(-92), "PS 3");
        this.slaveAddrsFruToModuleName.put(new Byte(-90), "PS 4");
        this.slaveAddrsFruBBPToModuleName.put(new Byte(112), "BBP 1");
        this.slaveAddrsFruBBPToModuleName.put(new Byte(114), "BBP 2");
        this.slaveAddrsFruBBPToModuleName.put(new Byte(116), "BBP 3");
        this.slaveAddrsFruBBPToModuleName.put(new Byte(118), "BBP 4");
    }

    @Override
    public void setIPMIInterface(IPMIInterface ipmiInterface) {
        this.ipmiInterface = ipmiInterface;
        this.ipmiMessageCommand.setIPMIInterface(ipmiInterface);
    }

    public IPMII2CPMBusCommand(IPMIInterface ipmiInterface, byte busID, byte slaveAddr) {
        super(ipmiInterface);
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
        this.busID = busID;
        this.slaveAddr = slaveAddr;
    }

    public byte[] sendPMBusCommand(byte readCount, byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddr, readCount, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (PMBus)");
    }

    public byte[] sendFRUCommand(byte readCount, byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddrFRU, readCount, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (FRU)");
    }

    public byte[] sendFRUBBPCommand(byte readCount, byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, this.slaveAddrFRUBBP, readCount, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (BBP)");
    }

    private void PMBUS_API____________() {
    }

    public byte detectBusID() {
        block4: {
            block5: {
                byte[] guid;
                block3: {
                    block2: {
                        IPMIMessagingCommand impiMessagingCommand = new IPMIMessagingCommand(this.ipmiInterface);
                        guid = this.ipmiMessageCommand.getSystemGUID();
                        if (IPMIMessagingCommand.isAMIGUID(guid)) break block2;
                        if (IPMIMessagingCommand.isATENGUID(guid)) break block2;
                        if (IPMIMessagingCommand.isAMIX9GUID(guid)) break block2;
                        if (IPMIMessagingCommand.isAMIAspeedGUID(guid)) break block2;
                        if (!IPMIMessagingCommand.isATENAspeedGUID(guid)) break block3;
                    }
                    this.busID = (byte)7;
                    break block4;
                }
                if (IPMIMessagingCommand.isPepperconGUID(guid)) break block5;
                if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) break block5;
                if (!IPMIMessagingCommand.isSIMBL(guid)) break block4;
            }
            this.busID = (byte)5;
        }
        return this.busID;
    }

    public void detectSlaveAddress() {
        int i2;
        if (this.busID == 0) {
            return;
        }
        Vector<Byte> temp = new Vector<Byte>();
        for (i2 = 0; i2 < this.slaveAddrs.length; ++i2) {
            this.slaveAddr = this.slaveAddrs[i2];
            try {
                this.getVOUT_MODE();
                temp.add(new Byte(this.slaveAddrs[i2]));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (temp.size() != 0) {
            this.availableSlaveAddrs = new byte[temp.size()];
            for (i2 = 0; i2 < temp.size(); ++i2) {
                this.availableSlaveAddrs[i2] = (Byte)temp.get(i2);
            }
        }
    }

    public byte getVOUT_MODE() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{32};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte getStatusByte() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{120};
        byte[] result = this.sendPMBusCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte[] readACInputVoltage() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-120};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readACInputCurrent() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-119};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readDC12VOutputVoltage() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-117};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readDC12VOutputCurrent() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-116};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readTemperature1() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-115};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readTemperature2() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-114};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readFan1() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-112};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readFan2() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-111};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readDC12VOutputPower() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-106};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] readACInputPower() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-105};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] getPMBusRevision() throws Exception {
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{-104};
        return this.sendPMBusCommand(readCount, dataToWrite);
    }

    public byte[] getPWSSerialNumber() throws Exception {
        if (this.is1K66PMBusCase()) {
            byte[] result = this.readSerialNumberFRU();
            return result;
        }
        byte[] commands = new byte[]{-48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34};
        byte readCount = 1;
        byte[] result = new byte[commands.length];
        for (int i2 = 0; i2 < commands.length; ++i2) {
            byte[] dataToWrite = new byte[]{commands[i2]};
            byte[] r = this.sendPMBusCommand(readCount, dataToWrite);
            if (r[0] == -1 || r[0] == 0 || r.length == 0) continue;
            result[i2] = r[0];
        }
        return result;
    }

    public byte[] getPWSModuleNumber() throws Exception {
        if (this.is1K66PMBusCase()) {
            byte[] result = this.readModuleNumberFRU();
            return result;
        }
        byte[] commands = new byte[]{-32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21};
        byte readCount = 1;
        byte[] result = new byte[commands.length];
        for (int i2 = 0; i2 < commands.length; ++i2) {
            byte[] dataToWrite = new byte[]{commands[i2]};
            byte[] r = this.sendPMBusCommand(readCount, dataToWrite);
            if (r[0] == -1 || r[0] == 0 || r.length == 0) continue;
            result[i2] = r[0];
        }
        return result;
    }

    public byte[] getPWSRevision() throws Exception {
        if (this.is1K66PMBusCase()) {
            byte[] result = this.readRevisionFRU();
            return result;
        }
        byte[] commands = new byte[]{-16, -15, -14, -13, -12, -11};
        byte readCount = 1;
        byte[] result = new byte[commands.length];
        for (int i2 = 0; i2 < commands.length; ++i2) {
            byte[] dataToWrite = new byte[]{commands[i2]};
            byte[] r = this.sendPMBusCommand(readCount, dataToWrite);
            if (r[0] == -1 || r[0] == 0 || r.length == 0) continue;
            result[i2] = r[0];
        }
        return result;
    }

    public PMBusHealth getAll() throws Exception {
        PMBusHealth pmBusHealth = new PMBusHealth();
        try {
            pmBusHealth.VOUT_MODE = this.getVOUT_MODE();
            pmBusHealth.isVOUT_MODE = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.statusByte = this.getStatusByte();
            pmBusHealth.isStatusByte = true;
        }
        catch (Exception ex1) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.acInputVoltage = this.readACInputVoltage();
            pmBusHealth.isAcInputVoltage = true;
        }
        catch (Exception ex2) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.acInputCurrent = this.readACInputCurrent();
            pmBusHealth.isAcInputCurrent = true;
        }
        catch (Exception ex3) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.dc12VOutputVoltage = this.readDC12VOutputVoltage();
            pmBusHealth.isDc12VOutputVoltage = true;
        }
        catch (Exception ex4) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.dc12VOutputCurrent = this.readDC12VOutputCurrent();
            pmBusHealth.isDc12VOutputCurrent = true;
        }
        catch (Exception ex5) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.temperature1 = this.readTemperature1();
            pmBusHealth.isTemperature1 = true;
        }
        catch (Exception ex6) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.temperature2 = this.readTemperature2();
            pmBusHealth.isTemperature2 = true;
        }
        catch (Exception ex7) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.fan1 = this.readFan1();
            pmBusHealth.isFan1 = true;
        }
        catch (Exception ex8) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.fan2 = this.readFan2();
            pmBusHealth.isFan2 = true;
        }
        catch (Exception ex9) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.dc12VOutputPower = this.readDC12VOutputPower();
            pmBusHealth.isDc12VOutputPower = true;
        }
        catch (Exception ex10) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.acInputPower = this.readACInputPower();
            pmBusHealth.isAcInputPower = true;
        }
        catch (Exception ex11) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.pmBusRevision = this.getPMBusRevision();
            pmBusHealth.isPmBusRevision = true;
        }
        catch (Exception ex12) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.pwsSerialNumber = this.getPWSSerialNumber();
            pmBusHealth.isPwsSerialNumber = true;
        }
        catch (Exception ex13) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.pwsModuleNumber = this.getPWSModuleNumber();
            pmBusHealth.isPwsModuleNumber = true;
        }
        catch (Exception ex14) {
            // empty catch block
        }
        this.delay();
        try {
            pmBusHealth.pwsRevision = this.getPWSRevision();
            pmBusHealth.isPwsRevision = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        return pmBusHealth;
    }

    public void delay() {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean is1K66PMBusCase() {
        if (this.slaveAddr == -80 || this.slaveAddr == -78 || this.slaveAddr == -76 || this.slaveAddr == -74) {
            this.slaveAddrFRU = (byte)(this.slaveAddr - 16);
            try {
                byte b2 = this.readStatusByFRU();
                if ((byte)(b2 & 0x80) != -128) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void FRU_API____________() {
    }

    public void detectSlaveAddressFRU() {
        int i2;
        if (this.busID == 0) {
            return;
        }
        Vector<Byte> temp = new Vector<Byte>();
        for (i2 = 0; i2 < this.slaveAddrsFRU.length; ++i2) {
            this.slaveAddrFRU = this.slaveAddrsFRU[i2];
            try {
                byte b2 = this.readStatusByFRU();
                if ((byte)(b2 & 0x80) == -128) continue;
                temp.add(new Byte(this.slaveAddrsFRU[i2]));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (temp.size() != 0) {
            this.availableSlaveAddrsFRU = new byte[temp.size()];
            for (i2 = 0; i2 < temp.size(); ++i2) {
                this.availableSlaveAddrsFRU[i2] = (Byte)temp.get(i2);
            }
        }
    }

    public byte readStatusByFRU() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{12};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte readTemperatureByFRU() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{9};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte readFan1ByFRU() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{10};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte readFan2ByFRU() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{11};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result[0];
    }

    public FRUHealth getAllFRU() throws Exception {
        FRUHealth fruHealth = new FRUHealth();
        if (this.is1K66FRUCase()) {
            return fruHealth;
        }
        try {
            fruHealth.statusByte = this.readStatusByFRU();
            fruHealth.isStatusByte = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.delay();
        try {
            fruHealth.temperature = this.readTemperatureByFRU();
            fruHealth.isTemperature = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.delay();
        try {
            fruHealth.fan1 = this.readFan1ByFRU();
            fruHealth.isFan1 = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.delay();
        try {
            fruHealth.fan2 = this.readFan2ByFRU();
            fruHealth.isFan2 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay();
        return fruHealth;
    }

    public byte[] readSerialNumberFRU() throws Exception {
        byte readCount = 15;
        byte[] dataToWrite = new byte[]{69};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] readModuleNumberFRU() throws Exception {
        byte readCount = 12;
        byte[] dataToWrite = new byte[]{39};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result;
    }

    public byte[] readRevisionFRU() throws Exception {
        byte readCount = 3;
        byte[] dataToWrite = new byte[]{65};
        byte[] result = this.sendFRUCommand(readCount, dataToWrite);
        return result;
    }

    public boolean is1K66FRUCase() {
        if (this.slaveAddrFRU == -96 || this.slaveAddrFRU == -94 || this.slaveAddrFRU == -92 || this.slaveAddrFRU == -90) {
            this.slaveAddr = (byte)(this.slaveAddrFRU + 16);
            try {
                this.getVOUT_MODE();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void BBP_API____________() {
    }

    public void detectSlaveAddressFRUBBP() {
        int i2;
        if (this.busID == 0) {
            return;
        }
        Vector<Byte> tempVector = new Vector<Byte>();
        for (i2 = 0; i2 < this.slaveAddrsFRUBBP.length; ++i2) {
            this.slaveAddrFRUBBP = this.slaveAddrsFRUBBP[i2];
            try {
                byte status = this.readStatusByFRUBBP();
                if ((status & 0xFFFFFF80) != -128) continue;
                tempVector.add(new Byte(this.slaveAddrsFRUBBP[i2]));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (tempVector.size() != 0) {
            this.availableSlaveAddrsFRUBBP = new byte[tempVector.size()];
            for (i2 = 0; i2 < tempVector.size(); ++i2) {
                this.availableSlaveAddrsFRUBBP[i2] = (Byte)tempVector.get(i2);
            }
        }
    }

    public BBPHealth getAllBBP() throws Exception {
        byte[] BBPFRURaw = new byte[256];
        for (int i2 = 0; i2 < 8; ++i2) {
            byte[] tempRaw = this.read32bytesFRUBBP((byte)(i2 * 32));
            System.arraycopy(tempRaw, 0, BBPFRURaw, i2 * 32, 32);
        }
        BBPHealth bbpHealth = new BBPHealth();
        bbpHealth.fromRaw(BBPFRURaw);
        return bbpHealth;
    }

    public byte readStatusByFRUBBP() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{12};
        byte[] result = this.sendFRUBBPCommand(readCount, dataToWrite);
        return result[0];
    }

    public byte[] read32bytesFRUBBP(byte offset) throws Exception {
        byte readCount = 32;
        byte[] dataToWrite = new byte[]{offset};
        byte[] result = this.sendFRUBBPCommand(readCount, dataToWrite);
        return result;
    }

    public void setAutoDischargeCommand(byte day) throws Exception {
        byte readCount = 0;
        byte value = (byte)(0xFFFFFF80 | day);
        byte[] dataToWrite = new byte[]{-22, value};
        this.sendFRUBBPCommand(readCount, dataToWrite);
    }

    public void setUserDischargeCommand() throws Exception {
        byte readCount = 0;
        byte day = this.read0xE9Offset();
        day = (byte)(day & 0x3F);
        byte value = (byte)(0x40 | day);
        byte[] dataToWrite = new byte[]{-22, value};
        this.sendFRUBBPCommand(readCount, dataToWrite);
    }

    public byte read0xE9Offset() throws Exception {
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-23};
        byte[] result = this.sendFRUBBPCommand(readCount, dataToWrite);
        return result[0];
    }

    public void setBBPCommand(byte offset, byte data) throws Exception {
        byte readCount = 0;
        byte[] dataToWrite = new byte[]{offset, data};
        byte[] result = this.sendFRUBBPCommand(readCount, dataToWrite);
    }

    private void CLASS__________() {
    }

    private void MAIN____________() {
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.137");
        config.setUserName("TEST");
        config.setPassword("TEST");
        config.setPrivilege((byte)4);
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiI2CPMBusCommand);
        if (sessionController == null) {
            return;
        }
        try {
            ipmiI2CPMBusCommand.detectBusID();
            ipmiI2CPMBusCommand.detectSlaveAddressFRUBBP();
            for (int i2 = 0; i2 < ipmiI2CPMBusCommand.availableSlaveAddrsFRUBBP.length; ++i2) {
                ipmiI2CPMBusCommand.setSlaveAddrFRUBBP(ipmiI2CPMBusCommand.availableSlaveAddrsFRUBBP[i2]);
                BBPHealth bbpHeath = ipmiI2CPMBusCommand.getAllBBP();
                System.out.println(bbpHeath.toFormatedHeader());
                System.out.println(bbpHeath.toFormatedString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sessionController.closeSession();
    }

    public byte getBusID() {
        return this.busID;
    }

    public byte getSlaveAddr() {
        return this.slaveAddr;
    }

    public byte[] getAvailableSlaveAddrs() {
        return this.availableSlaveAddrs;
    }

    public ArrayList getAvailableSlaveAddrsName() {
        ArrayList list = new ArrayList();
        if (this.availableSlaveAddrs == null) {
            return list;
        }
        for (int i2 = 0; i2 < this.availableSlaveAddrs.length; ++i2) {
            Byte b2 = new Byte(this.availableSlaveAddrs[i2]);
            list.add(this.slaveAddrsToModuleName.get(b2));
        }
        return list;
    }

    public byte getSlaveAddrFRU() {
        return this.slaveAddrFRU;
    }

    public byte[] getAvailableSlaveAddrsFRU() {
        return this.availableSlaveAddrsFRU;
    }

    public ArrayList getAvailableSlaveAddrsFRUName() {
        ArrayList list = new ArrayList();
        if (this.availableSlaveAddrsFRU == null) {
            return list;
        }
        for (int i2 = 0; i2 < this.availableSlaveAddrsFRU.length; ++i2) {
            Byte b2 = new Byte(this.availableSlaveAddrsFRU[i2]);
            list.add(this.slaveAddrsFruToModuleName.get(b2));
        }
        return list;
    }

    public byte[] getAvailableSlaveAddrsFRUBBP() {
        return this.availableSlaveAddrsFRUBBP;
    }

    public ArrayList getAvailableSlaveAddrsFRUBBPName() {
        ArrayList list = new ArrayList();
        if (this.availableSlaveAddrsFRUBBP == null) {
            return list;
        }
        for (int i2 = 0; i2 < this.availableSlaveAddrsFRUBBP.length; ++i2) {
            Byte b2 = new Byte(this.availableSlaveAddrsFRUBBP[i2]);
            list.add(this.slaveAddrsFruBBPToModuleName.get(b2));
        }
        return list;
    }

    public void setBusID(byte busID) {
        this.busID = busID;
    }

    public void setSlaveAddr(byte slaveAddr) {
        this.slaveAddr = slaveAddr;
    }

    public void setSlaveAddrFRU(byte slaveAddrFRU) {
        this.slaveAddrFRU = slaveAddrFRU;
    }

    public void setSlaveAddrFRUBBP(byte slaveAddrFRUBBP) {
        this.slaveAddrFRUBBP = slaveAddrFRUBBP;
    }

    public int getModule(byte aSlaveAddr) {
        if (aSlaveAddr == 120) {
            return 1;
        }
        if (aSlaveAddr == 122) {
            return 2;
        }
        if (aSlaveAddr == 124) {
            return 3;
        }
        if (aSlaveAddr == 126) {
            return 4;
        }
        if (aSlaveAddr == 176) {
            return 1;
        }
        if (aSlaveAddr == 178) {
            return 2;
        }
        if (aSlaveAddr == 180) {
            return 3;
        }
        if (aSlaveAddr == 182) {
            return 4;
        }
        return 0;
    }

    public int getModuleByFRU(byte aSlaveAddrFRU) {
        if (aSlaveAddrFRU == 112) {
            return 1;
        }
        if (aSlaveAddrFRU == 114) {
            return 2;
        }
        if (aSlaveAddrFRU == 116) {
            return 3;
        }
        if (aSlaveAddrFRU == 118) {
            return 4;
        }
        if (aSlaveAddrFRU == 160) {
            return 1;
        }
        if (aSlaveAddrFRU == 162) {
            return 2;
        }
        if (aSlaveAddrFRU == 164) {
            return 3;
        }
        if (aSlaveAddrFRU == 166) {
            return 4;
        }
        return 0;
    }

    public int getModuleByFRUBBP(byte aSlaveAddrFRUBBP) {
        if (aSlaveAddrFRUBBP == 112) {
            return 1;
        }
        if (aSlaveAddrFRUBBP == 114) {
            return 2;
        }
        if (aSlaveAddrFRUBBP == 116) {
            return 3;
        }
        if (aSlaveAddrFRUBBP == 118) {
            return 4;
        }
        return 0;
    }

    public class PMBusHealth {
        public byte VOUT_MODE;
        public byte statusByte;
        public byte[] acInputVoltage;
        public byte[] acInputCurrent;
        public byte[] dc12VOutputVoltage;
        public byte[] dc12VOutputCurrent;
        public byte[] temperature1;
        public byte[] temperature2;
        public byte[] fan1;
        public byte[] fan2;
        public byte[] dc12VOutputPower;
        public byte[] acInputPower;
        public byte[] pmBusRevision;
        public byte[] pwsSerialNumber;
        public byte[] pwsModuleNumber;
        public byte[] pwsRevision;
        public boolean isVOUT_MODE;
        public boolean isStatusByte;
        public boolean isAcInputVoltage;
        public boolean isAcInputCurrent;
        public boolean isDc12VOutputVoltage;
        public boolean isDc12VOutputCurrent;
        public boolean isTemperature1;
        public boolean isTemperature2;
        public boolean isFan1;
        public boolean isFan2;
        public boolean isDc12VOutputPower;
        public boolean isAcInputPower;
        public boolean isPmBusRevision;
        public boolean isPwsSerialNumber;
        public boolean isPwsModuleNumber;
        public boolean isPwsRevision;

        public double getACInputVoltage() {
            byte[] temp = new byte[]{this.acInputVoltage[0], this.acInputVoltage[1]};
            double returnValue = this.linearDataFormat(temp);
            return returnValue;
        }

        public double getACInputCurrent() {
            byte[] temp = new byte[]{this.acInputCurrent[0], this.acInputCurrent[1]};
            double returnValue = this.linearDataFormat(temp);
            return returnValue;
        }

        public double getDC12VOutputVoltage() {
            byte[] temp = new byte[]{this.dc12VOutputVoltage[0], this.dc12VOutputVoltage[1]};
            double returnValue = 0.0;
            if (this.VOUT_MODE == 0) {
                returnValue = this.linearDataFormat(temp);
            } else {
                double factor = (this.VOUT_MODE & 0x10) == 16 ? Math.pow(2.0, (byte)(this.VOUT_MODE | 0xE0)) : Math.pow(2.0, this.VOUT_MODE & 0x1F);
                int reading = ByteUtility.twoBytesToIntLSB(temp);
                returnValue = (double)reading * factor;
            }
            return returnValue;
        }

        public double getDC12VOutputCurrent() {
            byte[] temp = new byte[]{this.dc12VOutputCurrent[0], this.dc12VOutputCurrent[1]};
            double returnValue = this.linearDataFormat(temp);
            return returnValue;
        }

        public int getTemperature1() {
            byte[] temp = new byte[]{this.temperature1[0], this.temperature1[1]};
            int reading = (int)this.linearDataFormat(temp);
            return reading;
        }

        public int getTemperature2() {
            byte[] temp = new byte[]{this.temperature2[0], this.temperature2[1]};
            int reading = (int)this.linearDataFormat(temp);
            return reading;
        }

        public double getFan1() {
            byte[] temp = new byte[]{this.fan1[0], this.fan1[1]};
            double returnValue = 0.0;
            if (this.isSMCOldPower()) {
                temp[1] = (byte)(temp[1] & 0x3F);
                int reading = ByteUtility.twoBytesToIntLSB(temp);
                returnValue = (double)(reading * 30) / 0.262;
            } else {
                returnValue = this.linearDataFormat(temp);
            }
            return returnValue;
        }

        public double getFan2() {
            byte[] temp = new byte[]{this.fan2[0], this.fan2[1]};
            double returnValue = 0.0;
            if (this.isSMCOldPower()) {
                temp[1] = (byte)(temp[1] & 0x3F);
                int reading = ByteUtility.twoBytesToIntLSB(temp);
                returnValue = (double)(reading * 30) / 0.262;
            } else {
                returnValue = this.linearDataFormat(temp);
            }
            return returnValue;
        }

        public int getDC12VOutputPower() {
            byte[] temp = new byte[]{this.dc12VOutputPower[0], this.dc12VOutputPower[1]};
            int reading = (int)this.linearDataFormat(temp);
            return reading;
        }

        public int getACInputPower() {
            byte[] temp = new byte[]{this.acInputPower[0], this.acInputPower[1]};
            int reading = (int)this.linearDataFormat(temp);
            return reading;
        }

        public String getPMBusRevision() {
            return "0x" + ByteUtility.byteToHex(this.pmBusRevision[1]) + ByteUtility.byteToHex(this.pmBusRevision[0]);
        }

        public String getPWSSerialNumber() {
            return new String(this.pwsSerialNumber);
        }

        public String getPWSModuleNumber() {
            return new String(this.pwsModuleNumber).trim();
        }

        public String getPWSRevision() {
            return new String(this.pwsRevision);
        }

        public String getStatus() {
            String str = "";
            str = this.checkNoneStandardSMCPowerSupplies() ? this.getStatus_old_PS() : this.getStatus_PM1_2();
            return str;
        }

        public boolean getSimpleStatus() {
            if (this.checkNoneStandardSMCPowerSupplies()) {
                return (this.statusByte & 1) == 1;
            }
            return this.statusByte == 0;
        }

        public boolean checkNoneStandardSMCPowerSupplies() {
            String model = this.getPWSModuleNumber();
            for (int i2 = 0; i2 < IPMII2CPMBusCommand.this.noneStandardSMCPowerSupplies.length; ++i2) {
                if (model.indexOf(IPMII2CPMBusCommand.this.noneStandardSMCPowerSupplies[i2]) == -1) continue;
                return true;
            }
            return false;
        }

        public String getStatus_PM1_2() {
            String str = "";
            if ((this.statusByte & 1) == 1) {
                str = str + "[NONE OF THE ABOVE]";
            }
            if ((this.statusByte & 2) == 2) {
                str = str + "[COMM,MEMORY,LOGIC EVENT]";
            }
            if ((this.statusByte & 4) == 4) {
                str = str + "[TEMPERATURE FAULT OR WARNING]";
            }
            if ((this.statusByte & 8) == 8) {
                str = str + "[VIN_UV_FAULT]";
            }
            if ((this.statusByte & 0x10) == 16) {
                str = str + "[IOUT_OC_FAULT]";
            }
            if ((this.statusByte & 0x20) == 32) {
                str = str + "[VOUT_OV_FAULT]";
            }
            if ((this.statusByte & 0x40) == 64) {
                str = str + "[UNIT IS OFF]";
            }
            if ((this.statusByte & 0x80) == 128) {
                str = str + "[UNIT WAS BUSY]";
            }
            if (this.statusByte == 0) {
                str = str + "[STATUS OK]";
            }
            str = str + "(" + ByteUtility.byteToHex(this.statusByte) + "h)";
            return str;
        }

        public String getStatus_old_PS() {
            String str = "";
            if ((this.statusByte & 1) == 1) {
                str = str + "[STATUS OK]";
            }
            if ((this.statusByte & 2) == 2) {
                str = str + "[Over Temperature Fault]";
            }
            if ((this.statusByte & 4) == 4) {
                str = str + "[Under Voltage Fault]";
            }
            if ((this.statusByte & 8) == 8) {
                str = str + "[Over Current Fault]";
            }
            if ((this.statusByte & 0x10) == 16) {
                str = str + "[Over Voltage Fault]";
            }
            str = str + "(" + ByteUtility.byteToHex(this.statusByte) + "h)";
            return str;
        }

        public String toString() {
            String str = "";
            str = str + "VOUT_MODE = " + ByteUtility.byteToHex(this.VOUT_MODE) + "\n";
            str = str + "statusByte = " + ByteUtility.byteToHex(this.statusByte) + "\n";
            str = str + "acInputVoltage = " + ByteUtility.bytesToHex(this.acInputVoltage) + "\n";
            str = str + "acInputCurrent = " + ByteUtility.bytesToHex(this.acInputCurrent) + "\n";
            str = str + "dc12VOutputVoltage = " + ByteUtility.bytesToHex(this.dc12VOutputVoltage) + "\n";
            str = str + "dc12VOutputCurrent = " + ByteUtility.bytesToHex(this.dc12VOutputCurrent) + "\n";
            str = str + "temperature1 = " + ByteUtility.bytesToHex(this.temperature1) + "\n";
            str = str + "temperature2 = " + ByteUtility.bytesToHex(this.temperature2) + "\n";
            str = str + "fan1 = " + ByteUtility.bytesToHex(this.fan1) + "\n";
            str = str + "fan2 = " + ByteUtility.bytesToHex(this.fan2) + "\n";
            str = str + "dc12VOutputPower = " + ByteUtility.bytesToHex(this.dc12VOutputPower) + "\n";
            str = str + "acInputPower = " + ByteUtility.bytesToHex(this.acInputPower) + "\n";
            str = str + "pmBusRevision = " + ByteUtility.bytesToHex(this.pmBusRevision) + "\n";
            str = str + "pwsSerialNumber = " + ByteUtility.bytesToHex(this.pwsSerialNumber) + "\n";
            str = str + "-------------------------------------------------------------\n";
            str = str + "acInputVoltage(F) = " + this.getACInputVoltage() + "\n";
            str = str + "acInputCurrent(F) = " + this.getACInputCurrent() + "\n";
            str = str + "dc12vOutputVoltage(F) = " + this.getDC12VOutputVoltage() + "\n";
            str = str + "dc12vOutputCurrent(F) = " + this.getDC12VOutputCurrent() + "\n";
            str = str + "temperature1(F) = " + this.getTemperature1() + "\n";
            str = str + "temperature2(F) = " + this.getTemperature2() + "\n";
            str = str + "fan1(F) = " + this.getFan1() + "\n";
            str = str + "fan2(F) = " + this.getFan2() + "\n";
            str = str + "dc12VOutputPower(F) = " + this.getDC12VOutputPower() + "\n";
            str = str + "acInputPower(F) = " + this.getACInputPower() + "\n";
            str = str + "pmBusRevision(F) = " + this.getPMBusRevision() + "\n";
            str = str + "PWS Serial Number(F) = " + this.getPWSSerialNumber() + "\n";
            str = str + "PWS Module Number(F) = " + this.getPWSModuleNumber() + "\n";
            str = str + "PWS Revision(F) = " + this.getPWSRevision() + "\n";
            return str;
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f2 = " %-30s | %20s \n";
            StringBuffer fStr = new StringBuffer();
            fStr.append(String.format(f2, "Status", this.isStatusByte ? this.getStatus() : "N/A"));
            fStr.append(String.format(f2, "AC Input Voltage", this.isAcInputVoltage ? this.doubleToString(this.getACInputVoltage()) + " V" : "N/A"));
            fStr.append(String.format(f2, "AC Input Current", this.isAcInputCurrent ? this.doubleToString(this.getACInputCurrent()) + " A" : "N/A"));
            fStr.append(String.format(f2, "DC 12V Output Voltage", this.isDc12VOutputVoltage ? this.doubleToString(this.getDC12VOutputVoltage()) + " V" : "N/A"));
            fStr.append(String.format(f2, "DC 12V Output Current", this.isDc12VOutputCurrent ? this.doubleToString(this.getDC12VOutputCurrent()) + " A" : "N/A"));
            fStr.append(String.format(f2, "Temperature 1", this.isTemperature1 ? this.showCandF(this.getTemperature1()) : "N/A"));
            fStr.append(String.format(f2, "Temperature 2", this.isTemperature2 ? this.showCandF(this.getTemperature2()) : "N/A"));
            fStr.append(String.format(f2, "Fan 1", this.isFan1 ? "" + (int)this.getFan1() + " RPM" : "N/A"));
            if (this.getPWSModuleNumber().indexOf("721") == -1) {
                fStr.append(String.format(f2, "Fan 2", this.isFan2 ? "" + (int)this.getFan2() + " RPM" : "N/A"));
            }
            fStr.append(String.format(f2, "DC 12V Output Power", this.isDc12VOutputPower ? "" + this.getDC12VOutputPower() + " W" : "N/A"));
            fStr.append(String.format(f2, "AC Input Power", this.isAcInputPower ? "" + this.getACInputPower() + " W" : "N/A"));
            fStr.append(String.format(f2, "PMBus Revision", this.isPmBusRevision ? this.getPMBusRevision() : "N/A"));
            fStr.append(String.format(f2, "PWS Serial Number", this.isPwsSerialNumber ? this.getPWSSerialNumber() : "N/A"));
            fStr.append(String.format(f2, "PWS Module Number", this.isPwsModuleNumber ? this.getPWSModuleNumber() : "N/A"));
            fStr.append(String.format(f2, "PWS Revision", this.isPwsRevision ? this.getPWSRevision() : "N/A"));
            return fStr.toString();
        }

        private void UI_HELP_API___________() {
        }

        public String uiGetStatus() {
            return this.isStatusByte ? this.getStatus() : "N/A";
        }

        public String uiGetACInputVoltage() {
            return this.isAcInputVoltage ? this.doubleToString(this.getACInputVoltage()) + " V" : "N/A";
        }

        public String uiGetACInputCurrent() {
            return this.isAcInputCurrent ? this.doubleToString(this.getACInputCurrent()) + " A" : "N/A";
        }

        public String uiGetDC12VOutputVoltage() {
            return this.isDc12VOutputVoltage ? this.doubleToString(this.getDC12VOutputVoltage()) + " V" : "N/A";
        }

        public String uiGetDC12VOutputCurrent() {
            return this.isDc12VOutputCurrent ? this.doubleToString(this.getDC12VOutputCurrent()) + " A" : "N/A";
        }

        public String uiGetTemperature1() {
            return this.isTemperature1 ? this.showCandF(this.getTemperature1()) : "N/A";
        }

        public String uiGetTemperature2() {
            return this.isTemperature2 ? this.showCandF(this.getTemperature2()) : "N/A";
        }

        public String uiGetFan1() {
            return this.isFan1 ? "" + (int)this.getFan1() + " RPM" : "N/A";
        }

        public String uiGetFan2() {
            return this.isFan2 ? "" + (int)this.getFan2() + " RPM" : "N/A";
        }

        public String uiGetDC12VOutputPower() {
            return this.isDc12VOutputPower ? "" + this.getDC12VOutputPower() + " W" : "N/A";
        }

        public String uiGetACInputPower() {
            return this.isAcInputPower ? "" + this.getACInputPower() + " W" : "N/A";
        }

        public String uiGetPMBusRevision() {
            return this.isPmBusRevision ? this.getPMBusRevision() : "N/A";
        }

        public String uiGetPWSSerialNumber() {
            return this.isPwsSerialNumber ? this.getPWSSerialNumber() : "N/A";
        }

        public String uiGetPWSModuleNumber() {
            return this.isPwsModuleNumber ? this.getPWSModuleNumber() : "N/A";
        }

        public String uiGetPWSRevision() {
            return this.isPwsRevision ? this.getPWSRevision() : "N/A";
        }

        public String showCandF(int c2) {
            if (c2 == 0) {
                return "N/A";
            }
            long f2 = Math.round(1.8 * (double)c2 + 32.0);
            return c2 + "C/" + f2 + "F";
        }

        public String doubleToString(double value) {
            int temp = (int)(value * 100.0);
            double d2 = (double)temp / 100.0;
            return "" + d2;
        }

        public double linearDataFormat(byte[] temp) {
            double factor = 0.0;
            factor = (temp[1] & 0x80) == 128 ? Math.pow(2.0, (byte)(temp[1] >> 3 | 0xE0)) : Math.pow(2.0, temp[1] >> 3);
            temp[1] = (byte)(temp[1] & 7);
            int reading = ByteUtility.twoBytesToIntLSB(temp);
            if (reading >= 1024) {
                reading -= 2048;
            }
            double returnValue = (double)reading * factor;
            return returnValue;
        }

        public boolean isSMCOldPower() {
            String moduleNumber = new String(this.pwsModuleNumber);
            return moduleNumber.indexOf("721") != -1;
        }
    }

    public class FRUHealth {
        public byte statusByte;
        public byte temperature;
        public byte fan1;
        public byte fan2;
        public byte[] pwsSerialNumber;
        public byte[] pwsModuleNumber;
        public boolean isStatusByte;
        public boolean isTemperature;
        public boolean isFan1;
        public boolean isFan2;
        public boolean isPwsSerialNumber;
        public boolean isPwsModuleNumber;

        public byte getStatus() {
            return this.statusByte;
        }

        public byte getTemperature() {
            return this.temperature;
        }

        public double getFan1() {
            return 114.50381679389312 * (double)(this.fan1 & 0xFF);
        }

        public double getFan2() {
            return 114.50381679389312 * (double)(this.fan2 & 0xFF);
        }

        public String toString() {
            String str = "";
            str = str + "statusByte = " + ByteUtility.byteToHex(this.statusByte) + "\n";
            str = str + "temperature = " + ByteUtility.byteToHex(this.temperature) + "\n";
            str = str + "fan1 = " + ByteUtility.byteToHex(this.fan1) + "\n";
            str = str + "fan2 = " + ByteUtility.byteToHex(this.fan2) + "\n";
            str = str + "-------------------------------------------------------------\n";
            str = str + "statusByte(F) = " + (this.statusByte == 0 ? "off" : "on") + "\n";
            str = str + "temperature1(F) = " + this.getTemperature() + "\n";
            str = str + "fan1(F) = " + this.getFan1() + "\n";
            str = str + "fan2(F) = " + this.getFan2() + "\n";
            return str;
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f2 = " %-30s | %20s \n";
            StringBuffer fStr = new StringBuffer();
            if (this.isStatusByte) {
                fStr.append(String.format(f2, "Status", this.statusByte == 0 ? "Off" : "On"));
            } else {
                fStr.append(String.format(f2, "Status", "N/A"));
            }
            fStr.append(String.format(f2, "Temperature", this.isTemperature ? this.showCandF(this.getTemperature()) : "N/A"));
            fStr.append(String.format(f2, "Fan 1", this.isFan1 ? "" + (int)this.getFan1() + " RPM" : "N/A"));
            if (this.getFan2() != 0.0) {
                fStr.append(String.format(f2, "Fan 2", this.isFan2 ? "" + (int)this.getFan2() + " RPM" : "N/A"));
            }
            return fStr.toString();
        }

        public String uiGetTemperature() {
            return this.isTemperature ? this.showCandF(this.getTemperature()) : "N/A";
        }

        public String uiGetFan() {
            return this.isFan1 ? "" + (int)this.getFan1() + " RPM" : "N/A";
        }

        protected String showCandF(int c2) {
            if (c2 == 0) {
                return "N/A";
            }
            long f2 = Math.round(1.8 * (double)c2 + 32.0);
            return c2 + "C/" + f2 + "F";
        }

        public String doubleToString(double value) {
            int temp = (int)(value * 100.0);
            double d2 = (double)temp / 100.0;
            return "" + d2;
        }
    }

    public class BBPHealth {
        FRUInfo fruInfo;
        byte[] orgRaw;

        public void fromRaw(byte[] raw) {
            FRU_Internal.fixedInternalAreaSize = 16;
            this.fruInfo = FRUInfo.fromRaw(raw);
            FRU_Internal.fixedInternalAreaSize = 8;
            this.orgRaw = raw;
        }

        public byte getBatteryPackTemperature() {
            return this.fruInfo.fru.internal.useData[0];
        }

        public String getBatteryPackTemperatureDisplay() {
            if (this.getBatteryPackTemperature() == 0 || this.getBatteryPackTemperature() < 0) {
                return "N/A";
            }
            return this.showCandF(this.getBatteryPackTemperature());
        }

        public byte getBatteryPowerStatus() {
            return this.fruInfo.fru.internal.useData[3];
        }

        public String getBatteryPowerStatusDisplay() {
            if ((this.getBatteryPowerStatus() & 1) == 1) {
                return "Normal";
            }
            return "Not Operational";
        }

        public byte getBatteryPackTemperatureLimit() {
            return this.fruInfo.fru.internal.useData[4];
        }

        public byte getFirmwareVersion() {
            return this.fruInfo.fru.internal.useData[13];
        }

        public String getFirmwareVersionDisplay() {
            if (this.getFirmwareVersion() < 32) {
                return "1.0";
            }
            String v = "" + (this.getFirmwareVersion() > 4) + "." + (this.getFirmwareVersion() & 0xF);
            return v;
        }

        public byte getFRUFileRevision() {
            return this.fruInfo.fru.internal.useData[14];
        }

        public String getProductManufacturer() {
            return new String(this.fruInfo.fru.product.productManufacturerName);
        }

        public String getProductName() {
            return new String(this.fruInfo.fru.product.productName);
        }

        public String getProductVersion() {
            return new String(this.fruInfo.fru.product.productVersion);
        }

        public String getProductSerialNumber() {
            return new String(this.fruInfo.fru.product.productSerialNumber);
        }

        public byte getRemainingRelativeBatteryEnergy() {
            return this.orgRaw[224];
        }

        public String getRemainingRelativeBatteryEnergyDisplay() {
            return this.getRemainingRelativeBatteryEnergy() + "%";
        }

        public int getBatteryVoltage() {
            byte[] b2 = new byte[]{this.orgRaw[225], this.orgRaw[226]};
            return ByteUtility.twoBytesToIntLSB(b2);
        }

        public String getBatteryVoltageDisplay() {
            if (this.getBatteryVoltage() > 1000) {
                double v = (double)this.getBatteryVoltage() / 1000.0;
                return "" + this.doubleToString(v) + " V";
            }
            return "" + this.getBatteryVoltage() + " mV";
        }

        public int getBatteryCurrent() {
            byte[] b2 = new byte[]{this.orgRaw[227], this.orgRaw[228]};
            return ByteUtility.twoBytesToIntLSBSigned(b2);
        }

        public String getBatteryCurrentDisplay() {
            if (this.getBatteryCurrent() > 100) {
                double v = (double)this.getBatteryCurrent() / 100.0;
                return "" + this.doubleToString(v) + " A";
            }
            if (this.getBatteryCurrent() < -100) {
                double v = (double)this.getBatteryCurrent() / 100.0;
                return "" + this.doubleToString(v) + " A";
            }
            return "" + this.getBatteryCurrent() * 10 + " mA";
        }

        public int getBatteryStatus() {
            byte[] b2 = new byte[]{this.orgRaw[229], this.orgRaw[230]};
            return ByteUtility.twoBytesToIntLSB(b2);
        }

        public ArrayList getBatteryStatusDisplay() {
            int bitMask = 1;
            int status = this.getBatteryStatus();
            ArrayList<String> list = new ArrayList<String>();
            for (int i2 = 1; i2 <= 16; ++i2) {
                String message;
                if ((status & bitMask) == bitMask && (message = this.getBatteryStatusDescription(bitMask)) != null) {
                    list.add(message);
                }
                bitMask = 1 << i2;
            }
            return list;
        }

        public int getCycleCount() {
            byte[] b2 = new byte[]{this.orgRaw[231], this.orgRaw[232]};
            return ByteUtility.twoBytesToIntLSB(b2);
        }

        public String getCycleCountDisplay() {
            if (this.getCycleCount() < 0) {
                return "0";
            }
            return "" + this.getCycleCount();
        }

        public byte getBatteryDischargeTimerResponse() {
            return this.orgRaw[233];
        }

        public byte getBatteryDischargeTimerCommand() {
            return this.orgRaw[234];
        }

        public String getBatteryDischargeSettingDisplay() {
            boolean isAutoDischarge = (byte)(this.getBatteryDischargeTimerCommand() & 0x80) == -128;
            int dischargeDay = this.getBatteryDischargeTimerCommand() & 0x3F;
            int remainingDay = this.getBatteryDischargeTimerResponse() & 0x3F;
            if (isAutoDischarge) {
                return "Auto (" + dischargeDay + " days)";
            }
            return "User";
        }

        public String getBatteryDischargeRemainingDaysDisplay() {
            boolean isAutoDischarge = (byte)(this.getBatteryDischargeTimerCommand() & 0x80) == -128;
            int dischargeDay = this.getBatteryDischargeTimerCommand() & 0x3F;
            int remainingDay = this.getBatteryDischargeTimerResponse() & 0x3F;
            if (isAutoDischarge) {
                return remainingDay + " days";
            }
            return remainingDay + " days";
        }

        public String getBatteryDischargeStatusDisplay() {
            if ((byte)(this.getBatteryDischargeTimerResponse() & 0x80) == -128) {
                return "Discharging (auto)";
            }
            if ((byte)(this.getBatteryDischargeTimerResponse() & 0x40) == 64) {
                return "Discharging (user)";
            }
            return "None";
        }

        public byte getBoardTemperature() {
            return this.orgRaw[239];
        }

        public String getBoardTemperatureDisplay() {
            if (this.getBoardTemperature() == 0 || this.getBoardTemperature() < 0) {
                return "N/A";
            }
            return this.showCandF(this.getBoardTemperature());
        }

        public int getBatteryOutputWattage() {
            byte[] b2 = new byte[]{this.orgRaw[242], this.orgRaw[243]};
            return ByteUtility.twoBytesToIntLSB(b2);
        }

        public String getBatteryOutputWattageDisplay() {
            return "" + this.getBatteryOutputWattage() + "W";
        }

        public String getBatteryStatusNumberDisplay() {
            return "0x" + ByteUtility.byteToHex(this.orgRaw[230]) + ByteUtility.byteToHex(this.orgRaw[229]);
        }

        public String getBatteryStatusDescriptionsDisplay() {
            String desc = "";
            ArrayList list = this.getBatteryStatusDisplay();
            if (list.size() != 0) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    desc = desc + list.get(i2);
                }
            } else {
                desc = desc + "None";
            }
            return desc;
        }

        public String getBatteryStatusDescription(int index) {
            switch (index) {
                case 16384: {
                    return "[TERMINATE CHARGE]";
                }
                case 4096: {
                    return "[OVER TEMP]";
                }
                case 2048: {
                    return "[TERMINATE DISCHARGE]";
                }
                case 512: {
                    return "[REMAINING CAPACITY]";
                }
                case 256: {
                    return "[REMAINING TIME]";
                }
                case 64: {
                    return "[DISCHARGING]";
                }
                case 32: {
                    return "[FULLY CHARGED]";
                }
                case 16: {
                    return "[FULLY DISCHARGED]";
                }
            }
            return null;
        }

        public String toString() {
            String str = "";
            return str;
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f2 = " %-30s | %20s \n";
            StringBuffer fStr = new StringBuffer();
            fStr.append(String.format(f2, "Manufacturer", this.getProductManufacturer()));
            fStr.append(String.format(f2, "Model Name", this.getProductName()));
            fStr.append(String.format(f2, "Serial Number", this.getProductSerialNumber()));
            fStr.append(String.format(f2, "Product Version", this.getProductVersion()));
            fStr.append(String.format(f2, "Firmware version", this.getFirmwareVersionDisplay()));
            fStr.append(String.format(f2, "-----", ""));
            fStr.append(String.format(f2, "Battery Voltage", this.getBatteryVoltageDisplay()));
            fStr.append(String.format(f2, "Battery Current", this.getBatteryCurrentDisplay()));
            fStr.append(String.format(f2, "Battery Pack Temp", this.getBatteryPackTemperatureDisplay()));
            if (this.getBoardTemperature() > 0) {
                fStr.append(String.format(f2, "Board Temp", this.getBoardTemperatureDisplay()));
            }
            fStr.append(String.format(f2, "Power Wattage", this.getBatteryOutputWattageDisplay()));
            fStr.append(String.format(f2, "Cycle Count", this.getCycleCountDisplay()));
            fStr.append(String.format(f2, "-----", ""));
            fStr.append(String.format(f2, "Battery Power Status", this.getBatteryPowerStatusDisplay()));
            fStr.append(String.format(f2, "Remaining Energy", this.getRemainingRelativeBatteryEnergyDisplay()));
            fStr.append(String.format(f2, "Discharge Status", this.getBatteryDischargeStatusDisplay()));
            fStr.append(String.format(f2, "Discharge Setting", this.getBatteryDischargeSettingDisplay()));
            fStr.append(String.format(f2, "Discharge Remaining Days", this.getBatteryDischargeRemainingDaysDisplay()));
            fStr.append(String.format(f2, "Battery Status", this.getBatteryStatusNumberDisplay()));
            ArrayList list = this.getBatteryStatusDisplay();
            if (list.size() != 0) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    fStr.append(String.format(f2, "", list.get(i2)));
                }
            } else {
                fStr.append(String.format(f2, "", "None"));
            }
            return fStr.toString();
        }

        public String showCandF(int c2) {
            if (c2 == 0) {
                return "N/A";
            }
            long f2 = Math.round(1.8 * (double)c2 + 32.0);
            return c2 + "C/" + f2 + "F";
        }

        public String doubleToString(double value) {
            int temp = (int)(value * 100.0);
            double d2 = (double)temp / 100.0;
            return "" + d2;
        }
    }
}

