/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;

public class IPMISOLCommand
extends IPMICommand {
    public static final byte BAUD_RATE_9600 = 6;
    public static final byte BAUD_RATE_19200 = 7;
    public static final byte BAUD_RATE_38400 = 8;
    public static final byte BAUD_RATE_57600 = 9;
    public static final byte BAUD_RATE_115200 = 10;

    public IPMISOLCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage setSOLConfigurationParametersCommand(byte channel, byte parameterSelector, byte[] parameterData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + parameterData.length];
        data[0] = channel;
        data[1] = parameterSelector;
        System.arraycopy(parameterData, 0, data, 2, parameterData.length);
        ipmiMessage.setCommandAndData((byte)48, (byte)33, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSOLConfigurationParametersCommand(byte channel, byte parameterSelector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channel, parameterSelector, 0, 0};
        ipmiMessage.setCommandAndData((byte)48, (byte)34, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public boolean setSOLEnable() {
        byte[] parameterData = new byte[]{1};
        IPMIMessage resMessage = this.setSOLConfigurationParametersCommand((byte)1, (byte)1, parameterData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setSOLAuthentication(byte data) {
        byte[] parameterData = new byte[]{1};
        IPMIMessage resMessage = this.setSOLConfigurationParametersCommand((byte)1, (byte)1, parameterData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setSOLBitRateNonVolatile() {
        byte[] parameterData = new byte[]{7};
        IPMIMessage resMessage = this.setSOLConfigurationParametersCommand((byte)1, (byte)5, parameterData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setSOLBitRateNonVolatile(byte buadRate) {
        byte[] parameterData = new byte[]{buadRate};
        IPMIMessage resMessage = this.setSOLConfigurationParametersCommand((byte)1, (byte)5, parameterData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setSOLBitRateVolatile() {
        byte[] parameterData = new byte[]{7};
        IPMIMessage resMessage = this.setSOLConfigurationParametersCommand((byte)1, (byte)6, parameterData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setSOLBitRateVolatile(byte buadRate) {
        byte[] parameterData = new byte[]{buadRate};
        IPMIMessage resMessage = this.setSOLConfigurationParametersCommand((byte)1, (byte)6, parameterData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public byte getSOLBitRateNonVolatile() {
        IPMIMessage resMessage = this.getSOLConfigurationParametersCommand((byte)1, (byte)5);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[1];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return 0;
    }

    public byte getSOLBitRateVolatile() {
        IPMIMessage resMessage = this.getSOLConfigurationParametersCommand((byte)1, (byte)6);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[1];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return 0;
    }

    public boolean setSOLRetry(byte retryCount, byte retryInterval) {
        byte[] parameterData = new byte[]{retryCount, retryInterval};
        IPMIMessage resMessage = this.setSOLConfigurationParametersCommand((byte)1, (byte)4, parameterData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setSOLAuthentication(boolean forceSOLEncryption, boolean forceSOLAuthentication, byte privilegeLevel) {
        byte[] parameterData = new byte[]{0};
        parameterData[0] = (byte)(parameterData[0] | (forceSOLEncryption ? -128 : 0));
        parameterData[0] = (byte)(parameterData[0] | (forceSOLAuthentication ? 64 : 0));
        parameterData[0] = (byte)(parameterData[0] | privilegeLevel);
        IPMIMessage resMessage = this.setSOLConfigurationParametersCommand((byte)1, (byte)2, parameterData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.241");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMISOLCommand ipmiSOLCommand = new IPMISOLCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiSOLCommand.setIPMIInterface(rmcp);
        byte b2 = ipmiSOLCommand.getSOLBitRateVolatile();
        System.out.println(ByteUtility.byteToHex(b2));
        b2 = ipmiSOLCommand.getSOLBitRateNonVolatile();
        System.out.println(ByteUtility.byteToHex(b2));
        sessionController.closeSession();
    }
}

